/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.enforcer.rules.dependency;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.enforcer.rules.utils.ArtifactUtils;
import org.apache.maven.enforcer.rules.utils.ParentNodeProvider;
import org.apache.maven.enforcer.rules.utils.ParentsVisitor;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.graph.DependencyNode;
import org.eclipse.aether.graph.DependencyVisitor;

class DependencyVersionMap
implements DependencyVisitor,
ParentNodeProvider {
    private ParentsVisitor parentsVisitor;
    private boolean uniqueVersions;
    private final Map<String, List<DependencyNode>> idsToNode = new HashMap<String, List<DependencyNode>>();

    DependencyVersionMap() {
        this.parentsVisitor = new ParentsVisitor();
    }

    public DependencyVersionMap setUniqueVersions(boolean uniqueVersions) {
        this.uniqueVersions = uniqueVersions;
        return this;
    }

    public boolean visitEnter(DependencyNode node) {
        this.addDependency(node);
        return this.parentsVisitor.visitEnter(node) && !this.containsConflicts(node);
    }

    public boolean visitLeave(DependencyNode node) {
        return this.parentsVisitor.visitLeave(node);
    }

    @Override
    public DependencyNode getParent(DependencyNode node) {
        return this.parentsVisitor.getParent(node);
    }

    private String constructKey(DependencyNode node) {
        return this.constructKey(node.getArtifact());
    }

    private String constructKey(Artifact artifact) {
        return artifact.getGroupId() + ":" + artifact.getArtifactId();
    }

    public void addDependency(DependencyNode node) {
        String key = this.constructKey(node);
        this.idsToNode.computeIfAbsent(key, k -> new ArrayList()).add(node);
    }

    private String getVersion(Artifact artifact) {
        return this.uniqueVersions ? artifact.getVersion() : artifact.getBaseVersion();
    }

    private boolean containsConflicts(DependencyNode node) {
        return this.containsConflicts(node.getArtifact());
    }

    private boolean containsConflicts(Artifact artifact) {
        return this.containsConflicts(this.idsToNode.get(this.constructKey(artifact)));
    }

    private boolean containsConflicts(List<DependencyNode> nodes) {
        String version = null;
        for (DependencyNode node : nodes) {
            if (version == null) {
                version = this.getVersion(node.getArtifact());
                continue;
            }
            if (version.compareTo(this.getVersion(node.getArtifact())) == 0) continue;
            return true;
        }
        return false;
    }

    public List<List<DependencyNode>> getConflictedVersionNumbers(List<String> includes, List<String> excludes) {
        List<String> formattedIncludes = DependencyVersionMap.formatPatterns(includes);
        List<String> formattedExcludes = DependencyVersionMap.formatPatterns(excludes);
        ArrayList<List<DependencyNode>> output = new ArrayList<List<DependencyNode>>();
        Iterator<List<DependencyNode>> iterator = this.idsToNode.values().iterator();
        while (iterator.hasNext()) {
            List<DependencyNode> nodes;
            List<DependencyNode> filteredNodes = nodes = iterator.next();
            if (formattedIncludes != null || formattedExcludes != null) {
                filteredNodes = new ArrayList<DependencyNode>();
                for (DependencyNode node : nodes) {
                    if (!DependencyVersionMap.includeArtifact(node, formattedIncludes, formattedExcludes)) continue;
                    filteredNodes.add(node);
                }
            }
            if (!this.containsConflicts(filteredNodes)) continue;
            output.add(filteredNodes);
        }
        return output;
    }

    private static boolean includeArtifact(DependencyNode node, List<String> includes, List<String> excludes) {
        boolean included;
        boolean bl = included = includes == null || includes.isEmpty();
        if (!included) {
            for (String pattern : includes) {
                if (!ArtifactUtils.compareDependency(pattern, ArtifactUtils.toArtifact(node))) continue;
                included = true;
                break;
            }
        }
        if (!included) {
            return false;
        }
        boolean excluded = false;
        if (excludes != null) {
            for (String pattern : excludes) {
                if (!ArtifactUtils.compareDependency(pattern, ArtifactUtils.toArtifact(node))) continue;
                excluded = true;
                break;
            }
        }
        return !excluded;
    }

    private static List<String> formatPatterns(List<String> patterns) {
        if (patterns == null) {
            return null;
        }
        ArrayList<String> formattedPatterns = new ArrayList<String>();
        for (String pattern : patterns) {
            Object[] subStrings = pattern.split(":");
            subStrings = StringUtils.stripAll((String[])subStrings);
            String formattedPattern = StringUtils.join((Object[])subStrings, (String)":");
            formattedPatterns.add(formattedPattern);
        }
        return formattedPatterns;
    }
}

