/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.assembly.archive.task;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.apache.maven.plugins.assembly.AssemblerConfigurationSource;
import org.apache.maven.plugins.assembly.archive.ArchiveCreationException;
import org.apache.maven.plugins.assembly.archive.task.AddDirectoryTask;
import org.apache.maven.plugins.assembly.format.AssemblyFormattingException;
import org.apache.maven.plugins.assembly.format.ReaderFormatter;
import org.apache.maven.plugins.assembly.model.FileSet;
import org.apache.maven.plugins.assembly.utils.AssemblyFileUtils;
import org.apache.maven.plugins.assembly.utils.AssemblyFormatUtils;
import org.apache.maven.plugins.assembly.utils.TypeConversionUtils;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.archiver.Archiver;
import org.codehaus.plexus.components.io.functions.InputStreamTransformer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AddFileSetsTask {
    private static final Logger LOGGER = LoggerFactory.getLogger(AddFileSetsTask.class);
    private final List<FileSet> fileSets;
    private MavenProject project;
    private MavenProject moduleProject;

    public AddFileSetsTask(List<FileSet> fileSets) {
        this.fileSets = fileSets;
    }

    public AddFileSetsTask(FileSet ... fileSets) {
        this.fileSets = new ArrayList<FileSet>(Arrays.asList(fileSets));
    }

    public void execute(Archiver archiver, AssemblerConfigurationSource configSource) throws ArchiveCreationException, AssemblyFormattingException {
        File archiveBaseDir = configSource.getArchiveBaseDirectory();
        if (archiveBaseDir != null) {
            if (!archiveBaseDir.exists()) {
                throw new ArchiveCreationException("The archive base directory '" + archiveBaseDir.getAbsolutePath() + "' does not exist");
            }
            if (!archiveBaseDir.isDirectory()) {
                throw new ArchiveCreationException("The archive base directory '" + archiveBaseDir.getAbsolutePath() + "' exists, but it is not a directory");
            }
        }
        for (FileSet fileSet : this.fileSets) {
            this.addFileSet(fileSet, archiver, configSource, archiveBaseDir);
        }
    }

    void addFileSet(FileSet fileSet, Archiver archiver, AssemblerConfigurationSource configSource, File archiveBaseDir) throws AssemblyFormattingException, ArchiveCreationException {
        if (this.project == null) {
            this.project = configSource.getProject();
        }
        File basedir = this.project.getBasedir();
        String destDirectory = fileSet.getOutputDirectory();
        if (destDirectory == null) {
            destDirectory = fileSet.getDirectory();
            AssemblyFormatUtils.warnForPlatformSpecifics(LOGGER, destDirectory);
        }
        destDirectory = AssemblyFormatUtils.getOutputDirectory(destDirectory, configSource.getFinalName(), configSource, AssemblyFormatUtils.moduleProjectInterpolator(this.moduleProject), AssemblyFormatUtils.artifactProjectInterpolator(this.project));
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("FileSet[" + destDirectory + "] dir perms: " + Integer.toString(archiver.getOverrideDirectoryMode(), 8) + " file perms: " + Integer.toString(archiver.getOverrideFileMode(), 8) + (fileSet.getLineEnding() == null ? "" : " lineEndings: " + fileSet.getLineEnding()));
        }
        LOGGER.debug("The archive base directory is '" + archiveBaseDir + "'");
        File fileSetDir = this.getFileSetDirectory(fileSet, basedir, archiveBaseDir);
        if (fileSetDir.exists()) {
            int fileMode;
            InputStreamTransformer fileSetTransformers = ReaderFormatter.getFileSetTransformers(configSource, fileSet.isFiltered(), new HashSet<String>(fileSet.getNonFilteredFileExtensions()), fileSet.getLineEnding());
            if (fileSetTransformers == null) {
                LOGGER.debug("NOT reformatting any files in " + fileSetDir);
            }
            if (fileSetDir.getPath().equals(File.separator)) {
                throw new AssemblyFormattingException("Your assembly descriptor specifies a directory of " + File.separator + ", which is your *entire* file system.\nThese are not the files you are looking for");
            }
            AddDirectoryTask task = new AddDirectoryTask(fileSetDir, fileSetTransformers);
            int dirMode = TypeConversionUtils.modeToInt(fileSet.getDirectoryMode(), LOGGER);
            if (dirMode != -1) {
                task.setDirectoryMode(dirMode);
            }
            if ((fileMode = TypeConversionUtils.modeToInt(fileSet.getFileMode(), LOGGER)) != -1) {
                task.setFileMode(fileMode);
            }
            task.setUseDefaultExcludes(fileSet.isUseDefaultExcludes());
            task.setExcludes(fileSet.getExcludes());
            task.setIncludes(fileSet.getIncludes());
            task.setOutputDirectory(destDirectory);
            task.execute(archiver);
        }
    }

    File getFileSetDirectory(FileSet fileSet, File basedir, File archiveBaseDir) throws ArchiveCreationException, AssemblyFormattingException {
        File fileSetDir;
        String sourceDirectory = fileSet.getDirectory();
        if (sourceDirectory == null || sourceDirectory.trim().length() < 1) {
            sourceDirectory = basedir.getAbsolutePath();
        }
        if (archiveBaseDir == null) {
            fileSetDir = new File(sourceDirectory);
            if (!AssemblyFileUtils.isAbsolutePath(fileSetDir)) {
                fileSetDir = new File(basedir, sourceDirectory);
            }
        } else {
            fileSetDir = new File(archiveBaseDir, sourceDirectory);
        }
        return fileSetDir;
    }

    public void setProject(MavenProject project) {
        this.project = project;
    }

    public void setModuleProject(MavenProject moduleProject) {
        this.moduleProject = moduleProject;
    }
}

