/*
 * Decompiled with CFR 0.152.
 */
package io.pkts.packet.sctp.impl;

import io.pkts.buffer.Buffer;
import io.pkts.buffer.Buffers;
import io.pkts.packet.PreConditions;
import io.pkts.packet.sctp.SctpDataChunk;
import io.pkts.packet.sctp.impl.DefaultSctpChunk;
import io.pkts.packet.sctp.impl.DelegatingSctpChunk;

public class SctpDataChunkImpl
extends DelegatingSctpChunk
implements SctpDataChunk {
    private final Buffer dataHeader;
    private final Buffer payload;

    public static final SctpDataChunk of(DefaultSctpChunk chunk) {
        PreConditions.assertNotNull(chunk, "The chunk we are wrapping cannot be null");
        return new SctpDataChunkImpl(chunk);
    }

    private SctpDataChunkImpl(DefaultSctpChunk chunk) {
        super(chunk);
        Buffer header = chunk.getHeader();
        Buffer value = chunk.getValue();
        Buffer remainingDataHeader = value.slice(12);
        this.payload = value.slice(12, value.capacity());
        this.dataHeader = Buffers.wrap((Buffer)header, (Buffer)remainingDataHeader);
    }

    @Override
    public Buffer getHeader() {
        return this.dataHeader;
    }

    @Override
    public boolean isUnordered() {
        return this.dataHeader.getBit2(1);
    }

    @Override
    public boolean isBeginningFragment() {
        return this.dataHeader.getBit1(1);
    }

    @Override
    public boolean isEndingFragment() {
        return this.dataHeader.getBit0(1);
    }

    @Override
    public boolean isImmediate() {
        return this.dataHeader.getBit3(1);
    }

    @Override
    public long getTransmissionSequenceNumber() {
        return this.dataHeader.getUnsignedInt(4);
    }

    @Override
    public int getStreamIdentifier() {
        return this.dataHeader.getUnsignedShort(8);
    }

    @Override
    public int getStreamSequenceNumber() {
        return this.dataHeader.getUnsignedShort(10);
    }

    @Override
    public long getPayloadProtocolIdentifier() {
        return this.dataHeader.getUnsignedInt(12);
    }

    @Override
    public Buffer getUserData() {
        return this.payload;
    }
}

