/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.srtp.utils;

import java.util.Formatter;
import org.jitsi.utils.ByteArrayBuffer;
import org.jitsi.utils.ByteArrayUtils;

public class SrtpPacketUtils {
    public static final int FIXED_HEADER_SIZE = 12;
    private static final int EXT_HEADER_SIZE = 4;

    public static boolean getExtensionBit(ByteArrayBuffer buf) {
        int offset;
        byte[] buffer = buf.getBuffer();
        return (buffer[offset = buf.getOffset()] & 0x10) == 16;
    }

    public static void setExtensionBit(ByteArrayBuffer buf) {
        int offset;
        byte[] buffer = buf.getBuffer();
        int n = offset = buf.getOffset();
        buffer[n] = (byte)(buffer[n] | 0x10);
    }

    public static int getCsrcCount(ByteArrayBuffer buf) {
        byte[] buffer = buf.getBuffer();
        int offset = buf.getOffset();
        return buffer[offset] & 0xF;
    }

    public static int getExtensionType(ByteArrayBuffer buf) {
        int cc = SrtpPacketUtils.getCsrcCount(buf);
        int extTypeIndex = 12 + cc * 4;
        int type = ByteArrayUtils.readUint16((ByteArrayBuffer)buf, (int)extTypeIndex);
        return type;
    }

    public static void setExtensionType(ByteArrayBuffer buf, int type) {
        int cc = SrtpPacketUtils.getCsrcCount(buf);
        int extTypeIndex = 12 + cc * 4;
        ByteArrayUtils.writeUint16((ByteArrayBuffer)buf, (int)extTypeIndex, (int)type);
    }

    public static int getExtensionLength(ByteArrayBuffer buf) {
        int cc = SrtpPacketUtils.getCsrcCount(buf);
        int extLenIndex = 12 + cc * 4 + 2;
        int len = ByteArrayUtils.readUint16((ByteArrayBuffer)buf, (int)extLenIndex) * 4;
        return len;
    }

    public static int getSequenceNumber(ByteArrayBuffer buf) {
        return ByteArrayUtils.readUint16((ByteArrayBuffer)buf, (int)2);
    }

    public static int getSsrc(ByteArrayBuffer buf) {
        return ByteArrayUtils.readInt((ByteArrayBuffer)buf, (int)8);
    }

    public static boolean validatePacketLength(ByteArrayBuffer buf, int authTagLen) {
        int neededLength;
        int length = buf.getLength();
        if (length < (neededLength = 12 + authTagLen)) {
            return false;
        }
        int cc = SrtpPacketUtils.getCsrcCount(buf);
        if (length < (neededLength += cc * 4)) {
            return false;
        }
        if (SrtpPacketUtils.getExtensionBit(buf)) {
            if (length < (neededLength += 4)) {
                return false;
            }
            int extLen = SrtpPacketUtils.getExtensionLength(buf);
            if (length < (neededLength += extLen)) {
                return false;
            }
        }
        return true;
    }

    public static int getTotalHeaderLength(ByteArrayBuffer buf) {
        int length = 12 + SrtpPacketUtils.getCsrcCount(buf) * 4;
        if (SrtpPacketUtils.getExtensionBit(buf)) {
            length += 4 + SrtpPacketUtils.getExtensionLength(buf);
        }
        return length;
    }

    public static String formatReplayWindow(long maxIdx, long replayWindow, long replayWindowSize) {
        StringBuilder out = new StringBuilder();
        Formatter formatter = new Formatter(out);
        formatter.format("maxIdx=%d, window=0x%016x: [", maxIdx, replayWindow);
        boolean printedSomething = false;
        for (long i = replayWindowSize - 1L; i >= 0L; --i) {
            if ((replayWindow >> (int)i & 1L) == 0L) continue;
            if (printedSomething) {
                out.append(", ");
            }
            printedSomething = true;
            out.append(maxIdx - i);
        }
        out.append("]");
        return out.toString();
    }
}

