/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.versions;

import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.xml.stream.XMLStreamException;
import javax.xml.transform.TransformerException;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.handler.manager.ArtifactHandlerManager;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Model;
import org.apache.maven.model.ModelBase;
import org.apache.maven.model.Profile;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.wagon.Wagon;
import org.codehaus.mojo.versions.AbstractVersionsDependencyUpdaterMojo;
import org.codehaus.mojo.versions.api.PomHelper;
import org.codehaus.mojo.versions.api.VersionRetrievalException;
import org.codehaus.mojo.versions.api.recording.ChangeRecorder;
import org.codehaus.mojo.versions.api.recording.DependencyChangeRecord;
import org.codehaus.mojo.versions.recording.DefaultPropertyChangeRecord;
import org.codehaus.mojo.versions.rewriting.MutableXMLStreamReader;
import org.codehaus.mojo.versions.utils.DependencyComparator;
import org.codehaus.mojo.versions.utils.ModelNode;
import org.eclipse.aether.RepositorySystem;

@Mojo(name="use-dep-version", aggregator=true, threadSafe=true)
public class UseDepVersionMojo
extends AbstractVersionsDependencyUpdaterMojo {
    @Parameter(property="depVersion", required=true)
    protected String depVersion;
    @Parameter(property="forceVersion", defaultValue="false")
    protected boolean forceVersion;
    @Parameter(property="processProperties", defaultValue="false")
    protected boolean processProperties;

    @Inject
    public UseDepVersionMojo(ArtifactHandlerManager artifactHandlerManager, RepositorySystem repositorySystem, Map<String, Wagon> wagonMap, Map<String, ChangeRecorder> changeRecorders) {
        super(artifactHandlerManager, repositorySystem, wagonMap, changeRecorders);
    }

    @Override
    protected void validateInput() throws MojoExecutionException {
        super.validateInput();
        if (StringUtils.isBlank((CharSequence)this.depVersion)) {
            throw new IllegalArgumentException("depVersion must be supplied with use-specific-version, and cannot be blank.");
        }
        if (!this.forceVersion && !this.hasIncludes()) {
            throw new IllegalArgumentException("The use-specific-version goal is intended to be used with a single artifact. Please specify a value for the 'includes' parameter, or use -DforceVersion=true to override this check.");
        }
    }

    @Override
    protected void update(MutableXMLStreamReader pom) throws MojoExecutionException, MojoFailureException, XMLStreamException, VersionRetrievalException {
    }

    @Override
    public void execute() throws MojoExecutionException, MojoFailureException {
        this.validateInput();
        try {
            MutableXMLStreamReader pomReader = new MutableXMLStreamReader(this.getProject().getFile().toPath());
            ModelNode rootNode = new ModelNode(PomHelper.getRawModel((String)pomReader.getSource(), (File)this.getProject().getFile()), pomReader);
            List rawModels = PomHelper.getRawModelTree((ModelNode)rootNode, (Log)this.getLog());
            Collections.reverse(rawModels);
            HashSet<String> propertyBacklog = new HashSet<String>();
            HashMap<String, Set<Dependency>> propertyConflicts = new HashMap<String, Set<Dependency>>();
            for (ModelNode node : rawModels) {
                this.processModel(node, propertyBacklog, propertyConflicts, Optional.ofNullable(pomReader.getEncoding()).map(Charset::forName).orElse(Charset.defaultCharset()));
            }
            propertyBacklog.forEach(p -> this.getLog().warn((CharSequence)("Not updating property ${" + p + "}: defined in parent")));
        }
        catch (IOException | XMLStreamException | TransformerException e) {
            throw new MojoFailureException(e.getMessage(), (Throwable)e);
        }
        catch (RuntimeException e) {
            if (e.getCause() instanceof MojoFailureException) {
                throw (MojoFailureException)e.getCause();
            }
            if (e.getCause() instanceof MojoExecutionException) {
                throw (MojoExecutionException)e.getCause();
            }
            throw e;
        }
    }

    protected boolean processModel(ModelNode node, Set<String> propertyBacklog, Map<String, Set<Dependency>> propertyConflicts, Charset charset) throws MojoFailureException, MojoExecutionException {
        propertyBacklog.removeIf(p -> this.updatePropertyValue(node, (String)p));
        try {
            if (this.isProcessingDependencyManagement() && node.getModel().getDependencyManagement() != null) {
                this.useDepVersion(node, node.getModel().getDependencyManagement().getDependencies(), DependencyChangeRecord.ChangeKind.DEPENDENCY_MANAGEMENT, propertyBacklog, propertyConflicts);
            }
            if (this.isProcessingDependencies()) {
                this.useDepVersion(node, UseDepVersionMojo.getDependencies(node.getModel()), DependencyChangeRecord.ChangeKind.DEPENDENCY, propertyBacklog, propertyConflicts);
            }
            if (this.getProject().getParent() != null && this.isProcessingParent()) {
                this.useDepVersion(node, Collections.singletonList(this.getParentDependency()), DependencyChangeRecord.ChangeKind.PARENT, propertyBacklog, propertyConflicts);
            }
        }
        catch (XMLStreamException e) {
            throw new MojoFailureException("Unable to parse the pom " + node.getModel().getPomFile(), (Throwable)e);
        }
        catch (VersionRetrievalException e) {
            throw new MojoFailureException("Unable to retrieve a dependency version while processing " + node.getModel().getPomFile(), (Throwable)e);
        }
        if (node.getMutableXMLStreamReader().isModified()) {
            if (this.generateBackupPoms) {
                Objects.requireNonNull(node.getModel().getPomFile());
                Objects.requireNonNull(node.getModel().getPomFile().toPath().getParent());
                Path backupFile = node.getModel().getPomFile().toPath().getParent().resolve(node.getModel().getPomFile().toPath().getFileName() + ".versionsBackup");
                if (!Files.exists(backupFile, new LinkOption[0])) {
                    if (this.getLog().isDebugEnabled()) {
                        this.getLog().debug((CharSequence)("Backing up " + node.getModel().getPomFile() + " to " + backupFile));
                    }
                    try {
                        Files.copy(node.getModel().getPomFile().toPath(), backupFile, StandardCopyOption.REPLACE_EXISTING);
                    }
                    catch (IOException e) {
                        throw new MojoFailureException("Error backing up the " + node.getModel().getPomFile(), (Throwable)e);
                    }
                } else if (this.getLog().isDebugEnabled()) {
                    this.getLog().debug((CharSequence)("Leaving existing backup " + backupFile + " unmodified"));
                }
            } else {
                this.getLog().debug((CharSequence)"Skipping the generation of a backup file");
            }
            try (BufferedWriter writer = Files.newBufferedWriter(node.getModel().getPomFile().toPath(), charset, new OpenOption[0]);){
                writer.write(node.getMutableXMLStreamReader().getSource());
            }
            catch (IOException e) {
                throw new MojoFailureException("Unable to write the changed file " + node.getModel().getPomFile(), (Throwable)e);
            }
        }
        try {
            this.saveChangeRecorderResults();
        }
        catch (IOException e) {
            this.getLog().warn((CharSequence)("Cannot save the change recorder result for file " + node.getModel().getPomFile()), (Throwable)e);
        }
        return node.getMutableXMLStreamReader().isModified();
    }

    private static List<Dependency> getDependencies(Model model) {
        List dependencies = Optional.ofNullable(model.getDependencies()).orElse(new ArrayList());
        dependencies.addAll(Optional.ofNullable(model.getProfiles()).flatMap(profiles -> profiles.stream().map(ModelBase::getDependencies).reduce((l1, l2) -> {
            l1.addAll(l2);
            return l1;
        })).orElse(Collections.emptyList()));
        return dependencies;
    }

    private void useDepVersion(ModelNode node, Collection<Dependency> dependencies, DependencyChangeRecord.ChangeKind changeKind, Set<String> propertyBacklog, Map<String, Set<Dependency>> propertyConflicts) throws MojoExecutionException, XMLStreamException, VersionRetrievalException {
        if (this.processProperties) {
            dependencies.stream().filter(dep -> {
                try {
                    return !this.isIncluded(this.toArtifact((Dependency)dep));
                }
                catch (MojoExecutionException e) {
                    throw new RuntimeException(e);
                }
            }).forEach(dep -> PomHelper.extractExpression((String)dep.getVersion()).ifPresent(p -> propertyConflicts.compute((String)p, (k, v) -> Optional.ofNullable(v).map(set -> {
                set.add(dep);
                return set;
            }).orElseGet(() -> {
                TreeSet<Dependency> set = new TreeSet<Dependency>((Comparator<Dependency>)DependencyComparator.INSTANCE);
                set.add((Dependency)dep);
                return set;
            }))));
        }
        for (Dependency dep2 : dependencies) {
            if (this.isExcludeReactor() && this.isProducedByReactor(dep2)) {
                this.getLog().info((CharSequence)("Ignoring a reactor dependency: " + this.toString(dep2)));
                continue;
            }
            Optional propertyName = PomHelper.extractExpression((String)dep2.getVersion());
            if (propertyName.isPresent() && !this.processProperties) {
                this.getLog().info((CharSequence)("Ignoring a dependency with the version set using a property: " + this.toString(dep2)));
                continue;
            }
            Artifact artifact = this.toArtifact(dep2);
            if (!this.isIncluded(artifact)) continue;
            if (dep2.getVersion() == null) {
                this.getLog().warn((CharSequence)String.format("Not updating %s:%s in dependencies: version defined in dependencyManagement", dep2.getGroupId(), dep2.getArtifactId()));
                continue;
            }
            if (!this.forceVersion && !this.getHelper().lookupArtifactVersions(artifact, false).containsVersion(this.depVersion)) {
                throw new MojoExecutionException(String.format("Version %s is not available for artifact %s:%s", this.depVersion, artifact.getGroupId(), artifact.getArtifactId()));
            }
            if (!propertyName.isPresent()) {
                this.updateDependencyVersion(node.getMutableXMLStreamReader(), dep2, this.depVersion, changeKind);
                continue;
            }
            Optional.ofNullable(propertyConflicts.get(propertyName.get())).map(conflict -> {
                this.getLog().warn((CharSequence)("Cannot update property ${" + (String)propertyName.get() + "}: controls more than one dependency: " + conflict.stream().map(Dependency::getArtifactId).collect(Collectors.joining(", "))));
                return false;
            }).orElseGet(() -> {
                if (!this.updatePropertyValue(node, (String)propertyName.get())) {
                    propertyBacklog.add((String)propertyName.get());
                } else if (this.getLog().isDebugEnabled()) {
                    this.getLog().debug((CharSequence)String.format("Updated the %s property value to %s.", propertyName.get(), this.depVersion));
                }
                return true;
            });
        }
        propertyConflicts.keySet().removeIf(key -> Optional.ofNullable(node.getModel().getProperties()).filter(p -> p.containsKey(key)).isPresent());
        propertyConflicts.keySet().removeIf(key -> Optional.ofNullable(node.getModel().getProfiles()).map(list -> list.stream().anyMatch(p -> Optional.ofNullable(p.getProperties()).filter(prop -> prop.containsKey(key)).isPresent())).orElse(false));
    }

    private boolean updatePropertyValue(ModelNode node, String property) {
        return Stream.concat(Stream.of(node.getModel().getProperties().getProperty(property)).filter(Objects::nonNull).map(value -> new ImmutablePair(null, value)), node.getModel().getProfiles().stream().map(profile -> new ImmutablePair(profile, (Object)profile.getProperties())).map(pair -> Optional.ofNullable(((Properties)pair.getRight()).getProperty(property)).map(value -> new ImmutablePair((Object)((Profile)pair.getLeft()), value)).orElse(null))).filter(Objects::nonNull).map(pair -> {
            try {
                boolean result = PomHelper.setPropertyVersion((MutableXMLStreamReader)node.getMutableXMLStreamReader(), (String)Optional.ofNullable((Profile)pair.getLeft()).map(Profile::getId).orElse(null), (String)property, (String)this.depVersion);
                if (result) {
                    try {
                        this.getChangeRecorder().recordChange(DefaultPropertyChangeRecord.builder().withProperty(property).withOldValue((String)pair.getRight()).withNewValue(this.depVersion).build());
                    }
                    catch (MojoExecutionException e) {
                        throw new RuntimeException(e);
                    }
                }
                return result;
            }
            catch (XMLStreamException e) {
                throw new RuntimeException(e);
            }
        }).reduce(Boolean::logicalOr).orElse(false);
    }
}

