/*
 * Decompiled with CFR 0.152.
 */
package sun.security.krb5.internal.crypto;

import java.security.GeneralSecurityException;
import sun.security.krb5.KrbCryptoException;
import sun.security.krb5.internal.crypto.Aes128;
import sun.security.krb5.internal.crypto.CksumType;

public class HmacSha1Aes128CksumType
extends CksumType {
    @Override
    public int confounderSize() {
        return 16;
    }

    @Override
    public int cksumType() {
        return 15;
    }

    @Override
    public boolean isKeyed() {
        return true;
    }

    @Override
    public int cksumSize() {
        return 12;
    }

    @Override
    public int keyType() {
        return 3;
    }

    @Override
    public int keySize() {
        return 16;
    }

    @Override
    public byte[] calculateChecksum(byte[] byArray, int n, byte[] byArray2, int n2) throws KrbCryptoException {
        try {
            return Aes128.calculateChecksum(byArray2, n2, byArray, 0, n);
        }
        catch (GeneralSecurityException generalSecurityException) {
            KrbCryptoException krbCryptoException = new KrbCryptoException(generalSecurityException.getMessage());
            krbCryptoException.initCause(generalSecurityException);
            throw krbCryptoException;
        }
    }

    @Override
    public boolean verifyChecksum(byte[] byArray, int n, byte[] byArray2, byte[] byArray3, int n2) throws KrbCryptoException {
        try {
            byte[] byArray4 = Aes128.calculateChecksum(byArray2, n2, byArray, 0, n);
            return HmacSha1Aes128CksumType.isChecksumEqual(byArray3, byArray4);
        }
        catch (GeneralSecurityException generalSecurityException) {
            KrbCryptoException krbCryptoException = new KrbCryptoException(generalSecurityException.getMessage());
            krbCryptoException.initCause(generalSecurityException);
            throw krbCryptoException;
        }
    }
}

