<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\RealTimeBidding;

class AdvertiserAndBrand extends \Google\Model
{
  public $advertiserId;
  public $advertiserName;
  public $brandId;
  public $brandName;

  public function setAdvertiserId($advertiserId)
  {
    $this->advertiserId = $advertiserId;
  }
  public function getAdvertiserId()
  {
    return $this->advertiserId;
  }
  public function setAdvertiserName($advertiserName)
  {
    $this->advertiserName = $advertiserName;
  }
  public function getAdvertiserName()
  {
    return $this->advertiserName;
  }
  public function setBrandId($brandId)
  {
    $this->brandId = $brandId;
  }
  public function getBrandId()
  {
    return $this->brandId;
  }
  public function setBrandName($brandName)
  {
    $this->brandName = $brandName;
  }
  public function getBrandName()
  {
    return $this->brandName;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(AdvertiserAndBrand::class, 'Google_Service_RealTimeBidding_AdvertiserAndBrand');
