/* config/IlmBaseConfig.h.  Generated from IlmBaseConfig.h.in by configure.  */
// SPDX-License-Identifier: BSD-3-Clause
// Copyright Contributors to the OpenEXR Project.

// This file is auto-generated by the configure step

#ifndef INCLUDED_ILMBASE_CONFIG_H
#define INCLUDED_ILMBASE_CONFIG_H 1

#pragma once

//
// Define and set to 1 if the target system has c++11/14 support
// and you want IlmBase to NOT use it's features
//

/* #undef ILMBASE_FORCE_CXX03 */

//
// Define and set to 1 if the target system has POSIX thread support
// and you want IlmBase to use it for multithreaded file I/O.
//

#define HAVE_PTHREAD 1

//
// Define and set to 1 if the target system supports POSIX semaphores
// and you want OpenEXR to use them; otherwise, OpenEXR will use its
// own semaphore implementation.
//

#define HAVE_POSIX_SEMAPHORES 1


//
// Define and set to 1 if the target system has support for large
// stack sizes.
//

/* #undef ILMBASE_HAVE_LARGE_STACK */

//
// Current (internal) library namepace name and corresponding public
// client namespaces.
//
/* #undef ILMBASE_INTERNAL_NAMESPACE_CUSTOM */
#define IMATH_INTERNAL_NAMESPACE Imath
#define IEX_INTERNAL_NAMESPACE Iex
#define ILMTHREAD_INTERNAL_NAMESPACE IlmThread

/* #undef ILMBASE_NAMESPACE_CUSTOM */
#define IMATH_NAMESPACE Imath
#define IEX_NAMESPACE Iex
#define ILMTHREAD_NAMESPACE IlmThread


//
// Define and set to 1 if the target system has support for large
// stack sizes.
//

/* #undef ILMBASE_HAVE_LARGE_STACK */


//
// Version information
//
#define ILMBASE_VERSION_STRING "2.5.5"
#define ILMBASE_PACKAGE_STRING "IlmBase 2.5.5"

#define ILMBASE_VERSION_MAJOR 2
#define ILMBASE_VERSION_MINOR 5
#define ILMBASE_VERSION_PATCH 5

// Version as a single hex number, e.g. 0x01000300 == 1.0.3
#define ILMBASE_VERSION_HEX ((uint32_t(ILMBASE_VERSION_MAJOR) << 24) | \
                             (uint32_t(ILMBASE_VERSION_MINOR) << 16) | \
                             (uint32_t(ILMBASE_VERSION_PATCH) <<  8))

#endif // INCLUDED_ILMBASE_CONFIG_H
