dnl This file contains local autoconf macros.

dnl ----------------------------------------------------------------------------
dnl Output stylize macros for configure (help/runtime).
dnl ----------------------------------------------------------------------------

dnl
dnl PHP_HELP_SEPARATOR(title)
dnl
dnl Adds separator title into the configure --help display.
dnl
AC_DEFUN([PHP_HELP_SEPARATOR],[
AC_ARG_ENABLE([],[
$1
],[])
])

dnl
dnl PHP_CONFIGURE_PART(title)
dnl
dnl Adds separator title configure output (idea borrowed from mm).
dnl
AC_DEFUN([PHP_CONFIGURE_PART],[
  AC_MSG_RESULT()
  AC_MSG_RESULT([${T_MD}$1${T_ME}])
])

dnl ----------------------------------------------------------------------------
dnl Build system helper macros.
dnl ----------------------------------------------------------------------------

dnl
dnl PHP_DEF_HAVE(what)
dnl
dnl Generates 'AC_DEFINE(HAVE_WHAT, 1, [ ])'.
dnl
AC_DEFUN([PHP_DEF_HAVE],[AC_DEFINE([HAVE_]translit($1,a-z_.-,A-Z___), 1, [ ])])

dnl
dnl PHP_RUN_ONCE(namespace, variable, code)
dnl
dnl Execute code, if variable is not set in namespace.
dnl
AC_DEFUN([PHP_RUN_ONCE],[
  changequote({,})
  unique=`echo $2|$SED 's/[^a-zA-Z0-9]/_/g'`
  changequote([,])
  cmd="echo $ac_n \"\$$1$unique$ac_c\""
  if test -n "$unique" && test "`eval $cmd`" = "" ; then
    eval "$1$unique=set"
    $3
  fi
])

dnl
dnl PHP_EXPAND_PATH(path, variable)
dnl
dnl Expands path to an absolute path and assigns it to variable.
dnl
AC_DEFUN([PHP_EXPAND_PATH],[
  if test -z "$1" || echo "$1" | grep '^/' >/dev/null ; then
    $2=$1
  else
    changequote({,})
    ep_dir=`echo $1|$SED 's%/*[^/][^/]*/*$%%'`
    changequote([,])
    ep_realdir=`(cd "$ep_dir" && pwd)`
    $2="$ep_realdir"/`basename "$1"`
  fi
])

dnl
dnl PHP_DEFINE(WHAT [, value[, directory]])
dnl
dnl Creates builddir/include/what.h and in there #define WHAT value.
dnl
AC_DEFUN([PHP_DEFINE],[
  [echo "#define ]$1[]ifelse([$2],,[ 1],[ $2])[" > ]ifelse([$3],,[include],[$3])[/php_]translit($1,A-Z,a-z)[.h]
])

dnl
dnl PHP_SUBST(varname)
dnl
dnl Adds variable with its value into Makefile, e.g.:
dnl CC = gcc
dnl
AC_DEFUN([PHP_SUBST],[
  PHP_VAR_SUBST="$PHP_VAR_SUBST $1"
])

dnl
dnl PHP_SUBST_OLD(varname, [VALUE])
dnl
dnl Same as PHP_SUBST() but also substitutes all @VARNAME@ instances in every
dnl file passed to AC_OUTPUT.
dnl
AC_DEFUN([PHP_SUBST_OLD],[
  AC_SUBST($@)
  PHP_SUBST([$1])
])

dnl
dnl PHP_OUTPUT(file)
dnl
dnl Adds "file" to the list of files generated by AC_OUTPUT. This macro can be
dnl used several times.
dnl
AC_DEFUN([PHP_OUTPUT],[
  PHP_OUTPUT_FILES="$PHP_OUTPUT_FILES $1"
])

dnl ----------------------------------------------------------------------------
dnl Build system base macros.
dnl ----------------------------------------------------------------------------

dnl
dnl PHP_CANONICAL_HOST_TARGET
dnl
AC_DEFUN([PHP_CANONICAL_HOST_TARGET],[
  AC_REQUIRE([AC_CANONICAL_HOST])dnl
  AC_REQUIRE([AC_CANONICAL_TARGET])dnl
  dnl Make sure we do not continue if host_alias is empty.
  if test -z "$host_alias" && test -n "$host"; then
    host_alias=$host
  fi
  if test -z "$host_alias"; then
    AC_MSG_ERROR([host_alias is not set!])
  fi
])

dnl
dnl PHP_INIT_BUILD_SYSTEM
dnl
dnl Creates build directories and Makefile placeholders.
dnl
AC_DEFUN([PHP_INIT_BUILD_SYSTEM],[
AC_REQUIRE([PHP_CANONICAL_HOST_TARGET])dnl
test -d include || $php_shtool mkdir include
> Makefile.objects
> Makefile.fragments
dnl We need to play tricks here to avoid matching the grep line itself.
pattern=define
$EGREP $pattern'.*include/php' $srcdir/configure|$SED 's/.*>//'|xargs touch 2>/dev/null
])

dnl
dnl PHP_GEN_GLOBAL_MAKEFILE
dnl
dnl Generates the global makefile.
dnl
AC_DEFUN([PHP_GEN_GLOBAL_MAKEFILE],[
  cat >Makefile <<EOF
srcdir = $abs_srcdir
builddir = $abs_builddir
top_srcdir = $abs_srcdir
top_builddir = $abs_builddir
EOF
  for i in $PHP_VAR_SUBST; do
    eval echo "$i = \$$i" >> Makefile
  done

  cat $abs_srcdir/build/Makefile.global Makefile.fragments Makefile.objects >> Makefile
])

dnl
dnl PHP_ADD_MAKEFILE_FRAGMENT([srcfile [, ext_srcdir [, ext_builddir]]])
dnl
dnl Processes a file called Makefile.frag in the source directory of the most
dnl recently added extension. $(srcdir) and $(builddir) are substituted with the
dnl proper paths. Can be used to supply custom rules and/or additional targets.
dnl
AC_DEFUN([PHP_ADD_MAKEFILE_FRAGMENT],[
  ifelse($1,,src=$ext_srcdir/Makefile.frag,src=$1)
  ifelse($2,,ac_srcdir=$ext_srcdir,ac_srcdir=$2)
  ifelse($3,,ac_builddir=$ext_builddir,ac_builddir=$3)
  test -f "$src" && $SED -e "s#\$(srcdir)#$ac_srcdir#g" -e "s#\$(builddir)#$ac_builddir#g" $src  >> Makefile.fragments
])

dnl
dnl PHP_ADD_SOURCES(source-path, sources [, special-flags [, type]])
dnl
dnl Adds sources which are located relative to source-path to the array of type
dnl type. Sources are processed with optional special-flags which are passed to
dnl the compiler. Sources can be either written in C or C++ (filenames shall end
dnl in .c or .cpp, respectively).
dnl
dnl Note: If source-path begins with a "/", the "/" is removed and the path is
dnl interpreted relative to the top build-directory.
dnl
dnl Which array to append to?
dnl
AC_DEFUN([PHP_ADD_SOURCES],[
  PHP_ADD_SOURCES_X($1, $2, $3, ifelse($4,sapi,PHP_SAPI_OBJS,PHP_GLOBAL_OBJS))
])

dnl
dnl _PHP_ASSIGN_BUILD_VARS(type)
dnl
dnl Internal, don't use.
dnl
AC_DEFUN([_PHP_ASSIGN_BUILD_VARS],[
ifelse($1,shared,[
  b_c_pre=$shared_c_pre
  b_cxx_pre=$shared_cxx_pre
  b_c_meta=$shared_c_meta
  b_cxx_meta=$shared_cxx_meta
  b_c_post=$shared_c_post
  b_cxx_post=$shared_cxx_post
],[
  b_c_pre=$php_c_pre
  b_cxx_pre=$php_cxx_pre
  b_c_meta=$php_c_meta
  b_cxx_meta=$php_cxx_meta
  b_c_post=$php_c_post
  b_cxx_post=$php_cxx_post
])dnl
  b_lo=[$]$1_lo
])

dnl
dnl PHP_ADD_SOURCES_X(source-path, sources[, special-flags[, target-var[, shared]]])
dnl
dnl Additional to PHP_ADD_SOURCES (see above), this lets you set the name of the
dnl array target-var directly, as well as whether shared objects will be built
dnl from the sources. Should not be used directly.
dnl
AC_DEFUN([PHP_ADD_SOURCES_X],[
dnl Relative to source- or build-directory?
dnl ac_srcdir/ac_bdir include trailing slash
  case $1 in
  ""[)] ac_srcdir="$abs_srcdir/"; unset ac_bdir; ac_inc="-I. -I$abs_srcdir" ;;
  /*[)] ac_srcdir=`echo "$1"|cut -c 2-`"/"; ac_bdir=$ac_srcdir; ac_inc="-I$ac_bdir -I$abs_srcdir/$ac_bdir" ;;
  *[)] ac_srcdir="$abs_srcdir/$1/"; ac_bdir="$1/"; ac_inc="-I$ac_bdir -I$ac_srcdir" ;;
  esac

dnl how to build .. shared or static?
  ifelse($5,yes,_PHP_ASSIGN_BUILD_VARS(shared),_PHP_ASSIGN_BUILD_VARS(php))

dnl Iterate over the sources.
  old_IFS=[$]IFS
  for ac_src in $2; do

dnl Remove the suffix.
      IFS=.
      set $ac_src
      ac_obj=[$]1
      IFS=$old_IFS

dnl Append to the array which has been dynamically chosen at m4 time.
      $4="[$]$4 [$]ac_bdir[$]ac_obj.lo"

dnl Choose the right compiler/flags/etc. for the source-file.
      case $ac_src in
        *.c[)] ac_comp="$b_c_pre $ac_inc $b_c_meta $3 -c $ac_srcdir$ac_src -o $ac_bdir$ac_obj.$b_lo $b_c_post" ;;
        *.s[)] ac_comp="$b_c_pre $ac_inc $b_c_meta $3 -c $ac_srcdir$ac_src -o $ac_bdir$ac_obj.$b_lo $b_c_post" ;;
        *.S[)] ac_comp="$b_c_pre $ac_inc $b_c_meta $3 -c $ac_srcdir$ac_src -o $ac_bdir$ac_obj.$b_lo $b_c_post" ;;
        *.cpp|*.cc|*.cxx[)] ac_comp="$b_cxx_pre $ac_inc $b_cxx_meta $3 -c $ac_srcdir$ac_src -o $ac_bdir$ac_obj.$b_lo $b_cxx_post" ;;
      esac

dnl Generate Makefiles with dependencies
      ac_comp="$ac_comp -MMD -MF $ac_bdir$ac_obj.dep -MT $ac_bdir[$]ac_obj.lo"

dnl Create a rule for the object/source combo.
    cat >>Makefile.objects<<EOF
-include $ac_bdir[$]ac_obj.dep
$ac_bdir[$]ac_obj.lo: $ac_srcdir[$]ac_src
	$ac_comp
EOF
  done
])

dnl ----------------------------------------------------------------------------
dnl Compiler characteristics checks.
dnl ----------------------------------------------------------------------------

dnl
dnl PHP_RUNPATH_SWITCH
dnl
dnl Checks for -R, etc. switch.
dnl
AC_DEFUN([PHP_RUNPATH_SWITCH],[
AC_MSG_CHECKING([if compiler supports -Wl,-rpath,])
AC_CACHE_VAL(php_cv_cc_rpath,[
  SAVE_LIBS=$LIBS
  LIBS="-Wl,-rpath,/usr/$PHP_LIBDIR $LIBS"
  AC_LINK_IFELSE([AC_LANG_PROGRAM([], [])],[php_cv_cc_rpath=yes],[php_cv_cc_rpath=no])
  LIBS=$SAVE_LIBS])
AC_MSG_RESULT([$php_cv_cc_rpath])
if test $php_cv_cc_rpath = "yes"; then
  ld_runpath_switch=-Wl,-rpath,
else
  AC_MSG_CHECKING([if compiler supports -R])
  AC_CACHE_VAL(php_cv_cc_dashr,[
    SAVE_LIBS=$LIBS
    LIBS="-R /usr/$PHP_LIBDIR $LIBS"
    AC_LINK_IFELSE([AC_LANG_PROGRAM([], [])],[php_cv_cc_dashr=yes],[php_cv_cc_dashr=no])
    LIBS=$SAVE_LIBS])
  AC_MSG_RESULT([$php_cv_cc_dashr])
  if test $php_cv_cc_dashr = "yes"; then
    ld_runpath_switch=-R
  else
    dnl Something innocuous.
    ld_runpath_switch=-L
  fi
fi
if test "$PHP_RPATH" = "no"; then
  ld_runpath_switch=
fi
])

AC_DEFUN([PHP_CHECK_GCC_ARG],[
  AC_MSG_ERROR([[Use AX_CHECK_COMPILE_FLAG instead]])
])

dnl
dnl PHP_LIBGCC_LIBPATH(gcc)
dnl
dnl Stores the location of libgcc in libgcc_libpath.
dnl
AC_DEFUN([PHP_LIBGCC_LIBPATH],[
  changequote({,})
  libgcc_libpath=`$1 --print-libgcc-file-name|$SED 's%/*[^/][^/]*$%%'`
  changequote([,])
])

dnl ----------------------------------------------------------------------------
dnl Macros to modify LIBS, INCLUDES, etc. variables.
dnl ----------------------------------------------------------------------------

dnl
dnl PHP_REMOVE_USR_LIB(NAME)
dnl
dnl Removes all -L/usr/$PHP_LIBDIR entries from variable NAME.
dnl
AC_DEFUN([PHP_REMOVE_USR_LIB],[
  unset ac_new_flags
  for i in [$]$1; do
    case [$]i in
    -L/usr/$PHP_LIBDIR|-L/usr/$PHP_LIBDIR/[)] ;;
    *[)] ac_new_flags="[$]ac_new_flags [$]i" ;;
    esac
  done
  $1=[$]ac_new_flags
])

dnl
dnl PHP_EVAL_LIBLINE(libline, SHARED-LIBADD)
dnl
dnl Use this macro, if you need to add libraries and or library search paths to
dnl the PHP build system which are only given in compiler notation.
dnl
AC_DEFUN([PHP_EVAL_LIBLINE],[
  for ac_i in $1; do
    case $ac_i in
    -pthread[)]
      if test "$ext_shared" = "yes"; then
        $2="[$]$2 -pthread"
      else
        PHP_RUN_ONCE(EXTRA_LDFLAGS, [$ac_i], [EXTRA_LDFLAGS="$EXTRA_LDFLAGS $ac_i"])
        PHP_RUN_ONCE(EXTRA_LDFLAGS_PROGRAM, [$ac_i],
            [EXTRA_LDFLAGS_PROGRAM="$EXTRA_LDFLAGS_PROGRAM $ac_i"])
      fi
    ;;
    -l*[)]
      ac_ii=`echo $ac_i|cut -c 3-`
      PHP_ADD_LIBRARY($ac_ii,1,$2)
    ;;
    -L*[)]
      ac_ii=`echo $ac_i|cut -c 3-`
      PHP_ADD_LIBPATH($ac_ii,$2)
    ;;
    esac
  done
])

dnl
dnl PHP_EVAL_INCLINE(headerline)
dnl
dnl Use this macro, if you need to add header search paths to the PHP build
dnl system which are only given in compiler notation.
dnl
AC_DEFUN([PHP_EVAL_INCLINE],[
  for ac_i in $1; do
    case $ac_i in
    -I*[)]
      ac_ii=`echo $ac_i|cut -c 3-`
      PHP_ADD_INCLUDE($ac_ii)
    ;;
    esac
  done
])

dnl
dnl _PHP_ADD_LIBPATH_GLOBAL(variable)
dnl
dnl Internal, don't use.
dnl
AC_DEFUN([_PHP_ADD_LIBPATH_GLOBAL],[
  PHP_RUN_ONCE(LIBPATH, $1, [
    test -n "$ld_runpath_switch" && LDFLAGS="$LDFLAGS $ld_runpath_switch$1"
    LDFLAGS="$LDFLAGS -L$1"
    PHP_RPATHS="$PHP_RPATHS $1"
  ])
])

dnl
dnl PHP_ADD_LIBPATH(path [, SHARED-LIBADD])
dnl
dnl Adds a path to linkpath/runpath (LDFLAGS).
dnl
AC_DEFUN([PHP_ADD_LIBPATH],[
  if test "$1" != "/usr/$PHP_LIBDIR" && test "$1" != "/usr/lib"; then
    PHP_EXPAND_PATH($1, ai_p)
    ifelse([$2],,[
      _PHP_ADD_LIBPATH_GLOBAL([$ai_p])
    ],[
      if test "$ext_shared" = "yes"; then
        $2="-L$ai_p [$]$2"
        test -n "$ld_runpath_switch" && $2="$ld_runpath_switch$ai_p [$]$2"
      else
        _PHP_ADD_LIBPATH_GLOBAL([$ai_p])
      fi
    ])
  fi
])

dnl
dnl PHP_UTILIZE_RPATHS()
dnl
dnl Builds RPATHS/LDFLAGS from PHP_RPATHS.
dnl
AC_DEFUN([PHP_UTILIZE_RPATHS],[
  OLD_RPATHS=$PHP_RPATHS
  unset PHP_RPATHS

  for i in $OLD_RPATHS; do
    dnl Can be passed to native cc/libtool
    PHP_LDFLAGS="$PHP_LDFLAGS -L$i"
    dnl Libtool-specific
    PHP_RPATHS="$PHP_RPATHS -R $i"
    dnl cc-specific
    NATIVE_RPATHS="$NATIVE_RPATHS $ld_runpath_switch$i"
  done

  if test "$PHP_RPATH" = "no"; then
    unset PHP_RPATHS
    unset NATIVE_RPATHS
  fi
])

dnl
dnl PHP_ADD_INCLUDE(path [,before])
dnl
dnl Add an include path. If before is 1, add in the beginning of INCLUDES.
dnl
AC_DEFUN([PHP_ADD_INCLUDE],[
  if test "$1" != "/usr/include"; then
    PHP_EXPAND_PATH($1, ai_p)
    PHP_RUN_ONCE(INCLUDEPATH, $ai_p, [
      if test "$2"; then
        INCLUDES="-I$ai_p $INCLUDES"
      else
        INCLUDES="$INCLUDES -I$ai_p"
      fi
    ])
  fi
])

dnl
dnl _PHP_X_ADD_LIBRARY
dnl
dnl Internal, don't use.
dnl
AC_DEFUN([_PHP_X_ADD_LIBRARY],[dnl
  ifelse([$2],,$3="-l$1 [$]$3", $3="[$]$3 -l$1") dnl
])

dnl
dnl _PHP_ADD_LIBRARY_SKELETON
dnl
dnl Internal, don't use.
dnl
AC_DEFUN([_PHP_ADD_LIBRARY_SKELETON],[
  case $1 in
  c|c_r[)] ;;
  *[)] ifelse($3,,[
    _PHP_X_ADD_LIBRARY($1,$2,$5)
  ],[
    if test "$ext_shared" = "yes"; then
      _PHP_X_ADD_LIBRARY($1,$2,$3)
    else
      $4($1,$2)
    fi
  ]) ;;
  esac
])

dnl
dnl PHP_ADD_LIBRARY(library[, append[, shared-libadd]])
dnl
dnl Add a library to the link line.
dnl
AC_DEFUN([PHP_ADD_LIBRARY],[
  _PHP_ADD_LIBRARY_SKELETON([$1],[$2],[$3],[PHP_ADD_LIBRARY],[LIBS])
])

dnl
dnl PHP_ADD_LIBRARY_DEFER(library[, append[, shared-libadd]])
dnl
dnl Add a library to the link line (deferred, not used during configure).
dnl
AC_DEFUN([PHP_ADD_LIBRARY_DEFER],[
  _PHP_ADD_LIBRARY_SKELETON([$1],[$2],[$3],[PHP_ADD_LIBRARY_DEFER],[DLIBS])
])

dnl
dnl PHP_ADD_LIBRARY_WITH_PATH(library, path[, shared-libadd])
dnl
dnl Add a library to the link line and path to linkpath/runpath. If
dnl shared-libadd is not empty and $ext_shared is yes, shared-libadd will be
dnl assigned the library information.
dnl
AC_DEFUN([PHP_ADD_LIBRARY_WITH_PATH],[
ifelse($3,,[
  if test -n "$2"; then
    PHP_ADD_LIBPATH($2)
  fi
  PHP_ADD_LIBRARY($1)
],[
  if test "$ext_shared" = "yes"; then
    $3="-l$1 [$]$3"
    if test -n "$2"; then
      PHP_ADD_LIBPATH($2,$3)
    fi
  else
    PHP_ADD_LIBRARY_WITH_PATH($1,$2)
  fi
])
])

dnl
dnl PHP_ADD_LIBRARY_DEFER_WITH_PATH(library, path[, shared-libadd])
dnl
dnl Add a library to the link line (deferred) and path to linkpath/runpath (not
dnl deferred). If shared-libadd is not empty and $ext_shared is yes,
dnl shared-libadd will be assigned the library information.
dnl
AC_DEFUN([PHP_ADD_LIBRARY_DEFER_WITH_PATH],[
ifelse($3,,[
  if test -n "$2"; then
    PHP_ADD_LIBPATH($2)
  fi
  PHP_ADD_LIBRARY_DEFER($1)
],[
  if test "$ext_shared" = "yes"; then
    $3="-l$1 [$]$3"
    if test -n "$2"; then
      PHP_ADD_LIBPATH($2,$3)
    fi
  else
    PHP_ADD_LIBRARY_DEFER_WITH_PATH($1,$2)
  fi
])
])

dnl
dnl PHP_ADD_FRAMEWORK(framework [,before])
dnl
dnl Add a (Darwin / Mac OS X) framework to the link line. If before is 1, the
dnl framework is added to the beginning of the line.
dnl
AC_DEFUN([PHP_ADD_FRAMEWORK], [
  PHP_RUN_ONCE(FRAMEWORKS, $1, [
    if test "$2"; then
      PHP_FRAMEWORKS="-framework $1 $PHP_FRAMEWORKS"
    else
      PHP_FRAMEWORKS="$PHP_FRAMEWORKS -framework $1"
    fi
  ])
])

dnl
dnl PHP_ADD_FRAMEWORKPATH(path [,before])
dnl
dnl Add a (Darwin / Mac OS X) framework path to the link and include lines.
dnl Default paths include (but are not limited to) /Local/Library/Frameworks and
dnl /System/Library/Frameworks, so these don't need to be specifically added. If
dnl before is 1, the framework path is added to the beginning of the relevant
dnl lines.
dnl
AC_DEFUN([PHP_ADD_FRAMEWORKPATH], [
  PHP_EXPAND_PATH($1, ai_p)
  PHP_RUN_ONCE(FRAMEWORKPATH, $ai_p, [
    if test "$2"; then
      PHP_FRAMEWORKPATH="-F$ai_p $PHP_FRAMEWORKPATH"
    else
      PHP_FRAMEWORKPATH="$PHP_FRAMEWORKPATH -F$ai_p"
    fi
  ])
])

dnl
dnl PHP_ADD_FRAMEWORK_WITH_PATH(framework, path)
dnl
dnl Adds a (Darwin / Mac OS X) framework path and the framework itself to the
dnl link and include lines.
dnl
AC_DEFUN([PHP_ADD_FRAMEWORK_WITH_PATH], [
  PHP_ADD_FRAMEWORKPATH($2)
  PHP_ADD_FRAMEWORK($1)
])

dnl
dnl PHP_SET_LIBTOOL_VARIABLE(var)
dnl
dnl Set libtool variable.
dnl
AC_DEFUN([PHP_SET_LIBTOOL_VARIABLE],[
  if test -z "$LIBTOOL"; then
    LIBTOOL='$(SHELL) $(top_builddir)/libtool $1'
  else
    LIBTOOL="$LIBTOOL $1"
  fi
])

dnl ----------------------------------------------------------------------------
dnl Wrapper macros for AC_ARG_WITH / AC_ARG_ENABLE
dnl ----------------------------------------------------------------------------

dnl
dnl PHP_ARG_ANALYZE_EX
dnl
dnl Internal.
dnl
AC_DEFUN([PHP_ARG_ANALYZE_EX],[
ext_output="yes, shared"
ext_shared=yes
case [$]$1 in
shared,*[)]
  $1=`echo "[$]$1"|$SED 's/^shared,//'`
  ;;
shared[)]
  $1=yes
  ;;
no[)]
  ext_output=no
  ext_shared=no
  ;;
*[)]
  ext_output=yes
  ext_shared=no
  ;;
esac

PHP_ALWAYS_SHARED([$1])
])

dnl
dnl PHP_ARG_ANALYZE
dnl
dnl Internal.
dnl
AC_DEFUN([PHP_ARG_ANALYZE],[
ifelse([$3],yes,[PHP_ARG_ANALYZE_EX([$1])],[ext_output=ifelse([$]$1,,no,[$]$1)])
ifelse([$2],,,[AC_MSG_RESULT([$ext_output])])
])

dnl
dnl PHP_ARG_WITH(arg-name, check message, help text[, default-val[, extension-or-not]])
dnl
dnl Sets PHP_ARG_NAME either to the user value or to the default value.
dnl default-val defaults to no. This will also set the variable ext_shared, and
dnl will overwrite any previous variable of that name. If extension-or-not is
dnl yes (default), then do the ENABLE_ALL check and run the PHP_ARG_ANALYZE_EX.
dnl
AC_DEFUN([PHP_ARG_WITH],[
php_with_[]translit($1,A-Z0-9-,a-z0-9_)=ifelse($4,,no,$4)
PHP_REAL_ARG_WITH([$1],[$2],[$3],[$4],PHP_[]translit($1,a-z0-9-,A-Z0-9_),[ifelse($5,,yes,$5)])
])

dnl
dnl PHP_REAL_ARG_WITH
dnl
dnl Internal.
dnl
AC_DEFUN([PHP_REAL_ARG_WITH],[
ifelse([$2],,,[AC_MSG_CHECKING([$2])])
AC_ARG_WITH($1,[$3],$5=[$]withval,
[
  $5=ifelse($4,,no,$4)
  ifelse($6,yes,[test "$PHP_ENABLE_ALL" && $5=$PHP_ENABLE_ALL])
])
PHP_ARG_ANALYZE($5,[$2],$6)
])

dnl
dnl PHP_ARG_ENABLE(arg-name, check message, help text[, default-val[, extension-or-not]])
dnl
dnl Sets PHP_ARG_NAME either to the user value or to the default value.
dnl default-val defaults to no. This will also set the variable ext_shared, and
dnl will overwrite any previous variable of that name. If extension-or-not is
dnl yes (default), then do the ENABLE_ALL check and run the PHP_ARG_ANALYZE_EX.
dnl
AC_DEFUN([PHP_ARG_ENABLE],[
php_enable_[]translit($1,A-Z0-9-,a-z0-9_)=ifelse($4,,no,$4)
PHP_REAL_ARG_ENABLE([$1],[$2],[$3],[$4],PHP_[]translit($1,a-z0-9-,A-Z0-9_),[ifelse($5,,yes,$5)])
])

dnl
dnl PHP_REAL_ARG_ENABLE
dnl
dnl Internal.
dnl
AC_DEFUN([PHP_REAL_ARG_ENABLE],[
ifelse([$2],,,[AC_MSG_CHECKING([$2])])
AC_ARG_ENABLE($1,[$3],$5=[$]enableval,
[
  $5=ifelse($4,,no,$4)
  ifelse($6,yes,[test "$PHP_ENABLE_ALL" && $5=$PHP_ENABLE_ALL])
])
PHP_ARG_ANALYZE($5,[$2],$6)
])

dnl ----------------------------------------------------------------------------
dnl Build macros
dnl ----------------------------------------------------------------------------

dnl
dnl PHP_BUILD_THREAD_SAFE
dnl
AC_DEFUN([PHP_BUILD_THREAD_SAFE],[
  enable_zts=yes
  if test "$pthreads_working" != "yes"; then
    AC_MSG_ERROR([ZTS currently requires working POSIX threads. We were unable to verify that your system supports Pthreads.])
  fi
])

dnl
dnl PHP_REQUIRE_CXX
dnl
AC_DEFUN([PHP_REQUIRE_CXX],[
  if test -z "$php_cxx_done"; then
    AC_PROG_CXX
    AC_PROG_CXXCPP
    PHP_ADD_LIBRARY(stdc++)
    php_cxx_done=yes
  fi
])

dnl
dnl PHP_BUILD_SHARED
dnl
AC_DEFUN([PHP_BUILD_SHARED],[
  PHP_BUILD_PROGRAM
  OVERALL_TARGET=libphp$PHP_VER.la
  php_sapi_module=shared

  php_c_pre=$shared_c_pre
  php_c_meta=$shared_c_meta
  php_c_post=$shared_c_post
  php_cxx_pre=$shared_cxx_pre
  php_cxx_meta=$shared_cxx_meta
  php_cxx_post=$shared_cxx_post
  php_lo=$shared_lo
])

dnl
dnl PHP_BUILD_STATIC
dnl
AC_DEFUN([PHP_BUILD_STATIC],[
  PHP_BUILD_PROGRAM
  OVERALL_TARGET=libphp$PHP_VER.la
  php_sapi_module=static
])

dnl
dnl PHP_BUILD_BUNDLE
dnl
AC_DEFUN([PHP_BUILD_BUNDLE],[
  PHP_BUILD_PROGRAM
  OVERALL_TARGET=libs/libphp$PHP_VER.bundle
  php_sapi_module=static
])

dnl
dnl PHP_BUILD_PROGRAM
dnl
AC_DEFUN([PHP_BUILD_PROGRAM],[
  php_c_pre='$(LIBTOOL) --tag=CC --mode=compile $(CC)'
  php_c_meta='$(COMMON_FLAGS) $(CFLAGS_CLEAN) $(EXTRA_CFLAGS)'
  php_c_post=
  php_cxx_pre='$(LIBTOOL) --tag=CXX --mode=compile $(CXX)'
  php_cxx_meta='$(COMMON_FLAGS) $(CXXFLAGS_CLEAN) $(EXTRA_CXXFLAGS)'
  php_cxx_post=
  php_lo=lo

  case $with_pic in
    yes) pic_setting='-prefer-pic';;
    no)  pic_setting='-prefer-non-pic';;
  esac

  shared_c_pre='$(LIBTOOL) --tag=CC --mode=compile $(CC)'
  shared_c_meta='$(COMMON_FLAGS) $(CFLAGS_CLEAN) $(EXTRA_CFLAGS) '$pic_setting
  shared_c_post=
  shared_cxx_pre='$(LIBTOOL) --tag=CXX --mode=compile $(CXX)'
  shared_cxx_meta='$(COMMON_FLAGS) $(CXXFLAGS_CLEAN) $(EXTRA_CXXFLAGS) '$pic_setting
  shared_cxx_post=
  shared_lo=lo
])

dnl
dnl PHP_SHARED_MODULE(module-name, object-var, build-dir, cxx, zend_ext)
dnl
dnl Basically sets up the link-stage for building module-name from object_var in
dnl build-dir.
dnl
AC_DEFUN([PHP_SHARED_MODULE],[
  install_modules="install-modules"
  suffix=la

  case $host_alias in
    *aix*[)]
      additional_flags="-Wl,-G"
      ;;
  esac

  if test "x$5" = "xyes"; then
    PHP_ZEND_EX="$PHP_ZEND_EX \$(phplibdir)/$1.$suffix"
  else
    PHP_MODULES="$PHP_MODULES \$(phplibdir)/$1.$suffix"
  fi
  PHP_SUBST($2)
  cat >>Makefile.objects<<EOF
\$(phplibdir)/$1.$suffix: $3/$1.$suffix
	\$(LIBTOOL) --tag=ifelse($4,,CC,CXX) --mode=install cp $3/$1.$suffix \$(phplibdir)

$3/$1.$suffix: \$($2) \$(translit($1,a-z_-,A-Z__)_SHARED_DEPENDENCIES)
	\$(LIBTOOL) --tag=ifelse($4,,CC,CXX) --mode=link ifelse($4,,[\$(CC)],[\$(CXX)]) -shared \$(COMMON_FLAGS) \$(CFLAGS_CLEAN) \$(EXTRA_CFLAGS) \$(LDFLAGS) $additional_flags -o [\$]@ -export-dynamic -avoid-version -prefer-pic -module -rpath \$(phplibdir) \$(EXTRA_LDFLAGS) \$($2) \$(translit($1,a-z_-,A-Z__)_SHARED_LIBADD)

EOF
])

dnl
dnl PHP_SELECT_SAPI(name, type[, sources [, extra-cflags [, build-target]]])
dnl
dnl Selects the SAPI name and type (static, shared, bundle, program) and
dnl optionally also the source-files for the SAPI-specific objects.
dnl
AC_DEFUN([PHP_SELECT_SAPI],[
  if test "$2" = "program"; then
    PHP_BINARIES="$PHP_BINARIES $1"
  elif test "$PHP_SAPI" != "none"; then
    AC_MSG_ERROR([
+--------------------------------------------------------------------+
|                        *** ATTENTION ***                           |
|                                                                    |
| You've configured multiple SAPIs to be built. You can build only   |
| one SAPI module plus CGI, CLI and FPM binaries at the same time.   |
+--------------------------------------------------------------------+
])
  else
    PHP_SAPI=$1
  fi

  PHP_ADD_BUILD_DIR([sapi/$1])

  PHP_INSTALLED_SAPIS="$PHP_INSTALLED_SAPIS $1"

  ifelse($2,program,[
    PHP_BUILD_PROGRAM
    install_binaries="install-binaries"
    install_binary_targets="$install_binary_targets install-$1"
    PHP_SUBST(PHP_[]translit($1,a-z0-9-,A-Z0-9_)[]_OBJS)
    ifelse($3,,,[PHP_ADD_SOURCES_X([sapi/$1],[$3],[$4],PHP_[]translit($1,a-z0-9-,A-Z0-9_)[]_OBJS)])
  ],[
    case "$2" in
    static[)] PHP_BUILD_STATIC;;
    shared[)] PHP_BUILD_SHARED;;
    bundle[)] PHP_BUILD_BUNDLE;;
    esac
    install_sapi="install-sapi"
    ifelse($3,,,[PHP_ADD_SOURCES([sapi/$1],[$3],[$4],[sapi])])
  ])
])

dnl
dnl PHP_ADD_BUILD_DIR
dnl
AC_DEFUN([PHP_ADD_BUILD_DIR],[
  ifelse($2,,[
    BUILD_DIR="$BUILD_DIR $1"
  ], [
    $php_shtool mkdir -p $1
  ])
])

dnl
dnl PHP_GEN_BUILD_DIRS
dnl
AC_DEFUN([PHP_GEN_BUILD_DIRS],[
  $php_shtool mkdir -p $BUILD_DIR
])

dnl
dnl PHP_NEW_EXTENSION(extname, sources [, shared [, sapi_class [, extra-cflags [, cxx [, zend_ext]]]]])
dnl
dnl Includes an extension in the build.
dnl
dnl "extname" is the name of the extension.
dnl "sources" is a list of files relative to the subdir which are used to build
dnl the extension.
dnl "shared" can be set to "shared" or "yes" to build the extension as a
dnl dynamically loadable library. Optional parameter "sapi_class" can be set to
dnl "cli" to mark extension build only with CLI or CGI sapi's. "extra-cflags"
dnl are passed to the compiler, with @ext_srcdir@ and @ext_builddir@ being
dnl substituted.
dnl "cxx" can be used to indicate that a C++ shared module is desired.
dnl "zend_ext" indicates a zend extension.
AC_DEFUN([PHP_NEW_EXTENSION],[
  ext_builddir=[]PHP_EXT_BUILDDIR($1)
  ext_srcdir=[]PHP_EXT_SRCDIR($1)
  ext_dir=[]PHP_EXT_DIR($1)

  ifelse($5,,ac_extra=,[ac_extra=`echo "$5"|$SED s#@ext_srcdir@#$ext_srcdir#g|$SED s#@ext_builddir@#$ext_builddir#g`])

  if test "$3" != "shared" && test "$3" != "yes" && test "$4" != "cli"; then
dnl ---------------------------------------------- Static module
    [PHP_]translit($1,a-z_-,A-Z__)[_SHARED]=no
    PHP_ADD_SOURCES($ext_dir,$2,$ac_extra,)
    EXT_STATIC="$EXT_STATIC $1;$ext_dir"
    if test "$3" != "nocli"; then
      EXT_CLI_STATIC="$EXT_CLI_STATIC $1;$ext_dir"
    fi
  else
    if test "$3" = "shared" || test "$3" = "yes"; then
dnl ---------------------------------------------- Shared module
      [PHP_]translit($1,a-z_-,A-Z__)[_SHARED]=yes
      PHP_ADD_SOURCES_X($ext_dir,$2,$ac_extra -DZEND_COMPILE_DL_EXT=1,shared_objects_$1,yes)
      PHP_SHARED_MODULE($1,shared_objects_$1, $ext_builddir, $6, $7)
      AC_DEFINE_UNQUOTED([COMPILE_DL_]translit($1,a-z_-,A-Z__), 1, Whether to build $1 as dynamic module)
    fi
  fi

  if test "$3" != "shared" && test "$3" != "yes" && test "$4" = "cli"; then
dnl ---------------------------------------------- CLI static module
    [PHP_]translit($1,a-z_-,A-Z__)[_SHARED]=no
    case "$PHP_SAPI" in
      cgi|embed|phpdbg[)]
        PHP_ADD_SOURCES($ext_dir,$2,$ac_extra,)
        EXT_STATIC="$EXT_STATIC $1;$ext_dir"
        ;;
      *[)]
        PHP_ADD_SOURCES($ext_dir,$2,$ac_extra,cli)
        ;;
    esac
    EXT_CLI_STATIC="$EXT_CLI_STATIC $1;$ext_dir"
  fi
  PHP_ADD_BUILD_DIR($ext_builddir)

dnl Set for phpize builds only.
dnl ---------------------------
  if test "$ext_builddir" = "."; then
    PHP_PECL_EXTENSION=$1
    PHP_SUBST(PHP_PECL_EXTENSION)
  fi
])

dnl
dnl PHP_WITH_SHARED
dnl
dnl Checks whether $withval is "shared" or starts with "shared,XXX" and sets
dnl $shared to "yes" or "no", and removes "shared,?" stuff from $withval.
dnl
AC_DEFUN([PHP_WITH_SHARED],[
  PHP_ARG_ANALYZE_EX(withval)
  shared=$ext_shared
  unset ext_shared ext_output
])

dnl
dnl PHP_ADD_EXTENSION_DEP(extname, depends [, depconf])
dnl
dnl This macro is scanned by genif.sh when it builds the internal functions
dnl list, so that modules can be init'd in the correct order
dnl $1 = name of extension, $2 = extension upon which it depends
dnl $3 = optional: if true, it's ok for $2 to have not been configured default
dnl is false and should halt the build. To be effective, this macro must be
dnl invoked *after* PHP_NEW_EXTENSION. The extension on which it depends must
dnl also have been configured. See ADD_EXTENSION_DEP in win32 build.
dnl
AC_DEFUN([PHP_ADD_EXTENSION_DEP], [
  am_i_shared=$[PHP_]translit($1,a-z_-,A-Z__)[_SHARED]
  is_it_shared=$[PHP_]translit($2,a-z_-,A-Z__)[_SHARED]
  is_it_enabled=$[PHP_]translit($2,a-z_-,A-Z__)
  if test "$am_i_shared" = "no" && test "$is_it_shared" = "yes" ; then
    AC_MSG_ERROR([
You've configured extension $1 to build statically, but it
depends on extension $2, which you've configured to build shared.
You either need to build $1 shared or build $2 statically for the
build to be successful.
])
  fi
  if test "x$is_it_enabled" = "xno" && test "x$3" != "xtrue"; then
    AC_MSG_ERROR([
You've configured extension $1, which depends on extension $2,
but you've either not enabled $2, or have disabled it.
])
  fi
  dnl Some systems require that we link $2 to $1 when building.
])

dnl ----------------------------------------------------------------------------
dnl Checks for structures, typedefs, broken functions, etc.
dnl ----------------------------------------------------------------------------

dnl
dnl _PHP_CHECK_SIZEOF(type, cross-value, extra-headers [, found-action [, not-found-action]])
dnl
dnl Internal helper macro.
dnl
AC_DEFUN([_PHP_CHECK_SIZEOF], [
  php_cache_value=php_cv_sizeof_[]$1
  AC_CACHE_VAL(php_cv_sizeof_[]$1, [
    old_LIBS=$LIBS
    LIBS=
    old_LDFLAGS=$LDFLAGS
    LDFLAGS=
    AC_RUN_IFELSE([AC_LANG_SOURCE([[#include <stdio.h>
#include <stdlib.h>
#include <stddef.h>
#include <inttypes.h>
#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif
$3

int main(void)
{
	FILE *fp = fopen("conftestval", "w");
	if (!fp) return(1);
	fprintf(fp, "%d\n", sizeof($1));
	return(0);
}
  ]])], [
    eval $php_cache_value=`cat conftestval`
  ], [
    eval $php_cache_value=0
  ], [
    ifelse([$2],,[eval $php_cache_value=0], [eval $php_cache_value=$2])
])
  LDFLAGS=$old_LDFLAGS
  LIBS=$old_LIBS
])
  if eval test "\$$php_cache_value" != "0"; then
ifelse([$4],[],:,[$4])
ifelse([$5],[],,[else $5])
  fi
])

dnl
dnl PHP_CHECK_SIZEOF(type, cross-value, extra-headers)
dnl
AC_DEFUN([PHP_CHECK_SIZEOF], [
  AC_MSG_CHECKING([size of $1])
  _PHP_CHECK_SIZEOF($1, $2, $3, [
    AC_DEFINE_UNQUOTED([SIZEOF_]translit($1,a-z,A-Z_), [$]php_cv_sizeof_[]$1, [Size of $1])
    AC_DEFINE_UNQUOTED([HAVE_]translit($1,a-z,A-Z_), 1, [Whether $1 is available])
  ])
  AC_MSG_RESULT([[$][php_cv_sizeof_]translit($1, ,_)])
])

dnl
dnl PHP_CHECK_IN_ADDR_T
dnl
AC_DEFUN([PHP_CHECK_IN_ADDR_T], [
dnl AIX keeps in_addr_t in /usr/include/netinet/in.h
AC_MSG_CHECKING([for in_addr_t])
AC_CACHE_VAL(ac_cv_type_in_addr_t,
[AC_EGREP_CPP(dnl
changequote(<<,>>)dnl
<<in_addr_t[^a-zA-Z_0-9]>>dnl
changequote([,]), [#include <sys/types.h>
#include <stdlib.h>
#include <stddef.h>
#ifdef HAVE_NETINET_IN_H
#include <netinet/in.h>
#endif], ac_cv_type_in_addr_t=yes, ac_cv_type_in_addr_t=no)])dnl
AC_MSG_RESULT([$ac_cv_type_in_addr_t])
if test $ac_cv_type_in_addr_t = no; then
  AC_DEFINE(in_addr_t, u_int, [ ])
fi
])

dnl
dnl PHP_TIME_R_TYPE
dnl
dnl Check type of reentrant time-related functions. Type can be: irix, hpux or
dnl POSIX.
dnl
AC_DEFUN([PHP_TIME_R_TYPE],[
AC_CACHE_CHECK(for type of reentrant time-related functions, ac_cv_time_r_type,[
AC_RUN_IFELSE([AC_LANG_SOURCE([[
#include <time.h>

int main(void) {
char buf[27];
struct tm t;
time_t old = 0;
int r, s;

s = gmtime_r(&old, &t);
r = (int) asctime_r(&t, buf, 26);
if (r == s && s == 0) return (0);
return (1);
}
]])],[
  ac_cv_time_r_type=hpux
],[
  AC_RUN_IFELSE([AC_LANG_SOURCE([[
#include <time.h>
int main(void) {
  struct tm t, *s;
  time_t old = 0;
  char buf[27], *p;

  s = gmtime_r(&old, &t);
  p = asctime_r(&t, buf, 26);
  if (p == buf && s == &t) return (0);
  return (1);
}
  ]])],[
    ac_cv_time_r_type=irix
  ],[
    ac_cv_time_r_type=POSIX
  ],[
    ac_cv_time_r_type=POSIX
  ])
],[
  ac_cv_time_r_type=POSIX
])
])
  case $ac_cv_time_r_type in
  hpux[)] AC_DEFINE(PHP_HPUX_TIME_R,1,[Whether you have HP-UX 10.x]) ;;
  irix[)] AC_DEFINE(PHP_IRIX_TIME_R,1,[Whether you have IRIX-style functions]) ;;
  esac
])

dnl
dnl PHP_DOES_PWRITE_WORK
dnl
dnl Internal.
dnl
AC_DEFUN([PHP_DOES_PWRITE_WORK],[
  AC_RUN_IFELSE([AC_LANG_SOURCE([[
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <unistd.h>
#include <errno.h>
#include <stdlib.h>
$1
    int main(void) {
    int fd = open("conftest_in", O_WRONLY|O_CREAT, 0600);

    if (fd < 0) return 1;
    if (pwrite(fd, "text", 4, 0) != 4) return 1;
    /* Linux glibc breakage until 2.2.5 */
    if (pwrite(fd, "text", 4, -1) != -1 || errno != EINVAL) return 1;
    return 0;
    }

  ]])],[
    ac_cv_pwrite=yes
  ],[
    ac_cv_pwrite=no
  ],[
    ac_cv_pwrite=no
  ])
])

dnl
dnl PHP_DOES_PREAD_WORK
dnl
dnl Internal.
dnl
AC_DEFUN([PHP_DOES_PREAD_WORK],[
  echo test > conftest_in
  AC_RUN_IFELSE([AC_LANG_SOURCE([[
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <unistd.h>
#include <errno.h>
#include <stdlib.h>
$1
    int main(void) {
    char buf[3];
    int fd = open("conftest_in", O_RDONLY);
    if (fd < 0) return 1;
    if (pread(fd, buf, 2, 0) != 2) return 1;
    /* Linux glibc breakage until 2.2.5 */
    if (pread(fd, buf, 2, -1) != -1 || errno != EINVAL) return 1;
    return 0;
    }
  ]])],[
    ac_cv_pread=yes
  ],[
    ac_cv_pread=no
  ],[
    ac_cv_pread=no
  ])
  rm -f conftest_in
])

dnl
dnl PHP_PWRITE_TEST
dnl
AC_DEFUN([PHP_PWRITE_TEST],[
  AC_CACHE_CHECK(whether pwrite works,ac_cv_pwrite,[
    PHP_DOES_PWRITE_WORK
    if test "$ac_cv_pwrite" = "no"; then
      PHP_DOES_PWRITE_WORK([ssize_t pwrite(int, void *, size_t, off64_t);])
      if test "$ac_cv_pwrite" = "yes"; then
        ac_cv_pwrite=64
      fi
    fi
  ])

  if test "$ac_cv_pwrite" != "no"; then
    AC_DEFINE(HAVE_PWRITE, 1, [ ])
    if test "$ac_cv_pwrite" = "64"; then
      AC_DEFINE(PHP_PWRITE_64, 1, [whether pwrite64 is default])
    fi
  fi
])

dnl
dnl PHP_PREAD_TEST
dnl
AC_DEFUN([PHP_PREAD_TEST],[
  AC_CACHE_CHECK(whether pread works,ac_cv_pread,[
    PHP_DOES_PREAD_WORK
    if test "$ac_cv_pread" = "no"; then
      PHP_DOES_PREAD_WORK([ssize_t pread(int, void *, size_t, off64_t);])
      if test "$ac_cv_pread" = "yes"; then
        ac_cv_pread=64
      fi
    fi
  ])

  if test "$ac_cv_pread" != "no"; then
    AC_DEFINE(HAVE_PREAD, 1, [ ])
    if test "$ac_cv_pread" = "64"; then
      AC_DEFINE(PHP_PREAD_64, 1, [whether pread64 is default])
    fi
  fi
])

dnl
dnl PHP_MISSING_TIME_R_DECL
dnl
AC_DEFUN([PHP_MISSING_TIME_R_DECL],[
AC_CHECK_DECL([localtime_r],,
  [AC_DEFINE([MISSING_LOCALTIME_R_DECL], [1], [Whether localtime_r is declared])],
  [#include <time.h>])
AC_CHECK_DECL([gmtime_r],,
  [AC_DEFINE([MISSING_GMTIME_R_DECL], [1], [Whether gmtime_r is declared])],
  [#include <time.h>])
AC_CHECK_DECL([asctime_r],,
  [AC_DEFINE([MISSING_ASCTIME_R_DECL], [1], [Whether asctime_r is declared])],
  [#include <time.h>])
AC_CHECK_DECL([ctime_r],,
  [AC_DEFINE([MISSING_CTIME_R_DECL], [1], [Whether ctime_r is declared])],
  [#include <time.h>])
AC_CHECK_DECL([strtok_r],,
  [AC_DEFINE([MISSING_STRTOK_R_DECL], [1], [Whether strtok_r is declared])],
  [#include <string.h>])
])

dnl
dnl PHP_STRUCT_FLOCK
dnl
AC_DEFUN([PHP_STRUCT_FLOCK],[
AC_CACHE_CHECK(for struct flock,ac_cv_struct_flock,
    AC_COMPILE_IFELSE([AC_LANG_PROGRAM([[
#include <unistd.h>
#include <fcntl.h>
        ]], [[struct flock x;]])],[
          ac_cv_struct_flock=yes
        ],[
          ac_cv_struct_flock=no
        ])
)
if test "$ac_cv_struct_flock" = "yes" ; then
    AC_DEFINE(HAVE_STRUCT_FLOCK, 1,[whether you have struct flock])
fi
])

dnl
dnl PHP_MISSING_FCLOSE_DECL
dnl
dnl See if we have broken header files like SunOS has.
dnl
AC_DEFUN([PHP_MISSING_FCLOSE_DECL],[
  AC_MSG_CHECKING([for fclose declaration])
  AC_COMPILE_IFELSE([AC_LANG_PROGRAM([[#include <stdio.h>]], [[int (*func)(FILE *) = fclose]])],[
    AC_DEFINE(MISSING_FCLOSE_DECL,0,[ ])
    AC_MSG_RESULT([ok])
  ],[
    AC_DEFINE(MISSING_FCLOSE_DECL,1,[ ])
    AC_MSG_RESULT([missing])
  ])
])

dnl
dnl PHP_SOCKADDR_CHECKS
dnl
AC_DEFUN([PHP_SOCKADDR_CHECKS], [
  dnl Check for struct sockaddr_storage exists.
  AC_CACHE_CHECK([for struct sockaddr_storage], ac_cv_sockaddr_storage,
    [AC_COMPILE_IFELSE([AC_LANG_PROGRAM([[#include <sys/types.h>
#include <sys/socket.h>]],
    [[struct sockaddr_storage s; s]])],
    [ac_cv_sockaddr_storage=yes], [ac_cv_sockaddr_storage=no])
  ])
  if test "$ac_cv_sockaddr_storage" = "yes"; then
    AC_DEFINE(HAVE_SOCKADDR_STORAGE, 1, [Whether you have struct sockaddr_storage])
  fi
  dnl Check if field sa_len exists in struct sockaddr.
  AC_CACHE_CHECK([for field sa_len in struct sockaddr],ac_cv_sockaddr_sa_len,[
    AC_COMPILE_IFELSE([AC_LANG_PROGRAM([[#include <sys/types.h>
#include <sys/socket.h>]], [[static struct sockaddr sa; int n = (int) sa.sa_len; return n;]])],
    [ac_cv_sockaddr_sa_len=yes], [ac_cv_sockaddr_sa_len=no])
  ])
  if test "$ac_cv_sockaddr_sa_len" = "yes"; then
    AC_DEFINE(HAVE_SOCKADDR_SA_LEN, 1, [Whether struct sockaddr has field sa_len])
  fi
])

dnl
dnl PHP_EBCDIC
dnl
AC_DEFUN([PHP_EBCDIC], [
  AC_CACHE_CHECK([whether system uses EBCDIC],ac_cv_ebcdic,[
  AC_RUN_IFELSE([AC_LANG_SOURCE([[
int main(void) {
  return (unsigned char)'A' != (unsigned char)0xC1;
}
]])],[
  ac_cv_ebcdic=yes
],[
  ac_cv_ebcdic=no
],[
  ac_cv_ebcdic=no
])])
  if test "$ac_cv_ebcdic" = "yes"; then
    AC_MSG_ERROR([PHP does not support EBCDIC targets])
  fi
])

dnl
dnl PHP_BROKEN_GETCWD
dnl
dnl Some systems, notably Solaris, cause getcwd() or realpath to fail if a
dnl component of the path has execute but not read permissions.
dnl
AC_DEFUN([PHP_BROKEN_GETCWD],[
  AC_MSG_CHECKING([for broken getcwd])
  os=`uname -sr 2>/dev/null`
  case $os in
    SunOS*[)]
      AC_DEFINE(HAVE_BROKEN_GETCWD,1, [Define if system has broken getcwd])
      AC_MSG_RESULT([yes]);;
    *[)]
      AC_MSG_RESULT([no]);;
  esac
])

dnl
dnl PHP_BROKEN_GCC_STRLEN_OPT
dnl
dnl Early releases of GCC 8 shipped with a strlen() optimization bug, so they
dnl didn't properly handle the `char val[1]` struct hack. See bug #76510.
dnl
AC_DEFUN([PHP_BROKEN_GCC_STRLEN_OPT], [
  AC_CACHE_CHECK([for broken gcc optimize-strlen],ac_cv_have_broken_gcc_strlen_opt,[
  AC_RUN_IFELSE([AC_LANG_SOURCE([[
#include <stdlib.h>
#include <string.h>
#include <stdio.h>
struct s
{
  int i;
  char c[1];
};
int main(void)
{
  struct s *s = malloc(sizeof(struct s) + 3);
  s->i = 3;
  strcpy(s->c, "foo");
  return strlen(s->c+1) == 2;
}
]])],[
  ac_cv_have_broken_gcc_strlen_opt=yes
],[
  ac_cv_have_broken_gcc_strlen_opt=no
],[
  ac_cv_have_broken_gcc_strlen_opt=no
])])
  if test "$ac_cv_have_broken_gcc_strlen_opt" = "yes"; then
    CFLAGS="$CFLAGS -fno-optimize-strlen"
  fi
])

dnl
dnl PHP_FOPENCOOKIE
dnl
AC_DEFUN([PHP_FOPENCOOKIE], [
  AC_CHECK_FUNC(fopencookie, [have_glibc_fopencookie=yes])

  if test "$have_glibc_fopencookie" = "yes"; then
dnl This comes in two flavors: newer glibcs (since 2.1.2?) have a type called
dnl cookie_io_functions_t.
AC_COMPILE_IFELSE([AC_LANG_PROGRAM([[
#define _GNU_SOURCE
#include <stdio.h>
]], [[cookie_io_functions_t cookie;]])],[have_cookie_io_functions_t=yes],[])

    if test "$have_cookie_io_functions_t" = "yes"; then
      cookie_io_functions_t=cookie_io_functions_t
      have_fopen_cookie=yes

dnl Even newer glibcs have a different seeker definition.
AC_RUN_IFELSE([AC_LANG_SOURCE([[
#define _GNU_SOURCE
#include <stdio.h>
#include <stdlib.h>

struct cookiedata {
  off64_t pos;
};

ssize_t reader(void *cookie, char *buffer, size_t size)
{ return size; }
ssize_t writer(void *cookie, const char *buffer, size_t size)
{ return size; }
int closer(void *cookie)
{ return 0; }
int seeker(void *cookie, off64_t *position, int whence)
{ ((struct cookiedata*)cookie)->pos = *position; return 0; }

cookie_io_functions_t funcs = {reader, writer, seeker, closer};

int main(void) {
  struct cookiedata g = { 0 };
  FILE *fp = fopencookie(&g, "r", funcs);

  if (fp && fseek(fp, 8192, SEEK_SET) == 0 && g.pos == 8192)
    return 0;
  return 1;
}

]])], [
  cookie_io_functions_use_off64_t=yes
], [
  cookie_io_functions_use_off64_t=no
], [
  dnl Cross compilation.
  case $host_alias in
    *linux*)
      cookie_io_functions_use_off64_t=yes
      ;;
    *)
      cookie_io_functions_use_off64_t=no
      ;;
  esac
])

    else

dnl Older glibc versions (up to 2.1.2?) call it _IO_cookie_io_functions_t.
AC_COMPILE_IFELSE([AC_LANG_PROGRAM([[
#define _GNU_SOURCE
#include <stdio.h>
]], [[_IO_cookie_io_functions_t cookie;]])], [have_IO_cookie_io_functions_t=yes], [])
      if test "$have_cookie_io_functions_t" = "yes" ; then
        cookie_io_functions_t=_IO_cookie_io_functions_t
        have_fopen_cookie=yes
      fi
    fi

    if test "$have_fopen_cookie" = "yes" ; then
      AC_DEFINE(HAVE_FOPENCOOKIE, 1, [ ])
      AC_DEFINE_UNQUOTED(COOKIE_IO_FUNCTIONS_T, $cookie_io_functions_t, [ ])
      if test "$cookie_io_functions_use_off64_t" = "yes" ; then
        AC_DEFINE(COOKIE_SEEKER_USES_OFF64_T, 1, [ ])
      fi
    fi
  fi
])

dnl ----------------------------------------------------------------------------
dnl Library/function existence and build sanity checks.
dnl ----------------------------------------------------------------------------

dnl
dnl PHP_CHECK_LIBRARY(library, function [, action-found [, action-not-found [, extra-libs]]])
dnl
dnl Wrapper for AC_CHECK_LIB.
dnl
AC_DEFUN([PHP_CHECK_LIBRARY], [
  save_old_LDFLAGS=$LDFLAGS
  ac_stuff="$5"

  save_ext_shared=$ext_shared
  ext_shared=yes
  PHP_EVAL_LIBLINE([$]ac_stuff, LDFLAGS)
  AC_CHECK_LIB([$1],[$2],[
    LDFLAGS=$save_old_LDFLAGS
    ext_shared=$save_ext_shared
    $3
  ],[
    LDFLAGS=$save_old_LDFLAGS
    ext_shared=$save_ext_shared
    unset ac_cv_lib_$1[]_$2
    $4
  ])dnl
])

dnl
dnl PHP_CHECK_FRAMEWORK(framework, function [, action-found [, action-not-found ]])
dnl
dnl El cheapo wrapper for AC_CHECK_LIB.
dnl
AC_DEFUN([PHP_CHECK_FRAMEWORK], [
  save_old_LDFLAGS=$LDFLAGS
  LDFLAGS="-framework $1 $LDFLAGS"
  dnl Supplying "c" to AC_CHECK_LIB is technically cheating, but rewriting
  dnl AC_CHECK_LIB is overkill and this only affects the "checking.." output
  dnl anyway.
  AC_CHECK_LIB(c,[$2],[
    LDFLAGS=$save_old_LDFLAGS
    $3
  ],[
    LDFLAGS=$save_old_LDFLAGS
    $4
  ])
])

dnl
dnl PHP_CHECK_FUNC_LIB(func, libs)
dnl
dnl This macro checks whether 'func' or '__func' exists in the specified
dnl library. Defines HAVE_func and HAVE_library if found and adds the library to
dnl LIBS. This should be called in the ACTION-IF-NOT-FOUND part of
dnl PHP_CHECK_FUNC.
dnl
dnl autoconf undefines the builtin "shift" :-(
dnl If possible, we use the builtin shift anyway, otherwise we use the ubercool
dnl definition that has been tested so far with FreeBSD/GNU m4.
dnl
ifdef([builtin],[builtin(define, phpshift, [builtin(shift, $@)])],[
define([phpshift],[ifelse(index([$@],[,]),-1,,[substr([$@],incr(index([$@],[,])))])])
])

dnl
dnl PHP_CHECK_FUNC_LIB
dnl
AC_DEFUN([PHP_CHECK_FUNC_LIB],[
  ifelse($2,,:,[
  unset ac_cv_lib_$2[]_$1
  unset ac_cv_lib_$2[]___$1
  unset found
  AC_CHECK_LIB($2, $1, [found=yes], [
    AC_CHECK_LIB($2, __$1, [found=yes], [found=no])
  ])

  if test "$found" = "yes"; then
    ac_libs=$LIBS
    LIBS="$LIBS -l$2"
    AC_RUN_IFELSE([AC_LANG_PROGRAM()],[found=yes],[found=no],[
      dnl Cross compilation.
      found=yes
    ])
    LIBS=$ac_libs
  fi

  if test "$found" = "yes"; then
    PHP_ADD_LIBRARY($2)
    PHP_DEF_HAVE($1)
    PHP_DEF_HAVE(lib$2)
    ac_cv_func_$1=yes
  else
    PHP_CHECK_FUNC_LIB($1,phpshift(phpshift($@)))
  fi
  ])
])

dnl
dnl PHP_CHECK_FUNC(func, ...)
dnl
dnl This macro checks whether 'func' or '__func' exists in the default libraries
dnl and as a fall back in the specified library. Defines HAVE_func and
dnl HAVE_library if found and adds the library to LIBS.
dnl
AC_DEFUN([PHP_CHECK_FUNC],[
  unset ac_cv_func_$1
  unset ac_cv_func___$1
  unset found

  AC_CHECK_FUNC($1, [found=yes],[ AC_CHECK_FUNC(__$1,[found=yes],[found=no]) ])

  case $found in
  yes[)]
    PHP_DEF_HAVE($1)
    ac_cv_func_$1=yes
  ;;
  ifelse($#,1,,[
    *[)] PHP_CHECK_FUNC_LIB($@) ;;
  ])
  esac
])

dnl
dnl PHP_TEST_BUILD(function, action-if-ok, action-if-not-ok [, extra-libs [, extra-source]])
dnl
dnl This macro checks whether build works and given function exists.
dnl
AC_DEFUN([PHP_TEST_BUILD], [
  old_LIBS=$LIBS
  LIBS="$4 $LIBS"
  AC_LINK_IFELSE([AC_LANG_SOURCE([[
    $5
    char $1(void);
    int main(void) {
      $1();
      return 0;
    }
  ]])],[
    LIBS=$old_LIBS
    $2
  ],[
    LIBS=$old_LIBS
    $3
  ])
])

dnl ----------------------------------------------------------------------------
dnl Platform characteristics checks.
dnl ----------------------------------------------------------------------------

dnl
dnl PHP_SHLIB_SUFFIX_NAMES
dnl
dnl Determines link library suffix SHLIB_SUFFIX_NAME which can be: .so, .sl or
dnl .dylib
dnl
dnl Determines shared library suffix SHLIB_DL_SUFFIX_NAME suffix can be: .so or
dnl .sl
dnl
AC_DEFUN([PHP_SHLIB_SUFFIX_NAMES],[
 AC_REQUIRE([PHP_CANONICAL_HOST_TARGET])dnl
 PHP_SUBST_OLD(SHLIB_SUFFIX_NAME)
 PHP_SUBST_OLD(SHLIB_DL_SUFFIX_NAME)
 SHLIB_SUFFIX_NAME=so
 SHLIB_DL_SUFFIX_NAME=$SHLIB_SUFFIX_NAME
 case $host_alias in
 *hpux*[)]
   SHLIB_SUFFIX_NAME=sl
   SHLIB_DL_SUFFIX_NAME=sl
   ;;
 *darwin*[)]
   SHLIB_SUFFIX_NAME=dylib
   SHLIB_DL_SUFFIX_NAME=so
   ;;
 esac
])

dnl
dnl PHP_C_BIGENDIAN
dnl
dnl Replacement macro for AC_C_BIGENDIAN.
dnl
AC_DEFUN([PHP_C_BIGENDIAN],
[AC_CACHE_CHECK([whether byte ordering is bigendian], ac_cv_c_bigendian_php,
 [
  ac_cv_c_bigendian_php=unknown
  AC_RUN_IFELSE([AC_LANG_SOURCE([[
int main(void)
{
  short one = 1;
  char *cp = (char *)&one;

  if (*cp == 0) {
    return(0);
  } else {
    return(1);
  }
}
  ]])], [ac_cv_c_bigendian_php=yes], [ac_cv_c_bigendian_php=no], [ac_cv_c_bigendian_php=unknown])
 ])
 if test $ac_cv_c_bigendian_php = yes; then
   AC_DEFINE(WORDS_BIGENDIAN, [], [Define if processor uses big-endian word])
 fi
])

dnl ----------------------------------------------------------------------------
dnl Checks for programs: PHP_PROG_<program>.
dnl ----------------------------------------------------------------------------

dnl
dnl PHP_PROG_SENDMAIL
dnl
dnl Search for the sendmail binary.
dnl
AC_DEFUN([PHP_PROG_SENDMAIL], [
  PHP_ALT_PATH=/usr/bin:/usr/sbin:/usr/etc:/etc:/usr/ucblib:/usr/lib
  AC_PATH_PROG(PROG_SENDMAIL, sendmail, /usr/sbin/sendmail, $PATH:$PHP_ALT_PATH)
  PHP_SUBST(PROG_SENDMAIL)
])

dnl
dnl PHP_PROG_AWK
dnl
dnl Some vendors force mawk before gawk; mawk is broken so we don't like that.
dnl
AC_DEFUN([PHP_PROG_AWK], [
  AC_CHECK_PROGS(AWK, gawk nawk awk mawk, bork, /usr/xpg4/bin/:$PATH)
  case "$AWK" in
    *mawk)
      AC_MSG_WARN([mawk is known to have problems on some systems. You should install GNU awk])
      ;;
    *gawk)
      ;;
    bork)
      AC_MSG_ERROR([Could not find awk; Install GNU awk])
      ;;
    *)
      AC_MSG_CHECKING([if $AWK is broken])
      if ! $AWK 'function foo() {}' >/dev/null 2>&1 ; then
        AC_MSG_RESULT([yes])
        AC_MSG_ERROR([You should install GNU awk])
      else
        AC_MSG_RESULT([no])
      fi
      ;;
  esac
  PHP_SUBST(AWK)
])

dnl
dnl PHP_PROG_BISON([MIN-VERSION], [EXCLUDED-VERSION...])
dnl
dnl Search for bison and optionally check if version is at least the minimum
dnl required version MIN-VERSION and doesn't match any of the blank separated
dnl list of excluded versions EXCLUDED-VERSION (for example "3.0 3.2").
dnl
AC_DEFUN([PHP_PROG_BISON], [
  AC_CHECK_PROG(YACC, bison, bison)

  ifelse($1,,php_bison_required_version='',php_bison_required_version="$1")
  ifelse($2,,php_bison_excluded_versions='none',php_bison_excluded_versions="$2")

  if test -n "$YACC"; then
    AC_MSG_CHECKING([for bison version])

    php_bison_version=$($YACC --version 2> /dev/null | grep 'GNU Bison' | cut -d ' ' -f 4 | tr -d a-z)
    if test -z "$php_bison_version"; then
      php_bison_version=0.0.0
    fi
    ac_IFS=$IFS; IFS="."
    set $php_bison_version
    IFS=$ac_IFS
    php_bison_num=`expr [$]{1:-0} \* 10000 + [$]{2:-0} \* 100 + [$]{3:-0}`
    php_bison_branch="[$]1.[$]2"
    php_bison_check=ok

    if test -z "$php_bison_required_version" && test -z "$php_bison_num"; then
      php_bison_check=invalid
    elif test -n "$php_bison_required_version"; then
      ac_IFS=$IFS; IFS="."
      set $php_bison_required_version
      IFS=$ac_IFS
      php_bison_required_num=`expr [$]{1:-0} \* 10000 + [$]{2:-0} \* 100 + [$]{3:-0}`
      php_bison_required_version="$php_bison_required_version or later"

      if test -z "$php_bison_num" || test "$php_bison_num" -lt "$php_bison_required_num"; then
        php_bison_check=invalid
      fi
    fi

    for php_bison_check_version in $php_bison_excluded_versions; do
      if test "$php_bison_version" = "$php_bison_check_version" || test "$php_bison_branch" = "$php_bison_check_version"; then
        php_bison_check=invalid
        break
      fi
    done

    if test "$php_bison_check" != "invalid"; then
      PHP_SUBST_OLD([YFLAGS], [-Wall])
      AC_MSG_RESULT([$php_bison_version (ok)])
    else
      AC_MSG_RESULT([$php_bison_version])
    fi
  fi

  case $php_bison_check in
    ""|invalid[)]
      if test ! -f "$abs_srcdir/Zend/zend_language_parser.h" || test ! -f "$abs_srcdir/Zend/zend_language_parser.c"; then
        AC_MSG_ERROR([bison $php_bison_required_version is required to generate PHP parsers (excluded versions: $php_bison_excluded_versions).])
      fi

      YACC="exit 0;"
      ;;
  esac

  PHP_SUBST(YACC)
])

dnl
dnl PHP_PROG_RE2C([MIN-VERSION])
dnl
dnl Search for the re2c and optionally check if version is at least the minimum
dnl required version MIN-VERSION.
dnl
AC_DEFUN([PHP_PROG_RE2C],[
  AC_CHECK_PROG(RE2C, re2c, re2c)

  ifelse($1,,php_re2c_required_version='',php_re2c_required_version="$1")

  if test -n "$RE2C"; then
    AC_MSG_CHECKING([for re2c version])

    php_re2c_version=$($RE2C --version | cut -d ' ' -f 2 2>/dev/null)
    if test -z "$php_re2c_version"; then
      php_re2c_version=0.0.0
    fi
    ac_IFS=$IFS; IFS="."
    set $php_re2c_version
    IFS=$ac_IFS
    php_re2c_num=`expr [$]{1:-0} \* 10000 + [$]{2:-0} \* 100 + [$]{3:-0}`
    php_re2c_check=ok

    if test -z "$php_re2c_required_version" && test -z "$php_re2c_num"; then
      php_re2c_check=invalid
    elif test -n "$php_re2c_required_version"; then
      ac_IFS=$IFS; IFS="."
      set $php_re2c_required_version
      IFS=$ac_IFS
      php_re2c_required_num=`expr [$]{1:-0} \* 10000 + [$]{2:-0} \* 100 + [$]{3:-0}`
      php_re2c_required_version="$php_re2c_required_version or later"

      if test -z "$php_re2c_num" || test "$php_re2c_num" -lt "$php_re2c_required_num"; then
        php_re2c_check=invalid
      fi
    fi

    if test "$php_re2c_check" != "invalid"; then
      AC_MSG_RESULT([$php_re2c_version (ok)])
    else
      AC_MSG_RESULT([$php_re2c_version])
    fi
  fi

  case $php_re2c_check in
    ""|invalid[)]
      if test ! -f "$abs_srcdir/Zend/zend_language_scanner.c"; then
        AC_MSG_ERROR([re2c $php_re2c_required_version is required to generate PHP lexers.])
      fi

      RE2C="exit 0;"
      ;;
  esac

  PHP_SUBST(RE2C)
])

AC_DEFUN([PHP_PROG_PHP],[
  AC_CHECK_PROG(PHP, php, php)

  if test -n "$PHP"; then
    AC_MSG_CHECKING([for php version])
    php_version=$($PHP -v | head -n1 | cut -d ' ' -f 2 | cut -d '-' -f 1)
    if test -z "$php_version"; then
      php_version=0.0.0
    fi
    ac_IFS=$IFS; IFS="."
    set $php_version
    IFS=$ac_IFS
    php_version_num=`expr [$]{1:-0} \* 10000 + [$]{2:-0} \* 100 + [$]{3:-0}`
    dnl Minimum supported version for gen_stub.php is PHP 7.4.
    if test "$php_version_num" -lt 70400; then
      AC_MSG_RESULT([$php_version (too old)])
      unset PHP
    else
      AC_MSG_RESULT([$php_version (ok)])
    fi
  fi
  PHP_SUBST(PHP)
])

dnl ----------------------------------------------------------------------------
dnl Common setup macros: PHP_SETUP_<what>
dnl ----------------------------------------------------------------------------

dnl
dnl PHP_SETUP_ICU([shared-add])
dnl
dnl Common setup macro for ICU.
dnl
AC_DEFUN([PHP_SETUP_ICU],[
  PKG_CHECK_MODULES([ICU], [icu-uc >= 50.1 icu-io icu-i18n])

  PHP_EVAL_INCLINE($ICU_CFLAGS)
  PHP_EVAL_LIBLINE($ICU_LIBS, $1)

  ICU_CFLAGS="$ICU_CFLAGS -DU_NO_DEFAULT_INCLUDE_UTF_HEADERS=1"
  ICU_CXXFLAGS="$ICU_CXXFLAGS -DUNISTR_FROM_CHAR_EXPLICIT=explicit -DUNISTR_FROM_STRING_EXPLICIT=explicit"

  AS_IF([$PKG_CONFIG icu-io --atleast-version=60],
    [ICU_CFLAGS="$ICU_CFLAGS -DU_HIDE_OBSOLETE_UTF_OLD_H=1"])
])

dnl
dnl PHP_SETUP_OPENSSL(shared-add [, action-found [, action-not-found]])
dnl
dnl Common setup macro for openssl.
dnl
AC_DEFUN([PHP_SETUP_OPENSSL],[
  found_openssl=no

  PKG_CHECK_MODULES([OPENSSL], [openssl >= 1.0.2], [found_openssl=yes])

  if test "$found_openssl" = "yes"; then
    PHP_EVAL_LIBLINE($OPENSSL_LIBS, $1)
    PHP_EVAL_INCLINE($OPENSSL_CFLAGS)
ifelse([$2],[],:,[$2])
ifelse([$3],[],,[else $3])
  fi
])

dnl
dnl PHP_SETUP_ICONV(shared-add [, action-found [, action-not-found]])
dnl
dnl Common setup macro for iconv.
dnl
AC_DEFUN([PHP_SETUP_ICONV], [
  found_iconv=no
  unset ICONV_DIR

  dnl Check libc first if no path is provided in --with-iconv.
  if test "$PHP_ICONV" = "yes"; then
    dnl Reset LIBS temporarily as it may have already been included -liconv in.
    LIBS_save="$LIBS"
    LIBS=
    AC_CHECK_FUNC(iconv, [
      found_iconv=yes
    ],[
      AC_CHECK_FUNC(libiconv,[
        AC_DEFINE(HAVE_LIBICONV, 1, [ ])
        found_iconv=yes
      ])
    ])
    LIBS="$LIBS_save"
  fi

  dnl Check external libs for iconv funcs.
  if test "$found_iconv" = "no"; then

    for i in $PHP_ICONV /usr/local /usr; do
      if test -r $i/include/gnu-libiconv/iconv.h; then
        ICONV_DIR=$i
        ICONV_INCLUDE_DIR=$i/include/gnu-libiconv
        iconv_lib_name=iconv
        break
      elif test -r $i/include/iconv.h; then
        ICONV_DIR=$i
        ICONV_INCLUDE_DIR=$i/include
        iconv_lib_name=iconv
        break
      fi
    done

    if test -z "$ICONV_DIR"; then
      AC_MSG_ERROR([Please specify the install prefix of iconv with --with-iconv=<DIR>])
    fi

    if test -f $ICONV_DIR/$PHP_LIBDIR/lib$iconv_lib_name.a ||
       test -f $ICONV_DIR/$PHP_LIBDIR/lib$iconv_lib_name.$SHLIB_SUFFIX_NAME ||
       test -f $ICONV_DIR/$PHP_LIBDIR/lib$iconv_lib_name.tbd
    then
      PHP_CHECK_LIBRARY($iconv_lib_name, libiconv, [
        found_iconv=yes
        AC_DEFINE(HAVE_LIBICONV,1,[ ])
        AC_DEFINE([ICONV_ALIASED_LIBICONV],1,[iconv() is aliased to libiconv() in -liconv])
      ], [
        PHP_CHECK_LIBRARY($iconv_lib_name, iconv, [
          found_iconv=yes
        ], [], [
          -L$ICONV_DIR/$PHP_LIBDIR
        ])
      ], [
        -L$ICONV_DIR/$PHP_LIBDIR
      ])
    fi
  fi

  if test "$found_iconv" = "yes"; then
    AC_DEFINE(HAVE_ICONV,1,[ ])
    if test -n "$ICONV_DIR"; then
      PHP_ADD_LIBRARY_WITH_PATH($iconv_lib_name, $ICONV_DIR/$PHP_LIBDIR, $1)
      PHP_ADD_INCLUDE($ICONV_INCLUDE_DIR)
    fi
    $2
ifelse([$3],[],,[else $3])
  fi
])

dnl
dnl PHP_SETUP_LIBXML(shared-add [, action-found])
dnl
dnl Common setup macro for libxml.
dnl
AC_DEFUN([PHP_SETUP_LIBXML], [
  PKG_CHECK_MODULES([LIBXML], [libxml-2.0 >= 2.9.0])

  PHP_EVAL_INCLINE($LIBXML_CFLAGS)
  PHP_EVAL_LIBLINE($LIBXML_LIBS, $1)

  AC_DEFINE(HAVE_LIBXML, 1, [ ])

  $2
])

dnl
dnl PHP_SETUP_EXPAT([shared-add])
dnl
dnl Common setup macro for expat.
dnl
AC_DEFUN([PHP_SETUP_EXPAT], [
  PKG_CHECK_MODULES([EXPAT], [expat])

  PHP_EVAL_INCLINE($EXPAT_CFLAGS)
  PHP_EVAL_LIBLINE($EXPAT_LIBS, $1)

  AC_DEFINE(HAVE_LIBEXPAT, 1, [ ])
])

dnl ----------------------------------------------------------------------------
dnl Misc. macros
dnl ----------------------------------------------------------------------------

dnl
dnl PHP_INSTALL_HEADERS(path [, file ...])
dnl
dnl PHP header files to be installed.
dnl
AC_DEFUN([PHP_INSTALL_HEADERS],[
  ifelse([$2],[],[
    for header_file in $1; do
      PHP_RUN_ONCE(INSTALLHEADERS, $header_file, [
        INSTALL_HEADERS="$INSTALL_HEADERS $header_file"
      ])
    done
  ], [
    header_path=$1
    for header_file in $2; do
      hp_hf="$header_path/$header_file"
      PHP_RUN_ONCE(INSTALLHEADERS, $hp_hf, [
        INSTALL_HEADERS="$INSTALL_HEADERS $hp_hf"
      ])
    done
  ])
])

dnl
dnl PHP_AP_EXTRACT_VERSION(/path/httpd)
dnl
dnl This macro is used to get a comparable version for Apache.
dnl
AC_DEFUN([PHP_AP_EXTRACT_VERSION],[
  ac_output=`$1 -v 2>&1 | grep version | $SED -e 's/Oracle-HTTP-//'`
  ac_IFS=$IFS
IFS="- /.
"
  set $ac_output
  IFS=$ac_IFS

  APACHE_VERSION=`expr [$]4 \* 1000000 + [$]5 \* 1000 + [$]6`
])

dnl
dnl PHP_CONFIG_NICE(filename)
dnl
dnl This macro creates script file with given filename which includes the last
dnl configure command run by user. This file is named 'config.nice' in PHP.
dnl
AC_DEFUN([PHP_CONFIG_NICE],[
  AC_REQUIRE([AC_PROG_EGREP])
  AC_REQUIRE([AC_PROG_SED])
  PHP_SUBST_OLD(EGREP)
  PHP_SUBST_OLD(SED)
  test -f $1 && mv $1 $1.old
  rm -f $1.old
  cat >$1<<EOF
#! /bin/sh
#
# Created by configure

EOF

  clean_configure_args=$ac_configure_args
  for var in CFLAGS CXXFLAGS CPPFLAGS LDFLAGS EXTRA_LDFLAGS_PROGRAM LIBS CC CXX; do
    eval val=\$$var
    if test -n "$val"; then
      echo "$var='$val' \\" >> $1
      if test `expr "X$ac_configure_args" : ".*${var}.*"` != 0; then
        clean_configure_args=$(echo $clean_configure_args | sed -e "s#'$var=$val'##")
      fi
    fi
  done

  echo "'[$]0' \\" >> $1
  if test `expr " [$]0" : " '.*"` = 0; then
    CONFIGURE_COMMAND="$CONFIGURE_COMMAND '[$]0'"
  else
    CONFIGURE_COMMAND="$CONFIGURE_COMMAND [$]0"
  fi
  CONFIGURE_ARGS="$clean_configure_args"
  while test "X$CONFIGURE_ARGS" != "X";
  do
   if CURRENT_ARG=`expr "X$CONFIGURE_ARGS" : "X *\('[[^']]*'\)"`
   then
     CONFIGURE_ARGS=`expr "X$CONFIGURE_ARGS" : "X *'[[^']]*' \(.*\)"`
   elif CURRENT_ARG=`expr "X$CONFIGURE_ARGS" : "X *\([[^ ]]*\)"`
   then
     CONFIGURE_ARGS=`expr "X$CONFIGURE_ARGS" : "X *[[^ ]]* \(.*\)"`
     CURRENT_ARG="'$CURRENT_ARG'"
   else
    break
   fi
   case "$CURRENT_ARG" in
      \'PKG_CONFIG\=*)	CURRENT_ARG="'PKG_CONFIG=/usr/pkg/bin/pkg-config'";;
      \'PKG_CONFIG_LIBDIR\=*)	CURRENT_ARG="'PKG_CONFIG_LIBDIR=/usr/pkg/lib/pkgconfig:/usr/pkg/share/pkgconfig:/usr/lib/pkgconfig:/usr/X11R7/lib/pkgconfig'";;
   esac
   AS_ECHO(["$CURRENT_ARG \\"]) >>$1
   CONFIGURE_OPTIONS="$CONFIGURE_OPTIONS $CURRENT_ARG"
  done
  echo '"[$]@"' >> $1
  chmod +x $1
  CONFIGURE_COMMAND="$CONFIGURE_COMMAND $CONFIGURE_OPTIONS"
  PHP_SUBST_OLD(CONFIGURE_COMMAND)
  PHP_SUBST_OLD(CONFIGURE_OPTIONS)
])

dnl
dnl PHP_CHECK_PDO_INCLUDES([found [, not-found]])
dnl
AC_DEFUN([PHP_CHECK_PDO_INCLUDES],[
  AC_CACHE_CHECK([for PDO includes], pdo_cv_inc_path, [
    if test -f $abs_srcdir/include/php/ext/pdo/php_pdo_driver.h; then
      pdo_cv_inc_path=$abs_srcdir/ext
    elif test -f $abs_srcdir/ext/pdo/php_pdo_driver.h; then
      pdo_cv_inc_path=$abs_srcdir/ext
    elif test -f $phpincludedir/ext/pdo/php_pdo_driver.h; then
      pdo_cv_inc_path=$phpincludedir/ext
    fi
  ])
  if test -n "$pdo_cv_inc_path"; then
ifelse([$1],[],:,[$1])
  else
ifelse([$2],[],[AC_MSG_ERROR([Cannot find php_pdo_driver.h.])],[$2])
  fi
])

dnl
dnl PHP_DETECT_ICC
dnl
dnl Detect Intel C++ Compiler and unset $GCC if ICC found.
dnl
AC_DEFUN([PHP_DETECT_ICC],
[
  ICC="no"
  AC_MSG_CHECKING([for icc])
  AC_EGREP_CPP([^__INTEL_COMPILER], [__INTEL_COMPILER],
    ICC="no"
    AC_MSG_RESULT([no]),
    ICC="yes"
    GCC="no"
    AC_MSG_RESULT([yes])
  )
])

dnl
dnl PHP_DETECT_SUNCC
dnl
dnl Detect if the systems default compiler is suncc. We also set some useful
dnl CFLAGS if the user didn't set any.
dnl
AC_DEFUN([PHP_DETECT_SUNCC],[
  SUNCC="no"
  AC_MSG_CHECKING([for suncc])
  AC_EGREP_CPP([^__SUNPRO_C], [__SUNPRO_C],
    SUNCC="no"
    AC_MSG_RESULT([no]),
    SUNCC="yes"
    GCC="no"
    test -n "$auto_cflags" && CFLAGS="-O -xs -xstrconst -zlazyload"
    GCC=""
    AC_MSG_RESULT([yes])
  )
])

dnl
dnl PHP_CRYPT_R_STYLE
dnl
dnl Detect the style of crypt_r() if any is available.
dnl See APR_CHECK_CRYPT_R_STYLE() for original version.
dnl
AC_DEFUN([PHP_CRYPT_R_STYLE],
[
  AC_CACHE_CHECK([which data struct is used by crypt_r], php_cv_crypt_r_style,[
    php_cv_crypt_r_style=none
    AC_COMPILE_IFELSE([AC_LANG_PROGRAM([[
#define _REENTRANT 1
#include <crypt.h>
]], [[
CRYPTD buffer;
crypt_r("passwd", "hash", &buffer);
]])],[php_cv_crypt_r_style=cryptd],[])

    if test "$php_cv_crypt_r_style" = "none"; then
      AC_COMPILE_IFELSE([AC_LANG_PROGRAM([[
#define _REENTRANT 1
#include <crypt.h>
]],[[
struct crypt_data buffer;
crypt_r("passwd", "hash", &buffer);
]])],[php_cv_crypt_r_style=struct_crypt_data],[])
    fi

    if test "$php_cv_crypt_r_style" = "none"; then
      AC_COMPILE_IFELSE([AC_LANG_PROGRAM([[
#define _REENTRANT 1
#define _GNU_SOURCE
#include <crypt.h>
]],[[
struct crypt_data buffer;
crypt_r("passwd", "hash", &buffer);
]])],[php_cv_crypt_r_style=struct_crypt_data_gnu_source],[])
    fi

    if test "$php_cv_crypt_r_style" = "none"; then
      AC_COMPILE_IFELSE([AC_LANG_PROGRAM([[
#include <stdlib.h>
#include <unistd.h>
]],[[
struct crypt_data buffer;
crypt_r("passwd", "hash", &buffer);
]])],[php_cv_crypt_r_style=struct_crypt_data],[])
    fi
    ])

  if test "$php_cv_crypt_r_style" = "cryptd"; then
    AC_DEFINE(CRYPT_R_CRYPTD, 1, [Define if crypt_r has uses CRYPTD])
  fi
  if test "$php_cv_crypt_r_style" = "struct_crypt_data" -o "$php_cv_crypt_r_style" = "struct_crypt_data_gnu_source"; then
    AC_DEFINE(CRYPT_R_STRUCT_CRYPT_DATA, 1, [Define if crypt_r uses struct crypt_data])
  fi
  if test "$php_cv_crypt_r_style" = "struct_crypt_data_gnu_source"; then
    AC_DEFINE(CRYPT_R_GNU_SOURCE, 1, [Define if struct crypt_data requires _GNU_SOURCE])
  fi
  if test "$php_cv_crypt_r_style" = "none"; then
    AC_MSG_ERROR([Unable to detect data struct used by crypt_r])
  fi
])

dnl
dnl PHP_TEST_WRITE_STDOUT
dnl
AC_DEFUN([PHP_TEST_WRITE_STDOUT],[
  AC_CACHE_CHECK(whether writing to stdout works,ac_cv_write_stdout,[
    AC_RUN_IFELSE([AC_LANG_SOURCE([[
#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif

#define TEXT "This is the test message -- "

int main(void)
{
  int n;

  n = write(1, TEXT, sizeof(TEXT)-1);
  return (!(n == sizeof(TEXT)-1));
}
    ]])],[
      ac_cv_write_stdout=yes
    ],[
      ac_cv_write_stdout=no
    ],[
      case $host_alias in
        *linux*)
          ac_cv_write_stdout=yes
          ;;
        *)
          ac_cv_write_stdout=no
          ;;
      esac
    ])
  ])
  if test "$ac_cv_write_stdout" = "yes"; then
    AC_DEFINE(PHP_WRITE_STDOUT, 1, [whether write(2) works])
  fi
])

dnl
dnl PHP_INIT_DTRACE(providerdesc, header-file, sources [, module])
dnl
AC_DEFUN([PHP_INIT_DTRACE],[
dnl Set paths properly when called from extension.
  case "$4" in
    ""[)] ac_srcdir="$abs_srcdir/"; unset ac_bdir;;
    /*[)] ac_srcdir=`echo "$4"|cut -c 2-`"/"; ac_bdir=$ac_srcdir;;
    *[)] ac_srcdir="$abs_srcdir/$1/"; ac_bdir="$4/";;
  esac

dnl providerdesc.
  ac_provsrc=$1
  old_IFS=[$]IFS
  IFS=.
  set $ac_provsrc
  ac_provobj=[$]1
  IFS=$old_IFS

dnl header-file.
  ac_hdrobj=$2

dnl Add providerdesc.o or .lo into global objects when needed.
  case $host_alias in
  *freebsd*)
    PHP_GLOBAL_OBJS="[$]PHP_GLOBAL_OBJS [$]ac_bdir[$]ac_provsrc.lo"
    PHP_LDFLAGS="$PHP_LDFLAGS -lelf"
    ;;
  *solaris*)
    PHP_GLOBAL_OBJS="[$]PHP_GLOBAL_OBJS [$]ac_bdir[$]ac_provsrc.lo"
    ;;
  *linux*)
    PHP_GLOBAL_OBJS="[$]PHP_GLOBAL_OBJS [$]ac_bdir[$]ac_provsrc.lo"
    ;;
  esac

dnl DTrace objects.
  old_IFS=[$]IFS
  for ac_src in $3; do
    IFS=.
    set $ac_src
    ac_obj=[$]1
    IFS=$old_IFS

    PHP_DTRACE_OBJS="[$]PHP_DTRACE_OBJS [$]ac_bdir[$]ac_obj.lo"
  done;

  case [$]php_sapi_module in
  shared[)]
    for ac_lo in $PHP_DTRACE_OBJS; do
      dtrace_objs="[$]dtrace_objs `echo $ac_lo | $SED -e 's,\.lo$,.o,' -e 's#\(.*\)\/#\1\/.libs\/#'`"
    done;
    ;;
  *[)]
    dtrace_objs='$(PHP_DTRACE_OBJS:.lo=.o)'
    ;;
  esac

dnl Generate Makefile.objects entries. The empty $ac_provsrc command stops an
dnl implicit circular dependency in GNU Make which causes the .d file to be
dnl overwritten (Bug 61268).
  cat>>Makefile.objects<<EOF

$abs_srcdir/$ac_provsrc:;

$ac_bdir[$]ac_hdrobj: $abs_srcdir/$ac_provsrc
	CFLAGS="\$(CFLAGS_CLEAN)" dtrace -h -C -s $ac_srcdir[$]ac_provsrc -o \$[]@.bak && \$(SED) -e 's,PHP_,DTRACE_,g' \$[]@.bak > \$[]@

\$(PHP_DTRACE_OBJS): $ac_bdir[$]ac_hdrobj

EOF

  case $host_alias in
  *solaris*|*linux*|*freebsd*)
    dtrace_prov_name="`echo $ac_provsrc | $SED -e 's#\(.*\)\/##'`.o"
    dtrace_lib_dir="`echo $ac_bdir[$]ac_provsrc | $SED -e 's#\(.*\)/[^/]*#\1#'`/.libs"
    dtrace_d_obj="`echo $ac_bdir[$]ac_provsrc | $SED -e 's#\(.*\)/\([^/]*\)#\1/.libs/\2#'`.o"
    dtrace_nolib_objs='$(PHP_DTRACE_OBJS:.lo=.o)'
    for ac_lo in $PHP_DTRACE_OBJS; do
      dtrace_lib_objs="[$]dtrace_lib_objs `echo $ac_lo | $SED -e 's,\.lo$,.o,' -e 's#\(.*\)\/#\1\/.libs\/#'`"
    done;
    dnl Always attempt to create both PIC and non-PIC DTrace objects (Bug 63692)
    cat>>Makefile.objects<<EOF
$ac_bdir[$]ac_provsrc.lo: \$(PHP_DTRACE_OBJS)
	echo "[#] Generated by Makefile for libtool" > \$[]@
	@test -d "$dtrace_lib_dir" || mkdir $dtrace_lib_dir
	if CFLAGS="\$(CFLAGS_CLEAN)" dtrace -G -o $dtrace_d_obj -s $abs_srcdir/$ac_provsrc $dtrace_lib_objs 2> /dev/null && test -f "$dtrace_d_obj"; then [\\]
	  echo "pic_object=['].libs/$dtrace_prov_name[']" >> \$[]@ [;\\]
	else [\\]
	  echo "pic_object='none'" >> \$[]@ [;\\]
	fi
	if CFLAGS="\$(CFLAGS_CLEAN)" dtrace -G -o $ac_bdir[$]ac_provsrc.o -s $abs_srcdir/$ac_provsrc $dtrace_nolib_objs 2> /dev/null && test -f "$ac_bdir[$]ac_provsrc.o"; then [\\]
	  echo "non_pic_object=[']$dtrace_prov_name[']" >> \$[]@ [;\\]
	else [\\]
	  echo "non_pic_object='none'" >> \$[]@ [;\\]
	fi

EOF

    ;;
  *)
cat>>Makefile.objects<<EOF
$ac_bdir[$]ac_provsrc.o: \$(PHP_DTRACE_OBJS)
	CFLAGS="\$(CFLAGS_CLEAN)" dtrace -G -o \$[]@ -s $abs_srcdir/$ac_provsrc $dtrace_objs

EOF
    ;;
  esac
])

dnl
dnl PHP_CHECK_STDINT_TYPES
dnl
AC_DEFUN([PHP_CHECK_STDINT_TYPES], [
  AC_CHECK_SIZEOF([short])
  AC_CHECK_SIZEOF([int])
  AC_CHECK_SIZEOF([long])
  AC_CHECK_SIZEOF([long long])
  AC_CHECK_SIZEOF([size_t])
  AC_CHECK_SIZEOF([off_t])
  AC_CHECK_TYPES([int8_t, int16_t, int32_t, int64_t, uint8_t, uint16_t, uint32_t, uint64_t], [], [
    AC_MSG_ERROR([One of the intN_t or uintN_t types is not available])
  ], [
#include <stdint.h>
#if HAVE_SYS_TYPES_H
# include <sys/types.h>
#endif
  ])
])

dnl
dnl PHP_CHECK_BUILTIN_EXPECT
dnl
AC_DEFUN([PHP_CHECK_BUILTIN_EXPECT], [
  AC_MSG_CHECKING([for __builtin_expect])

  AC_LINK_IFELSE([AC_LANG_PROGRAM([], [[
    return __builtin_expect(1,1) ? 1 : 0;
  ]])], [
    have_builtin_expect=1
    AC_MSG_RESULT([yes])
  ], [
    have_builtin_expect=0
    AC_MSG_RESULT([no])
  ])

  AC_DEFINE_UNQUOTED([PHP_HAVE_BUILTIN_EXPECT], [$have_builtin_expect], [Whether the compiler supports __builtin_expect])
])

dnl
dnl PHP_CHECK_BUILTIN_CLZ
dnl
AC_DEFUN([PHP_CHECK_BUILTIN_CLZ], [
  AC_MSG_CHECKING([for __builtin_clz])

  AC_LINK_IFELSE([AC_LANG_PROGRAM([], [[
    return __builtin_clz(1) ? 1 : 0;
  ]])], [
    have_builtin_clz=1
    AC_MSG_RESULT([yes])
  ], [
    have_builtin_clz=0
    AC_MSG_RESULT([no])
  ])

  AC_DEFINE_UNQUOTED([PHP_HAVE_BUILTIN_CLZ], [$have_builtin_clz], [Whether the compiler supports __builtin_clz])
])

dnl
dnl PHP_CHECK_BUILTIN_CLZL
dnl
AC_DEFUN([PHP_CHECK_BUILTIN_CLZL], [
  AC_MSG_CHECKING([for __builtin_clzl])

  AC_LINK_IFELSE([AC_LANG_PROGRAM([], [[
    return __builtin_clzl(1) ? 1 : 0;
  ]])], [
    have_builtin_clzl=1
    AC_MSG_RESULT([yes])
  ], [
    have_builtin_clzl=0
    AC_MSG_RESULT([no])
  ])

  AC_DEFINE_UNQUOTED([PHP_HAVE_BUILTIN_CLZL], [$have_builtin_clzl], [Whether the compiler supports __builtin_clzl])
])

dnl
dnl PHP_CHECK_BUILTIN_CLZLL
dnl
AC_DEFUN([PHP_CHECK_BUILTIN_CLZLL], [
  AC_MSG_CHECKING([for __builtin_clzll])

  AC_LINK_IFELSE([AC_LANG_PROGRAM([], [[
    return __builtin_clzll(1) ? 1 : 0;
  ]])], [
    have_builtin_clzll=1
    AC_MSG_RESULT([yes])
  ], [
    have_builtin_clzll=0
    AC_MSG_RESULT([no])
  ])

  AC_DEFINE_UNQUOTED([PHP_HAVE_BUILTIN_CLZLL], [$have_builtin_clzll], [Whether the compiler supports __builtin_clzll])
])

dnl
dnl PHP_CHECK_BUILTIN_CTZL
dnl
AC_DEFUN([PHP_CHECK_BUILTIN_CTZL], [
  AC_MSG_CHECKING([for __builtin_ctzl])

  AC_LINK_IFELSE([AC_LANG_PROGRAM([], [[
    return __builtin_ctzl(2L) ? 1 : 0;
  ]])], [
    have_builtin_ctzl=1
    AC_MSG_RESULT([yes])
  ], [
    have_builtin_ctzl=0
    AC_MSG_RESULT([no])
  ])

  AC_DEFINE_UNQUOTED([PHP_HAVE_BUILTIN_CTZL], [$have_builtin_ctzl], [Whether the compiler supports __builtin_ctzl])
])

dnl
dnl PHP_CHECK_BUILTIN_CTZLL
dnl
AC_DEFUN([PHP_CHECK_BUILTIN_CTZLL], [
  AC_MSG_CHECKING([for __builtin_ctzll])

  AC_LINK_IFELSE([AC_LANG_PROGRAM([], [[
    return __builtin_ctzll(2LL) ? 1 : 0;
  ]])], [
    have_builtin_ctzll=1
    AC_MSG_RESULT([yes])
  ], [
    have_builtin_ctzll=0
    AC_MSG_RESULT([no])
  ])

  AC_DEFINE_UNQUOTED([PHP_HAVE_BUILTIN_CTZLL], [$have_builtin_ctzll], [Whether the compiler supports __builtin_ctzll])
])

dnl
dnl PHP_CHECK_BUILTIN_SMULL_OVERFLOW
dnl
AC_DEFUN([PHP_CHECK_BUILTIN_SMULL_OVERFLOW], [
  AC_MSG_CHECKING([for __builtin_smull_overflow])

  AC_LINK_IFELSE([AC_LANG_PROGRAM([], [[
    long tmpvar;
    return __builtin_smull_overflow(3, 7, &tmpvar);
  ]])], [
    have_builtin_smull_overflow=1
    AC_MSG_RESULT([yes])
  ], [
    have_builtin_smull_overflow=0
    AC_MSG_RESULT([no])
  ])

  AC_DEFINE_UNQUOTED([PHP_HAVE_BUILTIN_SMULL_OVERFLOW],
   [$have_builtin_smull_overflow], [Whether the compiler supports __builtin_smull_overflow])
])

dnl
dnl PHP_CHECK_BUILTIN_SMULLL_OVERFLOW
dnl
AC_DEFUN([PHP_CHECK_BUILTIN_SMULLL_OVERFLOW], [
  AC_MSG_CHECKING([for __builtin_smulll_overflow])

  AC_LINK_IFELSE([AC_LANG_PROGRAM([], [[
    long long tmpvar;
    return __builtin_smulll_overflow(3, 7, &tmpvar);
  ]])], [
    have_builtin_smulll_overflow=1
    AC_MSG_RESULT([yes])
  ], [
    have_builtin_smulll_overflow=0
    AC_MSG_RESULT([no])
  ])

  AC_DEFINE_UNQUOTED([PHP_HAVE_BUILTIN_SMULLL_OVERFLOW],
   [$have_builtin_smulll_overflow], [Whether the compiler supports __builtin_smulll_overflow])
])

dnl
dnl PHP_CHECK_BUILTIN_SADDL_OVERFLOW
dnl
AC_DEFUN([PHP_CHECK_BUILTIN_SADDL_OVERFLOW], [
  AC_MSG_CHECKING([for __builtin_saddl_overflow])

  AC_LINK_IFELSE([AC_LANG_PROGRAM([], [[
    long tmpvar;
    return __builtin_saddl_overflow(3, 7, &tmpvar);
  ]])], [
    have_builtin_saddl_overflow=1
    AC_MSG_RESULT([yes])
  ], [
    have_builtin_saddl_overflow=0
    AC_MSG_RESULT([no])
  ])

  AC_DEFINE_UNQUOTED([PHP_HAVE_BUILTIN_SADDL_OVERFLOW],
   [$have_builtin_saddl_overflow], [Whether the compiler supports __builtin_saddl_overflow])
])

dnl
dnl PHP_CHECK_BUILTIN_SADDLL_OVERFLOW
dnl
AC_DEFUN([PHP_CHECK_BUILTIN_SADDLL_OVERFLOW], [
  AC_MSG_CHECKING([for __builtin_saddll_overflow])

  AC_LINK_IFELSE([AC_LANG_PROGRAM([], [[
    long long tmpvar;
    return __builtin_saddll_overflow(3, 7, &tmpvar);
  ]])], [
    have_builtin_saddll_overflow=1
    AC_MSG_RESULT([yes])
  ], [
    have_builtin_saddll_overflow=0
    AC_MSG_RESULT([no])
  ])

  AC_DEFINE_UNQUOTED([PHP_HAVE_BUILTIN_SADDLL_OVERFLOW],
   [$have_builtin_saddll_overflow], [Whether the compiler supports __builtin_saddll_overflow])
])

dnl
dnl PHP_CHECK_BUILTIN_SSUBL_OVERFLOW
dnl
AC_DEFUN([PHP_CHECK_BUILTIN_SSUBL_OVERFLOW], [
  AC_MSG_CHECKING([for __builtin_ssubl_overflow])

  AC_LINK_IFELSE([AC_LANG_PROGRAM([], [[
    long tmpvar;
    return __builtin_ssubl_overflow(3, 7, &tmpvar);
  ]])], [
    have_builtin_ssubl_overflow=1
    AC_MSG_RESULT([yes])
  ], [
    have_builtin_ssubl_overflow=0
    AC_MSG_RESULT([no])
  ])

  AC_DEFINE_UNQUOTED([PHP_HAVE_BUILTIN_SSUBL_OVERFLOW],
   [$have_builtin_ssubl_overflow], [Whether the compiler supports __builtin_ssubl_overflow])
])

dnl
dnl PHP_CHECK_BUILTIN_SSUBLL_OVERFLOW
dnl
AC_DEFUN([PHP_CHECK_BUILTIN_SSUBLL_OVERFLOW], [
  AC_MSG_CHECKING([for __builtin_ssubll_overflow])

  AC_LINK_IFELSE([AC_LANG_PROGRAM([], [[
    long long tmpvar;
    return __builtin_ssubll_overflow(3, 7, &tmpvar);
  ]])], [
    have_builtin_ssubll_overflow=1
    AC_MSG_RESULT([yes])
  ], [
    have_builtin_ssubll_overflow=0
    AC_MSG_RESULT([no])
  ])

  AC_DEFINE_UNQUOTED([PHP_HAVE_BUILTIN_SSUBLL_OVERFLOW],
   [$have_builtin_ssubll_overflow], [Whether the compiler supports __builtin_ssubll_overflow])
])

dnl
dnl PHP_CHECK_BUILTIN_CPU_INIT
dnl
AC_DEFUN([PHP_CHECK_BUILTIN_CPU_INIT], [
  AC_MSG_CHECKING([for __builtin_cpu_init])

  AC_LINK_IFELSE([AC_LANG_PROGRAM([], [[
    __builtin_cpu_init();
  ]])], [
    have_builtin_cpu_init=1
    AC_MSG_RESULT([yes])
  ], [
    have_builtin_cpu_init=0
    AC_MSG_RESULT([no])
  ])

  AC_DEFINE_UNQUOTED([PHP_HAVE_BUILTIN_CPU_INIT],
   [$have_builtin_cpu_init], [Whether the compiler supports __builtin_cpu_init])
])

dnl
dnl PHP_CHECK_BUILTIN_CPU_SUPPORTS
dnl
AC_DEFUN([PHP_CHECK_BUILTIN_CPU_SUPPORTS], [
  AC_MSG_CHECKING([for __builtin_cpu_supports])

  AC_LINK_IFELSE([AC_LANG_PROGRAM([], [[
    return __builtin_cpu_supports("sse")? 1 : 0;
  ]])], [
    have_builtin_cpu_supports=1
    AC_MSG_RESULT([yes])
  ], [
    have_builtin_cpu_supports=0
    AC_MSG_RESULT([no])
  ])

  AC_DEFINE_UNQUOTED([PHP_HAVE_BUILTIN_CPU_SUPPORTS],
   [$have_builtin_cpu_supports], [Whether the compiler supports __builtin_cpu_supports])
])

dnl
dnl PHP_PATCH_CONFIG_HEADERS([FILE])
dnl
dnl PACKAGE_* symbols are automatically defined by Autoconf. When including
dnl configuration header, warnings about redefined symbols are emitted for such
dnl symbols if they are defined by multiple libraries. This disables all
dnl PACKAGE_* symbols in the generated configuration header template FILE. For
dnl example, main/php_config.h.in for PHP or config.h.in for PHP extensions.
dnl
AC_DEFUN([PHP_PATCH_CONFIG_HEADERS], [
  AC_MSG_NOTICE([patching $1])

  $SED -e 's/^#undef PACKAGE_[^ ]*/\/\* & \*\//g' < $srcdir/$1 \
    > $srcdir/$1.tmp && mv $srcdir/$1.tmp $srcdir/$1
])

dnl
dnl PHP_REMOVE_OPTIMIZATION_FLAGS
dnl
dnl Removes known compiler optimization flags like -O, -O0, -O1, ..., -Ofast
dnl from CFLAGS and CXXFLAGS.
dnl
AC_DEFUN([PHP_REMOVE_OPTIMIZATION_FLAGS], [
  sed_script='s/\([[\t ]]\|^\)-O\([[0-9gsz]]\|fast\|\)\([[\t ]]\|$\)/\1/g'
  CFLAGS=$(echo "$CFLAGS" | $SED -e "$sed_script")
  CXXFLAGS=$(echo "$CXXFLAGS" | $SED -e "$sed_script")
])
