/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmx.snmp.daemon;

import com.sun.jmx.defaults.JmxProperties;
import com.sun.jmx.snmp.SnmpDefinitions;
import com.sun.jmx.snmp.SnmpEngine;
import com.sun.jmx.snmp.SnmpPdu;
import com.sun.jmx.snmp.SnmpStatusException;
import com.sun.jmx.snmp.SnmpVarBind;
import com.sun.jmx.snmp.ThreadContext;
import com.sun.jmx.snmp.agent.SnmpMibAgent;
import com.sun.jmx.snmp.agent.SnmpMibRequest;
import com.sun.jmx.snmp.internal.SnmpIncomingRequest;
import java.util.Vector;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SnmpSubRequestHandler
implements SnmpDefinitions,
Runnable {
    protected SnmpIncomingRequest incRequest = null;
    protected SnmpEngine engine = null;
    protected int version = 330;
    protected int type = 0;
    protected SnmpMibAgent agent;
    protected int errorStatus = 1230;
    protected int errorIndex = -1;
    protected Vector<SnmpVarBind> varBind;
    protected int[] translation;
    protected Object data;
    private SnmpMibRequest mibRequest = null;
    private SnmpPdu reqPdu = null;

    protected SnmpSubRequestHandler(SnmpEngine snmpEngine, SnmpIncomingRequest snmpIncomingRequest, SnmpMibAgent snmpMibAgent, SnmpPdu snmpPdu) {
        this(snmpMibAgent, snmpPdu);
        this.init(snmpEngine, snmpIncomingRequest);
    }

    protected SnmpSubRequestHandler(SnmpEngine snmpEngine, SnmpIncomingRequest snmpIncomingRequest, SnmpMibAgent snmpMibAgent, SnmpPdu snmpPdu, boolean bl) {
        this(snmpMibAgent, snmpPdu, bl);
        this.init(snmpEngine, snmpIncomingRequest);
    }

    protected SnmpSubRequestHandler(SnmpMibAgent snmpMibAgent, SnmpPdu snmpPdu) {
        if (JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINER)) {
            JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINER, SnmpSubRequestHandler.class.getName(), "constructor", "creating instance for request " + String.valueOf(snmpPdu.requestId));
        }
        this.version = snmpPdu.version;
        this.type = snmpPdu.type;
        this.agent = snmpMibAgent;
        this.reqPdu = snmpPdu;
        int n = snmpPdu.varBindList.length;
        this.translation = new int[n];
        this.varBind = new NonSyncVector<SnmpVarBind>(n);
    }

    protected SnmpSubRequestHandler(SnmpMibAgent snmpMibAgent, SnmpPdu snmpPdu, boolean bl) {
        this(snmpMibAgent, snmpPdu);
        int n = this.translation.length;
        SnmpVarBind[] snmpVarBindArray = snmpPdu.varBindList;
        for (int i = 0; i < n; ++i) {
            this.translation[i] = i;
            ((NonSyncVector)this.varBind).addNonSyncElement(snmpVarBindArray[i]);
        }
    }

    SnmpMibRequest createMibRequest(Vector<SnmpVarBind> vector, int n, Object object) {
        if (this.type == 4 && this.mibRequest != null) {
            return this.mibRequest;
        }
        SnmpMibRequest snmpMibRequest = null;
        snmpMibRequest = this.incRequest != null ? SnmpMibAgent.newMibRequest(this.engine, this.reqPdu, vector, n, object, this.incRequest.getPrincipal(), this.incRequest.getSecurityLevel(), this.incRequest.getSecurityModel(), this.incRequest.getContextName(), this.incRequest.getAccessContext()) : SnmpMibAgent.newMibRequest(this.reqPdu, vector, n, object);
        if (this.type == 3) {
            this.mibRequest = snmpMibRequest;
        }
        return snmpMibRequest;
    }

    void setUserData(Object object) {
        this.data = object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        block18: {
            try {
                ThreadContext threadContext = ThreadContext.push("SnmpUserData", this.data);
                try {
                    switch (this.type) {
                        case 1: {
                            if (JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINER)) {
                                JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINER, SnmpSubRequestHandler.class.getName(), "run", "[" + Thread.currentThread() + "]:get operation on " + this.agent.getMibName());
                            }
                            this.agent.get(this.createMibRequest(this.varBind, this.version, this.data));
                            break;
                        }
                        case 2: {
                            if (JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINER)) {
                                JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINER, SnmpSubRequestHandler.class.getName(), "run", "[" + Thread.currentThread() + "]:getNext operation on " + this.agent.getMibName());
                            }
                            this.agent.getNext(this.createMibRequest(this.varBind, this.version, this.data));
                            break;
                        }
                        case 4: {
                            if (JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINER)) {
                                JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINER, SnmpSubRequestHandler.class.getName(), "run", "[" + Thread.currentThread() + "]:set operation on " + this.agent.getMibName());
                            }
                            this.agent.set(this.createMibRequest(this.varBind, this.version, this.data));
                            break;
                        }
                        case 3: {
                            if (JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINER)) {
                                JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINER, SnmpSubRequestHandler.class.getName(), "run", "[" + Thread.currentThread() + "]:check operation on " + this.agent.getMibName());
                            }
                            this.agent.check(this.createMibRequest(this.varBind, this.version, this.data));
                            break;
                        }
                        default: {
                            if (JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINEST)) {
                                JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINEST, SnmpSubRequestHandler.class.getName(), "run", "[" + Thread.currentThread() + "]:unknown operation (" + this.type + ") on " + this.agent.getMibName());
                            }
                            this.errorStatus = 0;
                            this.errorIndex = 1;
                        }
                    }
                    Object var3_4 = null;
                }
                catch (Throwable throwable) {
                    Object var3_5 = null;
                    ThreadContext.restore(threadContext);
                    throw throwable;
                }
                ThreadContext.restore(threadContext);
                {
                }
            }
            catch (SnmpStatusException snmpStatusException) {
                this.errorStatus = snmpStatusException.getStatus();
                this.errorIndex = snmpStatusException.getErrorIndex();
                if (JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINEST)) {
                    JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINEST, SnmpSubRequestHandler.class.getName(), "run", "[" + Thread.currentThread() + "]:an Snmp error occured during the operation", snmpStatusException);
                }
            }
            catch (Exception exception) {
                this.errorStatus = 0;
                if (!JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINEST)) break block18;
                JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINEST, SnmpSubRequestHandler.class.getName(), "run", "[" + Thread.currentThread() + "]:a generic error occured during the operation", exception);
            }
        }
        if (JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINER)) {
            JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINER, SnmpSubRequestHandler.class.getName(), "run", "[" + Thread.currentThread() + "]:operation completed");
        }
    }

    static final int mapErrorStatusToV1(int n, int n2) {
        if (n == 1230) {
            return 1230;
        }
        if (n == 0) {
            return 0;
        }
        if (n == 10) {
            return 10;
        }
        if (n == 224 || n == 225 || n == 20 || n == 60 || n == 70) {
            return 10;
        }
        if (n == 70 || n == 0) {
            if (n2 == 3) {
                return 30;
            }
            return 10;
        }
        if (n == 80) {
            return 10;
        }
        if (n == 90 || n == 110 || n == 0 || n == 50 || n == 110 || n == 220) {
            if (n2 == 4 || n2 == 3) {
                return 40;
            }
            return 10;
        }
        if (n == 330 || n == 440 || n == 550) {
            return 0;
        }
        if (n == 660) {
            return 660;
        }
        if (n == 40 || n == 30) {
            if (n2 == 4 || n2 == 3) {
                return n;
            }
            return 10;
        }
        return 0;
    }

    static final int mapErrorStatusToV2(int n, int n2) {
        if (n == 1230) {
            return 1230;
        }
        if (n == 0) {
            return 0;
        }
        if (n == 660) {
            return 660;
        }
        if (n2 != 4 && n2 != 3) {
            if (n == 70) {
                return n;
            }
            return 0;
        }
        if (n == 10) {
            return 20;
        }
        if (n == 30) {
            return 0;
        }
        if (n == 40) {
            return 50;
        }
        if (n == 20 || n == 60 || n == 70 || n == 0 || n == 80 || n == 90 || n == 110 || n == 0 || n == 50 || n == 110 || n == 220 || n == 330 || n == 440 || n == 550) {
            return n;
        }
        return 0;
    }

    static final int mapErrorStatus(int n, int n2, int n3) {
        if (n == 1230) {
            return 1230;
        }
        if (n2 == 330) {
            return SnmpSubRequestHandler.mapErrorStatusToV1(n, n3);
        }
        if (n2 == 220 || n2 == 4430) {
            return SnmpSubRequestHandler.mapErrorStatusToV2(n, n3);
        }
        return 0;
    }

    protected int getErrorStatus() {
        if (this.errorStatus == 1230) {
            return 1230;
        }
        return SnmpSubRequestHandler.mapErrorStatus(this.errorStatus, this.version, this.type);
    }

    protected int getErrorIndex() {
        if (this.errorStatus == 1230) {
            return -1;
        }
        if (this.errorIndex == 0 || this.errorIndex == -1) {
            this.errorIndex = 1;
        }
        return this.translation[this.errorIndex - 1];
    }

    protected void updateRequest(SnmpVarBind snmpVarBind, int n) {
        int n2 = this.varBind.size();
        this.translation[n2] = n;
        this.varBind.addElement(snmpVarBind);
    }

    protected void updateResult(SnmpVarBind[] snmpVarBindArray) {
        if (snmpVarBindArray == null) {
            return;
        }
        int n = this.varBind.size();
        int n2 = snmpVarBindArray.length;
        for (int i = 0; i < n; ++i) {
            int n3 = this.translation[i];
            if (n3 < n2) {
                snmpVarBindArray[n3] = (SnmpVarBind)((NonSyncVector)this.varBind).elementAtNonSync(i);
                continue;
            }
            if (!JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINEST)) continue;
            JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINEST, SnmpSubRequestHandler.class.getName(), "updateResult", "Position `" + n3 + "' is out of bound...");
        }
    }

    private void init(SnmpEngine snmpEngine, SnmpIncomingRequest snmpIncomingRequest) {
        this.incRequest = snmpIncomingRequest;
        this.engine = snmpEngine;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class NonSyncVector<E>
    extends Vector<E> {
        public NonSyncVector(int n) {
            super(n);
        }

        final void addNonSyncElement(E e) {
            this.ensureCapacity(this.elementCount + 1);
            this.elementData[this.elementCount++] = e;
        }

        final E elementAtNonSync(int n) {
            return (E)this.elementData[n];
        }
    }
}

