/*
 * Decompiled with CFR 0.152.
 */
package com.sun.beans.finder;

import com.sun.beans.finder.PrimitiveTypeMap;

public final class ClassFinder {
    public static Class findClass(String string) throws ClassNotFoundException {
        try {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            if (classLoader == null) {
                classLoader = ClassLoader.getSystemClassLoader();
            }
            if (classLoader != null) {
                return Class.forName(string, false, classLoader);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        return Class.forName(string);
    }

    public static Class findClass(String string, ClassLoader classLoader) throws ClassNotFoundException {
        if (classLoader != null) {
            try {
                return Class.forName(string, false, classLoader);
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
        return ClassFinder.findClass(string);
    }

    public static Class resolveClass(String string) throws ClassNotFoundException {
        return ClassFinder.resolveClass(string, null);
    }

    public static Class resolveClass(String string, ClassLoader classLoader) throws ClassNotFoundException {
        Class clazz = PrimitiveTypeMap.getType(string);
        return clazz == null ? ClassFinder.findClass(string, classLoader) : clazz;
    }

    private ClassFinder() {
    }
}

