/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.fastinfoset.algorithm;

import com.sun.xml.internal.fastinfoset.CommonResourceBundle;
import com.sun.xml.internal.fastinfoset.algorithm.BuiltInEncodingAlgorithm;
import com.sun.xml.internal.fastinfoset.algorithm.IntegerEncodingAlgorithm;
import com.sun.xml.internal.org.jvnet.fastinfoset.EncodingAlgorithmException;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.CharBuffer;
import java.util.ArrayList;
import java.util.List;

public class IntEncodingAlgorithm
extends IntegerEncodingAlgorithm {
    public final int getPrimtiveLengthFromOctetLength(int n) throws EncodingAlgorithmException {
        if (n % 4 != 0) {
            throw new EncodingAlgorithmException(CommonResourceBundle.getInstance().getString("message.lengthNotMultipleOfInt", new Object[]{new Integer(4)}));
        }
        return n / 4;
    }

    public int getOctetLengthFromPrimitiveLength(int n) {
        return n * 4;
    }

    public final Object decodeFromBytes(byte[] byArray, int n, int n2) throws EncodingAlgorithmException {
        int[] nArray = new int[this.getPrimtiveLengthFromOctetLength(n2)];
        this.decodeFromBytesToIntArray(nArray, 0, byArray, n, n2);
        return nArray;
    }

    public final Object decodeFromInputStream(InputStream inputStream) throws IOException {
        return this.decodeFromInputStreamToIntArray(inputStream);
    }

    public void encodeToOutputStream(Object object, OutputStream outputStream) throws IOException {
        if (!(object instanceof int[])) {
            throw new IllegalArgumentException(CommonResourceBundle.getInstance().getString("message.dataNotIntArray"));
        }
        int[] nArray = (int[])object;
        this.encodeToOutputStreamFromIntArray(nArray, outputStream);
    }

    public final Object convertFromCharacters(char[] cArray, int n, int n2) {
        final CharBuffer charBuffer = CharBuffer.wrap(cArray, n, n2);
        final ArrayList arrayList = new ArrayList();
        this.matchWhiteSpaceDelimnatedWords(charBuffer, new BuiltInEncodingAlgorithm.WordListener(){

            public void word(int n, int n2) {
                String string = charBuffer.subSequence(n, n2).toString();
                arrayList.add(Integer.valueOf(string));
            }
        });
        return this.generateArrayFromList(arrayList);
    }

    public final void convertToCharacters(Object object, StringBuffer stringBuffer) {
        if (!(object instanceof int[])) {
            throw new IllegalArgumentException(CommonResourceBundle.getInstance().getString("message.dataNotIntArray"));
        }
        int[] nArray = (int[])object;
        this.convertToCharactersFromIntArray(nArray, stringBuffer);
    }

    public final void decodeFromBytesToIntArray(int[] nArray, int n, byte[] byArray, int n2, int n3) {
        int n4 = n3 / 4;
        for (int i = 0; i < n4; ++i) {
            nArray[n++] = (byArray[n2++] & 0xFF) << 24 | (byArray[n2++] & 0xFF) << 16 | (byArray[n2++] & 0xFF) << 8 | byArray[n2++] & 0xFF;
        }
    }

    public final int[] decodeFromInputStreamToIntArray(InputStream inputStream) throws IOException {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        byte[] byArray = new byte[4];
        while (true) {
            int n;
            int n2;
            if ((n2 = inputStream.read(byArray)) != 4) {
                if (n2 == -1) break;
                while (n2 != 4) {
                    n = inputStream.read(byArray, n2, 4 - n2);
                    if (n == -1) {
                        throw new EOFException();
                    }
                    n2 += n;
                }
            }
            n = (byArray[0] & 0xFF) << 24 | (byArray[1] & 0xFF) << 16 | (byArray[2] & 0xFF) << 8 | byArray[3] & 0xFF;
            arrayList.add(new Integer(n));
        }
        return this.generateArrayFromList(arrayList);
    }

    public final void encodeToOutputStreamFromIntArray(int[] nArray, OutputStream outputStream) throws IOException {
        for (int i = 0; i < nArray.length; ++i) {
            int n = nArray[i];
            outputStream.write(n >>> 24 & 0xFF);
            outputStream.write(n >>> 16 & 0xFF);
            outputStream.write(n >>> 8 & 0xFF);
            outputStream.write(n & 0xFF);
        }
    }

    public final void encodeToBytes(Object object, int n, int n2, byte[] byArray, int n3) {
        this.encodeToBytesFromIntArray((int[])object, n, n2, byArray, n3);
    }

    public final void encodeToBytesFromIntArray(int[] nArray, int n, int n2, byte[] byArray, int n3) {
        int n4 = n + n2;
        for (int i = n; i < n4; ++i) {
            int n5 = nArray[i];
            byArray[n3++] = (byte)(n5 >>> 24 & 0xFF);
            byArray[n3++] = (byte)(n5 >>> 16 & 0xFF);
            byArray[n3++] = (byte)(n5 >>> 8 & 0xFF);
            byArray[n3++] = (byte)(n5 & 0xFF);
        }
    }

    public final void convertToCharactersFromIntArray(int[] nArray, StringBuffer stringBuffer) {
        int n = nArray.length - 1;
        for (int i = 0; i <= n; ++i) {
            stringBuffer.append(Integer.toString(nArray[i]));
            if (i == n) continue;
            stringBuffer.append(' ');
        }
    }

    public final int[] generateArrayFromList(List list) {
        int[] nArray = new int[list.size()];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = (Integer)list.get(i);
        }
        return nArray;
    }
}

