/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.jps;

import java.net.URISyntaxException;
import java.util.Iterator;
import java.util.Set;
import sun.jvmstat.monitor.HostIdentifier;
import sun.jvmstat.monitor.MonitorException;
import sun.jvmstat.monitor.MonitoredHost;
import sun.jvmstat.monitor.MonitoredVm;
import sun.jvmstat.monitor.MonitoredVmUtil;
import sun.jvmstat.monitor.VmIdentifier;
import sun.tools.jps.Arguments;

public class Jps {
    private static Arguments arguments;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) {
        try {
            arguments = new Arguments(stringArray);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            System.err.println(illegalArgumentException.getMessage());
            Arguments.printUsage(System.err);
            return;
        }
        if (arguments.isHelp()) {
            Arguments.printUsage(System.out);
            System.exit(0);
        }
        try {
            HostIdentifier hostIdentifier = arguments.hostId();
            MonitoredHost monitoredHost = MonitoredHost.getMonitoredHost(hostIdentifier);
            Set<Integer> set = monitoredHost.activeVms();
            Iterator<Integer> iterator = set.iterator();
            while (iterator.hasNext()) {
                Object object;
                MonitoredVm monitoredVm;
                StringBuilder stringBuilder;
                block21: {
                    stringBuilder = new StringBuilder();
                    Exception exception = null;
                    int n = iterator.next();
                    stringBuilder.append(String.valueOf(n));
                    if (arguments.isQuiet()) {
                        System.out.println(stringBuilder);
                        continue;
                    }
                    monitoredVm = null;
                    String string = "//" + n + "?mode=r";
                    try {
                        object = new VmIdentifier(string);
                        monitoredVm = monitoredHost.getMonitoredVm((VmIdentifier)object, 0);
                    }
                    catch (URISyntaxException uRISyntaxException) {
                        exception = uRISyntaxException;
                        assert (false);
                    }
                    catch (Exception exception2) {
                        exception = exception2;
                    }
                    finally {
                        if (monitoredVm != null) break block21;
                        stringBuilder.append(" -- process information unavailable");
                        if (arguments.isDebug() && exception != null && exception.getMessage() != null) {
                            stringBuilder.append("\n\t");
                            stringBuilder.append(exception.getMessage());
                        }
                        System.out.println(stringBuilder);
                        if (!arguments.printStackTrace()) continue;
                        exception.printStackTrace();
                        continue;
                    }
                }
                stringBuilder.append(" ");
                stringBuilder.append(MonitoredVmUtil.mainClass(monitoredVm, arguments.showLongPaths()));
                if (arguments.showMainArgs() && (object = MonitoredVmUtil.mainArgs(monitoredVm)) != null && ((String)object).length() > 0) {
                    stringBuilder.append(" ").append((String)object);
                }
                if (arguments.showVmArgs() && (object = MonitoredVmUtil.jvmArgs(monitoredVm)) != null && ((String)object).length() > 0) {
                    stringBuilder.append(" ").append((String)object);
                }
                if (arguments.showVmFlags() && (object = MonitoredVmUtil.jvmFlags(monitoredVm)) != null && ((String)object).length() > 0) {
                    stringBuilder.append(" ").append((String)object);
                }
                System.out.println(stringBuilder);
                monitoredHost.detach(monitoredVm);
            }
        }
        catch (MonitorException monitorException) {
            if (monitorException.getMessage() != null) {
                System.err.println(monitorException.getMessage());
            }
            Throwable throwable = monitorException.getCause();
            if (throwable != null && throwable.getMessage() != null) {
                System.err.println(throwable.getMessage());
            }
            monitorException.printStackTrace();
        }
    }
}

