/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.internal.xjc.reader.xmlschema;

import com.sun.tools.internal.xjc.model.CAdapter;
import com.sun.tools.internal.xjc.model.CClassInfo;
import com.sun.tools.internal.xjc.model.CElement;
import com.sun.tools.internal.xjc.model.CElementInfo;
import com.sun.tools.internal.xjc.model.CElementPropertyInfo;
import com.sun.tools.internal.xjc.model.CReferencePropertyInfo;
import com.sun.tools.internal.xjc.model.CTypeRef;
import com.sun.tools.internal.xjc.model.Multiplicity;
import com.sun.tools.internal.xjc.reader.RawTypeSet;
import com.sun.tools.internal.xjc.reader.Ring;
import com.sun.tools.internal.xjc.reader.xmlschema.BGMBuilder;
import com.sun.tools.internal.xjc.reader.xmlschema.ClassSelector;
import com.sun.tools.internal.xjc.reader.xmlschema.MultiplicityCounter;
import com.sun.tools.internal.xjc.reader.xmlschema.bindinfo.BIDom;
import com.sun.xml.internal.bind.v2.model.core.ID;
import com.sun.xml.internal.bind.v2.model.core.WildcardMode;
import com.sun.xml.internal.xsom.XSElementDecl;
import com.sun.xml.internal.xsom.XSModelGroup;
import com.sun.xml.internal.xsom.XSModelGroupDecl;
import com.sun.xml.internal.xsom.XSParticle;
import com.sun.xml.internal.xsom.XSWildcard;
import com.sun.xml.internal.xsom.visitor.XSTermVisitor;
import java.util.HashSet;
import java.util.Set;
import javax.activation.MimeType;
import javax.xml.namespace.QName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RawTypeSetBuilder
implements XSTermVisitor {
    private final Set<QName> elementNames = new HashSet<QName>();
    private final Set<RawTypeSet.Ref> refs = new HashSet<RawTypeSet.Ref>();
    protected final BGMBuilder builder = Ring.get(BGMBuilder.class);

    public static RawTypeSet build(XSParticle xSParticle, boolean bl) {
        RawTypeSetBuilder rawTypeSetBuilder = new RawTypeSetBuilder();
        rawTypeSetBuilder.particle(xSParticle);
        Multiplicity multiplicity = MultiplicityCounter.theInstance.particle(xSParticle);
        if (bl) {
            multiplicity = multiplicity.makeOptional();
        }
        return new RawTypeSet(rawTypeSetBuilder.refs, multiplicity);
    }

    public Set<RawTypeSet.Ref> getRefs() {
        return this.refs;
    }

    private void particle(XSParticle xSParticle) {
        BIDom bIDom = this.builder.getLocalDomCustomization(xSParticle);
        if (bIDom != null) {
            bIDom.markAsAcknowledged();
            this.refs.add(new WildcardRef(WildcardMode.SKIP));
        } else {
            xSParticle.getTerm().visit(this);
        }
    }

    @Override
    public void wildcard(XSWildcard xSWildcard) {
        this.refs.add(new WildcardRef(xSWildcard));
    }

    @Override
    public void modelGroupDecl(XSModelGroupDecl xSModelGroupDecl) {
        this.modelGroup(xSModelGroupDecl.getModelGroup());
    }

    @Override
    public void modelGroup(XSModelGroup xSModelGroup) {
        for (XSParticle xSParticle : xSModelGroup.getChildren()) {
            this.particle(xSParticle);
        }
    }

    @Override
    public void elementDecl(XSElementDecl xSElementDecl) {
        QName qName = new QName(xSElementDecl.getTargetNamespace(), xSElementDecl.getName());
        if (this.elementNames.add(qName)) {
            CElement cElement = Ring.get(ClassSelector.class).bindToType(xSElementDecl);
            if (cElement == null) {
                this.refs.add(new RawTypeSet.XmlTypeRef(xSElementDecl));
            } else if (cElement instanceof CClassInfo) {
                this.refs.add(new CClassInfoRef(xSElementDecl, (CClassInfo)cElement));
            } else {
                this.refs.add(new CElementInfoRef(xSElementDecl, (CElementInfo)cElement));
            }
        }
    }

    public static final class CElementInfoRef
    extends RawTypeSet.Ref {
        public final CElementInfo target;
        public final XSElementDecl decl;

        CElementInfoRef(XSElementDecl xSElementDecl, CElementInfo cElementInfo) {
            this.decl = xSElementDecl;
            this.target = cElementInfo;
        }

        protected CTypeRef toTypeRef(CElementPropertyInfo cElementPropertyInfo) {
            assert (!this.target.isCollection());
            CAdapter cAdapter = this.target.getProperty().getAdapter();
            if (cAdapter != null && cElementPropertyInfo != null) {
                cElementPropertyInfo.setAdapter(cAdapter);
            }
            return new CTypeRef(this.target.getContentType(), this.target.getElementName(), this.decl.isNillable(), this.decl.getDefaultValue());
        }

        protected void toElementRef(CReferencePropertyInfo cReferencePropertyInfo) {
            cReferencePropertyInfo.getElements().add(this.target);
        }

        protected RawTypeSet.Mode canBeType(RawTypeSet rawTypeSet) {
            if (this.decl.getSubstitutables().size() > 1) {
                return RawTypeSet.Mode.MUST_BE_REFERENCE;
            }
            CElementPropertyInfo cElementPropertyInfo = this.target.getProperty();
            if (!(rawTypeSet.refs.size() <= 1 && rawTypeSet.mul.isAtMostOnce() || cElementPropertyInfo.getAdapter() == null && cElementPropertyInfo.id() == ID.NONE)) {
                return RawTypeSet.Mode.MUST_BE_REFERENCE;
            }
            return RawTypeSet.Mode.SHOULD_BE_TYPEREF;
        }

        protected boolean isListOfValues() {
            return this.target.getProperty().isValueList();
        }

        protected ID id() {
            return this.target.getProperty().id();
        }

        protected MimeType getExpectedMimeType() {
            return this.target.getProperty().getExpectedMimeType();
        }
    }

    public static final class CClassInfoRef
    extends RawTypeSet.Ref {
        public final CClassInfo target;
        public final XSElementDecl decl;

        CClassInfoRef(XSElementDecl xSElementDecl, CClassInfo cClassInfo) {
            this.decl = xSElementDecl;
            this.target = cClassInfo;
        }

        protected CTypeRef toTypeRef(CElementPropertyInfo cElementPropertyInfo) {
            return new CTypeRef(this.target, this.target.getElementName(), this.decl.isNillable(), this.decl.getDefaultValue());
        }

        protected void toElementRef(CReferencePropertyInfo cReferencePropertyInfo) {
            cReferencePropertyInfo.getElements().add(this.target);
        }

        protected RawTypeSet.Mode canBeType(RawTypeSet rawTypeSet) {
            if (this.decl.getSubstitutables().size() > 1) {
                return RawTypeSet.Mode.MUST_BE_REFERENCE;
            }
            return RawTypeSet.Mode.SHOULD_BE_TYPEREF;
        }

        protected boolean isListOfValues() {
            return false;
        }

        protected ID id() {
            return ID.NONE;
        }
    }

    public static final class WildcardRef
    extends RawTypeSet.Ref {
        private final WildcardMode mode;

        WildcardRef(XSWildcard xSWildcard) {
            this.mode = WildcardRef.getMode(xSWildcard);
        }

        WildcardRef(WildcardMode wildcardMode) {
            this.mode = wildcardMode;
        }

        private static WildcardMode getMode(XSWildcard xSWildcard) {
            switch (xSWildcard.getMode()) {
                case 1: {
                    return WildcardMode.LAX;
                }
                case 2: {
                    return WildcardMode.STRICT;
                }
                case 3: {
                    return WildcardMode.SKIP;
                }
            }
            throw new IllegalStateException();
        }

        protected CTypeRef toTypeRef(CElementPropertyInfo cElementPropertyInfo) {
            throw new IllegalStateException();
        }

        protected void toElementRef(CReferencePropertyInfo cReferencePropertyInfo) {
            cReferencePropertyInfo.setWildcard(this.mode);
        }

        protected RawTypeSet.Mode canBeType(RawTypeSet rawTypeSet) {
            return RawTypeSet.Mode.MUST_BE_REFERENCE;
        }

        protected boolean isListOfValues() {
            return false;
        }

        protected ID id() {
            return ID.NONE;
        }
    }
}

