/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.internal.xjc;

import com.sun.tools.internal.xjc.ErrorReceiver;
import com.sun.tools.internal.xjc.Messages;
import java.io.OutputStream;
import java.io.PrintStream;
import org.xml.sax.SAXParseException;

public class ConsoleErrorReporter
extends ErrorReceiver {
    private PrintStream output;
    private boolean hadError = false;

    public ConsoleErrorReporter(PrintStream printStream) {
        this.output = printStream;
    }

    public ConsoleErrorReporter(OutputStream outputStream) {
        this(new PrintStream(outputStream));
    }

    public ConsoleErrorReporter() {
        this(System.out);
    }

    public void warning(SAXParseException sAXParseException) {
        this.print("Driver.WarningMessage", sAXParseException);
    }

    public void error(SAXParseException sAXParseException) {
        this.hadError = true;
        this.print("Driver.ErrorMessage", sAXParseException);
    }

    public void fatalError(SAXParseException sAXParseException) {
        this.hadError = true;
        this.print("Driver.ErrorMessage", sAXParseException);
    }

    public void info(SAXParseException sAXParseException) {
        this.print("Driver.InfoMessage", sAXParseException);
    }

    public boolean hadError() {
        return this.hadError;
    }

    private void print(String string, SAXParseException sAXParseException) {
        this.output.println(Messages.format(string, sAXParseException.getMessage()));
        this.output.println(this.getLocationString(sAXParseException));
        this.output.println();
    }
}

