/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.internal.ws.util.xml;

import com.sun.xml.internal.ws.util.xml.CDATA;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;

public class XmlWriter {
    private static final boolean shouldPrettyprint = false;
    private BufferedWriter out;
    private char quoteChar = (char)34;
    private int depth = 0;
    private boolean inStart = false;
    private boolean needNewline = false;
    private boolean writtenChars = false;
    private boolean inAttribute = false;
    private boolean inAttributeValue = false;

    private XmlWriter(OutputStreamWriter outputStreamWriter, boolean bl) throws IOException {
        this.out = new BufferedWriter(outputStreamWriter, 1024);
        String string = outputStreamWriter.getEncoding();
        if (string.equals("UTF8")) {
            string = "UTF-8";
        } else if (string.equals("ASCII")) {
            string = "US-ASCII";
        }
        if (bl) {
            this.out.write("<?xml version=\"1.0\" encoding=\"" + string + "\"?>");
            this.out.newLine();
            this.needNewline = true;
        }
    }

    public XmlWriter(OutputStream outputStream, String string, boolean bl) throws UnsupportedEncodingException, IOException {
        this(new OutputStreamWriter(outputStream, string), bl);
    }

    public XmlWriter(OutputStream outputStream, String string) throws UnsupportedEncodingException, IOException {
        this(new OutputStreamWriter(outputStream, string), true);
    }

    public XmlWriter(OutputStream outputStream) throws IOException {
        this(new OutputStreamWriter(outputStream, "UTF-8"), true);
    }

    public void setQuote(char c) {
        if (c != '\"' && c != '\'') {
            throw new IllegalArgumentException("Illegal quote character: " + c);
        }
        this.quoteChar = c;
    }

    private void quote(char c) throws IOException {
        switch (c) {
            case '&': {
                this.out.write("&amp;");
                break;
            }
            case '<': {
                this.out.write("&lt;");
                break;
            }
            case '>': {
                this.out.write("&gt;");
                break;
            }
            default: {
                this.out.write(c);
            }
        }
    }

    private void nonQuote(char c) throws IOException {
        this.out.write(c);
    }

    private void aquote(char c) throws IOException {
        switch (c) {
            case '\'': {
                if (this.quoteChar == c) {
                    this.out.write("&apos;");
                    break;
                }
                this.out.write(c);
                break;
            }
            case '\"': {
                if (this.quoteChar == c) {
                    this.out.write("&quot;");
                    break;
                }
                this.out.write(c);
                break;
            }
            default: {
                this.quote(c);
            }
        }
    }

    private void quote(String string) throws IOException {
        for (int i = 0; i < string.length(); ++i) {
            this.quote(string.charAt(i));
        }
    }

    private void nonQuote(String string) throws IOException {
        for (int i = 0; i < string.length(); ++i) {
            this.nonQuote(string.charAt(i));
        }
    }

    private void aquote(String string) throws IOException {
        for (int i = 0; i < string.length(); ++i) {
            this.aquote(string.charAt(i));
        }
    }

    private void indent(int n) throws IOException {
        for (int i = 0; i < n; ++i) {
            this.out.write("  ");
        }
    }

    public void doctype(String string, String string2) throws IOException {
        this.needNewline = true;
        this.out.write("<!DOCTYPE " + string + " SYSTEM " + this.quoteChar);
        this.quote(string2);
        this.out.write(this.quoteChar + ">");
    }

    private void start0(String string) throws IOException {
        this.finishStart();
        this.out.write(60);
        this.out.write(string);
        this.inStart = true;
        this.writtenChars = false;
        ++this.depth;
    }

    private void start1(String string) throws IOException {
        this.finishStart();
        this.out.write(60);
        this.out.write(string);
        this.inStart = true;
        this.writtenChars = false;
        ++this.depth;
    }

    private void finishStart() throws IOException {
        if (this.inStart) {
            if (this.inAttribute) {
                this.out.write(this.quoteChar);
            }
            this.out.write(62);
            this.inStart = false;
            this.inAttribute = false;
            this.inAttributeValue = false;
        }
    }

    public void start(String string) throws IOException {
        this.start1(string);
    }

    public void attribute(String string, String string2) throws IOException {
        this.attributeName(string);
        this.attributeValue(string2);
    }

    public void attributeUnquoted(String string, String string2) throws IOException {
        this.attributeName(string);
        this.attributeValueUnquoted(string2);
    }

    public void attribute(String string, String string2, String string3) throws IOException {
        this.attributeName(string, string2);
        this.attributeValue(string3);
    }

    public void attributeUnquoted(String string, String string2, String string3) throws IOException {
        this.attributeName(string, string2);
        this.attributeValueUnquoted(string3);
    }

    public void attributeName(String string) throws IOException {
        if (!this.inStart) {
            throw new IllegalStateException();
        }
        if (this.inAttribute) {
            this.out.write(this.quoteChar);
            this.inAttribute = false;
            this.inAttributeValue = false;
        }
        this.out.write(32);
        this.out.write(string);
        this.out.write(61);
        this.out.write(this.quoteChar);
        this.inAttribute = true;
    }

    public void attributeName(String string, String string2) throws IOException {
        if (!this.inStart) {
            throw new IllegalStateException();
        }
        if (this.inAttribute) {
            this.out.write(this.quoteChar);
            this.inAttribute = false;
            this.inAttributeValue = false;
        }
        this.out.write(32);
        this.out.write(string);
        this.out.write(58);
        this.out.write(string2);
        this.out.write(61);
        this.out.write(this.quoteChar);
        this.inAttribute = true;
    }

    public void attributeValue(String string) throws IOException {
        if (!this.inAttribute || this.inAttributeValue) {
            throw new IllegalStateException();
        }
        this.aquote(string);
        this.out.write(this.quoteChar);
        this.inAttribute = false;
    }

    public void attributeValueUnquoted(String string) throws IOException {
        if (!this.inAttribute || this.inAttributeValue) {
            throw new IllegalStateException();
        }
        this.out.write(string, 0, string.length());
        this.out.write(this.quoteChar);
        this.inAttribute = false;
    }

    public void attributeValueToken(String string) throws IOException {
        if (!this.inAttribute) {
            throw new IllegalStateException();
        }
        if (this.inAttributeValue) {
            this.out.write(32);
        }
        this.aquote(string);
        this.inAttributeValue = true;
    }

    public void end(String string) throws IOException {
        if (this.inStart) {
            if (this.inAttribute) {
                this.out.write(this.quoteChar);
            }
            this.out.write("/>");
            this.inStart = false;
            this.inAttribute = false;
            this.inAttributeValue = false;
        } else {
            this.out.write("</");
            this.out.write(string);
            this.out.write(62);
        }
        --this.depth;
        this.writtenChars = false;
    }

    public void chars(String string) throws IOException {
        this.finishStart();
        this.quote(string);
        this.writtenChars = true;
    }

    public void chars(CDATA cDATA) throws IOException {
        this.finishStart();
        this.nonQuote(cDATA.getText());
        this.writtenChars = true;
    }

    public void charsUnquoted(String string) throws IOException {
        this.finishStart();
        this.out.write(string, 0, string.length());
        this.writtenChars = true;
    }

    public void charsUnquoted(char[] cArray, int n, int n2) throws IOException {
        this.finishStart();
        this.out.write(cArray, n, n2);
        this.writtenChars = true;
    }

    public void leaf(String string, String string2) throws IOException {
        this.start1(string);
        if (string2 != null && string2.length() != 0) {
            this.chars(string2);
        }
        this.end(string);
    }

    public void inlineLeaf(String string, String string2) throws IOException {
        this.start0(string);
        if (string2 != null && string2.length() != 0) {
            this.chars(string2);
        }
        this.end(string);
    }

    public void leaf(String string) throws IOException {
        this.leaf(string, null);
    }

    public void inlineLeaf(String string) throws IOException {
        this.inlineLeaf(string, null);
    }

    public void flush() throws IOException {
        if (this.depth != 0) {
            this.out.newLine();
        }
        this.out.flush();
    }

    public void close() throws IOException {
        this.flush();
        this.out.close();
    }
}

