/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.doclets.internal.toolkit.util;

import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.MemberDoc;
import com.sun.javadoc.PackageDoc;
import com.sun.tools.doclets.internal.toolkit.Configuration;
import com.sun.tools.doclets.internal.toolkit.util.Util;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetaKeywords {
    private final Configuration configuration;

    public MetaKeywords(Configuration configuration) {
        this.configuration = configuration;
    }

    public String[] getMetaKeywords(ClassDoc classDoc) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this.configuration.keywords) {
            arrayList.addAll(this.getClassKeyword(classDoc));
            arrayList.addAll(this.getMemberKeywords(classDoc.fields()));
            arrayList.addAll(this.getMemberKeywords(classDoc.methods()));
        }
        return arrayList.toArray(new String[0]);
    }

    protected ArrayList<String> getClassKeyword(ClassDoc classDoc) {
        String string = classDoc.isInterface() ? "interface" : "class";
        ArrayList<String> arrayList = new ArrayList<String>(1);
        arrayList.add(classDoc.qualifiedName() + " " + string);
        return arrayList;
    }

    public String[] getMetaKeywords(PackageDoc packageDoc) {
        if (this.configuration.keywords) {
            String string = Util.getPackageName(packageDoc);
            return new String[]{string + " " + "package"};
        }
        return new String[0];
    }

    public String[] getOverviewMetaKeywords(String string, String string2) {
        if (this.configuration.keywords) {
            String string3 = this.configuration.getText(string);
            String[] stringArray = new String[]{string3};
            if (string2.length() > 0) {
                stringArray[0] = stringArray[0] + ", " + string2;
            }
            return stringArray;
        }
        return new String[0];
    }

    protected ArrayList<String> getMemberKeywords(MemberDoc[] memberDocArray) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < memberDocArray.length; ++i) {
            String string = memberDocArray[i].name() + (memberDocArray[i].isMethod() ? "()" : "");
            if (arrayList.contains(string)) continue;
            arrayList.add(string);
        }
        return arrayList;
    }
}

