/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.example.debug.tty;

import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.Location;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SourceMapper {
    private final String[] dirs;

    SourceMapper(List<String> list) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : list) {
            if (string.endsWith(".jar") || string.endsWith(".zip")) continue;
            arrayList.add(string);
        }
        this.dirs = arrayList.toArray(new String[0]);
    }

    SourceMapper(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, File.pathSeparator);
        ArrayList<String> arrayList = new ArrayList<String>();
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (string2.endsWith(".jar") || string2.endsWith(".zip")) continue;
            arrayList.add(string2);
        }
        this.dirs = arrayList.toArray(new String[0]);
    }

    String getSourcePath() {
        int n = 0;
        if (this.dirs.length < 1) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer(this.dirs[n++]);
        while (n < this.dirs.length) {
            stringBuffer.append(File.pathSeparator);
            stringBuffer.append(this.dirs[n]);
            ++n;
        }
        return stringBuffer.toString();
    }

    File sourceFile(Location location) {
        try {
            String string = location.sourceName();
            String string2 = location.declaringType().name();
            int n = string2.lastIndexOf(46);
            String string3 = n >= 0 ? string2.substring(0, n + 1) : "";
            String string4 = string3.replace('.', File.separatorChar) + string;
            for (int i = 0; i < this.dirs.length; ++i) {
                File file = new File(this.dirs[i], string4);
                if (!file.exists()) continue;
                return file;
            }
            return null;
        }
        catch (AbsentInformationException absentInformationException) {
            return null;
        }
    }

    BufferedReader sourceReader(Location location) {
        File file = this.sourceFile(location);
        if (file == null) {
            return null;
        }
        try {
            return new BufferedReader(new FileReader(file));
        }
        catch (IOException iOException) {
            return null;
        }
    }
}

