/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.X11;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Menu;
import java.awt.MenuComponent;
import java.awt.MenuItem;
import java.awt.Point;
import java.awt.PopupMenu;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.peer.PopupMenuPeer;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import sun.awt.SunToolkit;
import sun.awt.X11.XComponentPeer;
import sun.awt.X11.XEvent;
import sun.awt.X11.XKeyEvent;
import sun.awt.X11.XMenuPeer;
import sun.awt.X11.XMenuWindow;
import sun.awt.X11.XToolkit;
import sun.awt.X11.XWindow;

public class XPopupMenuPeer
extends XMenuWindow
implements PopupMenuPeer {
    private static Logger log = Logger.getLogger("sun.awt.X11.XBaseMenuWindow");
    private XComponentPeer componentPeer;
    private PopupMenu popupMenuTarget;
    private XMenuPeer showingMousePressedSubmenu = null;
    private static final int CAPTION_MARGIN_TOP = 4;
    private static final int CAPTION_SEPARATOR_HEIGHT = 6;
    private static final Field f_enabled = SunToolkit.getField(MenuItem.class, "enabled");
    private static final Field f_label = SunToolkit.getField(MenuItem.class, "label");
    private static final Method m_getFont;
    private static final Field f_items;

    XPopupMenuPeer(PopupMenu popupMenu) {
        super((XMenuPeer)null);
        this.popupMenuTarget = popupMenu;
    }

    public void setFont(Font font) {
        this.resetMapping();
        this.setItemsFont(font);
        this.postPaintEvent();
    }

    public void setLabel(String string) {
        this.resetMapping();
        this.postPaintEvent();
    }

    public void setEnabled(boolean bl) {
        this.postPaintEvent();
    }

    public void enable() {
        this.setEnabled(true);
    }

    public void disable() {
        this.setEnabled(false);
    }

    public void addSeparator() {
        if (log.isLoggable(Level.FINER)) {
            log.finer("addSeparator is not implemented");
        }
    }

    public void show(Event event) {
        this.target = (Component)event.target;
        Vector vector = this.getMenuTargetItems();
        if (vector != null) {
            this.reloadItems(vector);
            Point point = this.target.getLocationOnScreen();
            Point point2 = new Point(point.x + event.x, point.y + event.y);
            if (!this.ensureCreated()) {
                return;
            }
            Dimension dimension = this.getDesiredSize();
            Rectangle rectangle = this.getWindowBounds(point2, dimension);
            this.reshape(rectangle);
            this.xSetVisible(true);
            this.toFront();
            this.selectItem(null, false);
            this.grabInput();
        }
    }

    Font getTargetFont() {
        if (this.popupMenuTarget == null) {
            return XWindow.getDefaultFont();
        }
        try {
            return (Font)m_getFont.invoke(this.popupMenuTarget, new Object[0]);
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
        }
        catch (InvocationTargetException invocationTargetException) {
            invocationTargetException.printStackTrace();
        }
        return XWindow.getDefaultFont();
    }

    String getTargetLabel() {
        if (this.target == null) {
            return "";
        }
        try {
            String string = (String)f_label.get(this.popupMenuTarget);
            return string == null ? "" : string;
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
            return "";
        }
    }

    boolean isTargetEnabled() {
        if (this.popupMenuTarget == null) {
            return false;
        }
        try {
            return f_enabled.getBoolean(this.popupMenuTarget);
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
            return false;
        }
    }

    Vector getMenuTargetItems() {
        try {
            return (Vector)f_items.get(this.popupMenuTarget);
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
            return null;
        }
    }

    protected Rectangle getWindowBounds(Point point, Dimension dimension) {
        Rectangle rectangle = new Rectangle(point.x, point.y, 0, 0);
        Dimension dimension2 = Toolkit.getDefaultToolkit().getScreenSize();
        Rectangle rectangle2 = this.fitWindowRight(rectangle, dimension, dimension2);
        if (rectangle2 != null) {
            return rectangle2;
        }
        rectangle2 = this.fitWindowLeft(rectangle, dimension, dimension2);
        if (rectangle2 != null) {
            return rectangle2;
        }
        rectangle2 = this.fitWindowBelow(rectangle, dimension, dimension2);
        if (rectangle2 != null) {
            return rectangle2;
        }
        rectangle2 = this.fitWindowAbove(rectangle, dimension, dimension2);
        if (rectangle2 != null) {
            return rectangle2;
        }
        return this.fitWindowToScreen(dimension, dimension2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Dimension getCaptionSize() {
        String string = this.getTargetLabel();
        if (string.equals("")) {
            return null;
        }
        Graphics graphics = this.getGraphics();
        if (graphics == null) {
            return null;
        }
        try {
            Dimension dimension;
            graphics.setFont(this.getTargetFont());
            FontMetrics fontMetrics = graphics.getFontMetrics();
            String string2 = this.getTargetLabel();
            int n = fontMetrics.stringWidth(string2);
            int n2 = 4 + fontMetrics.getHeight() + 6;
            Dimension dimension2 = dimension = new Dimension(n, n2);
            Object var10_9 = null;
            graphics.dispose();
            return dimension2;
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            graphics.dispose();
            throw throwable;
        }
    }

    protected void paintCaption(Graphics graphics, Rectangle rectangle) {
        String string = this.getTargetLabel();
        if (string.equals("")) {
            return;
        }
        graphics.setFont(this.getTargetFont());
        FontMetrics fontMetrics = graphics.getFontMetrics();
        String string2 = this.getTargetLabel();
        int n = fontMetrics.stringWidth(string2);
        int n2 = rectangle.x + (rectangle.width - n) / 2;
        int n3 = rectangle.y + 4 + fontMetrics.getAscent();
        int n4 = rectangle.y + rectangle.height - 3;
        graphics.setColor(this.isTargetEnabled() ? this.getForegroundColor() : this.getDisabledColor());
        graphics.drawString(string, n2, n3);
        this.draw3DRect(graphics, rectangle.x, n4, rectangle.width, 2, false);
    }

    protected void doDispose() {
        super.doDispose();
        XToolkit.targetDisposedPeer(this.popupMenuTarget, this);
    }

    protected void handleEvent(AWTEvent aWTEvent) {
        switch (aWTEvent.getID()) {
            case 500: 
            case 501: 
            case 502: 
            case 503: 
            case 504: 
            case 505: 
            case 506: {
                this.doHandleJavaMouseEvent((MouseEvent)aWTEvent);
                break;
            }
            case 401: 
            case 402: {
                this.doHandleJavaKeyEvent((KeyEvent)aWTEvent);
                break;
            }
            default: {
                super.handleEvent(aWTEvent);
            }
        }
    }

    void ungrabInputImpl() {
        this.hide();
    }

    public void handleKeyPress(XEvent xEvent) {
        XKeyEvent xKeyEvent = xEvent.get_xkey();
        if (log.isLoggable(Level.FINE)) {
            log.fine(xKeyEvent.toString());
        }
        if (this.isEventDisabled(xEvent)) {
            return;
        }
        Component component = this.getEventSource();
        this.handleKeyPress(xKeyEvent);
    }

    static {
        f_items = SunToolkit.getField(Menu.class, "items");
        m_getFont = SunToolkit.getMethod(MenuComponent.class, "getFont_NoClientCode", null);
    }
}

