/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.encoding.soap.client;

import com.sun.xml.internal.bind.api.BridgeContext;
import com.sun.xml.internal.ws.client.dispatch.impl.encoding.DispatchSerializer;
import com.sun.xml.internal.ws.encoding.jaxb.JAXBBridgeInfo;
import com.sun.xml.internal.ws.encoding.simpletype.EncoderUtils;
import com.sun.xml.internal.ws.encoding.soap.DeserializationException;
import com.sun.xml.internal.ws.encoding.soap.SOAP12Constants;
import com.sun.xml.internal.ws.encoding.soap.client.SOAPXMLDecoder;
import com.sun.xml.internal.ws.encoding.soap.internal.HeaderBlock;
import com.sun.xml.internal.ws.encoding.soap.internal.InternalMessage;
import com.sun.xml.internal.ws.encoding.soap.message.FaultCode;
import com.sun.xml.internal.ws.encoding.soap.message.FaultCodeEnum;
import com.sun.xml.internal.ws.encoding.soap.message.FaultReason;
import com.sun.xml.internal.ws.encoding.soap.message.FaultReasonText;
import com.sun.xml.internal.ws.encoding.soap.message.FaultSubcode;
import com.sun.xml.internal.ws.encoding.soap.message.SOAP12FaultInfo;
import com.sun.xml.internal.ws.encoding.soap.message.SOAPFaultInfo;
import com.sun.xml.internal.ws.model.soap.SOAPRuntimeModel;
import com.sun.xml.internal.ws.pept.ept.MessageInfo;
import com.sun.xml.internal.ws.server.RuntimeContext;
import com.sun.xml.internal.ws.streaming.XMLStreamReaderUtil;
import com.sun.xml.internal.ws.util.MessageInfoUtil;
import com.sun.xml.internal.ws.util.xml.XmlUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SOAP12XMLDecoder
extends SOAPXMLDecoder {
    private static final Logger logger = Logger.getLogger(new StringBuffer().append("javax.enterprise.resource.webservices.jaxws").append(".client.dispatch").toString());

    @Override
    protected DispatchSerializer getSerializerInstance() {
        return DispatchSerializer.SOAP_1_2;
    }

    @Override
    protected SOAPFaultInfo decodeFault(XMLStreamReader xMLStreamReader, InternalMessage internalMessage, MessageInfo messageInfo) {
        XMLStreamReaderUtil.verifyReaderState(xMLStreamReader, 1);
        XMLStreamReaderUtil.verifyTag(xMLStreamReader, SOAP12Constants.QNAME_SOAP_FAULT);
        XMLStreamReaderUtil.nextElementContent(xMLStreamReader);
        XMLStreamReaderUtil.verifyReaderState(xMLStreamReader, 1);
        XMLStreamReaderUtil.verifyTag(xMLStreamReader, SOAP12Constants.QNAME_FAULT_CODE);
        XMLStreamReaderUtil.nextElementContent(xMLStreamReader);
        QName qName = this.readFaultValue(xMLStreamReader);
        FaultCodeEnum faultCodeEnum = FaultCodeEnum.get(qName);
        if (faultCodeEnum == null) {
            throw new DeserializationException("unknown fault code:", qName.toString());
        }
        FaultSubcode faultSubcode = null;
        if (xMLStreamReader.getEventType() == 1) {
            faultSubcode = this.readFaultSubcode(xMLStreamReader);
        }
        FaultCode faultCode = new FaultCode(faultCodeEnum, faultSubcode);
        XMLStreamReaderUtil.verifyReaderState(xMLStreamReader, 2);
        XMLStreamReaderUtil.verifyTag(xMLStreamReader, SOAP12Constants.QNAME_FAULT_CODE);
        XMLStreamReaderUtil.nextElementContent(xMLStreamReader);
        FaultReason faultReason = this.readFaultReason(xMLStreamReader);
        String string = null;
        String string2 = null;
        Object object = null;
        QName qName2 = xMLStreamReader.getName();
        if (qName2.equals(SOAP12Constants.QNAME_FAULT_NODE)) {
            string = xMLStreamReader.getText();
        }
        if (qName2.equals(SOAP12Constants.QNAME_FAULT_ROLE)) {
            XMLStreamReaderUtil.nextContent(xMLStreamReader);
            string2 = xMLStreamReader.getText();
            XMLStreamReaderUtil.nextElementContent(xMLStreamReader);
            XMLStreamReaderUtil.nextElementContent(xMLStreamReader);
        }
        if (qName2.equals(SOAP12Constants.QNAME_FAULT_DETAIL)) {
            XMLStreamReaderUtil.nextElementContent(xMLStreamReader);
            object = this.readFaultDetail(xMLStreamReader, messageInfo);
            XMLStreamReaderUtil.nextElementContent(xMLStreamReader);
        }
        XMLStreamReaderUtil.verifyReaderState(xMLStreamReader, 2);
        XMLStreamReaderUtil.verifyTag(xMLStreamReader, SOAP12Constants.QNAME_SOAP_FAULT);
        XMLStreamReaderUtil.nextElementContent(xMLStreamReader);
        return new SOAP12FaultInfo(faultCode, faultReason, string, string2, object);
    }

    protected QName readFaultValue(XMLStreamReader xMLStreamReader) {
        XMLStreamReaderUtil.verifyReaderState(xMLStreamReader, 1);
        XMLStreamReaderUtil.verifyTag(xMLStreamReader, SOAP12Constants.QNAME_FAULT_VALUE);
        XMLStreamReaderUtil.nextContent(xMLStreamReader);
        String string = xMLStreamReader.getText();
        XMLStreamReaderUtil.next(xMLStreamReader);
        XMLStreamReaderUtil.verifyReaderState(xMLStreamReader, 2);
        XMLStreamReaderUtil.verifyTag(xMLStreamReader, SOAP12Constants.QNAME_FAULT_VALUE);
        XMLStreamReaderUtil.nextElementContent(xMLStreamReader);
        String string2 = "";
        string = EncoderUtils.collapseWhitespace(string);
        String string3 = XmlUtil.getPrefix(string);
        if (string3 != null && (string2 = xMLStreamReader.getNamespaceURI(string3)) == null) {
            throw new DeserializationException("xsd.unknownPrefix", string3);
        }
        String string4 = XmlUtil.getLocalPart(string);
        return new QName(string2, string4);
    }

    protected FaultSubcode readFaultSubcode(XMLStreamReader xMLStreamReader) {
        FaultSubcode faultSubcode = null;
        QName qName = xMLStreamReader.getName();
        if (qName.equals(SOAP12Constants.QNAME_FAULT_SUBCODE)) {
            XMLStreamReaderUtil.nextElementContent(xMLStreamReader);
            QName qName2 = this.readFaultValue(xMLStreamReader);
            FaultSubcode faultSubcode2 = null;
            if (xMLStreamReader.getEventType() == 1) {
                faultSubcode2 = this.readFaultSubcode(xMLStreamReader);
            }
            faultSubcode = new FaultSubcode(qName2, faultSubcode2);
            XMLStreamReaderUtil.verifyReaderState(xMLStreamReader, 2);
            XMLStreamReaderUtil.verifyTag(xMLStreamReader, SOAP12Constants.QNAME_FAULT_SUBCODE);
            XMLStreamReaderUtil.nextElementContent(xMLStreamReader);
        }
        return faultSubcode;
    }

    protected FaultReason readFaultReason(XMLStreamReader xMLStreamReader) {
        XMLStreamReaderUtil.verifyReaderState(xMLStreamReader, 1);
        XMLStreamReaderUtil.verifyTag(xMLStreamReader, SOAP12Constants.QNAME_FAULT_REASON);
        XMLStreamReaderUtil.nextElementContent(xMLStreamReader);
        ArrayList<FaultReasonText> arrayList = new ArrayList<FaultReasonText>();
        this.readFaultReasonTexts(xMLStreamReader, arrayList);
        XMLStreamReaderUtil.verifyReaderState(xMLStreamReader, 2);
        XMLStreamReaderUtil.verifyTag(xMLStreamReader, SOAP12Constants.QNAME_FAULT_REASON);
        XMLStreamReaderUtil.nextElementContent(xMLStreamReader);
        FaultReasonText[] faultReasonTextArray = arrayList.toArray(new FaultReasonText[0]);
        return new FaultReason(faultReasonTextArray);
    }

    protected void readFaultReasonTexts(XMLStreamReader xMLStreamReader, List<FaultReasonText> list) {
        QName qName = xMLStreamReader.getName();
        if (!qName.equals(SOAP12Constants.QNAME_FAULT_REASON_TEXT)) {
            return;
        }
        String string = xMLStreamReader.getAttributeValue("http://www.w3.org/XML/1998/namespace", "lang");
        if (string == null) {
            string = "en";
        }
        XMLStreamReaderUtil.nextContent(xMLStreamReader);
        String string2 = null;
        if (xMLStreamReader.getEventType() == 4) {
            string2 = xMLStreamReader.getText();
            XMLStreamReaderUtil.next(xMLStreamReader);
        }
        XMLStreamReaderUtil.verifyReaderState(xMLStreamReader, 2);
        XMLStreamReaderUtil.verifyTag(xMLStreamReader, SOAP12Constants.QNAME_FAULT_REASON_TEXT);
        XMLStreamReaderUtil.nextElementContent(xMLStreamReader);
        Locale locale = new Locale(string);
        list.add(new FaultReasonText(string2, locale));
        this.readFaultReasonTexts(xMLStreamReader, list);
    }

    @Override
    protected void decodeHeader(XMLStreamReader xMLStreamReader, MessageInfo messageInfo, InternalMessage internalMessage) {
        XMLStreamReaderUtil.verifyReaderState(xMLStreamReader, 1);
        if (!"Header".equals(xMLStreamReader.getLocalName())) {
            return;
        }
        XMLStreamReaderUtil.verifyTag(xMLStreamReader, this.getHeaderTag());
        XMLStreamReaderUtil.nextElementContent(xMLStreamReader);
        while (xMLStreamReader.getEventType() == 1) {
            this.decodeHeaderElement(xMLStreamReader, messageInfo, internalMessage);
        }
        XMLStreamReaderUtil.verifyReaderState(xMLStreamReader, 2);
        XMLStreamReaderUtil.verifyTag(xMLStreamReader, this.getHeaderTag());
        XMLStreamReaderUtil.nextElementContent(xMLStreamReader);
    }

    @Override
    protected void decodeHeaderElement(XMLStreamReader xMLStreamReader, MessageInfo messageInfo, InternalMessage internalMessage) {
        RuntimeContext runtimeContext = MessageInfoUtil.getRuntimeContext(messageInfo);
        BridgeContext bridgeContext = runtimeContext.getBridgeContext();
        Set<QName> set = ((SOAPRuntimeModel)runtimeContext.getModel()).getKnownHeaders();
        QName qName = xMLStreamReader.getName();
        if (set != null && set.contains(qName)) {
            Object object;
            QName qName2 = xMLStreamReader.getName();
            if (internalMessage.isHeaderPresent(qName)) {
                this.raiseFault(this.getSenderFaultCode(), "Duplicate Header" + qName2);
            }
            if ((object = runtimeContext.getDecoderInfo(qName)) != null && object instanceof JAXBBridgeInfo) {
                JAXBBridgeInfo jAXBBridgeInfo = (JAXBBridgeInfo)object;
                jAXBBridgeInfo.deserialize(xMLStreamReader, bridgeContext);
                HeaderBlock headerBlock = new HeaderBlock(jAXBBridgeInfo);
                internalMessage.addHeader(headerBlock);
            }
        } else {
            XMLStreamReaderUtil.skipElement(xMLStreamReader);
            XMLStreamReaderUtil.nextElementContent(xMLStreamReader);
        }
    }

    @Override
    protected QName getFaultTag() {
        return SOAP12Constants.QNAME_SOAP_FAULT;
    }

    @Override
    protected QName getBodyTag() {
        return SOAP12Constants.QNAME_SOAP_BODY;
    }

    @Override
    protected QName getEnvelopeTag() {
        return SOAP12Constants.QNAME_SOAP_ENVELOPE;
    }

    @Override
    protected QName getHeaderTag() {
        return SOAP12Constants.QNAME_SOAP_HEADER;
    }

    @Override
    protected QName getMUAttrQName() {
        return SOAP12Constants.QNAME_MUSTUNDERSTAND;
    }

    @Override
    protected QName getRoleAttrQName() {
        return SOAP12Constants.QNAME_ROLE;
    }

    @Override
    protected QName getFaultDetailTag() {
        return SOAP12Constants.QNAME_FAULT_DETAIL;
    }

    @Override
    public String getBindingId() {
        return "http://www.w3.org/2003/05/soap/bindings/HTTP/";
    }

    @Override
    protected QName getSenderFaultCode() {
        return SOAP12Constants.FAULT_CODE_SERVER;
    }

    @Override
    protected QName getReceiverFaultCode() {
        return SOAP12Constants.FAULT_CODE_CLIENT;
    }

    @Override
    protected QName getVersionMismatchFaultCode() {
        return SOAP12Constants.FAULT_CODE_VERSION_MISMATCH;
    }
}

