/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.client.dispatch.impl.encoding;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;

public class DispatchUtil {
    private Map<String, String> namespacePrefixMap;

    public void clearNPMap() {
        this.namespacePrefixMap.clear();
    }

    public void populatePrefixes(XMLStreamWriter xMLStreamWriter) {
        if (!this.namespacePrefixMap.isEmpty()) {
            Set<Map.Entry<String, String>> set = this.namespacePrefixMap.entrySet();
            for (Map.Entry<String, String> entry : set) {
                try {
                    xMLStreamWriter.setPrefix(entry.getValue(), entry.getKey());
                }
                catch (XMLStreamException xMLStreamException) {
                    xMLStreamException.printStackTrace();
                }
            }
        }
    }

    public void collectPrefixes(XMLStreamReader xMLStreamReader) {
        if (this.namespacePrefixMap == null) {
            this.namespacePrefixMap = new HashMap<String, String>();
        }
        int n = xMLStreamReader.getNamespaceCount();
        for (int i = 0; i < n; ++i) {
            String string = xMLStreamReader.getNamespacePrefix(i);
            String string2 = xMLStreamReader.getNamespaceURI(i);
            if (string.length() <= 0 || string2 == null) continue;
            this.namespacePrefixMap.put(string2, string);
        }
    }
}

