/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.example.debug.gui;

import com.sun.tools.example.debug.bdi.ExecutionManager;
import com.sun.tools.example.debug.gui.ApplicationTool;
import com.sun.tools.example.debug.gui.ClassTreeTool;
import com.sun.tools.example.debug.gui.CommandTool;
import com.sun.tools.example.debug.gui.ContextManager;
import com.sun.tools.example.debug.gui.Environment;
import com.sun.tools.example.debug.gui.JDBMenuBar;
import com.sun.tools.example.debug.gui.JDBToolBar;
import com.sun.tools.example.debug.gui.MonitorTool;
import com.sun.tools.example.debug.gui.SearchPath;
import com.sun.tools.example.debug.gui.SourceTool;
import com.sun.tools.example.debug.gui.SourceTreeTool;
import com.sun.tools.example.debug.gui.StackTraceTool;
import com.sun.tools.example.debug.gui.ThreadTreeTool;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;

public class GUI
extends JPanel {
    private CommandTool cmdTool;
    private ApplicationTool appTool;
    public static SourceTool srcTool;
    private SourceTreeTool sourceTreeTool;
    private ClassTreeTool classTreeTool;
    private ThreadTreeTool threadTreeTool;
    private StackTraceTool stackTool;
    private MonitorTool monitorTool;
    public static final String progname = "javadt";
    public static final String version = "1.0Beta";
    public static final String windowBanner = "Java(tm) platform Debug Tool";
    private Font fixedFont = new Font("monospaced", 0, 10);

    private GUI(Environment environment) {
        this.setLayout(new BorderLayout());
        this.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.add((Component)new JDBToolBar(environment), "North");
        srcTool = new SourceTool(environment);
        srcTool.setPreferredSize(new Dimension(500, 300));
        srcTool.setTextFont(this.fixedFont);
        this.stackTool = new StackTraceTool(environment);
        this.stackTool.setPreferredSize(new Dimension(500, 100));
        this.monitorTool = new MonitorTool(environment);
        this.monitorTool.setPreferredSize(new Dimension(500, 50));
        JSplitPane jSplitPane = new JSplitPane(0, srcTool, new JSplitPane(0, this.stackTool, this.monitorTool));
        this.sourceTreeTool = new SourceTreeTool(environment);
        this.sourceTreeTool.setPreferredSize(new Dimension(200, 450));
        this.classTreeTool = new ClassTreeTool(environment);
        this.classTreeTool.setPreferredSize(new Dimension(200, 450));
        this.threadTreeTool = new ThreadTreeTool(environment);
        this.threadTreeTool.setPreferredSize(new Dimension(200, 450));
        JTabbedPane jTabbedPane = new JTabbedPane(3);
        jTabbedPane.addTab("Source", null, this.sourceTreeTool);
        jTabbedPane.addTab("Classes", null, this.classTreeTool);
        jTabbedPane.addTab("Threads", null, this.threadTreeTool);
        JSplitPane jSplitPane2 = new JSplitPane(1, jTabbedPane, jSplitPane);
        this.cmdTool = new CommandTool(environment);
        this.cmdTool.setPreferredSize(new Dimension(700, 150));
        this.appTool = new ApplicationTool(environment);
        this.appTool.setPreferredSize(new Dimension(700, 200));
        JSplitPane jSplitPane3 = new JSplitPane(0, this.cmdTool, this.appTool);
        JSplitPane jSplitPane4 = new JSplitPane(0, jSplitPane2, jSplitPane3);
        this.add((Component)jSplitPane4, "Center");
    }

    private static void usage() {
        String string = File.pathSeparator;
        System.out.println("Usage: javadt <options> <class> <arguments>");
        System.out.println();
        System.out.println("where options include:");
        System.out.println("    -help             print out this message and exit");
        System.out.println("    -sourcepath <directories separated by \"" + string + "\">");
        System.out.println("                      list directories in which to look for source files");
        System.out.println("    -remote <hostname>:<port-number>");
        System.out.println("                      host machine and port number of interpreter to attach to");
        System.out.println("    -dbgtrace [flags] print info for debugging javadt");
        System.out.println();
        System.out.println("options forwarded to debuggee process:");
        System.out.println("    -v -verbose[:class|gc|jni]");
        System.out.println("                      turn on verbose mode");
        System.out.println("    -D<name>=<value>  set a system property");
        System.out.println("    -classpath <directories separated by \"" + string + "\">");
        System.out.println("                      list directories in which to look for classes");
        System.out.println("    -X<option>        non-standard debuggee VM option");
        System.out.println();
        System.out.println("<class> is the name of the class to begin debugging");
        System.out.println("<arguments> are the arguments passed to the main() method of <class>");
        System.out.println();
        System.out.println("For command help type 'help' at javadt prompt");
    }

    public static void main(String[] stringArray) {
        Object var1_1 = null;
        String string = "";
        String string2 = "";
        String string3 = "";
        boolean bl = false;
        final Environment environment = new Environment();
        GUI gUI = new GUI(environment);
        ContextManager contextManager = environment.getContextManager();
        ExecutionManager executionManager = environment.getExecutionManager();
        for (int i = 0; i < stringArray.length; ++i) {
            String string4 = stringArray[i];
            if (string4.equals("-dbgtrace")) {
                if (i == stringArray.length - 1 || !Character.isDigit(stringArray[i + 1].charAt(0))) {
                    executionManager.setTraceMode(0xFFFFFF);
                    continue;
                }
                String string5 = stringArray[++i];
                executionManager.setTraceMode(Integer.decode(string5));
                continue;
            }
            if (string4.equals("-X")) {
                System.out.println("Use 'java -X' to see the available non-standard options");
                System.out.println();
                GUI.usage();
                System.exit(1);
                continue;
            }
            if (string4.equals("-v") || string4.startsWith("-v:") || string4.startsWith("-verbose") || string4.startsWith("-D") || string4.startsWith("-X") || string4.equals("-noasyncgc") || string4.equals("-prof") || string4.equals("-verify") || string4.equals("-noverify") || string4.equals("-verifyremote") || string4.equals("-verbosegc") || string4.startsWith("-ms") || string4.startsWith("-mx") || string4.startsWith("-ss") || string4.startsWith("-oss")) {
                string3 = string3 + string4 + " ";
                continue;
            }
            if (string4.equals("-sourcepath")) {
                if (i == stringArray.length - 1) {
                    System.out.println("No sourcepath specified.");
                    GUI.usage();
                    System.exit(1);
                }
                environment.getSourceManager().setSourcePath(new SearchPath(stringArray[++i]));
                continue;
            }
            if (string4.equals("-classpath")) {
                if (i == stringArray.length - 1) {
                    System.out.println("No classpath specified.");
                    GUI.usage();
                    System.exit(1);
                }
                environment.getClassManager().setClassPath(new SearchPath(stringArray[++i]));
                continue;
            }
            if (string4.equals("-remote")) {
                if (i == stringArray.length - 1) {
                    System.out.println("No remote specified.");
                    GUI.usage();
                    System.exit(1);
                }
                environment.getContextManager().setRemotePort(stringArray[++i]);
                continue;
            }
            if (string4.equals("-help")) {
                GUI.usage();
                System.exit(0);
                continue;
            }
            if (string4.equals("-version")) {
                System.out.println("javadt version 1.0Beta");
                System.exit(0);
                continue;
            }
            if (string4.startsWith("-")) {
                System.out.println("invalid option: " + string4);
                GUI.usage();
                System.exit(1);
                continue;
            }
            string = string4;
            ++i;
            while (i < stringArray.length) {
                string2 = string2 + stringArray[i] + " ";
                ++i;
            }
            break;
        }
        contextManager.setMainClassName(string);
        contextManager.setProgramArguments(string2);
        contextManager.setVmArguments(string3);
        try {
            UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
        }
        catch (Exception exception) {
            System.err.println("Error loading L&F: " + exception);
        }
        JFrame jFrame = new JFrame();
        jFrame.setBackground(Color.lightGray);
        jFrame.setTitle(windowBanner);
        jFrame.setJMenuBar(new JDBMenuBar(environment));
        jFrame.setContentPane(gUI);
        jFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                environment.terminate();
            }
        });
        jFrame.pack();
        jFrame.show();
    }
}

