/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.example.debug.bdi;

import com.sun.jdi.ReferenceType;
import com.sun.tools.example.debug.bdi.ReferenceTypeSpec;
import com.sun.tools.example.debug.bdi.Utils;
import java.util.StringTokenizer;

class PatternReferenceTypeSpec
implements ReferenceTypeSpec {
    final boolean isWild;
    final String classId;

    PatternReferenceTypeSpec(String string) {
        this.isWild = string.startsWith("*.");
        this.classId = this.isWild ? string.substring(1) : string;
    }

    public boolean matches(ReferenceType referenceType) {
        if (this.isWild) {
            return referenceType.name().endsWith(this.classId);
        }
        return referenceType.name().equals(this.classId);
    }

    public int hashCode() {
        return this.classId.hashCode();
    }

    public boolean equals(Object object) {
        if (object instanceof PatternReferenceTypeSpec) {
            PatternReferenceTypeSpec patternReferenceTypeSpec = (PatternReferenceTypeSpec)object;
            return this.classId.equals(patternReferenceTypeSpec.classId) && this.isWild == patternReferenceTypeSpec.isWild;
        }
        return false;
    }

    private void checkClassName(String string) throws ClassNotFoundException {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        boolean bl = true;
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (!(Utils.isJavaIdentifier(string2) || bl && string2.equals("*"))) {
                throw new ClassNotFoundException();
            }
            bl = false;
        }
    }

    public String toString() {
        return this.isWild ? "*" + this.classId : this.classId;
    }
}

