/*
 * Decompiled with CFR 0.152.
 */
package com.sun.crypto.provider;

import com.sun.crypto.provider.SunJCE;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidParameterException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.KeyGeneratorSpi;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;

final class KeyGeneratorCore {
    private final String name;
    private final int defaultKeySize;
    private int keySize;
    private SecureRandom random;

    KeyGeneratorCore(String string, int n) {
        this.name = string;
        this.defaultKeySize = n;
        this.implInit(null);
    }

    void implInit(SecureRandom secureRandom) {
        this.keySize = this.defaultKeySize;
        this.random = secureRandom;
    }

    void implInit(AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
        throw new InvalidAlgorithmParameterException(this.name + " key generation does not take any parameters");
    }

    void implInit(int n, SecureRandom secureRandom) {
        if (n < 40) {
            throw new InvalidParameterException("Key length must be at least 40 bits");
        }
        this.keySize = n;
        this.random = secureRandom;
    }

    SecretKey implGenerateKey() {
        if (this.random == null) {
            this.random = SunJCE.RANDOM;
        }
        byte[] byArray = new byte[this.keySize + 7 >> 3];
        this.random.nextBytes(byArray);
        return new SecretKeySpec(byArray, this.name);
    }

    public static final class ARCFOURKeyGenerator
    extends KeyGeneratorSpi {
        private final KeyGeneratorCore core;

        public ARCFOURKeyGenerator() {
            SunJCE.ensureIntegrity(this.getClass());
            this.core = new KeyGeneratorCore("ARCFOUR", 128);
        }

        protected void engineInit(SecureRandom secureRandom) {
            this.core.implInit(secureRandom);
        }

        protected void engineInit(AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
            this.core.implInit(algorithmParameterSpec, secureRandom);
        }

        protected void engineInit(int n, SecureRandom secureRandom) {
            if (n < 40 || n > 1024) {
                throw new InvalidParameterException("Key length for ARCFOUR must be between 40 and 1024 bits");
            }
            this.core.implInit(n, secureRandom);
        }

        protected SecretKey engineGenerateKey() {
            return this.core.implGenerateKey();
        }
    }

    public static final class RC2KeyGenerator
    extends KeyGeneratorSpi {
        private final KeyGeneratorCore core;

        public RC2KeyGenerator() {
            SunJCE.ensureIntegrity(this.getClass());
            this.core = new KeyGeneratorCore("RC2", 128);
        }

        protected void engineInit(SecureRandom secureRandom) {
            this.core.implInit(secureRandom);
        }

        protected void engineInit(AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
            this.core.implInit(algorithmParameterSpec, secureRandom);
        }

        protected void engineInit(int n, SecureRandom secureRandom) {
            if (n < 40 || n > 1024) {
                throw new InvalidParameterException("Key length for RC2 must be between 40 and 1024 bits");
            }
            this.core.implInit(n, secureRandom);
        }

        protected SecretKey engineGenerateKey() {
            return this.core.implGenerateKey();
        }
    }

    public static final class HmacSHA512KG
    extends KeyGeneratorSpi {
        private final KeyGeneratorCore core;

        public HmacSHA512KG() {
            SunJCE.ensureIntegrity(this.getClass());
            this.core = new KeyGeneratorCore("HmacSHA512", 512);
        }

        protected void engineInit(SecureRandom secureRandom) {
            this.core.implInit(secureRandom);
        }

        protected void engineInit(AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
            this.core.implInit(algorithmParameterSpec, secureRandom);
        }

        protected void engineInit(int n, SecureRandom secureRandom) {
            this.core.implInit(n, secureRandom);
        }

        protected SecretKey engineGenerateKey() {
            return this.core.implGenerateKey();
        }
    }

    public static final class HmacSHA384KG
    extends KeyGeneratorSpi {
        private final KeyGeneratorCore core;

        public HmacSHA384KG() {
            SunJCE.ensureIntegrity(this.getClass());
            this.core = new KeyGeneratorCore("HmacSHA384", 384);
        }

        protected void engineInit(SecureRandom secureRandom) {
            this.core.implInit(secureRandom);
        }

        protected void engineInit(AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
            this.core.implInit(algorithmParameterSpec, secureRandom);
        }

        protected void engineInit(int n, SecureRandom secureRandom) {
            this.core.implInit(n, secureRandom);
        }

        protected SecretKey engineGenerateKey() {
            return this.core.implGenerateKey();
        }
    }

    public static final class HmacSHA256KG
    extends KeyGeneratorSpi {
        private final KeyGeneratorCore core;

        public HmacSHA256KG() {
            SunJCE.ensureIntegrity(this.getClass());
            this.core = new KeyGeneratorCore("HmacSHA256", 256);
        }

        protected void engineInit(SecureRandom secureRandom) {
            this.core.implInit(secureRandom);
        }

        protected void engineInit(AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
            this.core.implInit(algorithmParameterSpec, secureRandom);
        }

        protected void engineInit(int n, SecureRandom secureRandom) {
            this.core.implInit(n, secureRandom);
        }

        protected SecretKey engineGenerateKey() {
            return this.core.implGenerateKey();
        }
    }
}

