/*
 * Decompiled with CFR 0.152.
 */
package com.sun.crypto.provider;

import com.sun.crypto.provider.SunJCE;
import java.security.InvalidAlgorithmParameterException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.KeyGeneratorSpi;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;

public final class HmacSHA1KeyGenerator
extends KeyGeneratorSpi {
    private SecureRandom random = null;
    private int keysize = 64;

    public HmacSHA1KeyGenerator() {
        if (!SunJCE.verifySelfIntegrity(this.getClass())) {
            throw new SecurityException("The SunJCE provider may have been tampered.");
        }
    }

    protected void engineInit(SecureRandom secureRandom) {
        this.random = secureRandom;
    }

    protected void engineInit(AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
        throw new InvalidAlgorithmParameterException("HMAC-SHA1 key generation does not take any parameters");
    }

    protected void engineInit(int n, SecureRandom secureRandom) {
        this.keysize = (n + 7) / 8;
        this.engineInit(secureRandom);
    }

    protected SecretKey engineGenerateKey() {
        if (this.random == null) {
            this.random = SunJCE.RANDOM;
        }
        byte[] byArray = new byte[this.keysize];
        this.random.nextBytes(byArray);
        return new SecretKeySpec(byArray, "HmacSHA1");
    }
}

