/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javah;

import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.FieldDoc;
import com.sun.javadoc.MemberDoc;
import com.sun.javadoc.MethodDoc;
import com.sun.javadoc.Parameter;
import com.sun.javadoc.RootDoc;
import com.sun.javadoc.Type;
import com.sun.tools.javah.Gen;
import com.sun.tools.javah.TypeSignature;
import com.sun.tools.javah.Util;
import java.io.File;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Hashtable;

public class LLNI
extends Gen {
    protected final char pathChar = File.separatorChar;
    protected final char innerDelim = (char)36;
    protected Hashtable doneHandleTypes;
    MemberDoc[] fields;
    MemberDoc[] methods;
    private boolean doubleAlign;
    private int padFieldNum = 0;
    private static final boolean isWindows = System.getProperty("os.name").startsWith("Windows");

    LLNI(boolean bl, RootDoc rootDoc) {
        super(rootDoc);
        this.doubleAlign = bl;
    }

    protected String getIncludes() {
        return "";
    }

    protected void write(OutputStream outputStream, ClassDoc classDoc) throws ClassNotFoundException {
        String string = this.mangleClassName(classDoc.qualifiedName());
        PrintWriter printWriter = this.wrapWriter(outputStream);
        this.fields = classDoc.fields();
        this.methods = classDoc.methods();
        this.generateDeclsForClass(printWriter, classDoc, string);
    }

    protected void generateDeclsForClass(PrintWriter printWriter, ClassDoc classDoc, String string) throws ClassNotFoundException {
        this.doneHandleTypes = new Hashtable();
        this.genHandleType(null, "java.lang.Class");
        this.genHandleType(null, "java.lang.ClassLoader");
        this.genHandleType(null, "java.lang.Object");
        this.genHandleType(null, "java.lang.String");
        this.genHandleType(null, "java.lang.Thread");
        this.genHandleType(null, "java.lang.ThreadGroup");
        this.genHandleType(null, "java.lang.Throwable");
        printWriter.println("/* LLNI Header for class " + classDoc.qualifiedName() + " */" + this.lineSep);
        printWriter.println("#ifndef _Included_" + string);
        printWriter.println("#define _Included_" + string);
        printWriter.println("#include \"typedefs.h\"");
        printWriter.println("#include \"llni.h\"");
        printWriter.println("#include \"jni.h\"" + this.lineSep);
        this.forwardDecls(printWriter, classDoc);
        this.structSectionForClass(printWriter, classDoc, string);
        this.methodSectionForClass(printWriter, classDoc, string);
        printWriter.println("#endif");
    }

    protected void genHandleType(PrintWriter printWriter, String string) {
        String string2 = this.mangleClassName(string);
        if (!this.doneHandleTypes.containsKey(string2)) {
            this.doneHandleTypes.put(string2, string2);
            if (printWriter != null) {
                printWriter.println("#ifndef DEFINED_" + string2);
                printWriter.println("    #define DEFINED_" + string2);
                printWriter.println("    GEN_HANDLE_TYPES(" + string2 + ");");
                printWriter.println("#endif" + this.lineSep);
            }
        }
    }

    protected String mangleClassName(String string) {
        return string.replace('.', '_').replace(this.pathChar, '_').replace('$', '_');
    }

    protected void forwardDecls(PrintWriter printWriter, ClassDoc classDoc) throws ClassNotFoundException {
        Type type;
        String string;
        TypeSignature typeSignature;
        String string2;
        MemberDoc memberDoc;
        int n;
        Object var3_3 = null;
        if (classDoc.qualifiedName().equals("java.lang.Object")) {
            return;
        }
        this.genHandleType(printWriter, classDoc.qualifiedName());
        ClassDoc classDoc2 = classDoc.superclass();
        if (classDoc2 != null) {
            String string3 = classDoc2.qualifiedName();
            this.forwardDecls(printWriter, classDoc2);
        }
        for (n = 0; n < this.fields.length; ++n) {
            memberDoc = (FieldDoc)this.fields[n];
            if (memberDoc.isStatic() || (string2 = (typeSignature = new TypeSignature(this.root)).getTypeSignature(string = (type = memberDoc.type()).qualifiedTypeName())).charAt(0) == '[') continue;
            this.forwardDeclsFromSig(printWriter, string2);
        }
        for (n = 0; n < this.methods.length; ++n) {
            memberDoc = (MethodDoc)this.methods[n];
            if (!memberDoc.isNative()) continue;
            type = memberDoc.returnType();
            typeSignature = new TypeSignature(this.root);
            string = memberDoc.signature();
            string2 = typeSignature.getTypeSignature(string, type);
            if (string2.charAt(0) == '[') continue;
            this.forwardDeclsFromSig(printWriter, string2);
        }
    }

    protected void forwardDeclsFromSig(PrintWriter printWriter, String string) {
        int n;
        int n2 = string.length();
        int n3 = n = string.charAt(0) == '(' ? 1 : 0;
        while (n < n2) {
            if (string.charAt(n) == 'L') {
                int n4 = n + 1;
                while (string.charAt(n4) != ';') {
                    ++n4;
                }
                this.genHandleType(printWriter, string.substring(n + 1, n4));
                n = n4 + 1;
                continue;
            }
            ++n;
        }
    }

    protected void structSectionForClass(PrintWriter printWriter, ClassDoc classDoc, String string) throws ClassNotFoundException {
        String string2 = classDoc.qualifiedName();
        if (string.equals("java_lang_Object")) {
            printWriter.println("/* struct java_lang_Object is defined in typedefs.h. */");
            printWriter.println();
            return;
        }
        printWriter.println("#if !defined(__i386)");
        printWriter.println("#pragma pack(4)");
        printWriter.println("#endif");
        printWriter.println();
        printWriter.println("struct " + string + " {");
        printWriter.println("    ObjHeader h;");
        printWriter.print(this.fieldDefs(classDoc, string));
        if (string2.equals("java.lang.Class")) {
            printWriter.println("    Class *LLNI_mask(cClass);  /* Fake field; don't access (see oobj.h) */");
        }
        printWriter.println("};" + this.lineSep + this.lineSep + "#pragma pack()");
        printWriter.println();
    }

    private boolean doField(FieldDefsRes fieldDefsRes, FieldDoc fieldDoc, String string, boolean bl) throws ClassNotFoundException {
        String string2 = this.addStructMember(fieldDoc, string, bl);
        if (string2 != null) {
            if (!fieldDefsRes.printedOne) {
                if (fieldDefsRes.bottomMost) {
                    if (fieldDefsRes.s.length() != 0) {
                        fieldDefsRes.s = fieldDefsRes.s + "    /* local members: */" + this.lineSep;
                    }
                } else {
                    fieldDefsRes.s = fieldDefsRes.s + "    /* inherited members from " + fieldDefsRes.className + ": */" + this.lineSep;
                }
                fieldDefsRes.printedOne = true;
            }
            fieldDefsRes.s = fieldDefsRes.s + string2;
            return true;
        }
        return false;
    }

    private int doTwoWordFields(FieldDefsRes fieldDefsRes, ClassDoc classDoc, int n, String string, boolean bl) throws ClassNotFoundException {
        boolean bl2 = true;
        FieldDoc[] fieldDocArray = classDoc.fields();
        for (int i = 0; i < fieldDocArray.length; ++i) {
            boolean bl3;
            FieldDoc fieldDoc = fieldDocArray[i];
            String string2 = fieldDoc.type().typeName();
            boolean bl4 = bl3 = string2.equals("long") || string2.equals("double");
            if (!bl3 || !this.doField(fieldDefsRes, fieldDoc, string, bl2 && bl)) continue;
            n += 8;
            bl2 = false;
        }
        return n;
    }

    protected String fieldDefs(ClassDoc classDoc, String string) throws ClassNotFoundException {
        FieldDefsRes fieldDefsRes = this.fieldDefs(classDoc, string, true);
        return fieldDefsRes.s;
    }

    protected FieldDefsRes fieldDefs(ClassDoc classDoc, String string, boolean bl) throws ClassNotFoundException {
        int n;
        FieldDefsRes fieldDefsRes;
        FieldDoc[] fieldDocArray;
        boolean bl2 = false;
        ClassDoc classDoc2 = classDoc.superclass();
        if (classDoc2 != null) {
            fieldDocArray = classDoc2.qualifiedName();
            fieldDefsRes = new FieldDefsRes(classDoc, this.fieldDefs(classDoc2, string, false), bl);
            n = fieldDefsRes.parent.byteSize;
        } else {
            fieldDefsRes = new FieldDefsRes(classDoc, null, bl);
            n = 0;
        }
        fieldDocArray = classDoc.fields();
        for (int i = 0; i < fieldDocArray.length; ++i) {
            String string2;
            boolean bl3;
            FieldDoc fieldDoc = fieldDocArray[i];
            if (this.doubleAlign && !bl2 && n % 8 == 0) {
                n = this.doTwoWordFields(fieldDefsRes, classDoc, n, string, false);
                bl2 = true;
            }
            boolean bl4 = bl3 = (string2 = fieldDoc.type().typeName()).equals("long") || string2.equals("double");
            if (this.doubleAlign && bl3 || !this.doField(fieldDefsRes, fieldDoc, string, false)) continue;
            n += 4;
        }
        if (this.doubleAlign && !bl2) {
            if (n % 8 != 0) {
                n += 4;
            }
            n = this.doTwoWordFields(fieldDefsRes, classDoc, n, string, true);
        }
        fieldDefsRes.byteSize = n;
        return fieldDefsRes;
    }

    protected String addStructMember(FieldDoc fieldDoc, String string, boolean bl) throws ClassNotFoundException {
        String string2 = null;
        if (fieldDoc.isStatic()) {
            string2 = this.addStaticStructMember(fieldDoc, string);
        } else {
            if (bl) {
                string2 = "    java_int padWord" + this.padFieldNum++ + ";" + this.lineSep;
            }
            string2 = "    " + this.llniType(fieldDoc.type(), false, false) + " " + this.llniFieldName(fieldDoc);
            if (this.isLongOrDouble(fieldDoc.type())) {
                string2 = string2 + "[2]";
            }
            string2 = string2 + ";" + this.lineSep;
        }
        return string2;
    }

    protected String addStaticStructMember(FieldDoc fieldDoc, String string) throws ClassNotFoundException {
        String string2 = null;
        Object object = null;
        if (!fieldDoc.isStatic()) {
            return string2;
        }
        if (!fieldDoc.isFinal()) {
            return string2;
        }
        object = fieldDoc.constantValue();
        if (object != null) {
            String string3 = string + "_" + fieldDoc.name();
            String string4 = null;
            long l = 0L;
            if (object instanceof Integer) {
                string4 = "L";
                l = ((Integer)object).intValue();
            }
            if (object instanceof Long) {
                string4 = isWindows ? "i64" : "LL";
                l = (Long)object;
            }
            if (object instanceof Float) {
                string4 = "f";
            }
            if (object instanceof Double) {
                string4 = "";
            }
            if (string4 != null) {
                string2 = string4.equals("L") && l == Integer.MIN_VALUE || string4.equals("LL") && l == Long.MIN_VALUE ? "    #undef  " + string3 + this.lineSep + "    #define " + string3 + " (" + (l + 1L) + string4 + "-1)" + this.lineSep : "    #undef  " + string3 + this.lineSep + "    #define " + string3 + " " + object.toString() + string4 + this.lineSep;
            }
        }
        return string2;
    }

    protected void methodSectionForClass(PrintWriter printWriter, ClassDoc classDoc, String string) throws ClassNotFoundException {
        String string2 = this.methodDecls(classDoc, string);
        if (string2.length() != 0) {
            printWriter.println("/* Native method declarations: */" + this.lineSep);
            printWriter.println("#ifdef __cplusplus");
            printWriter.println("extern \"C\" {");
            printWriter.println("#endif" + this.lineSep);
            printWriter.println(string2);
            printWriter.println("#ifdef __cplusplus");
            printWriter.println("}");
            printWriter.println("#endif");
        }
    }

    protected String methodDecls(ClassDoc classDoc, String string) throws ClassNotFoundException {
        String string2 = "";
        for (int i = 0; i < this.methods.length; ++i) {
            MethodDoc methodDoc = (MethodDoc)this.methods[i];
            if (!methodDoc.isNative()) continue;
            string2 = string2 + this.methodDecl(methodDoc, classDoc, string);
        }
        return string2;
    }

    protected String methodDecl(MethodDoc methodDoc, ClassDoc classDoc, String string) throws ClassNotFoundException {
        int n;
        String string2 = null;
        Type type = methodDoc.returnType();
        String string3 = methodDoc.signature();
        TypeSignature typeSignature = new TypeSignature(this.root);
        String string4 = typeSignature.getTypeSignature(string3, type);
        boolean bl = this.needLongName(methodDoc, classDoc);
        if (string4.charAt(0) != '(') {
            Util.error("invalid.method.signature", string4);
        }
        string2 = "JNIEXPORT " + this.jniType(type) + " JNICALL" + this.lineSep + this.jniMethodName(methodDoc, string, bl) + "(JNIEnv *, " + this.cRcvrDecl(methodDoc, string);
        Parameter[] parameterArray = methodDoc.parameters();
        Type[] typeArray = new Type[parameterArray.length];
        for (n = 0; n < parameterArray.length; ++n) {
            typeArray[n] = parameterArray[n].type();
        }
        for (n = 0; n < typeArray.length; ++n) {
            string2 = string2 + ", " + this.jniType(typeArray[n]);
        }
        string2 = string2 + ");" + this.lineSep;
        return string2;
    }

    protected final boolean needLongName(MethodDoc methodDoc, ClassDoc classDoc) throws ClassNotFoundException {
        String string = methodDoc.name();
        for (int i = 0; i < this.methods.length; ++i) {
            MethodDoc methodDoc2 = (MethodDoc)this.methods[i];
            if (methodDoc2 == methodDoc || !methodDoc2.isNative() || string != methodDoc2.name()) continue;
            return true;
        }
        return false;
    }

    protected final String jniMethodName(MethodDoc methodDoc, String string, boolean bl) {
        String string2 = "Java_" + string + "_" + methodDoc.name();
        if (bl) {
            int n;
            Type type = methodDoc.returnType();
            Parameter[] parameterArray = methodDoc.parameters();
            Type[] typeArray = new Type[parameterArray.length];
            for (n = 0; n < parameterArray.length; ++n) {
                typeArray[n] = parameterArray[n].type();
            }
            string2 = string2 + "__";
            for (n = 0; n < typeArray.length; ++n) {
                Type type2 = typeArray[n];
                String string3 = type2.typeName();
                TypeSignature typeSignature = new TypeSignature(this.root);
                String string4 = typeSignature.getTypeSignature(string3);
                string2 = string2 + this.nameToIdentifier(string4);
            }
        }
        return string2;
    }

    protected final String jniType(Type type) {
        String string = type.typeName();
        if (type.dimension().indexOf("[]") != -1) {
            if (string.equals("boolean")) {
                return "jbooleanArray";
            }
            if (string.equals("byte")) {
                return "jbyteArray";
            }
            if (string.equals("char")) {
                return "jcharArray";
            }
            if (string.equals("short")) {
                return "jshortArray";
            }
            if (string.equals("int")) {
                return "jintArray";
            }
            if (string.equals("long")) {
                return "jlongArray";
            }
            if (string.equals("float")) {
                return "jfloatArray";
            }
            if (string.equals("double")) {
                return "jdoubleArray";
            }
            if (type.dimension().indexOf("[][]") != -1 || type.asClassDoc() != null) {
                return "jobjectArray";
            }
        } else {
            if (string.equals("void")) {
                return "void";
            }
            if (string.equals("boolean")) {
                return "jboolean";
            }
            if (string.equals("byte")) {
                return "jbyte";
            }
            if (string.equals("char")) {
                return "jchar";
            }
            if (string.equals("short")) {
                return "jshort";
            }
            if (string.equals("int")) {
                return "jint";
            }
            if (string.equals("long")) {
                return "jlong";
            }
            if (string.equals("float")) {
                return "jfloat";
            }
            if (string.equals("double")) {
                return "jdouble";
            }
            if (type.asClassDoc() != null) {
                if (string.equals("String")) {
                    return "jstring";
                }
                if (type.asClassDoc().subclassOf(this.root.classNamed("java.lang.Class"))) {
                    return "jclass";
                }
                return "jobject";
            }
        }
        Util.bug("jni.unknown.type");
        return null;
    }

    protected String llniType(Type type, boolean bl, boolean bl2) {
        String string = null;
        String string2 = type.typeName();
        if (type.dimension().indexOf("[]") != -1) {
            if (type.dimension().indexOf("[][]") != -1 || type.asClassDoc() != null) {
                string = "IArrayOfRef";
            } else if (string2.equals("boolean")) {
                string = "IArrayOfBoolean";
            } else if (string2.equals("byte")) {
                string = "IArrayOfByte";
            } else if (string2.equals("char")) {
                string = "IArrayOfChar";
            } else if (string2.equals("int")) {
                string = "IArrayOfInt";
            } else if (string2.equals("long")) {
                string = "IArrayOfLong";
            } else if (string2.equals("float")) {
                string = "IArrayOfFloat";
            } else if (string2.equals("double")) {
                string = "IArrayOfDouble";
            }
            if (!bl) {
                string = "DEREFERENCED_" + string;
            }
        } else if (string2.equals("void")) {
            string = "void";
        } else if (string2.equals("boolean") || string2.equals("byte") || string2.equals("char") || string2.equals("short") || string2.equals("int")) {
            string = "java_int";
        } else if (string2.equals("long")) {
            string = bl2 ? "java_long" : "val32 /* java_long */";
        } else if (string2.equals("float")) {
            string = "java_float";
        } else if (string2.equals("double")) {
            string = bl2 ? "java_double" : "val32 /* java_double */";
            string = string;
        } else if (type.asClassDoc() != null) {
            string = "I" + this.mangleClassName(type.asClassDoc().qualifiedName());
            if (!bl) {
                string = "DEREFERENCED_" + string;
            }
        }
        return string;
    }

    protected final String cRcvrDecl(MemberDoc memberDoc, String string) {
        return memberDoc.isStatic() ? "jclass" : "jobject";
    }

    protected String maskName(String string) {
        return "LLNI_mask(" + string + ")";
    }

    protected String llniFieldName(MemberDoc memberDoc) {
        return this.maskName(memberDoc.name());
    }

    protected final boolean isLongOrDouble(Type type) {
        String string = type.typeName();
        return string.equals("long") || string.equals("double");
    }

    protected final String nameToIdentifier(String string) {
        int n = string.length();
        StringBuffer stringBuffer = new StringBuffer(n);
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (this.isASCIILetterOrDigit(c)) {
                stringBuffer.append(c);
                continue;
            }
            if (c == '/') {
                stringBuffer.append('_');
                continue;
            }
            if (c == '.') {
                stringBuffer.append('_');
                continue;
            }
            if (c == '_') {
                stringBuffer.append("_1");
                continue;
            }
            if (c == ';') {
                stringBuffer.append("_2");
                continue;
            }
            if (c == '[') {
                stringBuffer.append("_3");
                continue;
            }
            stringBuffer.append("_0" + c);
        }
        return new String(stringBuffer);
    }

    protected final boolean isASCIILetterOrDigit(char c) {
        return c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c >= '0' && c <= '9';
    }

    private static class FieldDefsRes {
        public String className;
        public FieldDefsRes parent;
        public String s;
        public int byteSize;
        public boolean bottomMost;
        public boolean printedOne = false;

        FieldDefsRes(ClassDoc classDoc, FieldDefsRes fieldDefsRes, boolean bl) {
            this.className = classDoc.qualifiedName();
            this.parent = fieldDefsRes;
            this.bottomMost = bl;
            boolean bl2 = false;
            this.s = fieldDefsRes == null ? "" : fieldDefsRes.s;
        }
    }
}

