/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.internal.xjc;

import com.sun.codemodel.internal.JCodeModel;
import com.sun.tools.internal.xjc.ErrorReceiver;
import com.sun.tools.internal.xjc.Language;
import com.sun.tools.internal.xjc.Messages;
import com.sun.tools.internal.xjc.Options;
import com.sun.tools.internal.xjc.model.Model;
import com.sun.tools.internal.xjc.reader.ExtensionBindingChecker;
import com.sun.tools.internal.xjc.reader.dtd.TDTDReader;
import com.sun.tools.internal.xjc.reader.internalizer.DOMForest;
import com.sun.tools.internal.xjc.reader.internalizer.DOMForestScanner;
import com.sun.tools.internal.xjc.reader.internalizer.InternalizationLogic;
import com.sun.tools.internal.xjc.reader.internalizer.VersionChecker;
import com.sun.tools.internal.xjc.reader.relaxng.RELAXNGCompiler;
import com.sun.tools.internal.xjc.reader.relaxng.RELAXNGInternalizationLogic;
import com.sun.tools.internal.xjc.reader.xmlschema.BGMBuilder;
import com.sun.tools.internal.xjc.reader.xmlschema.bindinfo.AnnotationParserFactoryImpl;
import com.sun.tools.internal.xjc.reader.xmlschema.parser.CustomizationContextChecker;
import com.sun.tools.internal.xjc.reader.xmlschema.parser.IncorrectNamespaceURIChecker;
import com.sun.tools.internal.xjc.reader.xmlschema.parser.SchemaConstraintChecker;
import com.sun.tools.internal.xjc.reader.xmlschema.parser.XMLSchemaInternalizationLogic;
import com.sun.tools.internal.xjc.util.ErrorReceiverFilter;
import com.sun.xml.internal.rngom.ast.builder.SchemaBuilder;
import com.sun.xml.internal.rngom.ast.util.CheckingSchemaBuilder;
import com.sun.xml.internal.rngom.digested.DPattern;
import com.sun.xml.internal.rngom.digested.DSchemaBuilderImpl;
import com.sun.xml.internal.rngom.parse.IllegalSchemaException;
import com.sun.xml.internal.rngom.parse.Parseable;
import com.sun.xml.internal.rngom.parse.compact.CompactParseable;
import com.sun.xml.internal.rngom.parse.xml.SAXParseable;
import com.sun.xml.internal.rngom.xml.sax.XMLReaderCreator;
import com.sun.xml.internal.xsom.XSSchemaSet;
import com.sun.xml.internal.xsom.parser.JAXPParser;
import com.sun.xml.internal.xsom.parser.XMLParser;
import com.sun.xml.internal.xsom.parser.XSOMParser;
import java.io.IOException;
import java.io.StringReader;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLFilterImpl;

public final class ModelLoader {
    private final Options opt;
    private final ErrorReceiverFilter errorReceiver;
    private final JCodeModel codeModel;

    public static Model load(Options options, JCodeModel jCodeModel, ErrorReceiver errorReceiver) {
        return new ModelLoader(options, jCodeModel, errorReceiver).load();
    }

    public ModelLoader(Options options, JCodeModel jCodeModel, ErrorReceiver errorReceiver) {
        this.opt = options;
        this.codeModel = jCodeModel;
        this.errorReceiver = new ErrorReceiverFilter(errorReceiver);
    }

    private Model load() {
        if (!this.sanityCheck()) {
            return null;
        }
        try {
            Model model;
            switch (this.opt.getSchemaLanguage()) {
                case DTD: {
                    InputSource inputSource = null;
                    if (this.opt.getBindFiles().length > 0) {
                        inputSource = this.opt.getBindFiles()[0];
                    }
                    if (inputSource == null) {
                        inputSource = new InputSource(new StringReader("<?xml version='1.0'?><xml-java-binding-schema><options package='" + (this.opt.defaultPackage == null ? "generated" : this.opt.defaultPackage) + "'/></xml-java-binding-schema>"));
                    }
                    this.checkTooManySchemaErrors();
                    model = this.loadDTD(this.opt.getGrammars()[0], inputSource);
                    break;
                }
                case RELAXNG: {
                    this.checkTooManySchemaErrors();
                    model = this.loadRELAXNG();
                    break;
                }
                case RELAXNG_COMPACT: {
                    this.checkTooManySchemaErrors();
                    model = this.loadRELAXNGCompact();
                    break;
                }
                case WSDL: {
                    model = this.annotateXMLSchema(this.loadWSDL());
                    break;
                }
                case XMLSCHEMA: {
                    model = this.annotateXMLSchema(this.loadXMLSchema());
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
            if (this.errorReceiver.hadError()) {
                model = null;
            } else {
                model.setPackageLevelAnnotations(this.opt.packageLevelAnnotations);
            }
            return model;
        }
        catch (SAXException sAXException) {
            if (this.opt.verbose) {
                if (sAXException.getException() != null) {
                    sAXException.getException().printStackTrace();
                } else {
                    sAXException.printStackTrace();
                }
            }
            return null;
        }
    }

    private boolean sanityCheck() {
        if (this.opt.getSchemaLanguage() == Language.XMLSCHEMA) {
            Language language = this.opt.guessSchemaLanguage();
            String[] stringArray = null;
            switch (language) {
                case DTD: {
                    stringArray = new String[]{"DTD", "-dtd"};
                    break;
                }
                case RELAXNG: {
                    stringArray = new String[]{"RELAX NG", "-relaxng"};
                    break;
                }
                case RELAXNG_COMPACT: {
                    stringArray = new String[]{"RELAX NG compact syntax", "-relaxng-compact"};
                    break;
                }
                case WSDL: {
                    stringArray = new String[]{"WSDL", "-wsdl"};
                }
            }
            if (stringArray != null) {
                this.errorReceiver.warning(null, Messages.format("Driver.ExperimentalLanguageWarning", stringArray[0], stringArray[1]));
            }
        }
        return true;
    }

    private void checkTooManySchemaErrors() {
        if (this.opt.getGrammars().length != 1) {
            this.errorReceiver.error(null, Messages.format("ModelLoader.TooManySchema", new Object[0]));
        }
    }

    private Model loadDTD(InputSource inputSource, InputSource inputSource2) {
        return TDTDReader.parse(inputSource, inputSource2, this.errorReceiver, this.opt);
    }

    public DOMForest buildDOMForest(InternalizationLogic internalizationLogic) throws SAXException {
        DOMForest dOMForest = new DOMForest(internalizationLogic);
        dOMForest.setErrorHandler(this.errorReceiver);
        if (this.opt.entityResolver != null) {
            dOMForest.setEntityResolver(this.opt.entityResolver);
        }
        for (InputSource inputSource : this.opt.getGrammars()) {
            dOMForest.parse(inputSource, true);
        }
        for (InputSource inputSource : this.opt.getBindFiles()) {
            Element element;
            Document document = dOMForest.parse(inputSource, true);
            if (document == null || this.fixNull((element = document.getDocumentElement()).getNamespaceURI()).equals("http://java.sun.com/xml/ns/jaxb") && element.getLocalName().equals("bindings")) continue;
            this.errorReceiver.error(new SAXParseException(Messages.format("Driver.NotABindingFile", element.getNamespaceURI(), element.getLocalName()), null, inputSource.getSystemId(), -1, -1));
        }
        dOMForest.transform();
        return dOMForest;
    }

    private String fixNull(String string) {
        if (string == null) {
            return "";
        }
        return string;
    }

    public XSSchemaSet loadXMLSchema() throws SAXException {
        if (this.opt.strictCheck && !SchemaConstraintChecker.check(this.opt.getGrammars(), this.errorReceiver, this.opt.entityResolver)) {
            return null;
        }
        if (this.opt.getBindFiles().length == 0) {
            try {
                return this.createXSOMSpeculative();
            }
            catch (SpeculationFailure speculationFailure) {
                // empty catch block
            }
        }
        DOMForest dOMForest = this.buildDOMForest(new XMLSchemaInternalizationLogic());
        return this.createXSOM(dOMForest);
    }

    private XSSchemaSet loadWSDL() throws SAXException {
        DOMForest dOMForest = this.buildDOMForest(new XMLSchemaInternalizationLogic());
        DOMForestScanner dOMForestScanner = new DOMForestScanner(dOMForest);
        XSOMParser xSOMParser = this.createXSOMParser(dOMForest);
        for (InputSource inputSource : this.opt.getGrammars()) {
            Document document = dOMForest.get(inputSource.getSystemId());
            NodeList nodeList = document.getElementsByTagNameNS("http://www.w3.org/2001/XMLSchema", "schema");
            for (int i = 0; i < nodeList.getLength(); ++i) {
                dOMForestScanner.scan((Element)nodeList.item(i), xSOMParser.getParserHandler());
            }
        }
        return xSOMParser.getResult();
    }

    public Model annotateXMLSchema(XSSchemaSet xSSchemaSet) {
        if (xSSchemaSet == null) {
            return null;
        }
        return BGMBuilder.build(xSSchemaSet, this.codeModel, this.errorReceiver, this.opt);
    }

    public XSOMParser createXSOMParser(XMLParser xMLParser) {
        XSOMParser xSOMParser = new XSOMParser(new XMLSchemaParser(xMLParser));
        xSOMParser.setAnnotationParser(new AnnotationParserFactoryImpl(this.opt));
        xSOMParser.setErrorHandler(this.errorReceiver);
        xSOMParser.setEntityResolver(this.opt.entityResolver);
        return xSOMParser;
    }

    public XSOMParser createXSOMParser(final DOMForest dOMForest) {
        XSOMParser xSOMParser = this.createXSOMParser(dOMForest.createParser());
        xSOMParser.setEntityResolver(new EntityResolver(){

            public InputSource resolveEntity(String string, String string2) throws SAXException, IOException {
                if (string2 != null && dOMForest.get(string2) != null) {
                    return new InputSource(string2);
                }
                if (((ModelLoader)ModelLoader.this).opt.entityResolver != null) {
                    return ((ModelLoader)ModelLoader.this).opt.entityResolver.resolveEntity(string, string2);
                }
                return null;
            }
        });
        return xSOMParser;
    }

    private XSSchemaSet createXSOMSpeculative() throws SAXException, SpeculationFailure {
        XMLParser xMLParser = new XMLParser(){
            private final JAXPParser base = new JAXPParser();

            public void parse(InputSource inputSource, ContentHandler contentHandler, ErrorHandler errorHandler, EntityResolver entityResolver) throws SAXException, IOException {
                contentHandler = this.wrapBy(new SpeculationChecker(), contentHandler);
                contentHandler = this.wrapBy(new VersionChecker(null, ModelLoader.this.errorReceiver, entityResolver), contentHandler);
                this.base.parse(inputSource, contentHandler, errorHandler, entityResolver);
            }

            private ContentHandler wrapBy(XMLFilterImpl xMLFilterImpl, ContentHandler contentHandler) {
                xMLFilterImpl.setContentHandler(contentHandler);
                return xMLFilterImpl;
            }
        };
        XSOMParser xSOMParser = this.createXSOMParser(xMLParser);
        for (InputSource inputSource : this.opt.getGrammars()) {
            xSOMParser.parse(inputSource);
        }
        return xSOMParser.getResult();
    }

    public XSSchemaSet createXSOM(DOMForest dOMForest) throws SAXException {
        XSOMParser xSOMParser = this.createXSOMParser(dOMForest);
        for (String string : dOMForest.getRootDocuments()) {
            Document document = dOMForest.get(string);
            if (document.getDocumentElement().getNamespaceURI().equals("http://java.sun.com/xml/ns/jaxb")) continue;
            xSOMParser.parse(string);
        }
        return xSOMParser.getResult();
    }

    private Model loadRELAXNG() throws SAXException {
        final DOMForest dOMForest = this.buildDOMForest(new RELAXNGInternalizationLogic());
        XMLReaderCreator xMLReaderCreator = new XMLReaderCreator(){

            public XMLReader createXMLReader() {
                XMLFilterImpl xMLFilterImpl = new XMLFilterImpl(){

                    public void parse(InputSource inputSource) throws IOException, SAXException {
                        dOMForest.createParser().parse(inputSource, this, this, this);
                    }
                };
                ExtensionBindingChecker extensionBindingChecker = new ExtensionBindingChecker("http://relaxng.org/ns/structure/1.0", ModelLoader.this.opt, ModelLoader.this.errorReceiver);
                extensionBindingChecker.setParent(xMLFilterImpl);
                extensionBindingChecker.setEntityResolver(((ModelLoader)ModelLoader.this).opt.entityResolver);
                return extensionBindingChecker;
            }
        };
        SAXParseable sAXParseable = new SAXParseable(this.opt.getGrammars()[0], this.errorReceiver, xMLReaderCreator);
        return this.loadRELAXNG(sAXParseable);
    }

    private Model loadRELAXNGCompact() {
        if (this.opt.getBindFiles().length > 0) {
            this.errorReceiver.error(new SAXParseException(Messages.format("ModelLoader.BindingFileNotSupportedForRNC", new Object[0]), null));
        }
        CompactParseable compactParseable = new CompactParseable(this.opt.getGrammars()[0], this.errorReceiver);
        return this.loadRELAXNG(compactParseable);
    }

    private Model loadRELAXNG(Parseable parseable) {
        CheckingSchemaBuilder checkingSchemaBuilder = new CheckingSchemaBuilder((SchemaBuilder)new DSchemaBuilderImpl(), this.errorReceiver);
        try {
            DPattern dPattern = (DPattern)parseable.parse(checkingSchemaBuilder);
            return RELAXNGCompiler.build(dPattern, this.codeModel, this.opt);
        }
        catch (IllegalSchemaException illegalSchemaException) {
            this.errorReceiver.error(illegalSchemaException.getMessage(), illegalSchemaException);
            return null;
        }
    }

    private static final class SpeculationChecker
    extends XMLFilterImpl {
        private SpeculationChecker() {
        }

        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            if (string2.equals("bindings") && string.equals("http://java.sun.com/xml/ns/jaxb")) {
                throw new SpeculationFailure();
            }
            super.startElement(string, string2, string3, attributes);
        }
    }

    private static final class SpeculationFailure
    extends Error {
        private SpeculationFailure() {
        }
    }

    private class XMLSchemaParser
    implements XMLParser {
        private final XMLParser baseParser;

        private XMLSchemaParser(XMLParser xMLParser) {
            this.baseParser = xMLParser;
        }

        public void parse(InputSource inputSource, ContentHandler contentHandler, ErrorHandler errorHandler, EntityResolver entityResolver) throws SAXException, IOException {
            contentHandler = this.wrapBy(new ExtensionBindingChecker("http://www.w3.org/2001/XMLSchema", ModelLoader.this.opt, ModelLoader.this.errorReceiver), contentHandler);
            contentHandler = this.wrapBy(new IncorrectNamespaceURIChecker(ModelLoader.this.errorReceiver), contentHandler);
            contentHandler = this.wrapBy(new CustomizationContextChecker(ModelLoader.this.errorReceiver), contentHandler);
            this.baseParser.parse(inputSource, contentHandler, errorHandler, entityResolver);
        }

        private ContentHandler wrapBy(XMLFilterImpl xMLFilterImpl, ContentHandler contentHandler) {
            xMLFilterImpl.setContentHandler(contentHandler);
            return xMLFilterImpl;
        }
    }
}

