/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.internal.ws.wsdl.parser;

import com.sun.tools.internal.ws.wsdl.document.Binding;
import com.sun.tools.internal.ws.wsdl.document.BindingFault;
import com.sun.tools.internal.ws.wsdl.document.BindingInput;
import com.sun.tools.internal.ws.wsdl.document.BindingOperation;
import com.sun.tools.internal.ws.wsdl.document.BindingOutput;
import com.sun.tools.internal.ws.wsdl.document.Definitions;
import com.sun.tools.internal.ws.wsdl.document.Documentation;
import com.sun.tools.internal.ws.wsdl.document.Fault;
import com.sun.tools.internal.ws.wsdl.document.Import;
import com.sun.tools.internal.ws.wsdl.document.Input;
import com.sun.tools.internal.ws.wsdl.document.Message;
import com.sun.tools.internal.ws.wsdl.document.MessagePart;
import com.sun.tools.internal.ws.wsdl.document.Operation;
import com.sun.tools.internal.ws.wsdl.document.Output;
import com.sun.tools.internal.ws.wsdl.document.Port;
import com.sun.tools.internal.ws.wsdl.document.PortType;
import com.sun.tools.internal.ws.wsdl.document.Service;
import com.sun.tools.internal.ws.wsdl.document.Types;
import com.sun.tools.internal.ws.wsdl.document.WSDLConstants;
import com.sun.tools.internal.ws.wsdl.document.WSDLDocument;
import com.sun.tools.internal.ws.wsdl.document.WSDLDocumentVisitor;
import com.sun.tools.internal.ws.wsdl.document.schema.SchemaKinds;
import com.sun.tools.internal.ws.wsdl.framework.Extension;
import com.sun.tools.internal.ws.wsdl.framework.Kind;
import com.sun.tools.internal.ws.wsdl.framework.WriterContext;
import com.sun.tools.internal.ws.wsdl.parser.ExtensionHandler;
import com.sun.tools.internal.ws.wsdl.parser.HTTPExtensionHandler;
import com.sun.tools.internal.ws.wsdl.parser.JAXWSBindingExtensionHandler;
import com.sun.tools.internal.ws.wsdl.parser.MIMEExtensionHandler;
import com.sun.tools.internal.ws.wsdl.parser.SOAPExtensionHandler;
import com.sun.tools.internal.ws.wsdl.parser.SchemaExtensionHandler;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;

public class WSDLWriter {
    private Map _extensionHandlers = new HashMap();
    private static Map<String, String> _commonPrefixes = new HashMap<String, String>();
    private static final String TARGET_NAMESPACE_PREFIX = "tns";
    private static final String NEW_NAMESPACE_PREFIX_BASE = "ns";

    public WSDLWriter() throws IOException {
        this.register(new SOAPExtensionHandler());
        this.register(new HTTPExtensionHandler());
        this.register(new MIMEExtensionHandler());
        this.register(new SchemaExtensionHandler());
        this.register(new JAXWSBindingExtensionHandler());
    }

    public void register(ExtensionHandler extensionHandler) {
        this._extensionHandlers.put(extensionHandler.getNamespaceURI(), extensionHandler);
        extensionHandler.setExtensionHandlers(this._extensionHandlers);
    }

    public void unregister(ExtensionHandler extensionHandler) {
        this._extensionHandlers.put(extensionHandler.getNamespaceURI(), null);
        extensionHandler.setExtensionHandlers(null);
    }

    public void unregister(String string) {
        this._extensionHandlers.put(string, null);
    }

    public void write(final WSDLDocument wSDLDocument, OutputStream outputStream) throws IOException {
        final WriterContext writerContext = new WriterContext(outputStream);
        try {
            wSDLDocument.accept(new WSDLDocumentVisitor(){

                public void preVisit(Definitions definitions) throws Exception {
                    writerContext.push();
                    WSDLWriter.this.initializePrefixes(writerContext, wSDLDocument);
                    writerContext.writeStartTag(definitions.getElementName());
                    writerContext.writeAttribute("name", definitions.getName());
                    writerContext.writeAttribute("targetNamespace", definitions.getTargetNamespaceURI());
                    writerContext.writeAllPendingNamespaceDeclarations();
                }

                public void postVisit(Definitions definitions) throws Exception {
                    writerContext.writeEndTag(definitions.getElementName());
                    writerContext.pop();
                }

                public void visit(Import import_) throws Exception {
                    writerContext.writeStartTag(import_.getElementName());
                    writerContext.writeAttribute("namespace", import_.getNamespace());
                    writerContext.writeAttribute("location", import_.getLocation());
                    writerContext.writeEndTag(import_.getElementName());
                }

                public void preVisit(Types types) throws Exception {
                    writerContext.writeStartTag(types.getElementName());
                }

                public void postVisit(Types types) throws Exception {
                    writerContext.writeEndTag(types.getElementName());
                }

                public void preVisit(Message message) throws Exception {
                    writerContext.writeStartTag(message.getElementName());
                    writerContext.writeAttribute("name", message.getName());
                }

                public void postVisit(Message message) throws Exception {
                    writerContext.writeEndTag(message.getElementName());
                }

                public void visit(MessagePart messagePart) throws Exception {
                    writerContext.writeStartTag(messagePart.getElementName());
                    writerContext.writeAttribute("name", messagePart.getName());
                    QName qName = messagePart.getDescriptor();
                    Kind kind = messagePart.getDescriptorKind();
                    if (qName != null && kind != null) {
                        if (kind.equals(SchemaKinds.XSD_ELEMENT)) {
                            writerContext.writeAttribute("element", qName);
                        } else if (kind.equals(SchemaKinds.XSD_TYPE)) {
                            writerContext.writeAttribute("type", qName);
                        }
                    }
                    writerContext.writeEndTag(messagePart.getElementName());
                }

                public void preVisit(PortType portType) throws Exception {
                    writerContext.writeStartTag(portType.getElementName());
                    writerContext.writeAttribute("name", portType.getName());
                }

                public void postVisit(PortType portType) throws Exception {
                    writerContext.writeEndTag(portType.getElementName());
                }

                public void preVisit(Operation operation) throws Exception {
                    writerContext.writeStartTag(operation.getElementName());
                    writerContext.writeAttribute("name", operation.getName());
                    if (operation.getParameterOrder() != null && operation.getParameterOrder().length() > 0) {
                        writerContext.writeAttribute("parameterOrder", operation.getParameterOrder());
                    }
                }

                public void postVisit(Operation operation) throws Exception {
                    writerContext.writeEndTag(operation.getElementName());
                }

                public void preVisit(Input input) throws Exception {
                    writerContext.writeStartTag(input.getElementName());
                    writerContext.writeAttribute("name", input.getName());
                    writerContext.writeAttribute("message", input.getMessage());
                }

                public void postVisit(Input input) throws Exception {
                    writerContext.writeEndTag(input.getElementName());
                }

                public void preVisit(Output output) throws Exception {
                    writerContext.writeStartTag(output.getElementName());
                    writerContext.writeAttribute("name", output.getName());
                    writerContext.writeAttribute("message", output.getMessage());
                }

                public void postVisit(Output output) throws Exception {
                    writerContext.writeEndTag(output.getElementName());
                }

                public void preVisit(Fault fault) throws Exception {
                    writerContext.writeStartTag(fault.getElementName());
                    writerContext.writeAttribute("name", fault.getName());
                    writerContext.writeAttribute("message", fault.getMessage());
                }

                public void postVisit(Fault fault) throws Exception {
                    writerContext.writeEndTag(fault.getElementName());
                }

                public void preVisit(Binding binding) throws Exception {
                    writerContext.writeStartTag(binding.getElementName());
                    writerContext.writeAttribute("name", binding.getName());
                    writerContext.writeAttribute("type", binding.getPortType());
                }

                public void postVisit(Binding binding) throws Exception {
                    writerContext.writeEndTag(binding.getElementName());
                }

                public void preVisit(BindingOperation bindingOperation) throws Exception {
                    writerContext.writeStartTag(bindingOperation.getElementName());
                    writerContext.writeAttribute("name", bindingOperation.getName());
                }

                public void postVisit(BindingOperation bindingOperation) throws Exception {
                    writerContext.writeEndTag(bindingOperation.getElementName());
                }

                public void preVisit(BindingInput bindingInput) throws Exception {
                    writerContext.writeStartTag(bindingInput.getElementName());
                    writerContext.writeAttribute("name", bindingInput.getName());
                }

                public void postVisit(BindingInput bindingInput) throws Exception {
                    writerContext.writeEndTag(bindingInput.getElementName());
                }

                public void preVisit(BindingOutput bindingOutput) throws Exception {
                    writerContext.writeStartTag(bindingOutput.getElementName());
                    writerContext.writeAttribute("name", bindingOutput.getName());
                }

                public void postVisit(BindingOutput bindingOutput) throws Exception {
                    writerContext.writeEndTag(bindingOutput.getElementName());
                }

                public void preVisit(BindingFault bindingFault) throws Exception {
                    writerContext.writeStartTag(bindingFault.getElementName());
                    writerContext.writeAttribute("name", bindingFault.getName());
                }

                public void postVisit(BindingFault bindingFault) throws Exception {
                    writerContext.writeEndTag(bindingFault.getElementName());
                }

                public void preVisit(Service service) throws Exception {
                    writerContext.writeStartTag(service.getElementName());
                    writerContext.writeAttribute("name", service.getName());
                }

                public void postVisit(Service service) throws Exception {
                    writerContext.writeEndTag(service.getElementName());
                }

                public void preVisit(Port port) throws Exception {
                    writerContext.writeStartTag(port.getElementName());
                    writerContext.writeAttribute("name", port.getName());
                    writerContext.writeAttribute("binding", port.getBinding());
                }

                public void postVisit(Port port) throws Exception {
                    writerContext.writeEndTag(port.getElementName());
                }

                public void preVisit(Extension extension) throws Exception {
                    ExtensionHandler extensionHandler = (ExtensionHandler)WSDLWriter.this._extensionHandlers.get(extension.getElementName().getNamespaceURI());
                    extensionHandler.doHandleExtension(writerContext, extension);
                }

                public void postVisit(Extension extension) throws Exception {
                }

                public void visit(Documentation documentation) throws Exception {
                    writerContext.writeTag(WSDLConstants.QNAME_DOCUMENTATION, null);
                }
            });
            writerContext.flush();
        }
        catch (Exception exception) {
            if (exception instanceof IOException) {
                throw (IOException)exception;
            }
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            throw new IllegalStateException();
        }
    }

    private void initializePrefixes(WriterContext writerContext, WSDLDocument wSDLDocument) throws IOException {
        String string = wSDLDocument.getDefinitions().getTargetNamespaceURI();
        if (string != null) {
            writerContext.setTargetNamespaceURI(string);
            writerContext.declarePrefix(TARGET_NAMESPACE_PREFIX, string);
        }
        writerContext.declarePrefix("", "http://schemas.xmlsoap.org/wsdl/");
        Set set = wSDLDocument.collectAllNamespaces();
        for (String string2 : set) {
            if (writerContext.getPrefixFor(string2) != null) continue;
            String string3 = _commonPrefixes.get(string2);
            if (string3 == null) {
                string3 = writerContext.findNewPrefix(NEW_NAMESPACE_PREFIX_BASE);
            }
            writerContext.declarePrefix(string3, string2);
        }
    }

    static {
        _commonPrefixes.put("http://schemas.xmlsoap.org/wsdl/", "wsdl");
        _commonPrefixes.put("http://schemas.xmlsoap.org/wsdl/soap/", "soap");
        _commonPrefixes.put("http://schemas.xmlsoap.org/wsdl/http/", "http");
        _commonPrefixes.put("http://schemas.xmlsoap.org/wsdl/mime/", "mime");
        _commonPrefixes.put("http://www.w3.org/2001/XMLSchema", "xsd");
        _commonPrefixes.put("http://www.w3.org/2001/XMLSchema-instance", "xsi");
        _commonPrefixes.put("http://java.sun.com/xml/ns/jaxws", "jaxws");
    }
}

