/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.hat.internal.server;

import com.sun.tools.hat.internal.model.Snapshot;
import com.sun.tools.hat.internal.oql.OQLEngine;
import com.sun.tools.hat.internal.server.HttpReader;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;

public class QueryListener
implements Runnable {
    private Snapshot snapshot;
    private OQLEngine engine;
    private int port;

    public QueryListener(int n) {
        this.port = n;
        this.snapshot = null;
        this.engine = null;
    }

    public void setModel(Snapshot snapshot) {
        this.snapshot = snapshot;
        if (OQLEngine.isOQLSupported()) {
            this.engine = new OQLEngine(snapshot);
        }
    }

    public void run() {
        try {
            this.waitForRequests();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            System.exit(1);
        }
    }

    private void waitForRequests() throws IOException {
        ServerSocket serverSocket = new ServerSocket(this.port);
        Thread thread = null;
        while (true) {
            Socket socket = serverSocket.accept();
            Thread thread2 = new Thread(new HttpReader(socket, this.snapshot, this.engine));
            if (this.snapshot == null) {
                thread2.setPriority(6);
            } else {
                thread2.setPriority(4);
                if (thread != null) {
                    try {
                        thread.setPriority(3);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            }
            thread2.start();
            thread = thread2;
        }
    }
}

