/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.doclets.internal.toolkit.util;

import com.sun.javadoc.AnnotationTypeDoc;
import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.Doc;
import com.sun.javadoc.MemberDoc;
import com.sun.javadoc.RootDoc;
import com.sun.tools.doclets.internal.toolkit.util.Util;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeprecatedAPIListBuilder {
    public static final int NUM_TYPES = 11;
    public static final int INTERFACE = 0;
    public static final int CLASS = 1;
    public static final int ENUM = 2;
    public static final int EXCEPTION = 3;
    public static final int ERROR = 4;
    public static final int ANNOTATION_TYPE = 5;
    public static final int FIELD = 6;
    public static final int METHOD = 7;
    public static final int CONSTRUCTOR = 8;
    public static final int ENUM_CONSTANT = 9;
    public static final int ANNOTATION_TYPE_MEMBER = 10;
    private List<List<Doc>> deprecatedLists = new ArrayList<List<Doc>>();

    public DeprecatedAPIListBuilder(RootDoc rootDoc) {
        for (int i = 0; i < 11; ++i) {
            this.deprecatedLists.add(i, new ArrayList());
        }
        this.buildDeprecatedAPIInfo(rootDoc);
    }

    private void buildDeprecatedAPIInfo(RootDoc rootDoc) {
        ClassDoc[] classDocArray = rootDoc.classes();
        for (int i = 0; i < classDocArray.length; ++i) {
            ClassDoc classDoc = classDocArray[i];
            if (Util.isDeprecated(classDoc)) {
                if (classDoc.isOrdinaryClass()) {
                    this.getList(1).add(classDoc);
                } else if (classDoc.isInterface()) {
                    this.getList(0).add(classDoc);
                } else if (classDoc.isException()) {
                    this.getList(3).add(classDoc);
                } else if (classDoc.isEnum()) {
                    this.getList(2).add(classDoc);
                } else if (classDoc.isError()) {
                    this.getList(4).add(classDoc);
                } else if (classDoc.isAnnotationType()) {
                    this.getList(5).add(classDoc);
                }
            }
            this.composeDeprecatedList(this.getList(6), classDoc.fields());
            this.composeDeprecatedList(this.getList(7), classDoc.methods());
            this.composeDeprecatedList(this.getList(8), classDoc.constructors());
            if (classDoc.isEnum()) {
                this.composeDeprecatedList(this.getList(9), classDoc.enumConstants());
            }
            if (!classDoc.isAnnotationType()) continue;
            this.composeDeprecatedList(this.getList(10), ((AnnotationTypeDoc)classDoc).elements());
        }
        this.sortDeprecatedLists();
    }

    private void composeDeprecatedList(List<Doc> list, MemberDoc[] memberDocArray) {
        for (int i = 0; i < memberDocArray.length; ++i) {
            if (!Util.isDeprecated(memberDocArray[i])) continue;
            list.add(memberDocArray[i]);
        }
    }

    private void sortDeprecatedLists() {
        for (int i = 0; i < 11; ++i) {
            Collections.sort(this.getList(i));
        }
    }

    public List<Doc> getList(int n) {
        return this.deprecatedLists.get(n);
    }

    public boolean hasDocumentation(int n) {
        return this.deprecatedLists.get(n).size() > 0;
    }
}

