/*
 * Decompiled with CFR 0.152.
 */
package javax.crypto;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NullCipher;

public class CipherInputStream
extends FilterInputStream {
    private Cipher cipher;
    private InputStream input;
    private byte[] ibuffer = new byte[512];
    private boolean done = false;
    private byte[] obuffer;
    private int ostart = 0;
    private int ofinish = 0;

    private int getMoreData() throws IOException {
        if (this.done) {
            return -1;
        }
        int n = this.input.read(this.ibuffer);
        if (n == -1) {
            this.done = true;
            try {
                this.obuffer = this.cipher.doFinal();
            }
            catch (IllegalBlockSizeException illegalBlockSizeException) {
                this.obuffer = null;
            }
            catch (BadPaddingException badPaddingException) {
                this.obuffer = null;
            }
            if (this.obuffer == null) {
                return -1;
            }
            this.ostart = 0;
            this.ofinish = this.obuffer.length;
            return this.ofinish;
        }
        try {
            this.obuffer = this.cipher.update(this.ibuffer, 0, n);
        }
        catch (IllegalStateException illegalStateException) {
            this.obuffer = null;
        }
        this.ostart = 0;
        this.ofinish = this.obuffer == null ? 0 : this.obuffer.length;
        return this.ofinish;
    }

    public CipherInputStream(InputStream inputStream, Cipher cipher) {
        super(inputStream);
        this.input = inputStream;
        this.cipher = cipher;
    }

    protected CipherInputStream(InputStream inputStream) {
        super(inputStream);
        this.input = inputStream;
        this.cipher = new NullCipher();
    }

    public int read() throws IOException {
        if (this.ostart >= this.ofinish) {
            int n = 0;
            while (n == 0) {
                n = this.getMoreData();
            }
            if (n == -1) {
                return -1;
            }
        }
        return this.obuffer[this.ostart++] & 0xFF;
    }

    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3;
        if (this.ostart >= this.ofinish) {
            n3 = 0;
            while (n3 == 0) {
                n3 = this.getMoreData();
            }
            if (n3 == -1) {
                return -1;
            }
        }
        if (n2 <= 0) {
            return 0;
        }
        n3 = this.ofinish - this.ostart;
        if (n2 < n3) {
            n3 = n2;
        }
        if (byArray != null) {
            System.arraycopy(this.obuffer, this.ostart, byArray, n, n3);
        }
        this.ostart += n3;
        return n3;
    }

    public long skip(long l) throws IOException {
        int n = this.ofinish - this.ostart;
        if (l > (long)n) {
            l = n;
        }
        if (l < 0L) {
            return 0L;
        }
        this.ostart = (int)((long)this.ostart + l);
        return l;
    }

    public int available() throws IOException {
        return this.ofinish - this.ostart;
    }

    public void close() throws IOException {
        this.input.close();
        try {
            this.cipher.doFinal();
        }
        catch (BadPaddingException badPaddingException) {
        }
        catch (IllegalBlockSizeException illegalBlockSizeException) {
            // empty catch block
        }
        this.ostart = 0;
        this.ofinish = 0;
    }

    public boolean markSupported() {
        return false;
    }
}

