/*
 * Decompiled with CFR 0.152.
 */
package sun.security.krb5.internal.ktab;

import java.io.UnsupportedEncodingException;
import sun.security.krb5.EncryptionKey;
import sun.security.krb5.PrincipalName;
import sun.security.krb5.Realm;
import sun.security.krb5.internal.KerberosTime;
import sun.security.krb5.internal.Krb5;
import sun.security.krb5.internal.ktab.KeyTabConstants;

public class KeyTabEntry
implements KeyTabConstants {
    PrincipalName service;
    Realm realm;
    KerberosTime timestamp;
    int keyVersion;
    int keyType;
    byte[] keyblock = null;
    boolean DEBUG = Krb5.DEBUG;

    public KeyTabEntry(PrincipalName principalName, Realm realm, KerberosTime kerberosTime, int n, int n2, byte[] byArray) {
        this.service = principalName;
        this.realm = realm;
        this.timestamp = kerberosTime;
        this.keyVersion = n;
        this.keyType = n2;
        if (byArray != null) {
            this.keyblock = (byte[])byArray.clone();
        }
    }

    public PrincipalName getService() {
        return this.service;
    }

    public EncryptionKey getKey() {
        EncryptionKey encryptionKey = new EncryptionKey(this.keyblock, this.keyType, new Integer(this.keyVersion));
        return encryptionKey;
    }

    public String getKeyString() {
        StringBuffer stringBuffer = new StringBuffer("0x");
        for (int i = 0; i < this.keyblock.length; ++i) {
            stringBuffer.append(Integer.toHexString(this.keyblock[i] & 0xFF));
        }
        return stringBuffer.toString();
    }

    public int entryLength() {
        int n;
        int n2 = 0;
        String[] stringArray = this.service.getNameStrings();
        for (n = 0; n < stringArray.length; ++n) {
            try {
                n2 += 2 + stringArray[n].getBytes("8859_1").length;
                continue;
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        n = 0;
        try {
            n = this.realm.toString().getBytes("8859_1").length;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        int n3 = 4 + n + n2 + 4 + 4 + 1 + 2 + 2 + this.keyblock.length;
        if (this.DEBUG) {
            System.out.println(">>> KeyTabEntry: key tab entry size is " + n3);
        }
        return n3;
    }

    public KerberosTime getTimeStamp() {
        return this.timestamp;
    }
}

