/*
 * Decompiled with CFR 0.152.
 */
package sun.java2d.pipe;

import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.LinearGradientPaint;
import java.awt.MultipleGradientPaint;
import java.awt.Paint;
import java.awt.RadialGradientPaint;
import java.awt.TexturePaint;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import sun.awt.image.PixelConverter;
import sun.java2d.SunGraphics2D;
import sun.java2d.SurfaceData;
import sun.java2d.loops.CompositeType;
import sun.java2d.pipe.RenderBuffer;
import sun.java2d.pipe.RenderQueue;

public class BufferedPaints {
    public static final int MULTI_MAX_FRACTIONS = 12;

    static void setPaint(RenderQueue renderQueue, SunGraphics2D sunGraphics2D, Paint paint, int n) {
        if (sunGraphics2D.paintState <= 1) {
            BufferedPaints.setColor(renderQueue, sunGraphics2D.pixel);
        } else {
            boolean bl = (n & 2) != 0;
            switch (sunGraphics2D.paintState) {
                case 2: {
                    BufferedPaints.setGradientPaint(renderQueue, sunGraphics2D, (GradientPaint)paint, bl);
                    break;
                }
                case 3: {
                    BufferedPaints.setLinearGradientPaint(renderQueue, sunGraphics2D, (LinearGradientPaint)paint, bl);
                    break;
                }
                case 4: {
                    BufferedPaints.setRadialGradientPaint(renderQueue, sunGraphics2D, (RadialGradientPaint)paint, bl);
                    break;
                }
                case 5: {
                    BufferedPaints.setTexturePaint(renderQueue, sunGraphics2D, (TexturePaint)paint, bl);
                    break;
                }
            }
        }
    }

    static void resetPaint(RenderQueue renderQueue) {
        renderQueue.ensureCapacity(4);
        RenderBuffer renderBuffer = renderQueue.getBuffer();
        renderBuffer.putInt(100);
    }

    private static void setColor(RenderQueue renderQueue, int n) {
        renderQueue.ensureCapacity(8);
        RenderBuffer renderBuffer = renderQueue.getBuffer();
        renderBuffer.putInt(101);
        renderBuffer.putInt(n);
    }

    private static void setGradientPaint(RenderQueue renderQueue, AffineTransform affineTransform, Color color, Color color2, Point2D point2D, Point2D point2D2, boolean bl, boolean bl2) {
        double d;
        double d2;
        double d3;
        PixelConverter pixelConverter = PixelConverter.ArgbPre.instance;
        int n = pixelConverter.rgbToPixel(color.getRGB(), null);
        int n2 = pixelConverter.rgbToPixel(color2.getRGB(), null);
        double d4 = point2D.getX();
        double d5 = point2D.getY();
        affineTransform.translate(d4, d5);
        d4 = point2D2.getX() - d4;
        d5 = point2D2.getY() - d5;
        double d6 = Math.sqrt(d4 * d4 + d5 * d5);
        affineTransform.rotate(d4, d5);
        affineTransform.scale(2.0 * d6, 1.0);
        affineTransform.translate(-0.25, 0.0);
        try {
            affineTransform.invert();
            d3 = affineTransform.getScaleX();
            d2 = affineTransform.getShearX();
            d = affineTransform.getTranslateX();
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            d = 0.0;
            d2 = 0.0;
            d3 = 0.0;
        }
        renderQueue.ensureCapacityAndAlignment(44, 12);
        RenderBuffer renderBuffer = renderQueue.getBuffer();
        renderBuffer.putInt(102);
        renderBuffer.putInt(bl2 ? 1 : 0);
        renderBuffer.putInt(bl ? 1 : 0);
        renderBuffer.putDouble(d3).putDouble(d2).putDouble(d);
        renderBuffer.putInt(n).putInt(n2);
    }

    private static void setGradientPaint(RenderQueue renderQueue, SunGraphics2D sunGraphics2D, GradientPaint gradientPaint, boolean bl) {
        BufferedPaints.setGradientPaint(renderQueue, (AffineTransform)sunGraphics2D.transform.clone(), gradientPaint.getColor1(), gradientPaint.getColor2(), gradientPaint.getPoint1(), gradientPaint.getPoint2(), gradientPaint.isCyclic(), bl);
    }

    private static void setTexturePaint(RenderQueue renderQueue, SunGraphics2D sunGraphics2D, TexturePaint texturePaint, boolean bl) {
        double d;
        double d2;
        double d3;
        double d4;
        double d5;
        double d6;
        BufferedImage bufferedImage = texturePaint.getImage();
        SurfaceData surfaceData = sunGraphics2D.surfaceData;
        SurfaceData surfaceData2 = surfaceData.getSourceSurfaceData(bufferedImage, 0, CompositeType.SrcOver, null);
        boolean bl2 = sunGraphics2D.interpolationType != 1;
        AffineTransform affineTransform = (AffineTransform)sunGraphics2D.transform.clone();
        Rectangle2D rectangle2D = texturePaint.getAnchorRect();
        affineTransform.translate(rectangle2D.getX(), rectangle2D.getY());
        affineTransform.scale(rectangle2D.getWidth(), rectangle2D.getHeight());
        try {
            affineTransform.invert();
            d6 = affineTransform.getScaleX();
            d5 = affineTransform.getShearX();
            d4 = affineTransform.getTranslateX();
            d3 = affineTransform.getShearY();
            d2 = affineTransform.getScaleY();
            d = affineTransform.getTranslateY();
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            d = 0.0;
            d2 = 0.0;
            d3 = 0.0;
            d4 = 0.0;
            d5 = 0.0;
            d6 = 0.0;
        }
        renderQueue.ensureCapacityAndAlignment(68, 12);
        RenderBuffer renderBuffer = renderQueue.getBuffer();
        renderBuffer.putInt(105);
        renderBuffer.putInt(bl ? 1 : 0);
        renderBuffer.putInt(bl2 ? 1 : 0);
        renderBuffer.putLong(surfaceData2.getNativeOps());
        renderBuffer.putDouble(d6).putDouble(d5).putDouble(d4);
        renderBuffer.putDouble(d3).putDouble(d2).putDouble(d);
    }

    private static int convertSRGBtoLinearRGB(int n) {
        float f = (float)n / 255.0f;
        float f2 = f <= 0.04045f ? f / 12.92f : (float)Math.pow(((double)f + 0.055) / 1.055, 2.4);
        return Math.round(f2 * 255.0f);
    }

    private static int colorToIntArgbPrePixel(Color color, boolean bl) {
        int n = color.getRGB();
        if (!bl && n >> 24 == -1) {
            return n;
        }
        int n2 = n >>> 24;
        int n3 = n >> 16 & 0xFF;
        int n4 = n >> 8 & 0xFF;
        int n5 = n & 0xFF;
        if (bl) {
            n3 = BufferedPaints.convertSRGBtoLinearRGB(n3);
            n4 = BufferedPaints.convertSRGBtoLinearRGB(n4);
            n5 = BufferedPaints.convertSRGBtoLinearRGB(n5);
        }
        int n6 = n2 + (n2 >> 7);
        n3 = n3 * n6 >> 8;
        n4 = n4 * n6 >> 8;
        n5 = n5 * n6 >> 8;
        return n2 << 24 | n3 << 16 | n4 << 8 | n5;
    }

    private static int[] convertToIntArgbPrePixels(Color[] colorArray, boolean bl) {
        int[] nArray = new int[colorArray.length];
        for (int i = 0; i < colorArray.length; ++i) {
            nArray[i] = BufferedPaints.colorToIntArgbPrePixel(colorArray[i], bl);
        }
        return nArray;
    }

    private static void setLinearGradientPaint(RenderQueue renderQueue, SunGraphics2D sunGraphics2D, LinearGradientPaint linearGradientPaint, boolean bl) {
        float f;
        float f2;
        float f3;
        boolean bl2 = linearGradientPaint.getColorSpace() == MultipleGradientPaint.ColorSpaceType.LINEAR_RGB;
        Color[] colorArray = linearGradientPaint.getColors();
        int n = colorArray.length;
        Point2D point2D = linearGradientPaint.getStartPoint();
        Point2D point2D2 = linearGradientPaint.getEndPoint();
        AffineTransform affineTransform = linearGradientPaint.getTransform();
        affineTransform.preConcatenate(sunGraphics2D.transform);
        if (!bl2 && n == 2 && linearGradientPaint.getCycleMethod() != MultipleGradientPaint.CycleMethod.REPEAT) {
            boolean bl3 = linearGradientPaint.getCycleMethod() != MultipleGradientPaint.CycleMethod.NO_CYCLE;
            BufferedPaints.setGradientPaint(renderQueue, affineTransform, colorArray[0], colorArray[1], point2D, point2D2, bl3, bl);
            return;
        }
        int n2 = linearGradientPaint.getCycleMethod().ordinal();
        float[] fArray = linearGradientPaint.getFractions();
        int[] nArray = BufferedPaints.convertToIntArgbPrePixels(colorArray, bl2);
        double d = point2D.getX();
        double d2 = point2D.getY();
        affineTransform.translate(d, d2);
        d = point2D2.getX() - d;
        d2 = point2D2.getY() - d2;
        double d3 = Math.sqrt(d * d + d2 * d2);
        affineTransform.rotate(d, d2);
        affineTransform.scale(d3, 1.0);
        try {
            affineTransform.invert();
            f3 = (float)affineTransform.getScaleX();
            f2 = (float)affineTransform.getShearX();
            f = (float)affineTransform.getTranslateX();
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            f = 0.0f;
            f2 = 0.0f;
            f3 = 0.0f;
        }
        renderQueue.ensureCapacity(32 + n * 4 * 2);
        RenderBuffer renderBuffer = renderQueue.getBuffer();
        renderBuffer.putInt(103);
        renderBuffer.putInt(bl ? 1 : 0);
        renderBuffer.putInt(bl2 ? 1 : 0);
        renderBuffer.putInt(n2);
        renderBuffer.putInt(n);
        renderBuffer.putFloat(f3);
        renderBuffer.putFloat(f2);
        renderBuffer.putFloat(f);
        renderBuffer.put(fArray);
        renderBuffer.put(nArray);
    }

    private static void setRadialGradientPaint(RenderQueue renderQueue, SunGraphics2D sunGraphics2D, RadialGradientPaint radialGradientPaint, boolean bl) {
        boolean bl2 = radialGradientPaint.getColorSpace() == MultipleGradientPaint.ColorSpaceType.LINEAR_RGB;
        int n = radialGradientPaint.getCycleMethod().ordinal();
        float[] fArray = radialGradientPaint.getFractions();
        Color[] colorArray = radialGradientPaint.getColors();
        int n2 = colorArray.length;
        int[] nArray = BufferedPaints.convertToIntArgbPrePixels(colorArray, bl2);
        Point2D point2D = radialGradientPaint.getCenterPoint();
        Point2D point2D2 = radialGradientPaint.getFocusPoint();
        float f = radialGradientPaint.getRadius();
        double d = point2D.getX();
        double d2 = point2D.getY();
        double d3 = point2D2.getX();
        double d4 = point2D2.getY();
        AffineTransform affineTransform = radialGradientPaint.getTransform();
        affineTransform.preConcatenate(sunGraphics2D.transform);
        point2D2 = affineTransform.transform(point2D2, point2D2);
        affineTransform.translate(d, d2);
        affineTransform.rotate(d3 - d, d4 - d2);
        affineTransform.scale(f, f);
        try {
            affineTransform.invert();
        }
        catch (Exception exception) {
            affineTransform.setToScale(0.0, 0.0);
        }
        point2D2 = affineTransform.transform(point2D2, point2D2);
        d3 = Math.min(point2D2.getX(), 0.99);
        renderQueue.ensureCapacity(48 + n2 * 4 * 2);
        RenderBuffer renderBuffer = renderQueue.getBuffer();
        renderBuffer.putInt(104);
        renderBuffer.putInt(bl ? 1 : 0);
        renderBuffer.putInt(bl2 ? 1 : 0);
        renderBuffer.putInt(n2);
        renderBuffer.putInt(n);
        renderBuffer.putFloat((float)affineTransform.getScaleX());
        renderBuffer.putFloat((float)affineTransform.getShearX());
        renderBuffer.putFloat((float)affineTransform.getTranslateX());
        renderBuffer.putFloat((float)affineTransform.getShearY());
        renderBuffer.putFloat((float)affineTransform.getScaleY());
        renderBuffer.putFloat((float)affineTransform.getTranslateY());
        renderBuffer.putFloat((float)d3);
        renderBuffer.put(fArray);
        renderBuffer.put(nArray);
    }
}

