/*
 * Decompiled with CFR 0.152.
 */
package javax.imageio.stream;

import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteOrder;
import java.util.Stack;
import javax.imageio.IIOException;
import javax.imageio.stream.IIOByteBuffer;
import javax.imageio.stream.ImageInputStream;

public abstract class ImageInputStreamImpl
implements ImageInputStream {
    private Stack markByteStack = new Stack();
    private Stack markBitStack = new Stack();
    private boolean isClosed = false;
    private static final int BYTE_BUF_LENGTH = 8192;
    byte[] byteBuf = new byte[8192];
    protected ByteOrder byteOrder = ByteOrder.BIG_ENDIAN;
    protected long streamPos;
    protected int bitOffset;
    protected long flushedPos = 0L;

    protected final void checkClosed() throws IOException {
        if (this.isClosed) {
            throw new IOException("closed");
        }
    }

    public void setByteOrder(ByteOrder byteOrder) {
        this.byteOrder = byteOrder;
    }

    public ByteOrder getByteOrder() {
        return this.byteOrder;
    }

    public abstract int read() throws IOException;

    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    public abstract int read(byte[] var1, int var2, int var3) throws IOException;

    public void readBytes(IIOByteBuffer iIOByteBuffer, int n) throws IOException {
        if (n < 0) {
            throw new IndexOutOfBoundsException("len < 0!");
        }
        if (iIOByteBuffer == null) {
            throw new NullPointerException("buf == null!");
        }
        byte[] byArray = new byte[n];
        n = this.read(byArray, 0, n);
        iIOByteBuffer.setData(byArray);
        iIOByteBuffer.setOffset(0);
        iIOByteBuffer.setLength(n);
    }

    public boolean readBoolean() throws IOException {
        int n = this.read();
        if (n < 0) {
            throw new EOFException();
        }
        return n != 0;
    }

    public byte readByte() throws IOException {
        int n = this.read();
        if (n < 0) {
            throw new EOFException();
        }
        return (byte)n;
    }

    public int readUnsignedByte() throws IOException {
        int n = this.read();
        if (n < 0) {
            throw new EOFException();
        }
        return n;
    }

    public short readShort() throws IOException {
        if (this.read(this.byteBuf, 0, 2) < 0) {
            throw new EOFException();
        }
        if (this.byteOrder == ByteOrder.BIG_ENDIAN) {
            return (short)((this.byteBuf[0] & 0xFF) << 8 | (this.byteBuf[1] & 0xFF) << 0);
        }
        return (short)((this.byteBuf[1] & 0xFF) << 8 | (this.byteBuf[0] & 0xFF) << 0);
    }

    public int readUnsignedShort() throws IOException {
        return this.readShort() & 0xFFFF;
    }

    public char readChar() throws IOException {
        return (char)this.readShort();
    }

    public int readInt() throws IOException {
        if (this.read(this.byteBuf, 0, 4) < 0) {
            throw new EOFException();
        }
        if (this.byteOrder == ByteOrder.BIG_ENDIAN) {
            return (this.byteBuf[0] & 0xFF) << 24 | (this.byteBuf[1] & 0xFF) << 16 | (this.byteBuf[2] & 0xFF) << 8 | (this.byteBuf[3] & 0xFF) << 0;
        }
        return (this.byteBuf[3] & 0xFF) << 24 | (this.byteBuf[2] & 0xFF) << 16 | (this.byteBuf[1] & 0xFF) << 8 | (this.byteBuf[0] & 0xFF) << 0;
    }

    public long readUnsignedInt() throws IOException {
        return (long)this.readInt() & 0xFFFFFFFFL;
    }

    public long readLong() throws IOException {
        int n = this.readInt();
        int n2 = this.readInt();
        if (this.byteOrder == ByteOrder.BIG_ENDIAN) {
            return ((long)n << 32) + ((long)n2 & 0xFFFFFFFFL);
        }
        return ((long)n2 << 32) + ((long)n & 0xFFFFFFFFL);
    }

    public float readFloat() throws IOException {
        return Float.intBitsToFloat(this.readInt());
    }

    public double readDouble() throws IOException {
        return Double.longBitsToDouble(this.readLong());
    }

    public String readLine() throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        int n = -1;
        boolean bl = false;
        block4: while (!bl) {
            n = this.read();
            switch (n) {
                case -1: 
                case 10: {
                    bl = true;
                    continue block4;
                }
                case 13: {
                    bl = true;
                    long l = this.getStreamPosition();
                    if (this.read() == 10) continue block4;
                    this.seek(l);
                    continue block4;
                }
            }
            stringBuffer.append((char)n);
        }
        if (n == -1 && stringBuffer.length() == 0) {
            return null;
        }
        return stringBuffer.toString();
    }

    public String readUTF() throws IOException {
        String string;
        this.bitOffset = 0;
        ByteOrder byteOrder = this.getByteOrder();
        this.setByteOrder(ByteOrder.BIG_ENDIAN);
        try {
            string = DataInputStream.readUTF(this);
        }
        catch (IOException iOException) {
            this.setByteOrder(byteOrder);
            throw iOException;
        }
        this.setByteOrder(byteOrder);
        return string;
    }

    public void readFully(byte[] byArray, int n, int n2) throws IOException {
        if (n < 0 || n2 < 0 || n + n2 > byArray.length || n + n2 < 0) {
            throw new IndexOutOfBoundsException("off < 0 || len < 0 || off + len > b.length!");
        }
        while (n2 > 0) {
            int n3 = this.read(byArray, n, n2);
            if (n3 == -1) {
                throw new EOFException();
            }
            n += n3;
            n2 -= n3;
        }
    }

    public void readFully(byte[] byArray) throws IOException {
        this.readFully(byArray, 0, byArray.length);
    }

    public void readFully(short[] sArray, int n, int n2) throws IOException {
        if (n < 0 || n2 < 0 || n + n2 > sArray.length || n + n2 < 0) {
            throw new IndexOutOfBoundsException("off < 0 || len < 0 || off + len > s.length!");
        }
        while (n2 > 0) {
            int n3 = Math.min(n2, this.byteBuf.length / 2);
            this.readFully(this.byteBuf, 0, n3 * 2);
            this.toShorts(this.byteBuf, sArray, n, n3);
            n += n3;
            n2 -= n3;
        }
    }

    public void readFully(char[] cArray, int n, int n2) throws IOException {
        if (n < 0 || n2 < 0 || n + n2 > cArray.length || n + n2 < 0) {
            throw new IndexOutOfBoundsException("off < 0 || len < 0 || off + len > c.length!");
        }
        while (n2 > 0) {
            int n3 = Math.min(n2, this.byteBuf.length / 2);
            this.readFully(this.byteBuf, 0, n3 * 2);
            this.toChars(this.byteBuf, cArray, n, n3);
            n += n3;
            n2 -= n3;
        }
    }

    public void readFully(int[] nArray, int n, int n2) throws IOException {
        if (n < 0 || n2 < 0 || n + n2 > nArray.length || n + n2 < 0) {
            throw new IndexOutOfBoundsException("off < 0 || len < 0 || off + len > i.length!");
        }
        while (n2 > 0) {
            int n3 = Math.min(n2, this.byteBuf.length / 4);
            this.readFully(this.byteBuf, 0, n3 * 4);
            this.toInts(this.byteBuf, nArray, n, n3);
            n += n3;
            n2 -= n3;
        }
    }

    public void readFully(long[] lArray, int n, int n2) throws IOException {
        if (n < 0 || n2 < 0 || n + n2 > lArray.length || n + n2 < 0) {
            throw new IndexOutOfBoundsException("off < 0 || len < 0 || off + len > l.length!");
        }
        while (n2 > 0) {
            int n3 = Math.min(n2, this.byteBuf.length / 8);
            this.readFully(this.byteBuf, 0, n3 * 8);
            this.toLongs(this.byteBuf, lArray, n, n3);
            n += n3;
            n2 -= n3;
        }
    }

    public void readFully(float[] fArray, int n, int n2) throws IOException {
        if (n < 0 || n2 < 0 || n + n2 > fArray.length || n + n2 < 0) {
            throw new IndexOutOfBoundsException("off < 0 || len < 0 || off + len > f.length!");
        }
        while (n2 > 0) {
            int n3 = Math.min(n2, this.byteBuf.length / 4);
            this.readFully(this.byteBuf, 0, n3 * 4);
            this.toFloats(this.byteBuf, fArray, n, n3);
            n += n3;
            n2 -= n3;
        }
    }

    public void readFully(double[] dArray, int n, int n2) throws IOException {
        if (n < 0 || n2 < 0 || n + n2 > dArray.length || n + n2 < 0) {
            throw new IndexOutOfBoundsException("off < 0 || len < 0 || off + len > d.length!");
        }
        while (n2 > 0) {
            int n3 = Math.min(n2, this.byteBuf.length / 8);
            this.readFully(this.byteBuf, 0, n3 * 8);
            this.toDoubles(this.byteBuf, dArray, n, n3);
            n += n3;
            n2 -= n3;
        }
    }

    private void toShorts(byte[] byArray, short[] sArray, int n, int n2) {
        int n3 = 0;
        if (this.byteOrder == ByteOrder.BIG_ENDIAN) {
            for (int i = 0; i < n2; ++i) {
                byte by = byArray[n3];
                int n4 = byArray[n3 + 1] & 0xFF;
                sArray[n + i] = (short)(by << 8 | n4);
                n3 += 2;
            }
        } else {
            for (int i = 0; i < n2; ++i) {
                byte by = byArray[n3 + 1];
                int n5 = byArray[n3] & 0xFF;
                sArray[n + i] = (short)(by << 8 | n5);
                n3 += 2;
            }
        }
    }

    private void toChars(byte[] byArray, char[] cArray, int n, int n2) {
        int n3 = 0;
        if (this.byteOrder == ByteOrder.BIG_ENDIAN) {
            for (int i = 0; i < n2; ++i) {
                byte by = byArray[n3];
                int n4 = byArray[n3 + 1] & 0xFF;
                cArray[n + i] = (char)(by << 8 | n4);
                n3 += 2;
            }
        } else {
            for (int i = 0; i < n2; ++i) {
                byte by = byArray[n3 + 1];
                int n5 = byArray[n3] & 0xFF;
                cArray[n + i] = (char)(by << 8 | n5);
                n3 += 2;
            }
        }
    }

    private void toInts(byte[] byArray, int[] nArray, int n, int n2) {
        int n3 = 0;
        if (this.byteOrder == ByteOrder.BIG_ENDIAN) {
            for (int i = 0; i < n2; ++i) {
                byte by = byArray[n3];
                int n4 = byArray[n3 + 1] & 0xFF;
                int n5 = byArray[n3 + 2] & 0xFF;
                int n6 = byArray[n3 + 3] & 0xFF;
                nArray[n + i] = by << 24 | n4 << 16 | n5 << 8 | n6;
                n3 += 4;
            }
        } else {
            for (int i = 0; i < n2; ++i) {
                byte by = byArray[n3 + 3];
                int n7 = byArray[n3 + 2] & 0xFF;
                int n8 = byArray[n3 + 1] & 0xFF;
                int n9 = byArray[n3] & 0xFF;
                nArray[n + i] = by << 24 | n7 << 16 | n8 << 8 | n9;
                n3 += 4;
            }
        }
    }

    private void toLongs(byte[] byArray, long[] lArray, int n, int n2) {
        int n3 = 0;
        if (this.byteOrder == ByteOrder.BIG_ENDIAN) {
            for (int i = 0; i < n2; ++i) {
                byte by = byArray[n3];
                int n4 = byArray[n3 + 1] & 0xFF;
                int n5 = byArray[n3 + 2] & 0xFF;
                int n6 = byArray[n3 + 3] & 0xFF;
                byte by2 = byArray[n3 + 4];
                int n7 = byArray[n3 + 5] & 0xFF;
                int n8 = byArray[n3 + 6] & 0xFF;
                int n9 = byArray[n3 + 7] & 0xFF;
                int n10 = by << 24 | n4 << 16 | n5 << 8 | n6;
                int n11 = by2 << 24 | n7 << 16 | n8 << 8 | n9;
                lArray[n + i] = (long)n10 << 32 | (long)n11 & 0xFFFFFFFFL;
                n3 += 8;
            }
        } else {
            for (int i = 0; i < n2; ++i) {
                byte by = byArray[n3 + 7];
                int n12 = byArray[n3 + 6] & 0xFF;
                int n13 = byArray[n3 + 5] & 0xFF;
                int n14 = byArray[n3 + 4] & 0xFF;
                byte by3 = byArray[n3 + 3];
                int n15 = byArray[n3 + 2] & 0xFF;
                int n16 = byArray[n3 + 1] & 0xFF;
                int n17 = byArray[n3] & 0xFF;
                int n18 = by << 24 | n12 << 16 | n13 << 8 | n14;
                int n19 = by3 << 24 | n15 << 16 | n16 << 8 | n17;
                lArray[n + i] = (long)n18 << 32 | (long)n19 & 0xFFFFFFFFL;
                n3 += 8;
            }
        }
    }

    private void toFloats(byte[] byArray, float[] fArray, int n, int n2) {
        int n3 = 0;
        if (this.byteOrder == ByteOrder.BIG_ENDIAN) {
            for (int i = 0; i < n2; ++i) {
                byte by = byArray[n3];
                int n4 = byArray[n3 + 1] & 0xFF;
                int n5 = byArray[n3 + 2] & 0xFF;
                int n6 = byArray[n3 + 3] & 0xFF;
                int n7 = by << 24 | n4 << 16 | n5 << 8 | n6;
                fArray[n + i] = Float.intBitsToFloat(n7);
                n3 += 4;
            }
        } else {
            for (int i = 0; i < n2; ++i) {
                byte by = byArray[n3 + 3];
                int n8 = byArray[n3 + 2] & 0xFF;
                int n9 = byArray[n3 + 1] & 0xFF;
                int n10 = byArray[n3 + 0] & 0xFF;
                int n11 = by << 24 | n8 << 16 | n9 << 8 | n10;
                fArray[n + i] = Float.intBitsToFloat(n11);
                n3 += 4;
            }
        }
    }

    private void toDoubles(byte[] byArray, double[] dArray, int n, int n2) {
        int n3 = 0;
        if (this.byteOrder == ByteOrder.BIG_ENDIAN) {
            for (int i = 0; i < n2; ++i) {
                byte by = byArray[n3];
                int n4 = byArray[n3 + 1] & 0xFF;
                int n5 = byArray[n3 + 2] & 0xFF;
                int n6 = byArray[n3 + 3] & 0xFF;
                byte by2 = byArray[n3 + 4];
                int n7 = byArray[n3 + 5] & 0xFF;
                int n8 = byArray[n3 + 6] & 0xFF;
                int n9 = byArray[n3 + 7] & 0xFF;
                int n10 = by << 24 | n4 << 16 | n5 << 8 | n6;
                int n11 = by2 << 24 | n7 << 16 | n8 << 8 | n9;
                long l = (long)n10 << 32 | (long)n11 & 0xFFFFFFFFL;
                dArray[n + i] = Double.longBitsToDouble(l);
                n3 += 8;
            }
        } else {
            for (int i = 0; i < n2; ++i) {
                byte by = byArray[n3 + 7];
                int n12 = byArray[n3 + 6] & 0xFF;
                int n13 = byArray[n3 + 5] & 0xFF;
                int n14 = byArray[n3 + 4] & 0xFF;
                byte by3 = byArray[n3 + 3];
                int n15 = byArray[n3 + 2] & 0xFF;
                int n16 = byArray[n3 + 1] & 0xFF;
                int n17 = byArray[n3] & 0xFF;
                int n18 = by << 24 | n12 << 16 | n13 << 8 | n14;
                int n19 = by3 << 24 | n15 << 16 | n16 << 8 | n17;
                long l = (long)n18 << 32 | (long)n19 & 0xFFFFFFFFL;
                dArray[n + i] = Double.longBitsToDouble(l);
                n3 += 8;
            }
        }
    }

    public long getStreamPosition() throws IOException {
        this.checkClosed();
        return this.streamPos;
    }

    public int getBitOffset() throws IOException {
        this.checkClosed();
        return this.bitOffset;
    }

    public void setBitOffset(int n) throws IOException {
        this.checkClosed();
        if (n < 0 || n > 7) {
            throw new IllegalArgumentException("bitOffset must be betwwen 0 and 7!");
        }
        this.bitOffset = n;
    }

    public int readBit() throws IOException {
        this.checkClosed();
        int n = this.bitOffset + 1 & 7;
        int n2 = this.read();
        if (n2 == -1) {
            throw new EOFException();
        }
        if (n != 0) {
            this.seek(this.getStreamPosition() - 1L);
            n2 >>= 8 - n;
        }
        this.bitOffset = n;
        return n2 & 1;
    }

    public long readBits(int n) throws IOException {
        int n2;
        this.checkClosed();
        if (n < 0 || n > 64) {
            throw new IllegalArgumentException();
        }
        if (n == 0) {
            return 0L;
        }
        int n3 = this.bitOffset + n & 7;
        long l = 0L;
        for (n2 = n + this.bitOffset; n2 > 0; n2 -= 8) {
            int n4 = this.read();
            if (n4 == -1) {
                throw new EOFException();
            }
            l <<= 8;
            l |= (long)n4;
        }
        if (n3 != 0) {
            this.seek(this.getStreamPosition() - 1L);
        }
        this.bitOffset = n3;
        l >>>= -n2;
        return l &= -1L >>> 64 - n;
    }

    public long length() {
        return -1L;
    }

    public int skipBytes(int n) throws IOException {
        long l = this.getStreamPosition();
        this.seek(l + (long)n);
        return (int)(this.getStreamPosition() - l);
    }

    public long skipBytes(long l) throws IOException {
        long l2 = this.getStreamPosition();
        this.seek(l2 + l);
        return this.getStreamPosition() - l2;
    }

    public void seek(long l) throws IOException {
        this.checkClosed();
        if (l < this.flushedPos) {
            throw new IndexOutOfBoundsException("pos < flushedPos!");
        }
        this.streamPos = l;
        this.bitOffset = 0;
    }

    public void mark() {
        try {
            this.markByteStack.push(this.getStreamPosition());
            this.markBitStack.push(this.getBitOffset());
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void reset() throws IOException {
        if (this.markByteStack.empty()) {
            return;
        }
        long l = (Long)this.markByteStack.pop();
        if (l < this.flushedPos) {
            throw new IIOException("Previous marked position has been discarded!");
        }
        this.seek(l);
        int n = (Integer)this.markBitStack.pop();
        this.setBitOffset(n);
    }

    public void flushBefore(long l) throws IOException {
        this.checkClosed();
        if (l < this.flushedPos) {
            throw new IndexOutOfBoundsException("pos < flushedPos!");
        }
        if (l > this.getStreamPosition()) {
            throw new IndexOutOfBoundsException("pos > getStreamPosition()!");
        }
        this.flushedPos = l;
    }

    public void flush() throws IOException {
        this.flushBefore(this.getStreamPosition());
    }

    public long getFlushedPosition() {
        return this.flushedPos;
    }

    public boolean isCached() {
        return false;
    }

    public boolean isCachedMemory() {
        return false;
    }

    public boolean isCachedFile() {
        return false;
    }

    public void close() throws IOException {
        this.checkClosed();
        this.isClosed = true;
    }

    protected void finalize() throws Throwable {
        if (!this.isClosed) {
            try {
                this.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        super.finalize();
    }
}

