/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.server.provider;

import com.sun.xml.internal.bind.api.JAXBRIContext;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import javax.activation.DataSource;
import javax.xml.soap.SOAPMessage;
import javax.xml.transform.Source;
import javax.xml.ws.Binding;
import javax.xml.ws.Provider;
import javax.xml.ws.Service;
import javax.xml.ws.ServiceMode;
import javax.xml.ws.soap.SOAPBinding;

public class ProviderModel {
    private final boolean isSource;
    private final Service.Mode mode;

    public ProviderModel(Class clazz, Binding binding) {
        assert (clazz != null);
        assert (binding != null);
        this.mode = ProviderModel.getServiceMode(clazz);
        Class clazz2 = binding instanceof SOAPBinding ? SOAPMessage.class : DataSource.class;
        this.isSource = ProviderModel.isSource(clazz, clazz2);
        if (this.mode == Service.Mode.PAYLOAD && !this.isSource) {
            throw new IllegalArgumentException("Illeagal combination - Mode.PAYLOAD and Provider<" + clazz2.getName() + ">");
        }
    }

    public boolean isSource() {
        return this.isSource;
    }

    public Service.Mode getServiceMode() {
        return this.mode;
    }

    private static Service.Mode getServiceMode(Class clazz) {
        ServiceMode serviceMode = clazz.getAnnotation(ServiceMode.class);
        if (serviceMode == null) {
            return Service.Mode.PAYLOAD;
        }
        return serviceMode.value();
    }

    private static boolean isSource(Class clazz, Class clazz2) {
        Type type = JAXBRIContext.getBaseType(clazz, Provider.class);
        assert (type != null);
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            Type[] typeArray = parameterizedType.getActualTypeArguments();
            if (typeArray[0] instanceof Class && Source.class.isAssignableFrom((Class)typeArray[0])) {
                return true;
            }
            if (typeArray[0] instanceof Class && clazz2.isAssignableFrom((Class)typeArray[0])) {
                return false;
            }
        }
        throw new IllegalArgumentException("Endpoint should implement Provider<" + Source.class.getName() + "> or Provider<" + clazz2.getName() + ">");
    }
}

