/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.protocol.soap.client;

import com.sun.xml.internal.messaging.saaj.soap.MessageImpl;
import com.sun.xml.internal.ws.binding.BindingImpl;
import com.sun.xml.internal.ws.client.AsyncHandlerService;
import com.sun.xml.internal.ws.client.ContextMap;
import com.sun.xml.internal.ws.client.EndpointIFContext;
import com.sun.xml.internal.ws.client.EndpointIFInvocationHandler;
import com.sun.xml.internal.ws.client.RequestContext;
import com.sun.xml.internal.ws.client.ResponseContext;
import com.sun.xml.internal.ws.client.WSFuture;
import com.sun.xml.internal.ws.client.dispatch.DispatchContext;
import com.sun.xml.internal.ws.client.dispatch.ResponseImpl;
import com.sun.xml.internal.ws.encoding.JAXWSAttachmentMarshaller;
import com.sun.xml.internal.ws.encoding.soap.SOAPEncoder;
import com.sun.xml.internal.ws.encoding.soap.client.SOAP12XMLEncoder;
import com.sun.xml.internal.ws.encoding.soap.client.SOAPXMLDecoder;
import com.sun.xml.internal.ws.encoding.soap.client.SOAPXMLEncoder;
import com.sun.xml.internal.ws.encoding.soap.internal.InternalMessage;
import com.sun.xml.internal.ws.encoding.soap.internal.MessageInfoBase;
import com.sun.xml.internal.ws.encoding.soap.message.SOAPFaultInfo;
import com.sun.xml.internal.ws.handler.HandlerChainCaller;
import com.sun.xml.internal.ws.handler.HandlerContext;
import com.sun.xml.internal.ws.handler.MessageContextUtil;
import com.sun.xml.internal.ws.handler.SOAPHandlerContext;
import com.sun.xml.internal.ws.model.JavaMethod;
import com.sun.xml.internal.ws.model.RuntimeModel;
import com.sun.xml.internal.ws.model.soap.SOAPBinding;
import com.sun.xml.internal.ws.pept.ept.EPTFactory;
import com.sun.xml.internal.ws.pept.ept.MessageInfo;
import com.sun.xml.internal.ws.pept.protocol.MessageDispatcher;
import com.sun.xml.internal.ws.server.RuntimeContext;
import com.sun.xml.internal.ws.spi.runtime.Binding;
import com.sun.xml.internal.ws.spi.runtime.ClientTransportFactory;
import com.sun.xml.internal.ws.spi.runtime.WSConnection;
import com.sun.xml.internal.ws.transport.http.client.HttpClientTransportFactory;
import com.sun.xml.internal.ws.util.Base64Util;
import com.sun.xml.internal.ws.util.FastInfosetUtil;
import com.sun.xml.internal.ws.util.MessageInfoUtil;
import com.sun.xml.internal.ws.util.SOAPConnectionUtil;
import com.sun.xml.internal.ws.util.xml.XmlUtil;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;
import java.util.concurrent.ThreadFactory;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.JAXBException;
import javax.xml.namespace.QName;
import javax.xml.soap.MimeHeader;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import javax.xml.soap.SOAPPart;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMResult;
import javax.xml.ws.BindingProvider;
import javax.xml.ws.ProtocolException;
import javax.xml.ws.Response;
import javax.xml.ws.Service;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.handler.MessageContext;
import javax.xml.ws.handler.soap.SOAPMessageContext;
import javax.xml.ws.soap.SOAPFaultException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SOAPMessageDispatcher
implements MessageDispatcher {
    protected static final int MAX_THREAD_POOL_SIZE = 3;
    protected static final long AWAIT_TERMINATION_TIME = 10L;
    protected ExecutorService executorService;
    private static final String MUST_UNDERSTAND_FAULT_MESSAGE_STRING = "SOAP must understand error";

    @Override
    public void send(MessageInfo messageInfo) {
        if (this.isAsync(messageInfo)) {
            this.doSendAsync(messageInfo);
        } else {
            this.doSend(messageInfo);
        }
    }

    protected SOAPMessage doSend(MessageInfo messageInfo) {
        EPTFactory ePTFactory = messageInfo.getEPTFactory();
        SOAPXMLEncoder sOAPXMLEncoder = (SOAPXMLEncoder)ePTFactory.getEncoder(messageInfo);
        SOAPMessage sOAPMessage = null;
        boolean bl = true;
        boolean bl2 = messageInfo.getMEP() == 1;
        try {
            Object object;
            if (messageInfo.getMetaData("com.sun.xml.internal.ws.rt.client.dispatch.mode") == Service.Mode.MESSAGE) {
                sOAPMessage = (SOAPMessage)messageInfo.getData()[0];
                FastInfosetUtil.ensureCorrectEncoding(messageInfo, sOAPMessage);
            }
            SOAPHandlerContext sOAPHandlerContext = null;
            InternalMessage internalMessage = sOAPXMLEncoder.toInternalMessage(messageInfo);
            HandlerChainCaller handlerChainCaller = this.getHandlerChainCaller(messageInfo);
            if (handlerChainCaller.hasHandlers()) {
                internalMessage = this.preHandlerOutboundHook(sOAPMessage, internalMessage);
                sOAPHandlerContext = new SOAPHandlerContext(messageInfo, internalMessage, sOAPMessage);
                sOAPHandlerContext.getMessageContext().put("javax.xml.ws.handler.message.outbound", Boolean.TRUE);
                sOAPXMLEncoder.setAttachmentsMap(messageInfo, internalMessage);
                this.updateMessageContext(messageInfo, sOAPHandlerContext);
                sOAPHandlerContext.populateAttachmentMap();
                object = MessageInfoUtil.getAttachmentMarshaller(messageInfo);
                boolean bl3 = false;
                if (object != null && ((JAXWSAttachmentMarshaller)object).isXOPPackage()) {
                    bl3 = ((JAXWSAttachmentMarshaller)object).isXOPPackage();
                    ((JAXWSAttachmentMarshaller)object).setXOPPackage(false);
                }
                bl = this.callHandlersOnRequest(sOAPHandlerContext);
                if (object != null) {
                    ((JAXWSAttachmentMarshaller)object).setXOPPackage(bl3);
                }
                sOAPMessage = sOAPHandlerContext.getSOAPMessage();
                this.postHandlerOutboundHook(messageInfo, sOAPHandlerContext, sOAPMessage);
                if (sOAPMessage == null) {
                    sOAPMessage = sOAPXMLEncoder.toSOAPMessage(sOAPHandlerContext.getInternalMessage(), messageInfo);
                }
                if (bl2 && !bl) {
                    SOAPXMLDecoder sOAPXMLDecoder = (SOAPXMLDecoder)ePTFactory.getDecoder(messageInfo);
                    internalMessage = sOAPXMLDecoder.toInternalMessage(sOAPMessage, messageInfo);
                    sOAPXMLDecoder.toMessageInfo(internalMessage, messageInfo);
                    return sOAPMessage;
                }
            }
            messageInfo.setEncoder(sOAPXMLEncoder);
            object = ((Binding)this.getBinding(messageInfo)).getSystemHandlerDelegate();
            if (object != null) {
                if (sOAPHandlerContext == null) {
                    sOAPHandlerContext = new SOAPHandlerContext(messageInfo, internalMessage, sOAPMessage);
                    sOAPHandlerContext.getMessageContext().put("javax.xml.ws.handler.message.outbound", Boolean.TRUE);
                    sOAPHandlerContext.populateAttachmentMap();
                    this.updateMessageContext(messageInfo, sOAPHandlerContext);
                }
                sOAPXMLEncoder.setAttachmentsMap(messageInfo, internalMessage);
                if (sOAPMessage != null && internalMessage != null) {
                    sOAPHandlerContext.setInternalMessage(null);
                }
                sOAPHandlerContext.getBindingId();
                object.processRequest(sOAPHandlerContext.getSHDSOAPMessageContext());
                sOAPMessage = sOAPHandlerContext.getSOAPMessage();
            }
            if (sOAPMessage == null) {
                sOAPMessage = sOAPXMLEncoder.toSOAPMessage(internalMessage, messageInfo);
                if (sOAPHandlerContext == null) {
                    sOAPHandlerContext = new SOAPHandlerContext(messageInfo, internalMessage, sOAPMessage);
                }
                this.updateMessageContext(messageInfo, sOAPHandlerContext);
            }
            Map<String, Object> map = this.processMetadata(messageInfo, sOAPMessage);
            this.setConnection(messageInfo, map);
            if (!this.isAsync(messageInfo)) {
                WSConnection wSConnection = messageInfo.getConnection();
                this.logRequestMessage(sOAPMessage, messageInfo);
                SOAPConnectionUtil.sendResponse(wSConnection, sOAPMessage);
            }
            if (bl2) {
                this.receive(messageInfo);
            } else if (this.isOneway(messageInfo)) {
                this.checkReturnStatus(messageInfo);
            }
        }
        catch (WebServiceException webServiceException) {
            this.setResponseType(webServiceException, messageInfo);
            messageInfo.setResponse(webServiceException);
        }
        catch (Throwable throwable) {
            RuntimeException runtimeException = (RuntimeException)throwable;
            this.setResponseType(runtimeException, messageInfo);
            messageInfo.setResponse(runtimeException);
        }
        return sOAPMessage;
    }

    private boolean isOneway(MessageInfo messageInfo) {
        return messageInfo.getMEP() == 2;
    }

    protected Map<String, Object> processMetadata(MessageInfo messageInfo, SOAPMessage sOAPMessage) {
        Object object;
        Object object2;
        String string;
        Object object3;
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        ArrayList arrayList = new ArrayList();
        ContextMap contextMap = (ContextMap)messageInfo.getMetaData("com.sun.xml.internal.ws.context.request");
        if (messageInfo.getMEP() == 2) {
            hashMap.put("com.sun.xml.internal.ws.server.OneWayOperation", "true");
        }
        String string2 = null;
        boolean bl = false;
        if (contextMap != null) {
            object3 = contextMap.getPropertyNames();
            while (object3.hasNext()) {
                string = (String)object3.next();
                if (string.equals(ClientTransportFactory.class.getName())) {
                    hashMap.put("com.sun.xml.internal.ws.client.ClientTransportFactory", (ClientTransportFactory)contextMap.get(string));
                    continue;
                }
                if (string.equals("javax.xml.ws.security.auth.username")) {
                    object2 = (String)contextMap.get("javax.xml.ws.security.auth.username");
                    if (object2 == null) continue;
                    object2 = (String)object2 + ":";
                    object = (String)contextMap.get("javax.xml.ws.security.auth.password");
                    if (object != null) {
                        object2 = (String)object2 + (String)object;
                    }
                    try {
                        object2 = Base64Util.encode(((String)object2).getBytes());
                    }
                    catch (Exception exception) {
                        throw new WebServiceException(exception);
                    }
                    sOAPMessage.getMimeHeaders().addHeader("Authorization", "Basic " + (String)object2);
                    continue;
                }
                if (string.equals("javax.xml.ws.soap.http.soapaction.use")) {
                    bl = (Boolean)contextMap.get("javax.xml.ws.soap.http.soapaction.use");
                    if (!bl) continue;
                    string2 = (String)contextMap.get("javax.xml.ws.soap.http.soapaction.uri");
                    continue;
                }
                hashMap.put(string, contextMap.get(string));
            }
        }
        object3 = (String)messageInfo.getMetaData("com.sun.xml.ws.client.ContentNegotiation");
        string = this.getBindingId(messageInfo);
        if (string.equals("http://www.w3.org/2003/05/soap/bindings/HTTP/") || string.equals("http://www.w3.org/2003/05/soap/bindings/HTTP/?mtom=true")) {
            sOAPMessage.getMimeHeaders().setHeader("Accept", object3 != "none" ? "application/soap+fastinfoset, application/soap+xml, application/xop+xml, text/html, image/gif, image/jpeg, *; q=.2, */*; q=.2" : "application/soap+xml, application/xop+xml, text/html, image/gif, image/jpeg, *; q=.2, */*; q=.2");
        } else {
            sOAPMessage.getMimeHeaders().setHeader("Accept", object3 != "none" ? "application/fastinfoset, text/xml, application/xop+xml, text/html, image/gif, image/jpeg, *; q=.2, */*; q=.2" : "text/xml, application/xop+xml, text/html, image/gif, image/jpeg, *; q=.2, */*; q=.2");
        }
        hashMap.put("com.sun.xml.internal.ws.binding", string);
        object2 = (RuntimeContext)messageInfo.getMetaData("com.sun.xml.internal.ws.runtime.context");
        if (object2 != null) {
            object = ((RuntimeContext)object2).getModel().getJavaMethod(messageInfo.getMethod());
            if (object != null) {
                string2 = ((SOAPBinding)((JavaMethod)object).getBinding()).getSOAPAction();
                arrayList.clear();
                if (string.equals("http://www.w3.org/2003/05/soap/bindings/HTTP/") || string.equals("http://www.w3.org/2003/05/soap/bindings/HTTP/?mtom=true")) {
                    if (string2 != null && string2.length() > 0) {
                        ((MessageImpl)sOAPMessage).setAction(string2);
                    }
                } else if (string2 == null) {
                    sOAPMessage.getMimeHeaders().addHeader("SOAPAction", "\"\"");
                } else {
                    sOAPMessage.getMimeHeaders().addHeader("SOAPAction", "\"" + string2 + "\"");
                }
            }
        } else if (messageInfo.getMetaData("com.sun.xml.internal.ws.client.dispatch.context") != null) {
            arrayList.clear();
            if (string.equals("http://www.w3.org/2003/05/soap/bindings/HTTP/") || string.equals("http://www.w3.org/2003/05/soap/bindings/HTTP/?mtom=true")) {
                if (string2 != null && string2.length() > 0) {
                    ((MessageImpl)sOAPMessage).setAction(string2);
                }
            } else if (string2 == null) {
                sOAPMessage.getMimeHeaders().addHeader("SOAPAction", "\"\"");
            } else {
                sOAPMessage.getMimeHeaders().addHeader("SOAPAction", "\"" + string2 + "\"");
            }
        }
        return hashMap;
    }

    protected void setConnection(MessageInfo messageInfo, Map<String, Object> map) {
        ClientTransportFactory clientTransportFactory = (ClientTransportFactory)map.get("com.sun.xml.internal.ws.client.ClientTransportFactory");
        WSConnection wSConnection = null;
        if (clientTransportFactory == null) {
            clientTransportFactory = new HttpClientTransportFactory();
            map.put("com.sun.xml.internal.ws.client.ClientTransportFactory", clientTransportFactory);
        }
        wSConnection = clientTransportFactory.create(map);
        messageInfo.setConnection(wSConnection);
    }

    protected void setResponseType(Throwable throwable, MessageInfo messageInfo) {
        if (throwable instanceof RuntimeException) {
            messageInfo.setResponseType(2);
        } else {
            messageInfo.setResponseType(1);
        }
        messageInfo.setResponse(throwable);
    }

    public void checkReturnStatus(MessageInfo messageInfo) {
        WSConnection wSConnection = messageInfo.getConnection();
        Map<String, List<String>> map = wSConnection.getHeaders();
        if (wSConnection.getStatus() != 202 && wSConnection.getStatus() != 200) {
            Logger.getAnonymousLogger().log(Level.SEVERE, "HTTP status code for oneway: expected 202 or 200, got " + wSConnection.getStatus());
        }
    }

    @Override
    public void receive(MessageInfo messageInfo) {
        Object object;
        Object object2;
        EPTFactory ePTFactory = messageInfo.getEPTFactory();
        SOAPXMLDecoder sOAPXMLDecoder = (SOAPXMLDecoder)ePTFactory.getDecoder(messageInfo);
        SOAPMessage sOAPMessage = null;
        try {
            sOAPMessage = sOAPXMLDecoder.toSOAPMessage(messageInfo);
        }
        catch (RuntimeException runtimeException) {
            this.setContexts(messageInfo, sOAPMessage);
            throw runtimeException;
        }
        String string = (String)messageInfo.getMetaData("com.sun.xml.ws.client.ContentNegotiation");
        if (string == "pessimistic") {
            try {
                if (((MessageImpl)sOAPMessage).isFastInfoset()) {
                    object2 = (Map)messageInfo.getMetaData("com.sun.xml.internal.ws.context.request");
                    object2.put("com.sun.xml.ws.client.ContentNegotiation", "optimistic");
                }
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
        try {
            this.logResponseMessage(sOAPMessage, messageInfo);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        object2 = this.getInboundHandlerContext(messageInfo, sOAPMessage);
        WSConnection wSConnection = messageInfo.getConnection();
        MessageContextUtil.setHttpStatusCode(((HandlerContext)object2).getMessageContext(), wSConnection.getStatus());
        MessageContextUtil.setHttpResponseHeaders(((HandlerContext)object2).getMessageContext(), wSConnection.getHeaders());
        RuntimeContext runtimeContext = MessageInfoUtil.getRuntimeContext(messageInfo);
        if (runtimeContext != null) {
            runtimeContext.setHandlerContext((HandlerContext)object2);
        }
        ((HandlerContext)object2).getMessageContext().put("javax.xml.ws.handler.message.outbound", Boolean.FALSE);
        MessageContext messageContext = MessageInfoUtil.getMessageContext(messageInfo);
        if (messageContext != null) {
            try {
                object = (Map)messageContext.get("javax.xml.ws.binding.attachments.outbound");
                if (object != null) {
                    object.clear();
                }
                MessageContextUtil.copyInboundMessageAttachments(messageContext, sOAPMessage.getAttachments());
            }
            catch (SOAPException sOAPException) {
                throw new RuntimeException(sOAPException);
            }
        }
        if ((object = ((Binding)this.getBinding(messageInfo)).getSystemHandlerDelegate()) != null) {
            try {
                object.processResponse(((SOAPHandlerContext)object2).getSHDSOAPMessageContext());
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }
        try {
            MessageInfoUtil.setHandlerChainCaller(messageInfo, this.getHandlerChainCaller(messageInfo));
            sOAPXMLDecoder.doMustUnderstandProcessing(sOAPMessage, messageInfo, (HandlerContext)object2, false);
        }
        catch (SOAPException sOAPException) {
            throw new RuntimeException(sOAPException);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        catch (SOAPFaultException sOAPFaultException) {
            this.closeAllHandlers((SOAPHandlerContext)object2);
            throw sOAPFaultException;
        }
        HandlerChainCaller handlerChainCaller = this.getHandlerChainCaller(messageInfo);
        if (handlerChainCaller.hasHandlers()) {
            this.callHandlersOnResponse((SOAPHandlerContext)object2);
            this.postHandlerInboundHook(messageInfo, (SOAPHandlerContext)object2, sOAPMessage);
        }
        SOAPXMLEncoder sOAPXMLEncoder = (SOAPXMLEncoder)ePTFactory.getEncoder(messageInfo);
        InternalMessage internalMessage = ((HandlerContext)object2).getInternalMessage();
        if (messageInfo.getMetaData("com.sun.xml.internal.ws.rt.client.dispatch.mode") == Service.Mode.MESSAGE) {
            internalMessage = null;
        }
        internalMessage = internalMessage == null ? sOAPXMLDecoder.toInternalMessage(sOAPMessage, messageInfo) : sOAPXMLDecoder.toInternalMessage(sOAPMessage, internalMessage, messageInfo);
        sOAPXMLDecoder.toMessageInfo(internalMessage, messageInfo);
        this.updateResponseContext(messageInfo, (SOAPHandlerContext)object2);
        if (messageInfo.getMetaData("com.sun.xml.internal.ws.rt.client.dispatch.mode") == Service.Mode.MESSAGE) {
            messageInfo.setResponse(sOAPMessage);
            this.postReceiveAndDecodeHook(messageInfo);
        }
    }

    private void setContexts(MessageInfo messageInfo, SOAPMessage sOAPMessage) {
        WSConnection wSConnection = messageInfo.getConnection();
        SOAPHandlerContext sOAPHandlerContext = this.getInboundHandlerContext(messageInfo, sOAPMessage);
        MessageContextUtil.setHttpStatusCode(sOAPHandlerContext.getMessageContext(), wSConnection.getStatus());
        this.updateResponseContext(messageInfo, sOAPHandlerContext);
    }

    private SOAPHandlerContext getInboundHandlerContext(MessageInfo messageInfo, SOAPMessage sOAPMessage) {
        SOAPHandlerContext sOAPHandlerContext = (SOAPHandlerContext)messageInfo.getMetaData("com.sun.xml.internal.ws.handler.context");
        if (sOAPHandlerContext != null) {
            sOAPHandlerContext.setSOAPMessage(sOAPMessage);
            sOAPHandlerContext.setInternalMessage(null);
        } else {
            sOAPHandlerContext = new SOAPHandlerContext(messageInfo, null, sOAPMessage);
        }
        return sOAPHandlerContext;
    }

    protected void doSendAsync(MessageInfo messageInfo) {
        try {
            this.preSendHook(messageInfo);
            SOAPMessage sOAPMessage = this.doSend(messageInfo);
            this.postSendHook(messageInfo);
            Response<Object> response = this.sendAsyncReceive(MessageInfoBase.copy(messageInfo), sOAPMessage);
            if (this.executorService == null) {
                this.executorService = Executors.newFixedThreadPool(3, new DaemonThreadFactory());
            }
            AsyncHandlerService asyncHandlerService = (AsyncHandlerService)messageInfo.getMetaData("com.sun.xml.internal.ws.client.dispatch.asynchandler");
            WSFuture<Object> wSFuture = null;
            if (asyncHandlerService != null) {
                wSFuture = asyncHandlerService.setupAsyncCallback(response);
                ((ResponseImpl)response).setUID(asyncHandlerService.getUID());
                ((ResponseImpl)response).setHandlerService(asyncHandlerService);
            }
            this.executorService.execute((FutureTask)((Object)response));
            if (asyncHandlerService == null) {
                messageInfo.setResponse(response);
            } else {
                messageInfo.setResponse(wSFuture);
            }
        }
        catch (Throwable throwable) {
            messageInfo.setResponse(throwable);
        }
    }

    protected Response<Object> sendAsyncReceive(final MessageInfo messageInfo, final SOAPMessage sOAPMessage) {
        boolean bl;
        AsyncHandlerService asyncHandlerService = (AsyncHandlerService)messageInfo.getMetaData("com.sun.xml.internal.ws.client.dispatch.asynchandler");
        boolean bl2 = bl = messageInfo.getMEP() == 4;
        if (bl && asyncHandlerService == null) {
            throw new WebServiceException("Asynchronous callback invocation, but no handler - AsyncHandler required");
        }
        ResponseImpl<Object> responseImpl = new ResponseImpl<Object>(new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                try {
                    WSConnection wSConnection = messageInfo.getConnection();
                    SOAPMessageDispatcher.this.logRequestMessage(sOAPMessage, messageInfo);
                    SOAPConnectionUtil.sendResponse(wSConnection, sOAPMessage);
                }
                catch (Throwable throwable) {
                    messageInfo.setResponse(throwable);
                    messageInfo.setResponseType(2);
                }
                SOAPMessageDispatcher.this.preReceiveHook(messageInfo);
                try {
                    SOAPMessageDispatcher.this.receive(messageInfo);
                }
                catch (Exception exception) {
                    messageInfo.setResponse(exception);
                }
                SOAPMessageDispatcher.this.postReceiveHook(messageInfo);
                if (messageInfo.getResponse() instanceof Exception) {
                    throw (Exception)messageInfo.getResponse();
                }
                return messageInfo.getResponse();
            }
        });
        messageInfo.setMetaData("com.sun.xml.internal.ws.client.dispatch.async.response.context", responseImpl);
        return responseImpl;
    }

    protected boolean callHandlersOnRequest(SOAPHandlerContext sOAPHandlerContext) {
        try {
            HandlerChainCaller handlerChainCaller = this.getHandlerChainCaller(sOAPHandlerContext.getMessageInfo());
            boolean bl = sOAPHandlerContext.getMessageInfo().getMEP() != 2;
            return handlerChainCaller.callHandlers(HandlerChainCaller.Direction.OUTBOUND, HandlerChainCaller.RequestOrResponse.REQUEST, sOAPHandlerContext, bl);
        }
        catch (ProtocolException protocolException) {
            if (MessageContextUtil.ignoreFaultInMessage(sOAPHandlerContext.getMessageContext())) {
                throw protocolException;
            }
            return false;
        }
        catch (WebServiceException webServiceException) {
            throw webServiceException;
        }
        catch (RuntimeException runtimeException) {
            throw new WebServiceException(runtimeException);
        }
    }

    protected boolean callHandlersOnResponse(SOAPHandlerContext sOAPHandlerContext) {
        HandlerChainCaller handlerChainCaller = this.getHandlerChainCaller(sOAPHandlerContext.getMessageInfo());
        try {
            SOAPMessage sOAPMessage;
            int n = (Integer)sOAPHandlerContext.getMessageContext().get("javax.xml.ws.http.response.code");
            if (n != 200 && n != 202 && (sOAPMessage = sOAPHandlerContext.getSOAPMessage()) != null && sOAPMessage.getSOAPBody().hasFault()) {
                return handlerChainCaller.callHandleFaultOnClient(sOAPHandlerContext);
            }
            return handlerChainCaller.callHandlers(HandlerChainCaller.Direction.INBOUND, HandlerChainCaller.RequestOrResponse.RESPONSE, sOAPHandlerContext, false);
        }
        catch (SOAPException sOAPException) {
            throw new WebServiceException(sOAPException);
        }
        catch (WebServiceException webServiceException) {
            throw webServiceException;
        }
        catch (RuntimeException runtimeException) {
            throw new WebServiceException(runtimeException);
        }
    }

    protected javax.xml.ws.Binding getBinding(MessageInfo messageInfo) {
        ContextMap contextMap = (ContextMap)((MessageInfoBase)messageInfo).getMetaData("com.sun.xml.internal.ws.context.request");
        BindingProvider bindingProvider = (BindingProvider)contextMap.get("com.sun.xml.internal.ws.client.handle");
        return bindingProvider.getBinding();
    }

    protected HandlerChainCaller getHandlerChainCaller(MessageInfo messageInfo) {
        BindingImpl bindingImpl = (BindingImpl)this.getBinding(messageInfo);
        return bindingImpl.getHandlerChainCaller();
    }

    private void updateSOAPMessage(Object object, SOAPMessage sOAPMessage) {
        try {
            if (object instanceof Source) {
                SOAPBody sOAPBody = sOAPMessage.getSOAPPart().getEnvelope().getBody();
                sOAPBody.removeContents();
                XmlUtil.newTransformer().transform((Source)object, new DOMResult(sOAPBody));
                sOAPMessage.saveChanges();
            }
        }
        catch (SOAPException sOAPException) {
            throw new RuntimeException(sOAPException);
        }
        catch (TransformerException transformerException) {
            throw new RuntimeException(transformerException);
        }
    }

    protected void updateMessageContext(MessageInfo messageInfo, SOAPHandlerContext sOAPHandlerContext) {
        Object object;
        Object object2;
        Object object3;
        SOAPMessageContext sOAPMessageContext = sOAPHandlerContext.getSOAPMessageContext();
        messageInfo.setMetaData("com.sun.xml.internal.ws.handler.context", sOAPHandlerContext);
        RequestContext requestContext = (RequestContext)messageInfo.getMetaData("com.sun.xml.internal.ws.context.request");
        Iterator<String> iterator = requestContext.copy().getPropertyNames();
        while (iterator.hasNext()) {
            object3 = iterator.next();
            object2 = requestContext.get((String)object3);
            sOAPMessageContext.put(object3, object2);
        }
        object3 = (BindingProvider)sOAPHandlerContext.getMessageContext().get("com.sun.xml.internal.ws.client.handle");
        object2 = null;
        if (object3 != null && Proxy.isProxyClass(object3.getClass())) {
            object = (EndpointIFInvocationHandler)Proxy.getInvocationHandler(object3);
            EndpointIFContext endpointIFContext = ((EndpointIFInvocationHandler)object).getEndpointContext();
            object2 = ((EndpointIFInvocationHandler)object).getWSDLPortTypeQName();
            sOAPMessageContext.put("javax.xml.ws.wsdl.service", ((EndpointIFInvocationHandler)object).getServiceQName());
            sOAPMessageContext.put("javax.xml.ws.wsdl.port", endpointIFContext.getPortName());
            sOAPHandlerContext.setBindingId(endpointIFContext.getBindingID().toString());
            RuntimeContext runtimeContext = (RuntimeContext)messageInfo.getMetaData("com.sun.xml.internal.ws.runtime.context");
            if (runtimeContext != null) {
                RuntimeModel runtimeModel = runtimeContext.getModel();
                JavaMethod javaMethod = runtimeModel.getJavaMethod(messageInfo.getMethod());
                String string = javaMethod.getOperationName();
                if (object2 != null) {
                    String string2 = ((QName)object2).getNamespaceURI();
                    sOAPMessageContext.put("javax.xml.ws.wsdl.operation", new QName(string2, string));
                }
            }
            runtimeContext.setHandlerContext(sOAPHandlerContext);
        }
        if ((object = messageInfo.getMetaData("com.sun.xml.ws.client.ContentNegotiation")) != null) {
            sOAPMessageContext.put("com.sun.xml.ws.client.ContentNegotiation", object);
        }
    }

    protected void updateResponseContext(MessageInfo messageInfo, SOAPHandlerContext sOAPHandlerContext) {
        SOAPMessageContext sOAPMessageContext = sOAPHandlerContext.getSOAPMessageContext();
        RequestContext requestContext = (RequestContext)messageInfo.getMetaData("com.sun.xml.internal.ws.context.request");
        BindingProvider bindingProvider = (BindingProvider)requestContext.get("com.sun.xml.internal.ws.client.handle");
        ResponseContext responseContext = new ResponseContext(bindingProvider);
        for (String string : sOAPMessageContext.keySet()) {
            MessageContext.Scope scope = sOAPMessageContext.getScope(string);
            if (MessageContext.Scope.APPLICATION != scope) continue;
            Object v = sOAPMessageContext.get(string);
            responseContext.put(string, v);
        }
        ResponseImpl responseImpl = (ResponseImpl)messageInfo.getMetaData("com.sun.xml.internal.ws.client.dispatch.async.response.context");
        if (responseImpl != null) {
            responseImpl.setResponseContext(responseContext.copy());
        } else {
            messageInfo.setMetaData("com.sun.xml.internal.ws.context.response", responseContext.copy());
        }
    }

    protected boolean isAsync(MessageInfo messageInfo) {
        return messageInfo.getMEP() == 3 || messageInfo.getMEP() == 4;
    }

    private void preSendHook(MessageInfo messageInfo) {
    }

    private void preReceiveHook(MessageInfo messageInfo) {
    }

    private void postSendHook(MessageInfo messageInfo) {
        if (messageInfo.getResponseType() != 0) {
            this.postReceiveHook(messageInfo);
            throw (WebServiceException)messageInfo.getResponse();
        }
    }

    private void postReceiveAndDecodeHook(MessageInfo messageInfo) {
        Object object;
        DispatchContext dispatchContext = (DispatchContext)messageInfo.getMetaData("com.sun.xml.internal.ws.client.dispatch.context");
        if (messageInfo.getMetaData("com.sun.xml.internal.ws.rt.client.dispatch.mode") == Service.Mode.MESSAGE && dispatchContext.getProperty("com.sun.xml.internal.ws.rt.client.dispatch.messagetype") == DispatchContext.MessageType.SOURCE_MESSAGE && (object = messageInfo.getResponse()) instanceof SOAPMessage) {
            SOAPPart sOAPPart = ((SOAPMessage)object).getSOAPPart();
            try {
                messageInfo.setResponse(sOAPPart.getContent());
            }
            catch (SOAPException sOAPException) {
                throw new RuntimeException(sOAPException);
            }
        }
    }

    private void postReceiveHook(MessageInfo messageInfo) {
        Object object = messageInfo.getResponse();
        switch (messageInfo.getResponseType()) {
            case 0: {
                return;
            }
            case 1: {
                if (object instanceof SOAPFaultInfo) {
                    SOAPFaultInfo sOAPFaultInfo = (SOAPFaultInfo)object;
                    JAXBException jAXBException = null;
                    if (sOAPFaultInfo.getString().contains("javax.xml.bind")) {
                        jAXBException = new JAXBException(sOAPFaultInfo.getString());
                    }
                    SOAPFaultException sOAPFaultException = new SOAPFaultException(sOAPFaultInfo.getSOAPFault());
                    if (jAXBException != null) {
                        sOAPFaultException.initCause(jAXBException);
                    }
                    messageInfo.setResponse(sOAPFaultException);
                }
                return;
            }
            case 2: {
                if (object instanceof SOAPFaultException) {
                    messageInfo.setResponse((SOAPFaultException)object);
                } else if (object instanceof Exception) {
                    RuntimeException runtimeException = (RuntimeException)object;
                    messageInfo.setResponse(runtimeException);
                }
                return;
            }
        }
        messageInfo.setResponse(object);
    }

    private InternalMessage preHandlerOutboundHook(SOAPMessage sOAPMessage, InternalMessage internalMessage) {
        if (sOAPMessage != null && internalMessage != null) {
            internalMessage = null;
        }
        return internalMessage;
    }

    private void postHandlerOutboundHook(MessageInfo messageInfo, SOAPHandlerContext sOAPHandlerContext, SOAPMessage sOAPMessage) {
        if (messageInfo.getMetaData("com.sun.xml.internal.ws.rt.client.dispatch.mode") == Service.Mode.MESSAGE) {
            InternalMessage internalMessage = sOAPHandlerContext.getInternalMessage();
            if (internalMessage != null) {
                Object object = internalMessage.getBody().getValue();
                this.updateSOAPMessage(object, sOAPMessage);
                internalMessage = null;
            } else {
                try {
                    sOAPMessage.saveChanges();
                }
                catch (SOAPException sOAPException) {
                    throw new RuntimeException(sOAPException);
                }
            }
        }
    }

    private void postHandlerInboundHook(MessageInfo messageInfo, SOAPHandlerContext sOAPHandlerContext, SOAPMessage sOAPMessage) {
        if (messageInfo.getMetaData("com.sun.xml.internal.ws.rt.client.dispatch.mode") == Service.Mode.MESSAGE || messageInfo.getMetaData("com.sun.xml.internal.ws.rt.client.dispatch.mode") == Service.Mode.PAYLOAD) {
            InternalMessage internalMessage = sOAPHandlerContext.getInternalMessage();
            if (internalMessage != null) {
                Object object = internalMessage.getBody().getValue();
                this.updateSOAPMessage(object, sOAPMessage);
                internalMessage = null;
            } else {
                try {
                    sOAPMessage.saveChanges();
                }
                catch (SOAPException sOAPException) {
                    throw new RuntimeException(sOAPException);
                }
            }
        }
    }

    private void closeAllHandlers(SOAPHandlerContext sOAPHandlerContext) {
        HandlerChainCaller handlerChainCaller = this.getHandlerChainCaller(sOAPHandlerContext.getMessageInfo());
        if (handlerChainCaller != null && handlerChainCaller.hasHandlers()) {
            handlerChainCaller.forceCloseHandlersOnClient(sOAPHandlerContext);
        }
    }

    protected String getBindingId(MessageInfo messageInfo) {
        SOAPEncoder sOAPEncoder = (SOAPEncoder)messageInfo.getEncoder();
        if (sOAPEncoder instanceof SOAP12XMLEncoder) {
            return "http://www.w3.org/2003/05/soap/bindings/HTTP/";
        }
        return "http://schemas.xmlsoap.org/wsdl/soap/http";
    }

    protected void logRequestMessage(SOAPMessage sOAPMessage, MessageInfo messageInfo) throws IOException, SOAPException {
        OutputStream outputStream = messageInfo.getConnection().getDebug();
        if (outputStream != null) {
            String string = "******************\nRequest\n";
            outputStream.write(string.getBytes());
            Iterator iterator = sOAPMessage.getMimeHeaders().getAllHeaders();
            while (iterator.hasNext()) {
                MimeHeader mimeHeader = (MimeHeader)iterator.next();
                string = mimeHeader.getName() + ": " + mimeHeader.getValue() + "\n";
                outputStream.write(string.getBytes());
            }
            outputStream.flush();
            sOAPMessage.writeTo(outputStream);
            string = "\n";
            outputStream.write(string.getBytes());
            outputStream.flush();
        }
    }

    protected void logResponseMessage(SOAPMessage sOAPMessage, MessageInfo messageInfo) throws IOException, SOAPException {
        OutputStream outputStream = messageInfo.getConnection().getDebug();
        if (outputStream != null) {
            String string = "Response\n";
            outputStream.write(string.getBytes());
            string = "Http Status Code: " + messageInfo.getConnection().getStatus() + "\n\n";
            outputStream.write(string.getBytes());
            Iterator iterator = sOAPMessage.getMimeHeaders().getAllHeaders();
            while (iterator.hasNext()) {
                MimeHeader mimeHeader = (MimeHeader)iterator.next();
                string = mimeHeader.getName() + ": " + mimeHeader.getValue() + "\n";
                outputStream.write(string.getBytes());
            }
            outputStream.flush();
            sOAPMessage.writeTo(outputStream);
            string = "******************\n\n";
            outputStream.write(string.getBytes());
        }
    }

    class DaemonThreadFactory
    implements ThreadFactory {
        DaemonThreadFactory() {
        }

        public Thread newThread(Runnable runnable) {
            Thread thread = new Thread(runnable);
            thread.setDaemon(Boolean.TRUE);
            return thread;
        }
    }
}

