/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmx.mbeanserver;

import com.sun.jmx.defaults.JmxProperties;
import com.sun.jmx.mbeanserver.MBeanInjector;
import com.sun.jmx.mbeanserver.MBeanIntrospector;
import com.sun.jmx.mbeanserver.MXBeanIntrospector;
import com.sun.jmx.mbeanserver.MXBeanSupport;
import com.sun.jmx.mbeanserver.PerInterface;
import com.sun.jmx.mbeanserver.StandardMBeanIntrospector;
import com.sun.jmx.mbeanserver.StandardMBeanSupport;
import com.sun.jmx.mbeanserver.Util;
import com.sun.jmx.remote.util.EnvHelp;
import java.beans.BeanInfo;
import java.beans.PropertyDescriptor;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.management.AttributeNotFoundException;
import javax.management.Description;
import javax.management.Descriptor;
import javax.management.DescriptorFields;
import javax.management.DescriptorKey;
import javax.management.DynamicMBean;
import javax.management.ImmutableDescriptor;
import javax.management.MBean;
import javax.management.MBeanInfo;
import javax.management.MXBean;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import javax.management.ObjectNameTemplate;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.MXBeanMappingFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Introspector {
    private static Pattern OBJECT_NAME_PATTERN_TEMPLATE = Pattern.compile("(\\{[^\\}]+\\})|(=\"\\{[^\\}]+\\}\")");

    private Introspector() {
    }

    public static final boolean isDynamic(Class<?> clazz) {
        return DynamicMBean.class.isAssignableFrom(clazz);
    }

    public static void testCreation(Class<?> clazz) throws NotCompliantMBeanException {
        int n = clazz.getModifiers();
        if (Modifier.isAbstract(n) || Modifier.isInterface(n)) {
            throw new NotCompliantMBeanException("MBean class must be concrete");
        }
        Constructor<?>[] constructorArray = clazz.getConstructors();
        if (constructorArray.length == 0) {
            throw new NotCompliantMBeanException("MBean class must have public constructor");
        }
    }

    public static void checkCompliance(Class<?> clazz) throws NotCompliantMBeanException {
        MBeanInjector.validate(clazz);
        if (DynamicMBean.class.isAssignableFrom(clazz)) {
            return;
        }
        try {
            Introspector.getStandardMBeanInterface(clazz);
            return;
        }
        catch (NotCompliantMBeanException notCompliantMBeanException) {
            NotCompliantMBeanException notCompliantMBeanException2 = notCompliantMBeanException;
            try {
                Introspector.getMXBeanInterface(clazz);
                return;
            }
            catch (NotCompliantMBeanException notCompliantMBeanException3) {
                NotCompliantMBeanException notCompliantMBeanException4 = notCompliantMBeanException3;
                String string = "MBean class " + clazz.getName() + " does not implement " + "DynamicMBean; does not follow the Standard MBean conventions (" + notCompliantMBeanException2.toString() + "); does not follow the MXBean conventions (" + notCompliantMBeanException4.toString() + "); and does not have or inherit the @" + MBean.class.getSimpleName() + " or @" + MXBean.class.getSimpleName() + " annotation";
                throw new NotCompliantMBeanException(string);
            }
        }
    }

    public static <T> DynamicMBean makeDynamicMBean(T t) throws NotCompliantMBeanException {
        if (t == null) {
            throw new NotCompliantMBeanException("Null MBean object");
        }
        if (t instanceof DynamicMBean) {
            return (DynamicMBean)t;
        }
        Class<?> clazz = t.getClass();
        Class clazz2 = null;
        try {
            clazz2 = (Class)Util.cast(Introspector.getStandardMBeanInterface(clazz));
        }
        catch (NotCompliantMBeanException notCompliantMBeanException) {
            // empty catch block
        }
        if (clazz2 != null) {
            return new StandardMBeanSupport(t, clazz2);
        }
        try {
            clazz2 = (Class)Util.cast(Introspector.getMXBeanInterface(clazz));
        }
        catch (NotCompliantMBeanException notCompliantMBeanException) {
            // empty catch block
        }
        if (clazz2 != null) {
            MXBeanMappingFactory mXBeanMappingFactory;
            try {
                mXBeanMappingFactory = MXBeanMappingFactory.forInterface(clazz2);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                NotCompliantMBeanException notCompliantMBeanException = new NotCompliantMBeanException(illegalArgumentException.getMessage());
                notCompliantMBeanException.initCause(illegalArgumentException);
                throw notCompliantMBeanException;
            }
            return new MXBeanSupport(t, clazz2, mXBeanMappingFactory);
        }
        Introspector.checkCompliance(clazz);
        throw new NotCompliantMBeanException("Not compliant");
    }

    public static MBeanInfo testCompliance(Class<?> clazz) throws NotCompliantMBeanException {
        if (Introspector.isDynamic(clazz)) {
            return null;
        }
        return Introspector.testCompliance(clazz, null);
    }

    public static void testComplianceMXBeanInterface(Class<?> clazz, MXBeanMappingFactory mXBeanMappingFactory) throws NotCompliantMBeanException {
        MXBeanIntrospector.getInstance(mXBeanMappingFactory).getAnalyzer(clazz);
    }

    public static synchronized MBeanInfo testCompliance(Class<?> clazz, Class<?> clazz2) throws NotCompliantMBeanException {
        if (clazz2 == null) {
            clazz2 = Introspector.getStandardMBeanInterface(clazz);
        }
        StandardMBeanIntrospector standardMBeanIntrospector = StandardMBeanIntrospector.getInstance();
        return Introspector.getClassMBeanInfo(standardMBeanIntrospector, clazz, clazz2);
    }

    private static <M> MBeanInfo getClassMBeanInfo(MBeanIntrospector<M> mBeanIntrospector, Class<?> clazz, Class<?> clazz2) throws NotCompliantMBeanException {
        PerInterface<M> perInterface = mBeanIntrospector.getPerInterface(clazz2);
        return mBeanIntrospector.getClassMBeanInfo(clazz, perInterface);
    }

    public static Class<?> getMBeanInterface(Class<?> clazz) {
        if (Introspector.isDynamic(clazz)) {
            return null;
        }
        try {
            return Introspector.getStandardMBeanInterface(clazz);
        }
        catch (NotCompliantMBeanException notCompliantMBeanException) {
            return null;
        }
    }

    public static <T> Class<? super T> getStandardMBeanInterface(Class<T> clazz) throws NotCompliantMBeanException {
        if (clazz.isAnnotationPresent(MBean.class)) {
            return clazz;
        }
        Class<T> clazz2 = null;
        for (Class<T> clazz3 = clazz; clazz3 != null && (clazz2 = Introspector.findMBeanInterface(clazz3, clazz3.getName())) == null; clazz3 = clazz3.getSuperclass()) {
        }
        if (clazz2 != null) {
            return clazz2;
        }
        String string = "Class " + clazz.getName() + " is not a JMX compliant Standard MBean";
        throw new NotCompliantMBeanException(string);
    }

    public static <T> Class<? super T> getMXBeanInterface(Class<T> clazz) throws NotCompliantMBeanException {
        if (Introspector.hasMXBeanAnnotation(clazz)) {
            return clazz;
        }
        try {
            return MXBeanSupport.findMXBeanInterface(clazz);
        }
        catch (Exception exception) {
            throw Introspector.throwException(clazz, exception);
        }
    }

    public static <T> Class<? super T> getStandardOrMXBeanInterface(Class<T> clazz, boolean bl) throws NotCompliantMBeanException {
        if (bl) {
            return Introspector.getMXBeanInterface(clazz);
        }
        return Introspector.getStandardMBeanInterface(clazz);
    }

    public static ObjectName templateToObjectName(Descriptor descriptor, DynamicMBean dynamicMBean) throws NotCompliantMBeanException {
        String string = (String)descriptor.getFieldValue("objectNameTemplate");
        if (string == null) {
            return null;
        }
        try {
            Matcher matcher = OBJECT_NAME_PATTERN_TEMPLATE.matcher(string);
            while (matcher.find()) {
                String string2 = matcher.group();
                System.out.println("GROUP " + string2);
                String string3 = null;
                boolean bl = false;
                if (string2.startsWith("=\"{")) {
                    string3 = string2.substring(3, string2.length() - 2);
                    bl = true;
                } else {
                    string3 = string2.substring(1, string2.length() - 1);
                }
                Object object = dynamicMBean.getAttribute(string3);
                String string4 = bl ? "=" + ObjectName.quote(object.toString()) : object.toString();
                string = string.replace(string2, string4);
            }
            return new ObjectName(string);
        }
        catch (Exception exception) {
            NotCompliantMBeanException notCompliantMBeanException = new NotCompliantMBeanException(ObjectNameTemplate.class.getSimpleName() + " annotation value [" + string + "] " + "is invalid. " + exception);
            notCompliantMBeanException.initCause(exception);
            throw notCompliantMBeanException;
        }
    }

    static boolean hasMXBeanAnnotation(Class<?> clazz) {
        MXBean mXBean = clazz.getAnnotation(MXBean.class);
        return mXBean != null && mXBean.value();
    }

    private static <T> Class<? super T> findMBeanInterface(Class<T> clazz, String string) {
        for (Class<T> clazz2 = clazz; clazz2 != null; clazz2 = clazz2.getSuperclass()) {
            Class<?>[] classArray = clazz2.getInterfaces();
            int n = classArray.length;
            for (int i = 0; i < n; ++i) {
                Class<T> clazz3 = (Class<T>)Util.cast(classArray[i]);
                if ((clazz3 = Introspector.implementsMBean(clazz3, string)) == null) continue;
                return clazz3;
            }
        }
        return null;
    }

    public static String descriptionForElement(AnnotatedElement annotatedElement) {
        if (annotatedElement == null) {
            return null;
        }
        Description description = annotatedElement.getAnnotation(Description.class);
        if (description == null) {
            return null;
        }
        return description.value();
    }

    public static String descriptionForParameter(Annotation[] annotationArray) {
        for (Annotation annotation : annotationArray) {
            if (!(annotation instanceof Description)) continue;
            return ((Description)annotation).value();
        }
        return null;
    }

    public static String nameForParameter(Annotation[] annotationArray) {
        for (Annotation annotation : annotationArray) {
            Class<? extends Annotation> clazz = annotation.annotationType();
            if (!clazz.getSimpleName().equals("Name")) continue;
            try {
                Method method = clazz.getMethod("value", new Class[0]);
                if (method.getReturnType() != String.class || method.getParameterTypes().length != 0) continue;
                return (String)method.invoke(annotation, new Object[0]);
            }
            catch (Exception exception) {
                JmxProperties.MBEANSERVER_LOGGER.log(Level.WARNING, "Unexpected exception getting @" + clazz.getName(), exception);
            }
        }
        return null;
    }

    public static Descriptor descriptorForElement(AnnotatedElement annotatedElement, boolean bl) {
        if (annotatedElement == null) {
            return ImmutableDescriptor.EMPTY_DESCRIPTOR;
        }
        Annotation[] annotationArray = annotatedElement.getAnnotations();
        Descriptor descriptor = Introspector.descriptorForAnnotations(annotationArray);
        String[] stringArray = new String[]{};
        if (annotatedElement instanceof Method) {
            stringArray = Introspector.getAllExceptions(((Method)annotatedElement).getExceptionTypes());
        } else if (annotatedElement instanceof Constructor) {
            stringArray = Introspector.getAllExceptions(((Constructor)annotatedElement).getExceptionTypes());
        }
        if (stringArray.length > 0) {
            String string = bl ? "setExceptions" : "exceptions";
            String[] stringArray2 = new String[]{string};
            Object[] objectArray = new Object[]{stringArray};
            descriptor = ImmutableDescriptor.union(descriptor, new ImmutableDescriptor(stringArray2, objectArray));
        }
        return descriptor;
    }

    public static Descriptor descriptorForAnnotation(Annotation annotation) {
        return Introspector.descriptorForAnnotations(new Annotation[]{annotation});
    }

    public static Descriptor descriptorForAnnotations(Annotation[] annotationArray) {
        if (annotationArray.length == 0) {
            return ImmutableDescriptor.EMPTY_DESCRIPTOR;
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        for (Annotation annotation : annotationArray) {
            if (annotation instanceof DescriptorFields) {
                Introspector.addDescriptorFieldsToMap(hashMap, (DescriptorFields)annotation);
            }
            Introspector.addAnnotationFieldsToMap(hashMap, annotation);
        }
        if (hashMap.isEmpty()) {
            return ImmutableDescriptor.EMPTY_DESCRIPTOR;
        }
        return new ImmutableDescriptor(hashMap);
    }

    private static String[] getAllExceptions(Class<?>[] classArray) {
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        for (Class<?> clazz : classArray) {
            linkedHashSet.add(clazz.getName());
        }
        Object[] objectArray = new String[linkedHashSet.size()];
        return (String[])linkedHashSet.toArray(objectArray);
    }

    private static void addDescriptorFieldsToMap(Map<String, Object> map, DescriptorFields descriptorFields) {
        for (String string : descriptorFields.value()) {
            int n = string.indexOf(61);
            if (n < 0) {
                throw new IllegalArgumentException("@DescriptorFields string must contain '=': " + string);
            }
            String string2 = string.substring(0, n);
            String string3 = string.substring(n + 1);
            Introspector.addToMap(map, string2, string3);
        }
    }

    private static void addAnnotationFieldsToMap(Map<String, Object> map, Annotation annotation) {
        Method[] methodArray;
        Class<? extends Annotation> clazz = annotation.annotationType();
        for (Method method : methodArray = clazz.getMethods()) {
            Object object;
            DescriptorKey descriptorKey = method.getAnnotation(DescriptorKey.class);
            if (descriptorKey == null) continue;
            String string = descriptorKey.value();
            try {
                object = method.invoke(annotation, new Object[0]);
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new UndeclaredThrowableException(exception);
            }
            if (descriptorKey.omitIfDefault() && Introspector.equals(object, method.getDefaultValue())) continue;
            object = Introspector.annotationToField(object);
            Introspector.addToMap(map, string, object);
        }
    }

    private static void addToMap(Map<String, Object> map, String string, Object object) {
        Object object2 = map.put(string, object);
        if (object2 != null && !Introspector.equals(object2, object)) {
            String string2 = "Inconsistent values for descriptor field " + string + " from annotations: " + object + " :: " + object2;
            throw new IllegalArgumentException(string2);
        }
    }

    static NotCompliantMBeanException throwException(Class<?> clazz, Throwable throwable) throws NotCompliantMBeanException, SecurityException {
        if (throwable instanceof SecurityException) {
            throw (SecurityException)throwable;
        }
        if (throwable instanceof NotCompliantMBeanException) {
            throw (NotCompliantMBeanException)throwable;
        }
        String string = clazz == null ? "null class" : clazz.getName();
        String string2 = throwable == null ? "Not compliant" : throwable.getMessage();
        NotCompliantMBeanException notCompliantMBeanException = new NotCompliantMBeanException(string + ": " + string2);
        notCompliantMBeanException.initCause(throwable);
        throw notCompliantMBeanException;
    }

    private static Object annotationToField(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof Number || object instanceof String || object instanceof Character || object instanceof Boolean || object instanceof String[]) {
            return object;
        }
        Class<?> clazz = object.getClass();
        if (clazz.isArray()) {
            if (clazz.getComponentType().isPrimitive()) {
                return object;
            }
            Object[] objectArray = (Object[])object;
            String[] stringArray = new String[objectArray.length];
            for (int i = 0; i < objectArray.length; ++i) {
                stringArray[i] = (String)Introspector.annotationToField(objectArray[i]);
            }
            return stringArray;
        }
        if (object instanceof Class) {
            return ((Class)object).getName();
        }
        if (object instanceof Enum) {
            return ((Enum)object).name();
        }
        if (Proxy.isProxyClass(clazz)) {
            clazz = clazz.getInterfaces()[0];
        }
        throw new IllegalArgumentException("Illegal type for annotation element using @DescriptorKey: " + clazz.getName());
    }

    private static boolean equals(Object object, Object object2) {
        return Arrays.deepEquals(new Object[]{object}, new Object[]{object2});
    }

    private static <T> Class<? super T> implementsMBean(Class<T> clazz, String string) {
        String string2 = string + "MBean";
        if (clazz.getName().equals(string2)) {
            return clazz;
        }
        Class<?>[] classArray = clazz.getInterfaces();
        for (int i = 0; i < classArray.length; ++i) {
            if (!classArray[i].getName().equals(string2)) continue;
            return (Class)Util.cast(classArray[i]);
        }
        return null;
    }

    public static Object elementFromComplex(Object object, String string) throws AttributeNotFoundException {
        try {
            PropertyDescriptor[] propertyDescriptorArray;
            if (object.getClass().isArray() && string.equals("length")) {
                return Array.getLength(object);
            }
            if (object instanceof CompositeData) {
                return ((CompositeData)object).get(string);
            }
            BeanInfo beanInfo = java.beans.Introspector.getBeanInfo(object.getClass());
            for (PropertyDescriptor propertyDescriptor : propertyDescriptorArray = beanInfo.getPropertyDescriptors()) {
                if (!propertyDescriptor.getName().equals(string)) continue;
                return propertyDescriptor.getReadMethod().invoke(object, new Object[0]);
            }
            throw new AttributeNotFoundException("Could not find the getter method for the property " + string + " using the Java Beans introspector");
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new IllegalArgumentException(invocationTargetException);
        }
        catch (AttributeNotFoundException attributeNotFoundException) {
            throw attributeNotFoundException;
        }
        catch (Exception exception) {
            throw EnvHelp.initCause(new AttributeNotFoundException(exception.getMessage()), exception);
        }
    }
}

