/*
 * Decompiled with CFR 0.152.
 */
package com.sun.beans;

import com.sun.beans.WildcardTypeImpl;
import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.HashMap;
import java.util.Map;
import sun.reflect.generics.reflectiveObjects.GenericArrayTypeImpl;
import sun.reflect.generics.reflectiveObjects.ParameterizedTypeImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TypeResolver {
    private final Map<TypeVariable<?>, Type> map = new HashMap();

    public static Type resolveInClass(Class<?> clazz, Type type) {
        return TypeResolver.resolve(TypeResolver.getActualType(clazz), type);
    }

    public static Type[] resolveInClass(Class<?> clazz, Type[] typeArray) {
        return TypeResolver.resolve(TypeResolver.getActualType(clazz), typeArray);
    }

    public static Type resolve(Type type, Type type2) {
        return new TypeResolver(type).resolve(type2);
    }

    public static Type[] resolve(Type type, Type[] typeArray) {
        return new TypeResolver(type).resolve(typeArray);
    }

    public static Class<?> erase(Type type) {
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            return (Class)parameterizedType.getRawType();
        }
        if (type instanceof TypeVariable) {
            TypeVariable typeVariable = (TypeVariable)type;
            Type[] typeArray = typeVariable.getBounds();
            return 0 < typeArray.length ? TypeResolver.erase(typeArray[0]) : Object.class;
        }
        if (type instanceof WildcardType) {
            WildcardType wildcardType = (WildcardType)type;
            Type[] typeArray = wildcardType.getUpperBounds();
            return 0 < typeArray.length ? TypeResolver.erase(typeArray[0]) : Object.class;
        }
        if (type instanceof GenericArrayType) {
            GenericArrayType genericArrayType = (GenericArrayType)type;
            return Array.newInstance(TypeResolver.erase(genericArrayType.getGenericComponentType()), 0).getClass();
        }
        throw new IllegalArgumentException("Unknown Type kind: " + type.getClass());
    }

    public static Class[] erase(Type[] typeArray) {
        int n = typeArray.length;
        Class[] classArray = new Class[n];
        for (int i = 0; i < n; ++i) {
            classArray[i] = TypeResolver.erase(typeArray[i]);
        }
        return classArray;
    }

    private TypeResolver(Type type) {
        this.prepare(type);
    }

    private void prepare(Type type) {
        TypeVariable<Class<T>>[] typeVariableArray;
        Class clazz = (Class)(type instanceof Class ? type : ((ParameterizedType)type).getRawType());
        TypeVariable<Class<T>>[] typeVariableArray2 = clazz.getTypeParameters();
        Type[] typeArray = typeVariableArray = type instanceof Class ? typeVariableArray2 : ((ParameterizedType)type).getActualTypeArguments();
        assert (typeVariableArray2.length == typeVariableArray.length);
        for (int i = 0; i < typeVariableArray2.length; ++i) {
            this.map.put(typeVariableArray2[i], typeVariableArray[i]);
        }
        Type type2 = clazz.getGenericSuperclass();
        if (type2 != null) {
            this.prepare(type2);
        }
        for (Type type3 : clazz.getGenericInterfaces()) {
            this.prepare(type3);
        }
        if (type instanceof Class && typeVariableArray2.length > 0) {
            for (Map.Entry entry : this.map.entrySet()) {
                entry.setValue(TypeResolver.erase((Type)entry.getValue()));
            }
        }
    }

    private Type resolve(Type type) {
        if (type instanceof Class) {
            return type;
        }
        if (type instanceof GenericArrayType) {
            Type type2 = ((GenericArrayType)type).getGenericComponentType();
            return (type2 = this.resolve(type2)) instanceof Class ? Array.newInstance((Class)type2, 0).getClass() : GenericArrayTypeImpl.make(type2);
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            Type[] typeArray = this.resolve(parameterizedType.getActualTypeArguments());
            return ParameterizedTypeImpl.make((Class)parameterizedType.getRawType(), typeArray, parameterizedType.getOwnerType());
        }
        if (type instanceof WildcardType) {
            WildcardType wildcardType = (WildcardType)type;
            Type[] typeArray = this.resolve(wildcardType.getUpperBounds());
            Type[] typeArray2 = this.resolve(wildcardType.getLowerBounds());
            return new WildcardTypeImpl(typeArray, typeArray2);
        }
        if (!(type instanceof TypeVariable)) {
            throw new IllegalArgumentException("Bad Type kind: " + type.getClass());
        }
        Type type3 = this.map.get((TypeVariable)type);
        if (type3 == null || type3.equals(type)) {
            return type;
        }
        type3 = TypeResolver.fixGenericArray(type3);
        return this.resolve(type3);
    }

    private Type[] resolve(Type[] typeArray) {
        int n = typeArray.length;
        Type[] typeArray2 = new Type[n];
        for (int i = 0; i < n; ++i) {
            typeArray2[i] = this.resolve(typeArray[i]);
        }
        return typeArray2;
    }

    private static Type fixGenericArray(Type type) {
        if (type instanceof GenericArrayType) {
            Type type2 = ((GenericArrayType)type).getGenericComponentType();
            if ((type2 = TypeResolver.fixGenericArray(type2)) instanceof Class) {
                return Array.newInstance((Class)type2, 0).getClass();
            }
        }
        return type;
    }

    private static Type getActualType(Class<?> clazz) {
        Type[] typeArray = clazz.getTypeParameters();
        return typeArray.length == 0 ? clazz : ParameterizedTypeImpl.make(clazz, typeArray, clazz.getEnclosingClass());
    }
}

