/*
 * Decompiled with CFR 0.152.
 */
package sun.rmi.transport.tcp;

import java.io.IOException;
import java.io.OutputStream;
import sun.rmi.transport.tcp.ConnectionMultiplexer;
import sun.rmi.transport.tcp.MultiplexConnectionInfo;

final class MultiplexOutputStream
extends OutputStream {
    private ConnectionMultiplexer manager;
    private MultiplexConnectionInfo info;
    private byte[] buffer;
    private int pos = 0;
    private int requested = 0;
    private boolean disconnected = false;
    private Object lock = new Object();

    MultiplexOutputStream(ConnectionMultiplexer connectionMultiplexer, MultiplexConnectionInfo multiplexConnectionInfo, int n) {
        this.manager = connectionMultiplexer;
        this.info = multiplexConnectionInfo;
        this.buffer = new byte[n];
        this.pos = 0;
    }

    public synchronized void write(int n) throws IOException {
        while (this.pos >= this.buffer.length) {
            this.push();
        }
        this.buffer[this.pos++] = (byte)n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void write(byte[] byArray, int n, int n2) throws IOException {
        Object object;
        if (n2 <= 0) {
            return;
        }
        int n3 = this.buffer.length - this.pos;
        if (n2 <= n3) {
            System.arraycopy(byArray, n, this.buffer, this.pos, n2);
            this.pos += n2;
            return;
        }
        this.flush();
        while (true) {
            int n4;
            object = this.lock;
            synchronized (object) {
                while ((n4 = this.requested) < 1 && !this.disconnected) {
                    try {
                        this.lock.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
                if (this.disconnected) {
                    throw new IOException("Connection closed");
                }
            }
            if (n4 >= n2) break;
            this.manager.sendTransmit(this.info, byArray, n, n4);
            n += n4;
            n2 -= n4;
            object = this.lock;
            synchronized (object) {
                this.requested -= n4;
            }
        }
        this.manager.sendTransmit(this.info, byArray, n, n2);
        object = this.lock;
        synchronized (object) {
            this.requested -= n2;
        }
    }

    public synchronized void flush() throws IOException {
        while (this.pos > 0) {
            this.push();
        }
    }

    public void close() throws IOException {
        this.manager.sendClose(this.info);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void request(int n) {
        Object object = this.lock;
        synchronized (object) {
            this.requested += n;
            this.lock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void disconnect() {
        Object object = this.lock;
        synchronized (object) {
            this.disconnected = true;
            this.lock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void push() throws IOException {
        int n;
        Object object = this.lock;
        synchronized (object) {
            while ((n = this.requested) < 1 && !this.disconnected) {
                try {
                    this.lock.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            if (this.disconnected) {
                throw new IOException("Connection closed");
            }
        }
        if (n < this.pos) {
            this.manager.sendTransmit(this.info, this.buffer, 0, n);
            System.arraycopy(this.buffer, n, this.buffer, 0, this.pos - n);
            this.pos -= n;
            object = this.lock;
            synchronized (object) {
                this.requested -= n;
            }
        }
        this.manager.sendTransmit(this.info, this.buffer, 0, this.pos);
        object = this.lock;
        synchronized (object) {
            this.requested -= this.pos;
        }
        this.pos = 0;
    }
}

