/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text.html;

import java.awt.Polygon;
import java.io.Serializable;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.text.AttributeSet;
import javax.swing.text.html.HTML;

class Map
implements Serializable {
    private String name;
    private Vector<AttributeSet> areaAttributes;
    private Vector<RegionContainment> areas;

    public Map() {
    }

    public Map(String string) {
        this.name = string;
    }

    public String getName() {
        return this.name;
    }

    public void addArea(AttributeSet attributeSet) {
        if (attributeSet == null) {
            return;
        }
        if (this.areaAttributes == null) {
            this.areaAttributes = new Vector(2);
        }
        this.areaAttributes.addElement(attributeSet.copyAttributes());
    }

    public void removeArea(AttributeSet attributeSet) {
        if (attributeSet != null && this.areaAttributes != null) {
            int n = this.areas != null ? this.areas.size() : 0;
            for (int i = this.areaAttributes.size() - 1; i >= 0; --i) {
                if (!this.areaAttributes.elementAt(i).isEqual(attributeSet)) continue;
                this.areaAttributes.removeElementAt(i);
                if (i >= n) continue;
                this.areas.removeElementAt(i);
            }
        }
    }

    public AttributeSet[] getAreas() {
        int n;
        int n2 = n = this.areaAttributes != null ? this.areaAttributes.size() : 0;
        if (n != 0) {
            Object[] objectArray = new AttributeSet[n];
            this.areaAttributes.copyInto(objectArray);
            return objectArray;
        }
        return null;
    }

    public AttributeSet getArea(int n, int n2, int n3, int n4) {
        int n5;
        int n6 = n5 = this.areaAttributes != null ? this.areaAttributes.size() : 0;
        if (n5 > 0) {
            int n7;
            int n8 = n7 = this.areas != null ? this.areas.size() : 0;
            if (this.areas == null) {
                this.areas = new Vector(n5);
            }
            for (int i = 0; i < n5; ++i) {
                RegionContainment regionContainment;
                if (i >= n7) {
                    this.areas.addElement(this.createRegionContainment(this.areaAttributes.elementAt(i)));
                }
                if ((regionContainment = this.areas.elementAt(i)) == null || !regionContainment.contains(n, n2, n3, n4)) continue;
                return this.areaAttributes.elementAt(i);
            }
        }
        return null;
    }

    protected RegionContainment createRegionContainment(AttributeSet attributeSet) {
        Object object = attributeSet.getAttribute(HTML.Attribute.SHAPE);
        if (object == null) {
            object = "rect";
        }
        if (object instanceof String) {
            String string = ((String)object).toLowerCase();
            RegionContainment regionContainment = null;
            try {
                if (string.equals("rect")) {
                    regionContainment = new RectangleRegionContainment(attributeSet);
                } else if (string.equals("circle")) {
                    regionContainment = new CircleRegionContainment(attributeSet);
                } else if (string.equals("poly")) {
                    regionContainment = new PolygonRegionContainment(attributeSet);
                } else if (string.equals("default")) {
                    regionContainment = DefaultRegionContainment.sharedInstance();
                }
            }
            catch (RuntimeException runtimeException) {
                regionContainment = null;
            }
            return regionContainment;
        }
        return null;
    }

    protected static int[] extractCoords(Object object) {
        Object object2;
        if (object == null || !(object instanceof String)) {
            return null;
        }
        StringTokenizer stringTokenizer = new StringTokenizer((String)object, ", \t\n\r");
        Object object3 = null;
        int n = 0;
        while (stringTokenizer.hasMoreElements()) {
            int n2;
            object2 = stringTokenizer.nextToken();
            if (((String)object2).endsWith("%")) {
                n2 = -1;
                object2 = ((String)object2).substring(0, ((String)object2).length() - 1);
            } else {
                n2 = 1;
            }
            try {
                int n3 = Integer.parseInt((String)object2);
                if (object3 == null) {
                    object3 = new int[4];
                } else if (n == ((Object)object3).length) {
                    int[] nArray = new int[((Object)object3).length * 2];
                    System.arraycopy(object3, 0, nArray, 0, ((Object)object3).length);
                    object3 = nArray;
                }
                object3[n++] = n3 * n2;
            }
            catch (NumberFormatException numberFormatException) {
                return null;
            }
        }
        if (n > 0 && n != (object3).length) {
            object2 = new int[n];
            System.arraycopy(object3, 0, object2, 0, n);
            object3 = object2;
        }
        return object3;
    }

    static class DefaultRegionContainment
    implements RegionContainment {
        static DefaultRegionContainment si = null;

        DefaultRegionContainment() {
        }

        public static DefaultRegionContainment sharedInstance() {
            if (si == null) {
                si = new DefaultRegionContainment();
            }
            return si;
        }

        public boolean contains(int n, int n2, int n3, int n4) {
            return n <= n3 && n >= 0 && n2 >= 0 && n2 <= n3;
        }
    }

    static class CircleRegionContainment
    implements RegionContainment {
        int x;
        int y;
        int radiusSquared;
        float[] percentValues;
        int lastWidth;
        int lastHeight;

        public CircleRegionContainment(AttributeSet attributeSet) {
            int[] nArray = Map.extractCoords(attributeSet.getAttribute(HTML.Attribute.COORDS));
            if (nArray == null || nArray.length != 3) {
                throw new RuntimeException("Unable to parse circular area");
            }
            this.x = nArray[0];
            this.y = nArray[1];
            this.radiusSquared = nArray[2] * nArray[2];
            if (nArray[0] < 0 || nArray[1] < 0 || nArray[2] < 0) {
                this.lastHeight = -1;
                this.lastWidth = -1;
                this.percentValues = new float[3];
                for (int i = 0; i < 3; ++i) {
                    this.percentValues[i] = nArray[i] < 0 ? (float)nArray[i] / -100.0f : -1.0f;
                }
            } else {
                this.percentValues = null;
            }
        }

        public boolean contains(int n, int n2, int n3, int n4) {
            if (this.percentValues != null && (this.lastWidth != n3 || this.lastHeight != n4)) {
                int n5 = Math.min(n3, n4) / 2;
                this.lastWidth = n3;
                this.lastHeight = n4;
                if (this.percentValues[0] != -1.0f) {
                    this.x = (int)(this.percentValues[0] * (float)n3);
                }
                if (this.percentValues[1] != -1.0f) {
                    this.y = (int)(this.percentValues[1] * (float)n4);
                }
                if (this.percentValues[2] != -1.0f) {
                    this.radiusSquared = (int)(this.percentValues[2] * (float)Math.min(n3, n4));
                    this.radiusSquared *= this.radiusSquared;
                }
            }
            return (n - this.x) * (n - this.x) + (n2 - this.y) * (n2 - this.y) <= this.radiusSquared;
        }
    }

    static class PolygonRegionContainment
    extends Polygon
    implements RegionContainment {
        float[] percentValues;
        int[] percentIndexs;
        int lastWidth;
        int lastHeight;

        public PolygonRegionContainment(AttributeSet attributeSet) {
            int n;
            int[] nArray = Map.extractCoords(attributeSet.getAttribute(HTML.Attribute.COORDS));
            if (nArray == null || nArray.length == 0 || nArray.length % 2 != 0) {
                throw new RuntimeException("Unable to parse polygon area");
            }
            int n2 = 0;
            this.lastHeight = -1;
            this.lastWidth = -1;
            for (n = nArray.length - 1; n >= 0; --n) {
                if (nArray[n] >= 0) continue;
                ++n2;
            }
            if (n2 > 0) {
                this.percentIndexs = new int[n2];
                this.percentValues = new float[n2];
                int n3 = 0;
                for (n = nArray.length - 1; n >= 0; --n) {
                    if (nArray[n] >= 0) continue;
                    this.percentValues[n3] = (float)nArray[n] / -100.0f;
                    this.percentIndexs[n3] = n;
                    ++n3;
                }
            } else {
                this.percentIndexs = null;
                this.percentValues = null;
            }
            this.npoints = nArray.length / 2;
            this.xpoints = new int[this.npoints];
            this.ypoints = new int[this.npoints];
            for (n = 0; n < this.npoints; ++n) {
                this.xpoints[n] = nArray[n + n];
                this.ypoints[n] = nArray[n + n + 1];
            }
        }

        public boolean contains(int n, int n2, int n3, int n4) {
            if (this.percentValues == null || this.lastWidth == n3 && this.lastHeight == n4) {
                return this.contains(n, n2);
            }
            this.bounds = null;
            this.lastWidth = n3;
            this.lastHeight = n4;
            float f = n3;
            float f2 = n4;
            for (int i = this.percentValues.length - 1; i >= 0; --i) {
                if (this.percentIndexs[i] % 2 == 0) {
                    this.xpoints[this.percentIndexs[i] / 2] = (int)(this.percentValues[i] * f);
                    continue;
                }
                this.ypoints[this.percentIndexs[i] / 2] = (int)(this.percentValues[i] * f2);
            }
            return this.contains(n, n2);
        }
    }

    static class RectangleRegionContainment
    implements RegionContainment {
        float[] percents;
        int lastWidth;
        int lastHeight;
        int x0;
        int y0;
        int x1;
        int y1;

        public RectangleRegionContainment(AttributeSet attributeSet) {
            int[] nArray = Map.extractCoords(attributeSet.getAttribute(HTML.Attribute.COORDS));
            this.percents = null;
            if (nArray == null || nArray.length != 4) {
                throw new RuntimeException("Unable to parse rectangular area");
            }
            this.x0 = nArray[0];
            this.y0 = nArray[1];
            this.x1 = nArray[2];
            this.y1 = nArray[3];
            if (this.x0 < 0 || this.y0 < 0 || this.x1 < 0 || this.y1 < 0) {
                this.percents = new float[4];
                this.lastHeight = -1;
                this.lastWidth = -1;
                for (int i = 0; i < 4; ++i) {
                    this.percents[i] = nArray[i] < 0 ? (float)Math.abs(nArray[i]) / 100.0f : -1.0f;
                }
            }
        }

        public boolean contains(int n, int n2, int n3, int n4) {
            if (this.percents == null) {
                return this.contains(n, n2);
            }
            if (this.lastWidth != n3 || this.lastHeight != n4) {
                this.lastWidth = n3;
                this.lastHeight = n4;
                if (this.percents[0] != -1.0f) {
                    this.x0 = (int)(this.percents[0] * (float)n3);
                }
                if (this.percents[1] != -1.0f) {
                    this.y0 = (int)(this.percents[1] * (float)n4);
                }
                if (this.percents[2] != -1.0f) {
                    this.x1 = (int)(this.percents[2] * (float)n3);
                }
                if (this.percents[3] != -1.0f) {
                    this.y1 = (int)(this.percents[3] * (float)n4);
                }
            }
            return this.contains(n, n2);
        }

        public boolean contains(int n, int n2) {
            return n >= this.x0 && n <= this.x1 && n2 >= this.y0 && n2 <= this.y1;
        }
    }

    static interface RegionContainment {
        public boolean contains(int var1, int var2, int var3, int var4);
    }
}

