
/*
 * hfs.h
 *
 *   July 10, 1994 -- Lawrence Kesteloot
 */

/*
 * Physical block size of HFS partitions.  Not to be confused with
 * hfsVolumeInfo's drAlBlkSiz, which is the allocation block size.
 */

#define BLKSIZ		512

/*
 * Volume information.  This structure is located on the third physical
 * block of the partition.
 */

struct hfsVolumeInfo {
	ushort	drSigWord;
	ulong	drCrDate;
	ulong	drLsMod;
	ushort	drAtrb;
	ushort	drNmFls;
	ushort	drVBMSt;
	ushort	drAllocPtr;
	ushort	drNmAlBlks;
	ulong	drAlBlkSiz;
	ulong	drClpSiz;
	ushort	drAlBlSt;
	ulong	drNxtCNID;
	ushort	drFreeBks;
	uchar	drVN;
	uchar	drVolName[27];
	ulong	drVolBkUp;
	ushort	drVSeqNum;
	ulong	drWrCnt;
	ulong	drXTClpSiz;
	ulong	drCTClpSiz;
	ushort	drNmRtDirs;
	ulong	drFilCnt;
	ulong	drDirCnt;
	uchar	drFndrInfo[32];
	ushort	drVCSize;
	ushort	drVCBMSize;
	ushort	drCtlCSize;
	ulong	drXTFlSize;
	uchar	drXTExtRec[12];
	ulong	drCTFlSize;
	uchar	drCTExtRec[12];
};

/*
 * Directory information.  This structure comes short-word aligned right
 * after the key in the catalog tree for records that correspond to
 * directories.
 */

struct hfsDirInfo {
	uchar	cdrType; /* 1 */
	uchar	cdrResrv2;
	ushort	dirFlags;
	ushort	dirVal;
	ulong	dirDirID;
	ulong	dirCrDat;
	ulong	dirMdDat;
	ulong	dirBkDat;
	uchar	dirUsrInfo[16];
	uchar	dirFndrInfo[16];
	uchar	dirResrv[16];
};

/*
 * File information.  This structure comes short-word aligned right after
 * the key in the catalog tree for records that correspond to files.
 */

struct hfsFileInfo {
	uchar	cdrType;    /* 2 */
	uchar	cdrResrv2;
	uchar	filFlags;
	uchar	filTyp;
	uchar	filUsrWds[16];
	ulong	filFlNum;
	ushort	filStBlk;
	ulong	filLgLen;
	ulong	filPyLen;
	ushort	filRStBlk;
	ulong	filRLgLen;
	ulong	filRPyLen;
	ulong	filCrDat;
	ulong	filMdDat;
	ulong	filBkDat;
	uchar	filFndrInfo[16];
	ushort	filClpSize;
	ushort	filExtRec[6];
	ushort	filRExtRec[6];
	ulong	filResrv;
};

/*
 * Thread information.  This structure comes short-word aligned right after
 * the key in the catalog tree for records that correspond to threads.
 */

struct hfsThreadInfo {
	uchar	cdrType; /* 3 */
	uchar	cdrResrv2;
	uchar	thdResrv[8];
	ulong	thdParID;
	uchar	thdNameLen;
	uchar	thdCName[32];
};

/*
 * Entry info.  This structure does not appear on the disk -- it's only
 * for the "hfs" program.  For each entry (file, directory, or thread),
 * we keep the block number of its record in the catalog tree, the
 * record into that block, how many entries after this one there are
 * in the current directory, the name, and the information on the entry.
 */

struct hfsEntryInfo {
	ulong	blk;			/* Logical block in tree	*/
	ulong	rec;			/* Record in the block		*/
	ulong	left;			/* Number of entries left	*/
	uchar	name[64];		/* Pointer to name		*/
	union {
		uchar			filetype;
		struct hfsFileInfo	fil;
		struct hfsDirInfo	dir;
		struct hfsThreadInfo	thd;
	} info;
};

int hfsGetVolumeInfo (char *fn, struct hfsVolumeInfo *vi);
int hfsGetRootDir (int f, int ctblk, char *partname, struct hfsEntryInfo *ei);
int hfsGetRecord (int f, int ctblk, struct hfsEntryInfo *ei);
int hfsGetFirst (int f, int ctblk, struct hfsEntryInfo *ei);
int hfsGetNext (int f, int ctblk, struct hfsEntryInfo *ei);
void hfsDump (int f, int blk);
int hfsReadBlock (int f, struct hfsVolumeInfo *vi, int xtblk,
	struct hfsEntryInfo *ei, void *buf, int blknum);
int hfsRead (int f, struct hfsVolumeInfo *vi, int xtblk,
	struct hfsEntryInfo *ei, void *buf, int loc, int len);

extern int	debug;
#define dprintf if (debug) printf
