/*	$NetBSD: nouveau_ttm.h,v 1.3 2018/08/27 04:58:24 riastradh Exp $	*/

#ifndef __NOUVEAU_TTM_H__
#define __NOUVEAU_TTM_H__

static inline struct nouveau_drm *
nouveau_bdev(struct ttm_bo_device *bd)
{
	return container_of(bd, struct nouveau_drm, ttm.bdev);
}

extern const struct ttm_mem_type_manager_func nouveau_vram_manager;
extern const struct ttm_mem_type_manager_func nouveau_gart_manager;
extern const struct ttm_mem_type_manager_func nv04_gart_manager;

struct ttm_tt *nouveau_sgdma_create_ttm(struct ttm_bo_device *,
					unsigned long size, u32 page_flags,
					struct page *dummy_read_page);

int  nouveau_ttm_init(struct nouveau_drm *drm);
void nouveau_ttm_fini(struct nouveau_drm *drm);
#ifdef __NetBSD__
int  nouveau_ttm_mmap_object(struct drm_device *, off_t, size_t, vm_prot_t,
	    struct uvm_object **, voff_t *, struct file *);
#else
int  nouveau_ttm_mmap(struct file *, struct vm_area_struct *);
#endif

int  nouveau_ttm_global_init(struct nouveau_drm *);
void nouveau_ttm_global_release(struct nouveau_drm *);

#endif
