/*	$NetBSD: imx6_mmdcreg.h,v 1.1 2014/09/25 05:05:28 ryo Exp $	*/

/*
 * Copyright (c) 2014 Ryo Shimizu <ryo@nerv.org>
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
 * IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */
#ifndef _ARM_IMX_IMX6_MMDCREG_H_
#define _ARM_IMX_IMX6_MMDCREG_H_

#include <sys/cdefs.h>

#define MMDC1_MDCTL			0x00000000
#define  MMDC1_MDCTL_SDE_0		__BIT(31)
#define  MMDC1_MDCTL_SDE_1		__BIT(30)
#define  MMDC1_MDCTL_ROW		__BITS(26, 24)
#define  MMDC1_MDCTL_COL		__BITS(22, 20)
#define  MMDC1_MDCTL_BL			__BIT(19)
#define  MMDC1_MDCTL_DSIZ		__BITS(17, 16)
#define MMDC1_MDPDC			0x00000004
#define MMDC1_MDOTC			0x00000008
#define MMDC1_MDCFG0			0x0000000c
#define MMDC1_MDCFG1			0x00000010
#define MMDC1_MDCFG2			0x00000014
#define MMDC1_MDMISC			0x00000018
#define  MMDC1_MDMISC_CS0_RDY		__BIT(31)
#define  MMDC1_MDMISC_CS1_RDY		__BIT(30)
#define  MMDC1_MDMISC_CALIB_PER_CS	__BIT(20)
#define  MMDC1_MDMISC_ADDR_MIRROR	__BIT(19)
#define  MMDC1_MDMISC_LHD		__BIT(18)
#define  MMDC1_MDMISC_WALAT		__BITS(17, 16)
#define  MMDC1_MDMISC_BI_ON		__BIT(12)
#define  MMDC1_MDMISC_LPDDR2_S2		__BIT(11)
#define  MMDC1_MDMISC_MIF3_MODE		__BITS(10, 9)
#define  MMDC1_MDMISC_RALAT		__BITS(8, 6)
#define  MMDC1_MDMISC_DDR_4_BANK	__BIT(5)
#define  MMDC1_MDMISC_DDR_TYPE		__BITS(4, 3)
#define  MMDC1_MDMISC_LPDDR2_2CH	__BIT(2)
#define  MMDC1_MDMISC_RST		__BIT(1)
#define MMDC1_MDSCR			0x0000001c
#define MMDC1_MDREF			0x00000020
#define MMDC1_MDRWD			0x0000002c
#define MMDC1_MDOR			0x00000030
#define MMDC1_MDMRR			0x00000034
#define MMDC1_MDCFG3LP			0x00000038
#define MMDC1_MDMR4			0x0000003c
#define MMDC1_MDASP			0x00000040
#define MMDC1_MAARCR			0x00000400
#define MMDC1_MAPSR			0x00000404
#define MMDC1_MAEXIDR0			0x00000408
#define MMDC1_MAEXIDR1			0x0000040c
#define MMDC1_MADPCR0			0x00000410
#define MMDC1_MADPCR1			0x00000414
#define MMDC1_MADPSR0			0x00000418
#define MMDC1_MADPSR1			0x0000041c
#define MMDC1_MADPSR2			0x00000420
#define MMDC1_MADPSR3			0x00000424
#define MMDC1_MADPSR4			0x00000428
#define MMDC1_MADPSR5			0x0000042c
#define MMDC1_MASBS0			0x00000430
#define MMDC1_MASBS1			0x00000434
#define MMDC1_MAGENP			0x00000440
#define MMDC1_MPZQHWCTRL		0x00000800
#define MMDC1_MPZQSWCTRL		0x00000804
#define MMDC1_MPWLGCR			0x00000808
#define MMDC1_MPWLDECTRL0		0x0000080c
#define MMDC1_MPWLDECTRL1		0x00000810
#define MMDC1_MPWLDLST			0x00000814
#define MMDC1_MPODTCTRL			0x00000818
#define MMDC1_MPRDDQBY0DL		0x0000081c
#define MMDC1_MPRDDQBY1DL		0x00000820
#define MMDC1_MPRDDQBY2DL		0x00000824
#define MMDC1_MPRDDQBY3DL		0x00000828
#define MMDC1_MPWRDQBY0DL		0x0000082c
#define MMDC1_MPWRDQBY1DL		0x00000830
#define MMDC1_MPWRDQBY2DL		0x00000834
#define MMDC1_MPWRDQBY3DL		0x00000838
#define MMDC1_MPDGCTRL0			0x0000083c
#define MMDC1_MPDGCTRL1			0x00000840
#define MMDC1_MPDGDLST0			0x00000844
#define MMDC1_MPRDDLCTL			0x00000848
#define MMDC1_MPRDDLST			0x0000084c
#define MMDC1_MPWRDLCTL			0x00000850
#define MMDC1_MPWRDLST			0x00000854
#define MMDC1_MPSDCTRL			0x00000858
#define MMDC1_MPZQLP2CTL		0x0000085c
#define MMDC1_MPRDDLHWCTL		0x00000860
#define MMDC1_MPWRDLHWCTL		0x00000864
#define MMDC1_MPRDDLHWST0		0x00000868
#define MMDC1_MPRDDLHWST1		0x0000086c
#define MMDC1_MPWRDLHWST0		0x00000870
#define MMDC1_MPWRDLHWST1		0x00000874
#define MMDC1_MPWLHWERR			0x00000878
#define MMDC1_MPDGHWST0			0x0000087c
#define MMDC1_MPDGHWST1			0x00000880
#define MMDC1_MPDGHWST2			0x00000884
#define MMDC1_MPDGHWST3			0x00000888
#define MMDC1_MPPDCMPR1			0x0000088c
#define MMDC1_MPPDCMPR2			0x00000890
#define MMDC1_MPSWDAR0			0x00000894
#define MMDC1_MPSWDRDR0			0x00000898
#define MMDC1_MPSWDRDR1			0x0000089c
#define MMDC1_MPSWDRDR2			0x000008a0
#define MMDC1_MPSWDRDR3			0x000008a4
#define MMDC1_MPSWDRDR4			0x000008a8
#define MMDC1_MPSWDRDR5			0x000008ac
#define MMDC1_MPSWDRDR6			0x000008b0
#define MMDC1_MPSWDRDR7			0x000008b4
#define MMDC1_MPMUR0			0x000008b8
#define MMDC1_MPWRCADL			0x000008bc
#define MMDC1_MPDCCR			0x000008c0
#define MMDC2_MDCTL			0x00004000
#define MMDC2_MDPDC			0x00004004
#define MMDC2_MDOTC			0x00004008
#define MMDC2_MDCFG0			0x0000400c
#define MMDC2_MDCFG1			0x00004010
#define MMDC2_MDCFG2			0x00004014
#define MMDC2_MDMISC			0x00004018
#define MMDC2_MDSCR			0x0000401c
#define MMDC2_MDREF			0x00004020
#define MMDC2_MDRWD			0x0000402c
#define MMDC2_MDOR			0x00004030
#define MMDC2_MDMRR			0x00004034
#define MMDC2_MDCFG3LP			0x00004038
#define MMDC2_MDMR4			0x0000403c
#define MMDC2_MDASP			0x00004040
#define MMDC2_MAARCR			0x00004400
#define MMDC2_MAPSR			0x00004404
#define MMDC2_MAEXIDR0			0x00004408
#define MMDC2_MAEXIDR1			0x0000440c
#define MMDC2_MADPCR0			0x00004410
#define MMDC2_MADPCR1			0x00004414
#define MMDC2_MADPSR0			0x00004418
#define MMDC2_MADPSR1			0x0000441c
#define MMDC2_MADPSR2			0x00004420
#define MMDC2_MADPSR3			0x00004424
#define MMDC2_MADPSR4			0x00004428
#define MMDC2_MADPSR5			0x0000442c
#define MMDC2_MASBS0			0x00004430
#define MMDC2_MASBS1			0x00004434
#define MMDC2_MAGENP			0x00004440
#define MMDC2_MPZQHWCTRL		0x00004800
#define MMDC2_MPZQSWCTRL		0x00004804
#define MMDC2_MPWLGCR			0x00004808
#define MMDC2_MPWLDECTRL0		0x0000480c
#define MMDC2_MPWLDECTRL1		0x00004810
#define MMDC2_MPWLDLST			0x00004814
#define MMDC2_MPODTCTRL			0x00004818
#define MMDC2_MPRDDQBY0DL		0x0000481c
#define MMDC2_MPRDDQBY1DL		0x00004820
#define MMDC2_MPRDDQBY2DL		0x00004824
#define MMDC2_MPRDDQBY3DL		0x00004828
#define MMDC2_MPWRDQBY0DL		0x0000482c
#define MMDC2_MPWRDQBY1DL		0x00004830
#define MMDC2_MPWRDQBY2DL		0x00004834
#define MMDC2_MPWRDQBY3DL		0x00004838
#define MMDC2_MPDGCTRL0			0x0000483c
#define MMDC2_MPDGCTRL1			0x00004840
#define MMDC2_MPDGDLST0			0x00004844
#define MMDC2_MPRDDLCTL			0x00004848
#define MMDC2_MPRDDLST			0x0000484c
#define MMDC2_MPWRDLCTL			0x00004850
#define MMDC2_MPWRDLST			0x00004854
#define MMDC2_MPSDCTRL			0x00004858
#define MMDC2_MPZQLP2CTL		0x0000485c
#define MMDC2_MPRDDLHWCTL		0x00004860
#define MMDC2_MPWRDLHWCTL		0x00004864
#define MMDC2_MPRDDLHWST0		0x00004868
#define MMDC2_MPRDDLHWST1		0x0000486c
#define MMDC2_MPWRDLHWST0		0x00004870
#define MMDC2_MPWRDLHWST1		0x00004874
#define MMDC2_MPWLHWERR			0x00004878
#define MMDC2_MPDGHWST0			0x0000487c
#define MMDC2_MPDGHWST1			0x00004880
#define MMDC2_MPDGHWST2			0x00004884
#define MMDC2_MPDGHWST3			0x00004888
#define MMDC2_MPPDCMPR1			0x0000488c
#define MMDC2_MPPDCMPR2			0x00004890
#define MMDC2_MPSWDAR0			0x00004894
#define MMDC2_MPSWDRDR0			0x00004898
#define MMDC2_MPSWDRDR1			0x0000489c
#define MMDC2_MPSWDRDR2			0x000048a0
#define MMDC2_MPSWDRDR3			0x000048a4
#define MMDC2_MPSWDRDR4			0x000048a8
#define MMDC2_MPSWDRDR5			0x000048ac
#define MMDC2_MPSWDRDR6			0x000048b0
#define MMDC2_MPSWDRDR7			0x000048b4
#define MMDC2_MPMUR0			0x000048b8
#define MMDC2_MPWRCADL			0x000048bc
#define MMDC2_MPDCCR			0x000048c0

#endif /* _ARM_IMX_IMX6_MMDCREG_H_ */
