/*	$NetBSD: zl10353reg.h,v 1.2 2011/08/29 11:16:36 jruoho Exp $ */

/*-
 * Copyright (c) 2011 The NetBSD Foundation, Inc.
 * All rights reserved.
 *
 * This code is derived from software contributed to The NetBSD Foundation
 * by Jukka Ruohonen.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */
#ifndef _DEV_I2C_ZL10353REG_H_
#define _DEV_I2C_ZL10353REG_H_

#define ZL10353_DEFAULT_CLOCK_MHZ		450560	/* 45.056 MHz */
#define ZL10353_DEFAULT_INPUT_FREQ		 52606

#define ZL10353_REG_STATUS_LOCK			0x0006
#define		ZL10353_STATUS_LOCK_ON		0x0020
#define		ZL10353_STATUS_LOCK_VITERBI	0x0002
#define		ZL10353_STATUS_LOCK_CARRIER	0x0004

#define ZL10353_REG_STATUS_SYNC			0x0007
#define		ZL10353_STATUS_SYNC_ON		0x0010

#define ZL10353_REG_STATUS_SIGNAL		0x0008
#define		ZL10353_STATUS_SIGNAL_ON	0x0040

#define ZL10353_REG_SIGSTR_1			0x000a
#define ZL10353_REG_SIGSTR_2			0x000b
#define ZL10353_REG_SNR				0x0010

#define ZL10353_REG_GATE			0x0062
#define		ZL10353_GATE_ENABLE		0x001a
#define		ZL10353_GATE_DISABLE		0x000a

#define ZL10353_REG_AGC_TARGET			0x0056
#define		ZL10353_AGC_TARGET_DEFAULT	0x0028

#define ZL10353_REG_AGC_CTRL			0x005e
#define		ZL10353_AGC_CTRL_MODE_NONAUTO	0x0001
#define		ZL10353_AGC_CTRL_GUARD_NONAUTO	0x0002

#define	ZL10353_REG_BW_1			0x005c
#define		ZL10353_BW_1_6_MHZ		0x0097
#define		ZL10353_BW_1_7_MHZ		0x0086
#define		ZL10353_BW_1_8_MHZ		0x0075

#define	ZL10353_REG_BW_2			0x0064
#define		ZL10353_BW_2_6_MHZ		0x0034
#define		ZL10353_BW_2_7_MHZ		0x0035
#define		ZL10353_BW_2_8_MHZ		0x0036

#define	ZL10353_REG_BW_3			0x00cc
#define		ZL10353_BW_3_6_MHZ		0x00dd
#define		ZL10353_BW_3_7_MHZ		0x0073
#define		ZL10353_BW_3_8_MHZ		0x0073

#define ZL10353_REG_RATE_1			0x0065
#define ZL10353_REG_RATE_2			0x0066
#define ZL10353_REG_FREQ_1			0x006c
#define ZL10353_REG_FREQ_2			0x006d

#define ZL10353_REG_TPS_1			0x006e
#define	ZL10353_REG_TPS_2			0x006f
#define		ZL10353_TPS_GUARD_1_4		0x000c
#define		ZL10353_TPS_GUARD_1_8		0x0008
#define		ZL10353_TPS_GUARD_1_16		0x0004
#define		ZL10353_TPS_GUARD_1_32		0x0000
#define		ZL10353_TPS_GUARD_AUTO		0x0000
#define		ZL10353_TPS_MODE_2K		0x0000
#define		ZL10353_TPS_MODE_8K		0x0001
#define		ZL10353_TPS_MODE_AUTO		0x0000
#define		ZL10353_TPS_MODULATION_QPSK	0x0000
#define		ZL10353_TPS_MODULATION_QAM_16	0x2000
#define		ZL10353_TPS_MODULATION_QAM_64	0x4000
#define		ZL10353_TPS_MODULATION_QAM_AUTO	0x2000
#define		ZL10353_TPS_HIERARCHY_1		0x0400
#define		ZL10353_TPS_HIERARCHY_2		0x0800
#define		ZL10353_TPS_HIERARCHY_4		0x0c00
#define		ZL10353_TPS_HIERARCHY_NONE	0x0000
#define		ZL10353_TPS_HIERARCHY_AUTO	0x0000
#define		ZL10353_TPS_HP_FEC_1_2		0x0000
#define		ZL10353_TPS_HP_FEC_2_3		0x0080
#define		ZL10353_TPS_HP_FEC_3_4		0x0100
#define		ZL10353_TPS_HP_FEC_5_6		0x0180
#define		ZL10353_TPS_HP_FEC_7_8		0x0200
#define		ZL10353_TPS_HP_FEC_AUTO		0x0000
#define		ZL10353_TPS_LP_FEC_1_2		0x0000
#define		ZL10353_TPS_LP_FEC_2_3		0x0010
#define		ZL10353_TPS_LP_FEC_3_4		0x0020
#define		ZL10353_TPS_LP_FEC_5_6		0x0030
#define		ZL10353_TPS_LP_FEC_7_8		0x0040
#define		ZL10353_TPS_LP_FEC_AUTO		0x0000

#define	ZL10353_REG_FSM				0x0071
#define		ZL10353_FSM_START		0x0001

#define	ZL10353_REG_ID				0x007f
#define		ZL10353_ID_ZL10353		0x0014
#define		ZL10353_ID_CE6230		0x0018
#define		ZL10353_ID_CE6231		0x0019

#endif	/* !_DEV_I2C_ZL10353REG_H */
