/*	$NetBSD: vr4181giureg.h,v 1.2 2003/05/01 07:02:05 igy Exp $	*/

/*-
 * Copyright (c) 2002 SATO Kazumi. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of the project nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */

/*
 *	VR4181 GIU (General Purpose I/O Unit) Registers.
 */
#define VR4181GIU_NO_REG_W		0xffffffff	/* no register */

#define VR4181GIU_MODE0_REG		0x00
#define VR4181GIU_MODE0_REG_W		0x00
#define VR4181GIU_MODE1_REG_W		0x02
#define VR4181GIU_MODE2_REG_W		0x04
#define VR4181GIU_MODE3_REG_W		0x06

#define	VR4181GIU_MODE_GPIO		0x0
#define	VR4181GIU_MODE_ALT		0x1
/* VR4181GIU_MODE_GPIO */
#define	VR4181GIU_MODE_IN		0x0
#define	VR4181GIU_MODE_OUT		0x2
/* VR4181GIU_MODE_ALT */
#define	VR4181GIU_MODE_ALT1		0x0
#define	VR4181GIU_MODE_ALT2		0x2

#define  GP0_GPI	((VR4181GIU_MODE_IN  | VR4181GIU_MODE_GPIO) <<  0)
#define  GP0_CSISI	((VR4181GIU_MODE_IN  | VR4181GIU_MODE_ALT ) <<  0)
#define  GP0_GPO	((VR4181GIU_MODE_OUT | VR4181GIU_MODE_GPIO) <<  0)
#define  GP1_GPI	((VR4181GIU_MODE_IN  | VR4181GIU_MODE_GPIO) <<  2)
#define  GP1_GPO	((VR4181GIU_MODE_OUT | VR4181GIU_MODE_GPIO) <<  2)
#define  GP1_CSISO	((VR4181GIU_MODE_OUT | VR4181GIU_MODE_ALT ) <<  2)
#define  GP2_GPI	((VR4181GIU_MODE_IN  | VR4181GIU_MODE_GPIO) <<  4)
#define  GP2_CSICK	((VR4181GIU_MODE_IN  | VR4181GIU_MODE_ALT ) <<  4)
#define  GP2_GPO	((VR4181GIU_MODE_OUT | VR4181GIU_MODE_GPIO) <<  4)
#define  GP3_GPI	((VR4181GIU_MODE_IN  | VR4181GIU_MODE_GPIO) <<  6)
#define  GP3_GPO	((VR4181GIU_MODE_OUT | VR4181GIU_MODE_GPIO) <<  6)
#define  GP3_PCS0	((VR4181GIU_MODE_OUT | VR4181GIU_MODE_ALT ) <<  6)
#define  GP4_GPI	((VR4181GIU_MODE_IN  | VR4181GIU_MODE_GPIO) <<  8)
#define  GP4_GPO	((VR4181GIU_MODE_OUT | VR4181GIU_MODE_GPIO) <<  8)
#define  GP5_GPI	((VR4181GIU_MODE_IN  | VR4181GIU_MODE_GPIO) << 10)
#define  GP5_GPO	((VR4181GIU_MODE_OUT | VR4181GIU_MODE_GPIO) << 10)
#define  GP5_DCD2	((VR4181GIU_MODE_OUT | VR4181GIU_MODE_ALT ) << 10)
#define  GP6_GPI	((VR4181GIU_MODE_IN  | VR4181GIU_MODE_GPIO) << 12)
#define  GP6_GPO	((VR4181GIU_MODE_OUT | VR4181GIU_MODE_GPIO) << 12)
#define  GP6_RTS2	((VR4181GIU_MODE_OUT | VR4181GIU_MODE_ALT ) << 12)
#define  GP7_GPI	((VR4181GIU_MODE_IN  | VR4181GIU_MODE_GPIO) << 14)
#define  GP7_GPO	((VR4181GIU_MODE_OUT | VR4181GIU_MODE_GPIO) << 14)
#define  GP7_DTR2	((VR4181GIU_MODE_OUT | VR4181GIU_MODE_ALT ) << 14)
#define  GP8_GPI	((VR4181GIU_MODE_IN  | VR4181GIU_MODE_GPIO) <<  0)
#define  GP8_GPO	((VR4181GIU_MODE_OUT | VR4181GIU_MODE_GPIO) <<  0)
#define  GP8_DSR2	((VR4181GIU_MODE_OUT | VR4181GIU_MODE_ALT ) <<  0)
#define  GP9_GPI	((VR4181GIU_MODE_IN  | VR4181GIU_MODE_GPIO) <<  2)
#define  GP9_GPO	((VR4181GIU_MODE_OUT | VR4181GIU_MODE_GPIO) <<  2)
#define  GP9_CTS2	((VR4181GIU_MODE_OUT | VR4181GIU_MODE_ALT ) <<  2)
#define  GP10_GPI	((VR4181GIU_MODE_IN  | VR4181GIU_MODE_GPIO) <<  4)
#define  GP10_CSIFRM	((VR4181GIU_MODE_IN  | VR4181GIU_MODE_ALT ) <<  4)
#define  GP10_GPO	((VR4181GIU_MODE_OUT | VR4181GIU_MODE_GPIO) <<  4)
#define  GP10_SYSCLK	((VR4181GIU_MODE_OUT | VR4181GIU_MODE_ALT ) <<  4)
#define  GP11_GPI	((VR4181GIU_MODE_IN  | VR4181GIU_MODE_GPIO) <<  6)
#define  GP11_GPO	((VR4181GIU_MODE_OUT | VR4181GIU_MODE_GPIO) <<  6)
#define  GP11_PCS1	((VR4181GIU_MODE_OUT | VR4181GIU_MODE_ALT ) <<  6)
#define  GP12_GPI	((VR4181GIU_MODE_IN  | VR4181GIU_MODE_GPIO) <<  8)
#define  GP12_GPO	((VR4181GIU_MODE_OUT | VR4181GIU_MODE_GPIO) <<  8)
#define  GP12_LCDFPD4	((VR4181GIU_MODE_OUT | VR4181GIU_MODE_ALT ) <<  8)
#define  GP13_GPI	((VR4181GIU_MODE_IN  | VR4181GIU_MODE_GPIO) << 10)
#define  GP13_GPO	((VR4181GIU_MODE_OUT | VR4181GIU_MODE_GPIO) << 10)
#define  GP13_LCDPFD5	((VR4181GIU_MODE_OUT | VR4181GIU_MODE_ALT ) << 10)
#define  GP14_GPI	((VR4181GIU_MODE_IN  | VR4181GIU_MODE_GPIO) << 12)
#define  GP14_CD1	((VR4181GIU_MODE_IN  | VR4181GIU_MODE_ALT ) << 12)
#define  GP14_GPO	((VR4181GIU_MODE_OUT | VR4181GIU_MODE_GPIO) << 12)
#define  GP14_LCDPFD6	((VR4181GIU_MODE_OUT | VR4181GIU_MODE_ALT ) << 12)
#define  GP15_GPI	((VR4181GIU_MODE_IN  | VR4181GIU_MODE_GPIO) << 14)
#define  GP15_CD2	((VR4181GIU_MODE_IN  | VR4181GIU_MODE_ALT ) << 14)
#define  GP15_GPO	((VR4181GIU_MODE_OUT | VR4181GIU_MODE_GPIO) << 14)
#define  GP15_LCDFPD7	((VR4181GIU_MODE_OUT | VR4181GIU_MODE_ALT ) << 14)
#define  GP16_GPI	((VR4181GIU_MODE_IN  | VR4181GIU_MODE_GPIO) <<  0)
#define  GP16_GPO	((VR4181GIU_MODE_OUT | VR4181GIU_MODE_GPIO) <<  0)
#define  GP16_IORD	((VR4181GIU_MODE_OUT | VR4181GIU_MODE_ALT ) <<  0)
#define  GP17_GPI	((VR4181GIU_MODE_IN  | VR4181GIU_MODE_GPIO) <<  2)
#define  GP17_GPO	((VR4181GIU_MODE_OUT | VR4181GIU_MODE_GPIO) <<  2)
#define  GP17_IOWR	((VR4181GIU_MODE_OUT | VR4181GIU_MODE_ALT ) <<  2)
#define  GP18_GPI	((VR4181GIU_MODE_IN  | VR4181GIU_MODE_GPIO) <<  4)
#define  GP18_IORDY	((VR4181GIU_MODE_IN  | VR4181GIU_MODE_ALT ) <<  4)
#define  GP18_GPO	((VR4181GIU_MODE_OUT | VR4181GIU_MODE_GPIO) <<  4)
#define  GP19_GPI	((VR4181GIU_MODE_IN  | VR4181GIU_MODE_GPIO) <<  6)
#define  GP19_GPO	((VR4181GIU_MODE_OUT | VR4181GIU_MODE_GPIO) <<  6)
#define  GP19_IOCS16	((VR4181GIU_MODE_OUT | VR4181GIU_MODE_ALT ) <<  6)
#define  GP20_GPI	((VR4181GIU_MODE_IN  | VR4181GIU_MODE_GPIO) <<  8)
#define  GP20_LCDM	((VR4181GIU_MODE_OUT | VR4181GIU_MODE_GPIO) <<  8)
#define  GP20_UBE	((VR4181GIU_MODE_OUT | VR4181GIU_MODE_ALT ) <<  8)
#define  GP21_GPI	((VR4181GIU_MODE_IN  | VR4181GIU_MODE_GPIO) << 10)
#define  GP21_GPO	((VR4181GIU_MODE_OUT | VR4181GIU_MODE_GPIO) << 10)
#define  GP21_RESET	((VR4181GIU_MODE_OUT | VR4181GIU_MODE_ALT ) << 10)
#define  GP22_GPI	((VR4181GIU_MODE_IN  | VR4181GIU_MODE_GPIO) << 12)
#define  GP22_GPO	((VR4181GIU_MODE_OUT | VR4181GIU_MODE_GPIO) << 12)
#define  GP22_ROMCS0	((VR4181GIU_MODE_OUT | VR4181GIU_MODE_ALT ) << 12)
#define  GP23_GPI	((VR4181GIU_MODE_IN  | VR4181GIU_MODE_GPIO) << 14)
#define  GP23_GPO	((VR4181GIU_MODE_OUT | VR4181GIU_MODE_GPIO) << 14)
#define  GP23_ROMCS1	((VR4181GIU_MODE_OUT | VR4181GIU_MODE_ALT ) << 14)
#define  GP24_GPI	((VR4181GIU_MODE_IN  | VR4181GIU_MODE_GPIO) <<  0)
#define  GP24_GPO	((VR4181GIU_MODE_OUT | VR4181GIU_MODE_GPIO) <<  0)
#define  GP24_ROMCS2	((VR4181GIU_MODE_OUT | VR4181GIU_MODE_ALT ) <<  0)
#define  GP25_GPI	((VR4181GIU_MODE_IN  | VR4181GIU_MODE_GPIO) <<  2)
#define  GP25_RxD1	((VR4181GIU_MODE_IN  | VR4181GIU_MODE_ALT ) <<  2)
#define  GP25_GPO	((VR4181GIU_MODE_OUT | VR4181GIU_MODE_GPIO) <<  2)
#define  GP26_GPI	((VR4181GIU_MODE_IN  | VR4181GIU_MODE_GPIO) <<  4)
#define  GP26_GPO	((VR4181GIU_MODE_OUT | VR4181GIU_MODE_GPIO) <<  4)
#define  GP26_TxD1	((VR4181GIU_MODE_OUT | VR4181GIU_MODE_ALT ) <<  4)
#define  GP27_GPI	((VR4181GIU_MODE_IN  | VR4181GIU_MODE_GPIO) <<  6)
#define  GP27_GPO	((VR4181GIU_MODE_OUT | VR4181GIU_MODE_GPIO) <<  6)
#define  GP27_RTS1	((VR4181GIU_MODE_OUT | VR4181GIU_MODE_ALT ) <<  6)
#define  GP28_GPI	((VR4181GIU_MODE_IN  | VR4181GIU_MODE_GPIO) <<  8)
#define  GP28_CTS1	((VR4181GIU_MODE_IN  | VR4181GIU_MODE_ALT ) <<  8)
#define  GP28_GPO	((VR4181GIU_MODE_OUT | VR4181GIU_MODE_GPIO) <<  8)
#define  GP29_GPI	((VR4181GIU_MODE_IN  | VR4181GIU_MODE_GPIO) << 10)
#define  GP29_DCD1	((VR4181GIU_MODE_IN  | VR4181GIU_MODE_ALT ) << 10)
#define  GP29_GPO	((VR4181GIU_MODE_OUT | VR4181GIU_MODE_GPIO) << 10)
#define  GP30_GPI	((VR4181GIU_MODE_IN  | VR4181GIU_MODE_GPIO) << 12)
#define  GP30_GPO	((VR4181GIU_MODE_OUT | VR4181GIU_MODE_GPIO) << 12)
#define  GP30_DTR1	((VR4181GIU_MODE_OUT | VR4181GIU_MODE_ALT ) << 12)
#define  GP31_GPI	((VR4181GIU_MODE_IN  | VR4181GIU_MODE_GPIO) << 14)
#define  GP31_DSR1	((VR4181GIU_MODE_IN  | VR4181GIU_MODE_ALT ) << 14)
#define  GP31_GPO	((VR4181GIU_MODE_OUT | VR4181GIU_MODE_GPIO) << 14)


#define VR4181GIU_PIOD_REG		0x08
#define VR4181GIU_PIOD_H_REG_W		0x08
#define VR4181GIU_PIOD_L_REG_W		0x0a

#define VR4181GIU_INTEN_REG_W		0x0c
#define  GIEN0				(1U <<  0)
#define  GIEN1				(1U <<  1)
#define  GIEN2				(1U <<  2)
#define  GIEN3				(1U <<  3)
#define  GIEN4				(1U <<  4)
#define  GIEN5				(1U <<  5)
#define  GIEN6				(1U <<  6)
#define  GIEN7				(1U <<  7)
#define  GIEN8				(1U <<  8)
#define  GIEN9				(1U <<  9)
#define  GIEN10				(1U << 10)
#define  GIEN11				(1U << 11)
#define  GIEN12				(1U << 12)
#define  GIEN13				(1U << 13)
#define  GIEN14				(1U << 14)
#define  GIEN15				(1U << 15)

#define VR4181GIU_INTMASK_REG_W		0x0e
#define  GIMSK0				(1U <<  0)
#define  GIMSK1				(1U <<  1)
#define  GIMSK2				(1U <<  2)
#define  GIMSK3				(1U <<  3)
#define  GIMSK4				(1U <<  4)
#define  GIMSK5				(1U <<  5)
#define  GIMSK6				(1U <<  6)
#define  GIMSK7				(1U <<  7)
#define  GIMSK8				(1U <<  8)
#define  GIMSK9				(1U <<  9)
#define  GIMSK10			(1U << 10)
#define  GIMSK11			(1U << 11)
#define  GIMSK12			(1U << 12)
#define  GIMSK13			(1U << 13)
#define  GIMSK14			(1U << 14)
#define  GIMSK15			(1U << 15)

#define VR4181GIU_INTTYP_REG		0x10
#define VR4181GIU_INTTYP_H_REG_W	0x10
#define VR4181GIU_INTTYP_L_REG_W	0x12

#define VR4181GIU_INTTYP_HIGH_LEVEL	0x3
#define VR4181GIU_INTTYP_LOW_LEVEL	0x2
#define VR4181GIU_INTTYP_RISING_EDGE	0x1
#define VR4181GIU_INTTYP_FALLING_EDGE	0x0
#define VR4181GIU_INTTYP_INVALID	(-1)	/* for validation check */

#define  I0TYP_HIGH_LEVEL	(VR4181GIU_INTTYP_HIGH_LEVEL   <<  0)
#define  I0TYP_LOW_LEVEL	(VR4181GIU_INTTYP_LOW_LEVEL    <<  0)
#define  I0TYP_RISING_EDGE	(VR4181GIU_INTTYP_RISING_EDGE  <<  0)
#define  I0TYP_FALLING_EDGE	(VR4181GIU_INTTYP_FALLING_EDGE <<  0)

#define  I1TYP_HIGH_LEVEL	(VR4181GIU_INTTYP_HIGH_LEVEL   <<  2)
#define  I1TYP_LOW_LEVEL	(VR4181GIU_INTTYP_LOW_LEVEL    <<  2)
#define  I1TYP_RISING_EDGE	(VR4181GIU_INTTYP_RISING_EDGE  <<  2)
#define  I1TYP_FALLING_EDGE	(VR4181GIU_INTTYP_FALLING_EDGE <<  2)

#define  I2TYP_HIGH_LEVEL	(VR4181GIU_INTTYP_HIGH_LEVEL   <<  4)
#define  I2TYP_LOW_LEVEL	(VR4181GIU_INTTYP_LOW_LEVEL    <<  4)
#define  I2TYP_RISING_EDGE	(VR4181GIU_INTTYP_RISING_EDGE  <<  4)
#define  I2TYP_FALLING_EDGE	(VR4181GIU_INTTYP_FALLING_EDGE <<  4)

#define  I3TYP_HIGH_LEVEL	(VR4181GIU_INTTYP_HIGH_LEVEL   <<  6)
#define  I3TYP_LOW_LEVEL	(VR4181GIU_INTTYP_LOW_LEVEL    <<  6)
#define  I3TYP_RISING_EDGE	(VR4181GIU_INTTYP_RISING_EDGE  <<  6)
#define  I3TYP_FALLING_EDGE	(VR4181GIU_INTTYP_FALLING_EDGE <<  6)

#define  I4TYP_HIGH_LEVEL	(VR4181GIU_INTTYP_HIGH_LEVEL   <<  8)
#define  I4TYP_LOW_LEVEL	(VR4181GIU_INTTYP_LOW_LEVEL    <<  8)
#define  I4TYP_RISING_EDGE	(VR4181GIU_INTTYP_RISING_EDGE  <<  8)
#define  I4TYP_FALLING_EDGE	(VR4181GIU_INTTYP_FALLING_EDGE <<  8)

#define  I5TYP_HIGH_LEVEL	(VR4181GIU_INTTYP_HIGH_LEVEL   << 10)
#define  I5TYP_LOW_LEVEL	(VR4181GIU_INTTYP_LOW_LEVEL    << 10)
#define  I5TYP_RISING_EDGE	(VR4181GIU_INTTYP_RISING_EDGE  << 10)
#define  I5TYP_FALLING_EDGE	(VR4181GIU_INTTYP_FALLING_EDGE << 10)

#define  I6TYP_HIGH_LEVEL	(VR4181GIU_INTTYP_HIGH_LEVEL   << 12)
#define  I6TYP_LOW_LEVEL	(VR4181GIU_INTTYP_LOW_LEVEL    << 12)
#define  I6TYP_RISING_EDGE	(VR4181GIU_INTTYP_RISING_EDGE  << 12)
#define  I6TYP_FALLING_EDGE	(VR4181GIU_INTTYP_FALLING_EDGE << 12)

#define  I7TYP_HIGH_LEVEL	(VR4181GIU_INTTYP_HIGH_LEVEL   << 14)
#define  I7TYP_LOW_LEVEL	(VR4181GIU_INTTYP_LOW_LEVEL    << 14)
#define  I7TYP_RISING_EDGE	(VR4181GIU_INTTYP_RISING_EDGE  << 14)
#define  I7TYP_FALLING_EDGE	(VR4181GIU_INTTYP_FALLING_EDGE << 14)

#define  I8TYP_HIGH_LEVEL	(VR4181GIU_INTTYP_HIGH_LEVEL   <<  0)
#define  I8TYP_LOW_LEVEL	(VR4181GIU_INTTYP_LOW_LEVEL    <<  0)
#define  I8TYP_RISING_EDGE	(VR4181GIU_INTTYP_RISING_EDGE  <<  0)
#define  I8TYP_FALLING_EDGE	(VR4181GIU_INTTYP_FALLING_EDGE <<  0)

#define  I9TYP_HIGH_LEVEL	(VR4181GIU_INTTYP_HIGH_LEVEL   <<  2)
#define  I9TYP_LOW_LEVEL	(VR4181GIU_INTTYP_LOW_LEVEL    <<  2)
#define  I9TYP_RISING_EDGE	(VR4181GIU_INTTYP_RISING_EDGE  <<  2)
#define  I9TYP_FALLING_EDGE	(VR4181GIU_INTTYP_FALLING_EDGE <<  2)

#define  I10TYP_HIGH_LEVEL	(VR4181GIU_INTTYP_HIGH_LEVEL   <<  4)
#define  I10TYP_LOW_LEVEL	(VR4181GIU_INTTYP_LOW_LEVEL    <<  4)
#define  I10TYP_RISING_EDGE	(VR4181GIU_INTTYP_RISING_EDGE  <<  4)
#define  I10TYP_FALLING_EDGE	(VR4181GIU_INTTYP_FALLING_EDGE <<  4)

#define  I11TYP_HIGH_LEVEL	(VR4181GIU_INTTYP_HIGH_LEVEL   <<  6)
#define  I11TYP_LOW_LEVEL	(VR4181GIU_INTTYP_LOW_LEVEL    <<  6)
#define  I11TYP_RISING_EDGE	(VR4181GIU_INTTYP_RISING_EDGE  <<  6)
#define  I11TYP_FALLING_EDGE	(VR4181GIU_INTTYP_FALLING_EDGE <<  6)

#define  I12TYP_HIGH_LEVEL	(VR4181GIU_INTTYP_HIGH_LEVEL   <<  8)
#define  I12TYP_LOW_LEVEL	(VR4181GIU_INTTYP_LOW_LEVEL    <<  8)
#define  I12TYP_RISING_EDGE	(VR4181GIU_INTTYP_RISING_EDGE  <<  8)
#define  I12TYP_FALLING_EDGE	(VR4181GIU_INTTYP_FALLING_EDGE <<  8)

#define  I13TYP_HIGH_LEVEL	(VR4181GIU_INTTYP_HIGH_LEVEL   << 10)
#define  I13TYP_LOW_LEVEL	(VR4181GIU_INTTYP_LOW_LEVEL    << 10)
#define  I13TYP_RISING_EDGE	(VR4181GIU_INTTYP_RISING_EDGE  << 10)
#define  I13TYP_FALLING_EDGE	(VR4181GIU_INTTYP_FALLING_EDGE << 10)

#define  I14TYP_HIGH_LEVEL	(VR4181GIU_INTTYP_HIGH_LEVEL   << 12)
#define  I14TYP_LOW_LEVEL	(VR4181GIU_INTTYP_LOW_LEVEL    << 12)
#define  I14TYP_RISING_EDGE	(VR4181GIU_INTTYP_RISING_EDGE  << 12)
#define  I14TYP_FALLING_EDGE	(VR4181GIU_INTTYP_FALLING_EDGE << 12)

#define  I15TYP_HIGH_LEVEL	(VR4181GIU_INTTYP_HIGH_LEVEL   << 14)
#define  I15TYP_LOW_LEVEL	(VR4181GIU_INTTYP_LOW_LEVEL    << 14)
#define  I15TYP_RISING_EDGE	(VR4181GIU_INTTYP_RISING_EDGE  << 14)
#define  I15TYP_FALLING_EDGE	(VR4181GIU_INTTYP_FALLING_EDGE << 14)

#define VR4181GIU_INTSTAT_REG_W	0x14

#define VR4181GIU_HIBST_REG		0x16
#define VR4181GIU_HIBST_L_REG_W	0x16
#define VR4181GIU_HIBST_H_REG_W	0x18

#define VR4181GIU_SICTL_REG_W		0x1a

#define VR4181GIU_KEYEN_REG_W		0x1c

#define VR4181GIU_PCS0STRA_REG_W	0x20
#define VR4181GIU_PCS0STPA_REG_W	0x22
#define VR4181GIU_PCS0HIA_REG_W		0x24
#define VR4181GIU_PCS1STRA_REG_W	0x26
#define VR4181GIU_PCS1STPA_REG_W	0x28
#define VR4181GIU_PCS1HIA_REG_W		0x2a

#define VR4181GIU_PCSMODE_REG_W		0x2c

#define  PCS0MD_DISABLE			(0x0 <<  0)
#define  PCS0MD_READ			(0x1 <<  0)
#define  PCS0MD_WRITE			(0x2 <<  0)
#define  PCS0MD_READWRITE		(0x3 <<  0)
#define  PCS0DSIZE_8BIT			(0x0 <<  2)
#define  PCS0DSIZE_16BIT		(0x1 <<  2)
#define  PCS0MIOB_IO			(0x0 <<  3)
#define  PCS0MIOB_MEM			(0x1 <<  3)
#define  PCS1MD_DISABLE			(0x0 <<  4)
#define  PCS1MD_READ			(0x1 <<  4)
#define  PCS1MD_WRITE			(0x2 <<  4)
#define  PCS1MD_READWRITE		(0x3 <<  4)
#define  PCS1DSIZE_8BIT			(0x0 <<  6)
#define  PCS1DSIZE_16BIT		(0x1 <<  6)
#define  PCS1MIOB_IO			(0x0 <<  7)
#define  PCS1MIOB_MEM			(0x1 <<  7)


/* END vr4181giu.h */
