/*	$NetBSD: atomic_cas.S,v 1.7 2015/10/18 02:28:07 nakayama Exp $	*/

/*-
 * Copyright (c) 2007, 2008 The NetBSD Foundation, Inc.
 * All rights reserved.
 *
 * This code is derived from software contributed to The NetBSD Foundation
 * by Jason R. Thorpe.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *      
 * THIS SOFTWARE IS PROVIDED BY THE NETBSD FOUNDATION, INC. AND CONTRIBUTORS
 * ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
 * TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE FOUNDATION OR CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#include "atomic_op_asm.h"

	.text

ENTRY(_atomic_cas_32)
	cas	[%o0], %o1, %o2
	retl
	 mov	%o2, %o0

ATOMIC_OP_ALIAS(atomic_cas_32,_atomic_cas_32)
ATOMIC_OP_ALIAS(atomic_cas_uint,_atomic_cas_32)
STRONG_ALIAS(_atomic_cas_uint,_atomic_cas_32)

ATOMIC_OP_ALIAS(atomic_cas_32_ni,_atomic_cas_32)
STRONG_ALIAS(_atomic_cas_32_ni,_atomic_cas_32)
ATOMIC_OP_ALIAS(atomic_cas_uint_ni,_atomic_cas_32)
STRONG_ALIAS(_atomic_cas_uint_ni,_atomic_cas_32)

ENTRY(_atomic_cas_64)
#ifndef __arch64__
	COMBINE(%o1, %o2, %o1)
	COMBINE(%o3, %o4, %o2)
#endif
	casx	[%o0], %o1, %o2
#ifdef __arch64__
	retl
	 mov	%o2, %o0
#else
	SPLIT_RETL(%o2, %o0, %o1)
#endif

ATOMIC_OP_ALIAS(atomic_cas_64,_atomic_cas_64)
ATOMIC_OP_ALIAS_SIZE(atomic_cas_ulong,_atomic_cas)
STRONG_ALIAS_SIZE(_atomic_cas_ulong,_atomic_cas)
ATOMIC_OP_ALIAS_SIZE(atomic_cas_ptr,_atomic_cas)
STRONG_ALIAS_SIZE(_atomic_cas_ptr,_atomic_cas)

ATOMIC_OP_ALIAS(atomic_cas_64_ni,_atomic_cas_64)
STRONG_ALIAS_SIZE(_atomic_cas_64_ni,_atomic_cas)
ATOMIC_OP_ALIAS_SIZE(atomic_cas_ulong_ni,_atomic_cas)
STRONG_ALIAS_SIZE(_atomic_cas_ulong_ni,_atomic_cas)
ATOMIC_OP_ALIAS_SIZE(atomic_cas_ptr_ni,_atomic_cas)
STRONG_ALIAS_SIZE(_atomic_cas_ptr_ni,_atomic_cas)

#if !defined(__arch64__) && defined(CRT_ALIAS)
CRT_ALIAS(__sync_val_compare_and_swap_8,_atomic_cas_64)
#endif
