/*
 * Copyright (c) 1995 Leo Weppelman.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef AHDI_H
#define AHDI_H

#define	AHDI_BSIZE	512		/* AHDI blocksize		*/
#define	AHDI_BBLOCK	0		/* AHDI bootblock (root sector)	*/

/*
 * Various `well known' AHDI partition identifiers.
 */
#define AHDI_MKPID(x,y,z)	(   ((u_int32_t)(x) << 16)	\
				  | ((u_int32_t)(y) << 8)	\
				  | ((u_int32_t)(z))		\
				)
#define	AHDI_PID_XGM	AHDI_MKPID('X','G','M')
#define	AHDI_PID_GEM	AHDI_MKPID('G','E','M')
#define	AHDI_PID_BGM	AHDI_MKPID('B','G','M')
#define	AHDI_PID_RAW	AHDI_MKPID('R','A','W')
#define	AHDI_PID_SWP	AHDI_MKPID('S','W','P')
#define	AHDI_PID_NBD	AHDI_MKPID('N','B','D')
#define	AHDI_PID_NBR	AHDI_MKPID('N','B','R')
#define	AHDI_PID_NBS	AHDI_MKPID('N','B','S')
#define	AHDI_PID_NBU	AHDI_MKPID('N','B','U')

/*
 * Format of AHDI boot block.
 */
#define	AHDI_MAXRPD	4		/* max. # of partition descriptors */
					/* in an AHDI bootblock (aka root) */
#define	AHDI_MAXARPD	2		/* max. # of partition descriptors */

/*
 * On-disk representation of the AHDI disklabel.
 */
struct ahdi_part {
	u_int8_t	ap_flg;		/* bit 0 is in-use flag            */
	u_int8_t	ap_id[3];	/* id: GEM, BGM, XGM, UNX, MIX     */
	u_int32_t	ap_st;		/* block where partition starts    */
	u_int32_t	ap_size;	/* partition size in blocks        */
};

struct ahdi_root {
	u_int8_t	 ar_fill[0x1c2];/* filler, can be boot code        */
	u_int32_t	 ar_hdsize;	/* size of entire volume in blocks */
	struct ahdi_part ar_parts[AHDI_MAXRPD]; /* root partition table    */
	u_int32_t	 ar_bslst;	/* start of bad-sector list        */
	u_int32_t	 ar_bslsize;	/* # of blocks in bad-sector list  */
	u_int16_t	 ar_checksum;
};

/*
 * Partition table representation as generated by ahdi_getparts():
 */
typedef struct {
	char	id[4];
	u_int	start;
	u_int	end;
	u_int	rsec;
	u_int	rent;
	int	mod;
} part_t;

typedef struct {
	int	nparts;
	part_t	*parts;
} ptable_t;

/*
 * Functions exported from ahdi.c
 */
EXTERN u_int ahdi_getparts PROTO((disk_t *, ptable_t *, u_int, u_int));
#endif /*  AHDI_H */
