/*	$NetBSD: imxpciereg.h,v 1.3 2019/10/16 11:16:30 hkenken Exp $	*/

/*
 * Copyright (c) 2015 Ryo Shimizu <ryo@nerv.org>
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
 * IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef _ARM_IMX_IMX6_PCIEREG_H_
#define _ARM_IMX_IMX6_PCIEREG_H_

/* PCIe EP Mode Registers */
#define PCIE_EP_DEVICEID			0x00000000
#define PCIE_EP_COMMAND				0x00000004
#define PCIE_EP_BIST				0x0000000c
#define PCIE_EP_BAR0				0x00000010
#define PCIE_EP_MASK0				0x00000010
#define PCIE_EP_MASK1				0x00000014
#define PCIE_EP_MASK2				0x00000018
#define PCIE_EP_MASK3				0x0000001c
#define PCIE_EP_CISP				0x00000028
#define PCIE_EP_SSID				0x0000002c
#define PCIE_EP_EROMBAR				0x00000030
#define PCIE_EP_EROMMASK			0x00000030
#define PCIE_EP_CAPPR				0x00000034
#define PCIE_EP_ILR				0x0000003c
#define PCIE_EP_AER				0x00000100
#define PCIE_EP_UESR				0x00000104
#define PCIE_EP_UEMR				0x00000108
#define PCIE_EP_UESEVR				0x0000010c
#define PCIE_EP_CESR				0x00000110
#define PCIE_EP_CEMR				0x00000114
#define PCIE_EP_ACCR				0x00000118
#define PCIE_EP_HLR				0x0000011c
#define PCIE_EP_VCECHR				0x00000140
#define PCIE_EP_PVCCR1				0x00000144
#define PCIE_EP_PVCCR2				0x00000148
#define PCIE_EP_PVCCSR				0x0000014c
#define PCIE_EP_VCRCR				0x00000150
#define PCIE_EP_VCRCONR				0x00000154
#define PCIE_EP_VCRSR				0x00000158

/* PCIe RC Mode Registers */
#define PCIE_RC_DEVICEID			0x00000000
#define PCIE_RC_COMMAND				0x00000004
#define PCIE_RC_REVID				0x00000008
#define PCIE_RC_BIST				0x0000000c
#define PCIE_RC_BAR0				0x00000010
#define PCIE_RC_BAR1				0x00000014
#define PCIE_RC_BNR				0x00000018
#define PCIE_RC_IOBLSSR				0x0000001c
#define PCIE_RC_MEM_BLR				0x00000020
#define PCIE_RC_PREF_MEM_BLR			0x00000024
#define PCIE_RC_PREF_BASE_U32			0x00000028
#define PCIE_RC_PREF_LIM_U32			0x0000002c
#define PCIE_RC_IO_BASE_LIM_U16			0x00000030
#define PCIE_RC_CAPPR				0x00000034
#define PCIE_RC_EROMBAR				0x00000038
#define PCIE_RC_EROMMASK			0x00000038
#define PCIE_RC_PMCR				0x00000040
#define PCIE_RC_PMCSR				0x00000044
#define PCIE_RC_CIDR				0x00000070
#define PCIE_RC_DCR				0x00000074
#define PCIE_RC_DCONR				0x00000078
#define PCIE_RC_LCR				0x0000007c
#define  PCIE_RC_LCR_MAX_LINK_SPEEDS		__BITS(3, 0)
#define  PCIE_RC_LCR_MAX_LINK_SPEEDS_GEN1	__SHIFTIN(0x1, PCIE_RC_LCR_MAX_LINK_SPEEDS)
#define  PCIE_RC_LCR_MAX_LINK_SPEEDS_GEN2	__SHIFTIN(0x2, PCIE_RC_LCR_MAX_LINK_SPEEDS)
#define PCIE_RC_LCSR				0x00000080
#define  PCIE_RC_LCSR_LINK_SPEED		__BITS(19, 16)
#define PCIE_RC_SCR				0x00000084
#define PCIE_RC_SCSR				0x00000088
#define PCIE_RC_RCCR				0x0000008c
#define PCIE_RC_RSR				0x00000090
#define PCIE_RC_DCR2				0x00000094
#define PCIE_RC_DCSR2				0x00000098
#define PCIE_RC_LCR2				0x0000009c
#define PCIE_RC_LCSR2				0x000000a0
#define PCIE_RC_AER				0x00000100
#define PCIE_RC_UESR				0x00000104
#define PCIE_RC_UEMR				0x00000108
#define PCIE_RC_UESEVR				0x0000010c
#define PCIE_RC_CESR				0x00000110
#define PCIE_RC_CEMR				0x00000114
#define PCIE_RC_ACCR				0x00000118
#define PCIE_RC_HLR				0x0000011c
#define PCIE_RC_RECR				0x0000012c
#define PCIE_RC_RESR				0x00000130
#define PCIE_RC_ESIR				0x00000134
#define PCIE_RC_VCECHR				0x00000140
#define PCIE_RC_PVCCR1				0x00000144
#define PCIE_RC_PVCCR2				0x00000148
#define PCIE_RC_PVCCSR				0x0000014c
#define PCIE_RC_VCRCR				0x00000150
#define PCIE_RC_VCRCONR				0x00000154
#define PCIE_RC_VCRSR				0x00000158

/* PCIe Port Logic Registers */
#define PCIE_PL_ALTRTR				0x00000700
#define PCIE_PL_VSDR				0x00000704
#define PCIE_PL_PFLR				0x00000708
#define  PCIE_PL_PFLR_LOW_POWER_ENTRANCE_COUNT	__BITS(31, 24)
#define  PCIE_PL_PFLR_LINK_STATE		__BITS(21, 16)
#define  PCIE_PL_PFLR_FORCE_LINK		__BIT(15)
#define  PCIE_PL_PFLR_LINK_NUMBER		__BITS(7, 0)
#define PCIE_PL_AFLACR				0x0000070c
#define PCIE_PL_PLCR				0x00000710
#define  PCIE_PL_PLCR_LINK_MODE_ENABLE		__BITS(21, 16)
#define PCIE_PL_LSR				0x00000714
#define PCIE_PL_SNR				0x00000718
#define PCIE_PL_STRFM1				0x0000071c
#define PCIE_PL_STRFM2				0x00000720
#define PCIE_PL_AMODNPSR			0x00000724
#define PCIE_PL_DEBUG0				0x00000728
#define  PCIE_PL_DEBUG0_XMLH_LTSSM_STATE	__BITS(0, 5)
#define PCIE_PL_DEBUG1				0x0000072c
#define  PCIE_PL_DEBUG1_XMLH_LINK_UP		__BIT(4)
#define  PCIE_PL_DEBUG1_XMLH_LINK_IN_TRAINING	__BIT(29)
#define PCIE_PL_TPFCSR				0x00000730
#define PCIE_PL_TNFCSR				0x00000734
#define PCIE_PL_TCFCSR				0x00000738
#define PCIE_PL_QSR				0x0000073c
#define PCIE_PL_VCTAR1				0x00000740
#define PCIE_PL_VCTAR2				0x00000744
#define PCIE_PL_VC0PRQC				0x00000748
#define PCIE_PL_VC0NRQC				0x0000074c
#define PCIE_PL_VC0CRQC				0x00000750
#define PCIE_PL_VCNPRQC				0x00000754
#define PCIE_PL_VCNNRQC				0x00000758
#define PCIE_PL_VCNCRQC				0x0000075c
#define PCIE_PL_VC0PBD				0x000007a8
#define PCIE_PL_VC0NPBD				0x000007ac
#define PCIE_PL_VC0CBD				0x000007b0
#define PCIE_PL_VC1PBD				0x000007b4
#define PCIE_PL_VC1NPBD				0x000007b8
#define PCIE_PL_VC1CBD				0x000007bc
#define PCIE_PL_G2CR				0x0000080c
#define  PCIE_PL_G2CR_DIRECTED_SPEED_CHANGE	__BIT(17)
#define  PCIE_PL_G2CR_PREDETERMINED_NUMBER_OF_LANES	__BITS(16, 8)
#define PCIE_PL_PHY_STATUS			0x00000810
#define  PCIE_PL_PHY_STATUS_ACK			__BIT(16)
#define  PCIE_PL_PHY_STATUS_DATA		__BITS(0, 15)
#define PCIE_PL_PHY_CTRL			0x00000814
#define  PCIE_PL_PHY_CTRL_RD			__BIT(19)
#define  PCIE_PL_PHY_CTRL_WR			__BIT(18)
#define  PCIE_PL_PHY_CTRL_CAP_DAT		__BIT(17)
#define  PCIE_PL_PHY_CTRL_CAP_ADR		__BIT(16)
#define  PCIE_PL_PHY_CTRL_DATA			__BITS(0, 15)
#define PCIE_PL_MRCCR0				0x00000818
#define PCIE_PL_MRCCR1				0x0000081c
#define PCIE_PL_MSICA				0x00000820
#define PCIE_PL_MSICUA				0x00000824
#define PCIE_PL_MSICIN_ENB			0x00000828
#define PCIE_PL_MSICIN_MASK			0x0000082c
#define PCIE_PL_MSICIN_STATUS			0x00000830
#define PCIE_PL_MSICGPIO			0x00000888

// ATU_R_BaseAddress 0x900
#define PCIE_PL_IATUVR				0x00000900
// ATU_VIEWPORT_R (ATU_R_BaseAddress + 0x0)

#define PCIE_PL_IATURC1				0x00000904
// ATU_REGION_CTRL1_R (ATU_R_BaseAddress + 0x4)
#define  PCIE_PL_IATURC1_FUNC			__BITS(22, 20)
#define  PCIE_PL_IATURC1_AT			__BITS(17, 16)
#define  PCIE_PL_IATURC1_ATTR			__BITS(10, 9)
#define  PCIE_PL_IATURC1_TD			__BIT(8)
#define  PCIE_PL_IATURC1_TC			__BITS(7, 5)
#define  PCIE_PL_IATURC1_TYPE			__BITS(4, 0)
#define   PCIE_PL_IATURC1_TYPE_IO		__SHIFTIN(0, PCIE_PL_IATURC1_TYPE)
#define   PCIE_PL_IATURC1_TYPE_MEM		__SHIFTIN(2, PCIE_PL_IATURC1_TYPE)
#define   PCIE_PL_IATURC1_TYPE_CFG0		__SHIFTIN(4, PCIE_PL_IATURC1_TYPE)
#define   PCIE_PL_IATURC1_TYPE_CFG1		__SHIFTIN(5, PCIE_PL_IATURC1_TYPE)

#define PCIE_PL_IATURC2				0x00000908
// ATU_REGION_CTRL2_R (ATU_R_BaseAddress + 0x8)
#define  PCIE_PL_IATURC2_REGION_ENABLE		__BIT(31)

#define PCIE_PL_IATURLBA			0x0000090c
// ATU_REGION_LOWBASE_R (ATU_R_BaseAddress + 0xC)

#define PCIE_PL_IATURUBA			0x00000910
// ATU_REGION_UPBASE_R (ATU_R_BaseAddress + 0x10)

#define PCIE_PL_IATURLA				0x00000914
// ATU_REGION_LIMIT_ADDR_R (ATU_R_BaseAddress + 0x14)

#define PCIE_PL_IATURLTA			0x00000918
// ATU_REGION_LOW_TRGT_ADDR_R (ATU_R_BaseAddress + 0x18)

#define PCIE_PL_IATURUTA			0x0000091c
// ATU_REGION_UP_TRGT_ADDR_R (ATU_R_BaseAddress + 0x1C)

/* PCIe PHY registers */
#define PCIE_PHY_IDCODE_LO			0x0000
#define PCIE_PHY_IDCODE_HI			0x0001
#define PCIE_PHY_DEBUG				0x0002
#define PCIE_PHY_RTUNE_DEBUG			0x0003
#define PCIE_PHY_RTUNE_STAT			0x0004
#define PCIE_PHY_SS_PHASE			0x0005
#define PCIE_PHY_SS_FREQ			0x0006
#define PCIE_PHY_ATEOVRD			0x0010
#define  ATEOVRD_EN				__BIT(2)
#define  REF_USB2_EN				__BIT(1)
#define  REF_CLKDIV2				__BIT(0)
#define PCIE_PHY_MPLL_OVRD_IN_LO		0x0011
#define PCIE_PHY_MPLL_OVRD_IN_HI		0x0011
#define  RES_ACK_IN_OVRD			__BIT(15)
#define  RES_ACK_IN				__BIT(14)
#define  RES_REQ_IN_OVRD			__BIT(13)
#define  RES_REQ_IN				__BIT(12)
#define  RTUNE_REQ_OVRD				__BIT(11)
#define  RTUNE_REQ				__BIT(10)
#define  MPLL_MULTIPLIER_OVRD			__BIT(9)
#define  MPLL_MULTIPLIER			__BITS(8, 2)
#define  MPLL_EN_OVRD				__BIT(1)
#define  MPLL_EN				__BIT(0)
#define PCIE_PHY_SSC_OVRD_IN			0x0013
#define PCIE_PHY_BS_OVRD_IN			0x0014
#define PCIE_PHY_LEVEL_OVRD_IN			0x0015
#define PCIE_PHY_SUP_OVRD_OUT			0x0016
#define PCIE_PHY_MPLL_ASIC_IN			0x0017
#define PCIE_PHY_BS_ASIC_IN			0x0018
#define PCIE_PHY_LEVEL_ASIC_IN			0x0019
#define PCIE_PHY_SSC_ASIC_IN			0x001a
#define PCIE_PHY_SUP_ASIC_OUT			0x001b
#define PCIE_PHY_ATEOVRD_STATUS			0x001c
#define PCIE_PHY_SCOPE_ENABLES			0x0020
#define PCIE_PHY_SCOPE_SAMPLES			0x0021
#define PCIE_PHY_SCOPE_COUNT			0x0022
#define PCIE_PHY_SCOPE_CTL			0x0023
#define PCIE_PHY_SCOPE_MASK_000			0x0024
#define PCIE_PHY_SCOPE_MASK_001			0x0025
#define PCIE_PHY_SCOPE_MASK_010			0x0026
#define PCIE_PHY_SCOPE_MASK_011			0x0027
#define PCIE_PHY_SCOPE_MASK_100			0x0028
#define PCIE_PHY_SCOPE_MASK_101			0x0029
#define PCIE_PHY_SCOPE_MASK_110			0x002a
#define PCIE_PHY_SCOPE_MASK_111			0x002b
#define PCIE_PHY_MPLL_LOOP_CTL			0x0030
#define PCIE_PHY_MPLL_ATB_MEAS2			0x0032
#define PCIE_PHY_MPLL_OVR			0x0033
#define PCIE_PHY_RTUNE_RTUNE_CTRL		0x0034
#define PCIE_PHY_TX_OVRD_IN_LO			0x1000
#define PCIE_PHY_TX_OVRD_IN_HI			0x1001
#define PCIE_PHY_TX_OVRD_DRV_LO			0x1003
#define PCIE_PHY_TX_OVRD_OUT			0x1004
#define PCIE_PHY_RX_OVRD_IN_LO			0x1005
#define  PCIE_PHY_RX_OVRD_IN_LO_RX_PLL_EN_OVRD	__BIT(3)
#define  PCIE_PHY_RX_OVRD_IN_LO_RX_DATA_EN_OVRD	__BIT(5)
#define PCIE_PHY_RX_OVRD_IN_HI			0x1006
#define PCIE_PHY_RX_OVRD_OUT			0x1007
#define PCIE_PHY_TX_ASIC_IN			0x1008
#define PCIE_PHY_TX_ASIC_DRV_LO			0x1009
#define PCIE_PHY_TX_ASIC_DRV_HI			0x100a
#define PCIE_PHY_TX_ASIC_OUT			0x100b
#define PCIE_PHY_RX_ASIC_IN			0x100c
#define PCIE_PHY_RX_ASIC_OUT			0x100d
#define  PCIE_PHY_RX_ASIC_OUT_LOS		__BIT(2)
#define  PCIE_PHY_RX_ASIC_OUT_PLL_STATE		__BIT(1)
#define  PCIE_PHY_RX_ASIC_OUT_VALID		__BIT(0)
#define PCIE_PHY_TX_VMD_FSM_TX_VCM_0		0x1011
#define PCIE_PHY_TX_VMD_FSM_TX_VCM_1		0x1012
#define PCIE_PHY_TX_VMD_FSM_TX_VCM_DEBUG_IN	0x1013
#define PCIE_PHY_TX_VMD_FSM_TX_VCM_DEBUG_OUT	0x1014
#define PCIE_PHY_TX_LBERT_CTL			0x1015
#define PCIE_PHY_RX_LBERT_CTL			0x1016
#define PCIE_PHY_RX_LBERT_ERR			0x1017
#define PCIE_PHY_RX_SCOPE_CTL			0x1018
#define PCIE_PHY_RX_SCOPE_PHASE			0x1019
#define PCIE_PHY_RX_DPLL_FREQ			0x101a
#define PCIE_PHY_RX_CDR_CTL			0x101b
#define PCIE_PHY_RX_CDR_CDR_FSM_DEBUG		0x101c
#define PCIE_PHY_RX_CDR_LOCK_VEC_OVRD		0x101d
#define PCIE_PHY_RX_CDR_LOCK_VEC		0x101e
#define PCIE_PHY_RX_CDR_ADAP_FSM		0x101f
#define PCIE_PHY_RX_ATB0			0x1020
#define PCIE_PHY_RX_ATB1			0x1021
#define PCIE_PHY_RX_ENPWR0			0x1022
#define PCIE_PHY_RX_PMIX_PHASE			0x1023
#define PCIE_PHY_RX_ENPWR1			0x1024
#define PCIE_PHY_RX_ENPWR2			0x1025
#define PCIE_PHY_RX_SCOPE			0x1026
#define PCIE_PHY_TX_TXDRV_CNTRL			0x102b
#define PCIE_PHY_TX_POWER_CTL			0x102c
#define PCIE_PHY_TX_ALT_BLOCK			0x102d
#define PCIE_PHY_TX_ALT_AND_LOOPBACK		0x102e
#define PCIE_PHY_TX_TX_ATB_REG			0x102f

#endif /* _ARM_IMX_IMX6_PCIEREG_H_ */
