package ONVIF::Analytics::Types::MessageDescription;
use strict;
use warnings;


__PACKAGE__->_set_element_form_qualified(1);

sub get_xmlns { 'http://www.onvif.org/ver10/schema' };

our $XML_ATTRIBUTE_CLASS = 'ONVIF::Analytics::Types::MessageDescription::_MessageDescription::XmlAttr';

sub __get_attr_class {
    return $XML_ATTRIBUTE_CLASS;
}

use Class::Std::Fast::Storable constructor => 'none';
use base qw(SOAP::WSDL::XSD::Typelib::ComplexType);

Class::Std::initialize();

{ # BLOCK to scope variables

my %Source_of :ATTR(:get<Source>);
my %Key_of :ATTR(:get<Key>);
my %Data_of :ATTR(:get<Data>);
my %Extension_of :ATTR(:get<Extension>);

__PACKAGE__->_factory(
    [ qw(        Source
        Key
        Data
        Extension

    ) ],
    {
        'Source' => \%Source_of,
        'Key' => \%Key_of,
        'Data' => \%Data_of,
        'Extension' => \%Extension_of,
    },
    {
        'Source' => 'ONVIF::Analytics::Types::ItemListDescription',
        'Key' => 'ONVIF::Analytics::Types::ItemListDescription',
        'Data' => 'ONVIF::Analytics::Types::ItemListDescription',
        'Extension' => 'ONVIF::Analytics::Types::MessageDescriptionExtension',
    },
    {

        'Source' => 'Source',
        'Key' => 'Key',
        'Data' => 'Data',
        'Extension' => 'Extension',
    }
);

} # end BLOCK




package ONVIF::Analytics::Types::MessageDescription::_MessageDescription::XmlAttr;
use base qw(SOAP::WSDL::XSD::Typelib::AttributeSet);

{ # BLOCK to scope variables

my %IsProperty_of :ATTR(:get<IsProperty>);

__PACKAGE__->_factory(
    [ qw(
        IsProperty
    ) ],
    {

        IsProperty => \%IsProperty_of,
    },
    {
        IsProperty => 'SOAP::WSDL::XSD::Typelib::Builtin::boolean',
    }
);

} # end BLOCK




1;


=pod

=head1 NAME

ONVIF::Analytics::Types::MessageDescription

=head1 DESCRIPTION

Perl data type class for the XML Schema defined complexType
MessageDescription from the namespace http://www.onvif.org/ver10/schema.






=head2 PROPERTIES

The following properties may be accessed using get_PROPERTY / set_PROPERTY
methods:

=over

=item * Source


=item * Key


=item * Data


=item * Extension




=back


=head1 METHODS

=head2 new

Constructor. The following data structure may be passed to new():

 { # ONVIF::Analytics::Types::MessageDescription
   Source =>  { # ONVIF::Analytics::Types::ItemListDescription
     SimpleItemDescription => ,
     ElementItemDescription => ,
     Extension =>  { # ONVIF::Analytics::Types::ItemListDescriptionExtension
     },
   },
   Key =>  { # ONVIF::Analytics::Types::ItemListDescription
     SimpleItemDescription => ,
     ElementItemDescription => ,
     Extension =>  { # ONVIF::Analytics::Types::ItemListDescriptionExtension
     },
   },
   Data =>  { # ONVIF::Analytics::Types::ItemListDescription
     SimpleItemDescription => ,
     ElementItemDescription => ,
     Extension =>  { # ONVIF::Analytics::Types::ItemListDescriptionExtension
     },
   },
   Extension =>  { # ONVIF::Analytics::Types::MessageDescriptionExtension
   },
 },



=head2 attr

NOTE: Attribute documentation is experimental, and may be inaccurate.
See the correspondent WSDL/XML Schema if in question.

This class has additional attributes, accessibly via the C<attr()> method.

attr() returns an object of the class ONVIF::Analytics::Types::MessageDescription::_MessageDescription::XmlAttr.

The following attributes can be accessed on this object via the corresponding
get_/set_ methods:

=over

=item * IsProperty

 Default is false.



This attribute is of type L<SOAP::WSDL::XSD::Typelib::Builtin::boolean|SOAP::WSDL::XSD::Typelib::Builtin::boolean>.


=back




=head1 AUTHOR

Generated by SOAP::WSDL

=cut

