/*
 *========================================================================
 * $Id: libwulf_wulfhost.h 90 2004-09-30 17:38:02Z rgb $
 *
 * See copyright in copyright.h and the accompanying file COPYING
 *========================================================================
 */

#include <wulfware/libwulf_copyright.h>

/* libxml includes */
/*
 * COMPAT using xml-config --cflags to get the include path this will
 * work with both 
 */
#include <libxml/xmlmemory.h>
#include <libxml/parser.h>
#include <libxml/xpath.h>

/* We use these for certain buffer sizes */
#define K 1024
#define K4 4096
#define K64 65536

 /* 
  * This defines some flags to control just what the daemon sends and how.
  * Each is sort of documented in place.
  */
 typedef struct {

   int compress;	/* Do we compress xml output? */
   int whitespace;	/* Do we squeeze out whitespace? */

   /*
    * All the following toggle various components of the return.  Some of
    * these are only needed "once" in a typical monitoring session anyway
    * and can be pulled from the init return (which always sends
    * "everything").  Future developers should note the 1:1 correspondance
    * between many of these flags and "init_XXXX.c" and "update_XXXX.c"
    * sources and calls.
    */

   /* system call stuff */
   int identity;	/* Do we update system identity? */
   int time;		/* Do we update system time? */
   int users;		/* Do we update system pids? */
   /* proc-derived stuff */
   int cpuinfo;		/* Do we update proc cpuinfo? */
   int loadavg;		/* Do we update proc loadavg? */
   int meminfo;		/* Do we update proc meminfo? */
   int net;		/* Do we update proc net? */
   int stat;		/* Do we update proc stat? */
   int sysvipc;		/* Do we update proc shared memory stuff? */
   int uptime;		/* Do we update proc uptime? */
   int version;		/* Do we update proc (kernel) version? */
   /* Processes (in /proc/XXXXX where XXXXX is a pid) */
   int pids;		/* Do we update pids at all? */
   int pidstats;	/* (unused) for pidstats */
   int cmdline;		/* Do we get the cmdline in pids? */
   int running;		/* Running PIDs or all? */
   int root;		/* Including those owned by root? */
   List *userlist;	/* A linked list of usernames to watch */
   List *tasklist;	/* A linked list of tasknames to watch */

 } Dctl;

/*
 * This struct contains all per-host state information:
 *   hostname
 *   host IP number (character and binary)
 *   port number
 *   file descriptor of socket
 *   flag to indicate active connection
 *   xmlDocPtr to xmlDoc struct containing the as yet
 * unparsed xml returned by a command.  Note that this
 * space is allocated by the xml parser on EACH call and
 * must be freed when we've extracted as much or as little as
 * we need.  Note also that this CLIENT will have a nontrivial
 * memory footprint when run on very large numbers of hosts
 * because xmlDocs are lavishly provided with information.
 * Value val is the struct containing most values of interest.
 *
 * Note that the first four values are set by the various
 * wulfhost parsing blocks from <host>, <iprange> and <hostrange>
 * tags.
 */
 typedef struct {
    char hostname[K];
    char hostip[K];
    unsigned long inetaddress;
    int port;
    int client_fd;
    int connected;
    xmlDocPtr doc;
    xmlXPathContextPtr xp_doc;
    Value val;
    /*
     * To avoid having to re-malloc this every time we clear values
     * OR kludge something horrible to preserve the allocated memory,
     * we put the linked list for pid's in this struct, not the val
     * struct.  We still clear its CONTENTS when we clear values.
     */
    List *pidlist;
    Dctl dctl;
   
 } Host;

 /*
  * In order to be able to deal with variable numbers of hosts (add
  * and delete hosts, for example) hosts are stored in a linked list
  * so that we can freely add or delete them.  This means that we
  * have to walk the list whenever we loop over all hosts.
  */
 List *hostlist;
